/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteFromIpgroup;
import biz.netup.control.transport.urfa.functions.UrfaDeleteQuota;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.TClassFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.sl.SLFunctions;
import biz.netup.projects.utmadmin.functions.objects.IPSL;
import biz.netup.projects.utmadmin.functions.objects.Quota;
import biz.netup.projects.utmadmin.functions.objects.TClass;
import biz.netup.projects.utmadmin.gui.custom.quota.QuotaDialog;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialog;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.hs.BytesTextField;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddIPServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JTextField accountingPeriodTextField;
    private JButton selectDiscountPeriodButton;
    private JCheckBox donTChangeRecurringCheckBox;
    private JButton deleteIPGroupButton;
    private JButton addIPGroupButton;
    private JButton editIPGroupButton;
    private JButton deleteQuotaButton;
    private JButton addQuotaButton;
    private JCheckBox decreasePrepaidTrafficCheckBox;
    private JScrollPane ipGroupsScrollPane;
    private JScrollPane quotasScrollPane;
    private JLabel accountingPeriodLabel;
    private JDateTime startDateDateTime;
    private JDateTime expireDateDateTime;
    private JButton editQuotaButton;
    private TablePanelImpl ipGroupTablePanel;
    private TablePanelImpl quotaTablePanel;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    private int slinkId;
    private int tariffLinkId;
    IPSL ipsl;
    ResourceBundleWrapper resource = Utils.getResource();
    private Vector<Map<String, Object>> ipGroupsStart;
    private Vector<Quota> quotas;
    private Vector<Quota> quotasStart;
    private static final Logger logger = Utils.getLogger();
    private String[] ipGroupsColumnNames = new String[]{"IP", "Mask", "MAC adress", "Login", "Allowed CID"};
    private String[] quotasColumnNames = new String[]{"Class ID", "Traffic class name", "Quota"};

    public AddIPServiceLinkDialog(int n, int n2, int n3, String string, int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.ipsl = new IPSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
            this.expireDateDateTime.setDate(new Date(2000000000000L));
            this.donTChangeRecurringCheckBox.setSelected("1".equals(Settings.getValueFromPerst("RecalcAbonIPSL")));
            this.decreasePrepaidTrafficCheckBox.setSelected("1".equals(Settings.getValueFromPerst("RecalcTrafficIPSL")));
        } else {
            this.loadIPSL();
            this.disableSelectElements();
        }
        if (n5 != 0) {
            this.discountPeriod = n6;
            this.disableDiscountElements();
        }
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    private void disableSelectElements() {
        this.selectDiscountPeriodButton.setEnabled(false);
        this.startDateDateTime.setEnabled(false);
        this.expireDateDateTime.setEnabled(false);
        this.donTChangeRecurringCheckBox.setEnabled(false);
        this.decreasePrepaidTrafficCheckBox.setEnabled(false);
    }

    private void disableDiscountElements() {
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        this.selectDiscountPeriodButton.setEnabled(false);
    }

    private void loadIPSL() {
        try {
            this.ipsl = SLFunctions.getIPSL(this.slinkId);
            this.startDateDateTime.setDate(new Date((long)this.ipsl.getStartDate() * 1000L));
            this.expireDateDateTime.setDate(new Date((long)this.ipsl.getExpireDate() * 1000L));
            this.discountPeriod = this.ipsl.getDiscountPeriodId();
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            this.donTChangeRecurringCheckBox.setSelected(this.ipsl.isUnabon());
            this.decreasePrepaidTrafficCheckBox.setSelected(this.ipsl.isUnprepay());
            this.ipGroupsStart = new Vector();
            for (int i = 0; i < this.ipsl.getIpAddress1().length; ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("do_not_affect_firewall", this.ipsl.getDontUseFw1()[i] ? 1 : 0);
                hashMap.put("ip", this.ipsl.getIpAddress1()[i]);
                hashMap.put("ip_str", Resolve.ip_toString(this.ipsl.getIpAddress1()[i]));
                hashMap.put("not_vpn", this.ipsl.getIpNotVpn1()[i] ? 1 : 0);
                hashMap.put("allowed_cid", this.ipsl.getIptrafficAllowedCid1()[i]);
                hashMap.put("login", this.ipsl.getIptrafficLogin1()[i]);
                hashMap.put("password", this.ipsl.getIptrafficPassword1()[i]);
                hashMap.put("mac", this.ipsl.getMac1()[i]);
                hashMap.put("mask", this.ipsl.getMask1()[i]);
                hashMap.put("mask_str", Resolve.ip_toString(this.ipsl.getMask1()[i]));
                hashMap.put("router_id", this.ipsl.getRouterId1()[i]);
                this.ipGroupTablePanel.getTableModel().addRow(hashMap);
                hashMap = new HashMap();
                hashMap.put("do_not_affect_firewall", this.ipsl.getDontUseFw1()[i] ? 1 : 0);
                hashMap.put("ip", this.ipsl.getIpAddress1()[i]);
                hashMap.put("ip_str", Resolve.ip_toString(this.ipsl.getIpAddress1()[i]));
                hashMap.put("not_vpn", this.ipsl.getIpNotVpn1()[i] ? 1 : 0);
                hashMap.put("allowed_cid", this.ipsl.getIptrafficAllowedCid1()[i]);
                hashMap.put("login", this.ipsl.getIptrafficLogin1()[i]);
                hashMap.put("password", this.ipsl.getIptrafficPassword1()[i]);
                hashMap.put("mac", this.ipsl.getMac1()[i]);
                hashMap.put("mask", this.ipsl.getMask1()[i]);
                hashMap.put("mask_str", Resolve.ip_toString(this.ipsl.getMask1()[i]));
                hashMap.put("router_id", this.ipsl.getRouterId1()[i]);
                this.ipGroupsStart.add(hashMap);
            }
            this.quotasStart = new Vector();
            TClass[] tClassArray = TClassFunctions.getTclassList();
            for (int i = 0; i < this.ipsl.getQuota1().length; ++i) {
                Quota quota = new Quota();
                quota.setClassID(this.ipsl.getTclassId1()[i]);
                quota.setQuota(this.ipsl.getQuota1()[i]);
                for (TClass tClass : tClassArray) {
                    if (tClass.getTclassId() != this.ipsl.getTclassId1()[i]) continue;
                    quota.setTrafficClassName(tClass.getTclassName() + " (" + tClass.getTclassId() + ")");
                }
                if (this.ipsl.getQuota1()[i] != 0L) {
                    this.quotas.add(quota);
                }
                quota = new Quota();
                quota.setClassID(this.ipsl.getTclassId1()[i]);
                quota.setQuota(this.ipsl.getQuota1()[i]);
                for (TClass tClass : tClassArray) {
                    if (tClass.getTclassId() != this.ipsl.getTclassId1()[i]) continue;
                    quota.setTrafficClassName(tClass.getTclassName() + " (" + tClass.getTclassId() + ")");
                }
                if (this.ipsl.getQuota1()[i] == 0L) continue;
                this.quotasStart.add(quota);
            }
            this.refreshQuotasTable();
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException.getMessage(), urfaException);
        }
    }

    public AddIPServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
    }

    public AddIPServiceLinkDialog() {
        this.quotas = new Vector();
        this.$$$setupUI$$$();
        this.quotaTablePanel.registerOneRowButton(this.editQuotaButton);
        this.quotaTablePanel.registerOneRowButton(this.deleteQuotaButton);
        this.ipGroupTablePanel.registerOneRowButton(this.editIPGroupButton);
        this.ipGroupTablePanel.registerOneRowButton(this.deleteIPGroupButton);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(520, 580);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("IP traffic service link"));
        this.setIconImage(imageIcon.getImage());
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddIPServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectDiscountPeriodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.selectDiscountPeriod();
            }
        });
        this.addIPGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.addIpGroup();
            }
        });
        this.editIPGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.editIpGroup();
            }
        });
        this.deleteIPGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.deleteIPGroup();
            }
        });
        this.addQuotaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.addQuota();
            }
        });
        this.deleteQuotaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.deleteQuota();
            }
        });
        this.editQuotaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddIPServiceLinkDialog.this.editQuota();
            }
        });
    }

    private void editQuota() {
        int n = this.quotaTablePanel.getTable().getSelectedRow();
        QuotaDialog quotaDialog = new QuotaDialog(this.quotas.get(n));
        quotaDialog.setVisible(true);
        if (quotaDialog.isOkPressed()) {
            this.quotas.set(n, quotaDialog.getQuota());
            this.refreshQuotasTable();
        }
    }

    private void deleteQuota() {
        if (Dialogs.showYesNoDialog("Do you wish to continue?")) {
            this.quotas.remove(this.quotaTablePanel.getTable().getSelectedRow());
            this.refreshQuotasTable();
        }
    }

    private void addQuota() {
        QuotaDialog quotaDialog = new QuotaDialog();
        quotaDialog.setVisible(true);
        if (quotaDialog.isOkPressed()) {
            for (Quota quota : this.quotas) {
                if (quota.getClassID() != quotaDialog.getQuota().getClassID()) continue;
                Dialogs.showErrorDialog("Attempt to add one more quota value for tclass");
                return;
            }
            this.quotas.add(quotaDialog.getQuota());
            this.refreshQuotasTable();
        }
    }

    private void deleteIPGroup() {
        if (Dialogs.showYesNoDialog("Do you wish to continue?")) {
            this.ipGroupTablePanel.getTableModel().removeRow(this.ipGroupTablePanel.getSelectedTableRows()[0]);
        }
    }

    private void editIpGroup() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Map<String, Object> map = this.ipGroupTablePanel.getSelectedTableRows()[0];
        map.put("uid", this.uid);
        for (Map<String, Object> map2 : this.ipGroupTablePanel.getTableModel().data) {
            if (map2 == map) continue;
            hashSet.add((Integer)map2.get("ip"));
        }
        map.put("ips", hashSet);
        IpGroupDialog ipGroupDialog = new IpGroupDialog(map);
        ipGroupDialog.load();
        if (ipGroupDialog.isOkPressed()) {
            this.ipGroupTablePanel.getTableModel().removeRow(this.ipGroupTablePanel.getSelectedTableRows()[0]);
            this.ipGroupTablePanel.getTableModel().addRow(ipGroupDialog.getItem());
        }
    }

    private void addIpGroup() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("uid", this.uid);
        for (Map<String, Object> map : this.ipGroupTablePanel.getTableModel().data) {
            hashSet.add((Integer)map.get("ip"));
        }
        hashMap.put("ips", hashSet);
        IpGroupDialog ipGroupDialog = new IpGroupDialog(hashMap);
        ipGroupDialog.load();
        if (ipGroupDialog.isOkPressed()) {
            this.ipGroupTablePanel.getTableModel().addRow(ipGroupDialog.getItem());
        }
    }

    private void refreshQuotasTable() {
        this.quotaTablePanel.getTableModel().removeAllRows();
        for (int i = 0; i < this.quotas.size(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tclass_id", this.quotas.get(i).getClassID());
            hashMap.put("tclass_name", this.quotas.get(i).getTrafficClassName());
            hashMap.put("quota", this.quotas.get(i).getQuota());
            hashMap.put("quota_str", BytesTextField.getString(this.quotas.get(i).getQuota()));
            this.quotaTablePanel.getTableModel().addRow(hashMap);
        }
    }

    private void selectDiscountPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.buttonOK.setEnabled(true);
            this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        }
    }

    private void onOK() {
        if (this.discountPeriod == 0) {
            Dialogs.showErrorDialog("Discount period doesn't selected");
            return;
        }
        if (this.ipGroupTablePanel.getTableModel().getRowCount() == 0) {
            Dialogs.showErrorDialog("IP groups table is empty");
            return;
        }
        this.formIpsl();
        if (this.slinkId == 0) {
            try {
                SLFunctions.addIPSL(this.ipsl);
                this.dispose();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(urfaException.getMessage());
            }
        } else {
            Object object;
            if (Utils.isAdmin()) {
                try {
                    for (Map<String, Object> object2 : this.ipGroupsStart) {
                        object = new UrfaDeleteFromIpgroup(UrfaManagerImpl.getInstance());
                        ((UrfaDeleteFromIpgroup)object).setSlinkId(this.slinkId);
                        ((UrfaDeleteFromIpgroup)object).setIpAddress((Integer)object2.get("ip"));
                        ((UrfaDeleteFromIpgroup)object).setMask((Integer)object2.get("mask"));
                        ((UrfaDeleteFromIpgroup)object).call();
                    }
                    for (Quota quota : this.quotasStart) {
                        object = new UrfaDeleteQuota(UrfaManagerImpl.getInstance());
                        ((UrfaDeleteQuota)object).setSlinkId(this.slinkId);
                        ((UrfaDeleteQuota)object).setTcId(quota.getClassID());
                        ((UrfaDeleteQuota)object).call();
                    }
                }
                catch (UrfaException urfaException) {
                    Dialogs.showErrorDialog(urfaException.getMessage());
                }
            }
            try {
                SLFunctions.editIPSL(this.ipsl);
                this.dispose();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(urfaException.getMessage());
                Vector<Quota> vector = this.quotas;
                this.quotas = this.quotasStart;
                object = this.ipGroupTablePanel.getTableModel().data;
                this.ipGroupTablePanel.getTableModel().data = this.ipGroupsStart;
                this.formIpsl();
                try {
                    SLFunctions.editIPSL(this.ipsl);
                }
                catch (UrfaException urfaException2) {
                    // empty catch block
                }
                this.quotas = vector;
                this.ipGroupTablePanel.getTableModel().data = object;
            }
        }
    }

    private void formIpsl() {
        Object object;
        int n;
        this.ipsl.setAccountId(this.aid);
        this.ipsl.setUserId(this.uid);
        this.ipsl.setDiscountPeriodId(this.discountPeriod);
        this.ipsl.setExpireDate((int)(this.expireDateDateTime.getDate().getTime() / 1000L));
        this.ipsl.setServiceId(this.serviceId);
        this.ipsl.setServiceType(3);
        this.ipsl.setStartDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        this.ipsl.setUnabon(this.donTChangeRecurringCheckBox.isSelected());
        this.ipsl.setUnprepay(this.decreasePrepaidTrafficCheckBox.isSelected());
        int n2 = this.ipGroupTablePanel.getTable().getRowCount();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        String[] stringArray4 = new String[n2];
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            object = this.ipGroupTablePanel.getTableModel().data.get(n);
            nArray[n] = (Integer)object.get("ip");
            nArray2[n] = (Integer)object.get("mask");
            stringArray[n] = (String)object.get("mac");
            stringArray2[n] = (String)object.get("login");
            stringArray3[n] = (String)object.get("allowed_cid");
            stringArray4[n] = (String)object.get("password");
            blArray[n] = (Integer)object.get("not_vpn") == 1;
            blArray2[n] = (Integer)object.get("do_not_affect_firewall") == 1;
            nArray3[n] = (Integer)object.get("router_id");
        }
        this.ipsl.setIpAddress1(nArray);
        this.ipsl.setMask1(nArray2);
        this.ipsl.setMac1(stringArray);
        this.ipsl.setIptrafficAllowedCid1(stringArray3);
        this.ipsl.setIptrafficLogin1(stringArray2);
        this.ipsl.setIptrafficPassword1(stringArray4);
        this.ipsl.setRouterId1(nArray3);
        this.ipsl.setDontUseFw1(blArray2);
        this.ipsl.setIpNotVpn1(blArray);
        n = this.quotas.size();
        object = new int[n];
        long[] lArray = new long[n];
        for (int i = 0; i < this.quotas.size(); ++i) {
            object[i] = this.quotas.get(i).getClassID();
            lArray[i] = this.quotas.get(i).getQuota();
        }
        this.ipsl.setTclassId1((int[])object);
        this.ipsl.setQuota1(lArray);
        this.ipsl.setTariffLinkId(this.tariffLinkId);
        this.ipsl.setSlinkId(this.slinkId);
        this.ipsl.setUnabon(this.donTChangeRecurringCheckBox.isSelected());
        this.ipsl.setUnprepay(this.decreasePrepaidTrafficCheckBox.isSelected());
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.startDateDateTime = new JDateTime();
        this.expireDateDateTime = new JDateTime();
        this.startDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startDateDateTime.getButton().setText("");
        this.expireDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/up16.png")));
        this.expireDateDateTime.getButton().setText("");
        this.expireDateDateTime.setInfinity(true);
        this.ipGroupsScrollPane = new JScrollPane();
        this.quotasScrollPane = new JScrollPane();
        this.createIpGroupTable();
        this.createQuotaTable();
        this.refreshQuotasTable();
    }

    private void createQuotaTable() {
        this.quotaTablePanel = new TablePanelImpl(this.getClass().getName() + "_quotas", true);
        MapTableModel mapTableModel = this.quotaTablePanel.getTableModel();
        mapTableModel.addColumn("tclass_id", "TClass ID", true, false);
        mapTableModel.addColumn("tclass_name", "TClass name", true, false);
        mapTableModel.addColumn("quota_str", "Quota", true, false);
        this.quotaTablePanel.setEditable(false);
        this.quotaTablePanel.setAppendable(false);
        this.quotaTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(AddIPServiceLinkDialog.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(AddIPServiceLinkDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem3 = new JMenuItem(AddIPServiceLinkDialog.this.resource.getString("Edit"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddIPServiceLinkDialog.this.refreshQuotasTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddIPServiceLinkDialog.this.deleteQuota();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddIPServiceLinkDialog.this.editQuota();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem3);
                arrayList.add(jMenuItem2);
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                AddIPServiceLinkDialog.this.editQuota();
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.quotaTablePanel.applyTableSettings();
    }

    private void createIpGroupTable() {
        this.ipGroupTablePanel = new TablePanelImpl(this.getClass().getName() + "_ipgroups", true);
        MapTableModel mapTableModel = this.ipGroupTablePanel.getTableModel();
        mapTableModel.addColumn("ip_str", "IP address", true, false);
        mapTableModel.addColumn("mask_str", "Mask", true, false);
        mapTableModel.addColumn("mac", "Mac address", true, false);
        mapTableModel.addColumn("login", "Login", true, false);
        mapTableModel.addColumn("allowed_cid", "Allowed CID", true, false);
        this.ipGroupTablePanel.setEditable(false);
        this.ipGroupTablePanel.setAppendable(false);
        this.ipGroupTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(AddIPServiceLinkDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(AddIPServiceLinkDialog.this.resource.getString("Edit"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddIPServiceLinkDialog.this.deleteIPGroup();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddIPServiceLinkDialog.this.editIpGroup();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[0];
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[0];
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem2);
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                AddIPServiceLinkDialog.this.editIpGroup();
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.ipGroupTablePanel.applyTableSettings();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel6, "North");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel7, gridBagConstraints);
        jPanel7.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP traffic service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("End date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountingPeriodLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)this.accountingPeriodLabel, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.serviceNameTextField, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        this.donTChangeRecurringCheckBox = new JCheckBox();
        this.donTChangeRecurringCheckBox.setEnabled(true);
        this.$$$loadButtonText$$$(this.donTChangeRecurringCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't charge recurring fee"));
        this.donTChangeRecurringCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't charge slink hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.donTChangeRecurringCheckBox, gridBagConstraints);
        this.decreasePrepaidTrafficCheckBox = new JCheckBox();
        this.decreasePrepaidTrafficCheckBox.setEnabled(true);
        this.$$$loadButtonText$$$(this.decreasePrepaidTrafficCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Decrease prepaid traffic"));
        this.decreasePrepaidTrafficCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Decrease prepaid traffic slink hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.decreasePrepaidTrafficCheckBox, gridBagConstraints);
        this.selectDiscountPeriodButton = new JButton();
        this.selectDiscountPeriodButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectDiscountPeriodButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.selectDiscountPeriodButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.startDateDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.expireDateDateTime, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel18, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP Groups"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel18.add((Component)jLabel4, gridBagConstraints);
        this.deleteIPGroupButton = new JButton();
        this.deleteIPGroupButton.setEnabled(true);
        this.deleteIPGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteIPGroupButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel18.add((Component)this.deleteIPGroupButton, gridBagConstraints);
        this.addIPGroupButton = new JButton();
        this.addIPGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addIPGroupButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel18.add((Component)this.addIPGroupButton, gridBagConstraints);
        this.editIPGroupButton = new JButton();
        this.editIPGroupButton.setEnabled(true);
        this.editIPGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edit16.png")));
        this.$$$loadButtonText$$$(this.editIPGroupButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel18.add((Component)this.editIPGroupButton, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel18.add((Component)jPanel19, gridBagConstraints);
        jPanel19.add((Component)this.ipGroupTablePanel, "Center");
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel18.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel18.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel18.add((Component)jPanel22, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel18.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel18.add((Component)jPanel24, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel25, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Quotas"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel25.add((Component)jLabel5, gridBagConstraints);
        this.deleteQuotaButton = new JButton();
        this.deleteQuotaButton.setEnabled(true);
        this.deleteQuotaButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteQuotaButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel25.add((Component)this.deleteQuotaButton, gridBagConstraints);
        this.addQuotaButton = new JButton();
        this.addQuotaButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addQuotaButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel25.add((Component)this.addQuotaButton, gridBagConstraints);
        this.editQuotaButton = new JButton();
        this.editQuotaButton.setEnabled(true);
        this.editQuotaButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edit16.png")));
        this.$$$loadButtonText$$$(this.editQuotaButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel25.add((Component)this.editQuotaButton, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        jPanel26.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel25.add((Component)jPanel26, gridBagConstraints);
        jPanel26.add((Component)this.quotaTablePanel, "Center");
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel25.add((Component)jPanel27, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel25.add((Component)jPanel28, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel25.add((Component)jPanel29, gridBagConstraints);
        JPanel jPanel30 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel25.add((Component)jPanel30, gridBagConstraints);
        JPanel jPanel31 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel25.add((Component)jPanel31, gridBagConstraints);
        JPanel jPanel32 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel32, gridBagConstraints);
        JPanel jPanel33 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel33, gridBagConstraints);
        JPanel jPanel34 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel34, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

