/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.sl.SLFunctions;
import biz.netup.projects.utmadmin.functions.objects.HotspotSL;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddHotspotServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JTextField accountingPeriodTextField;
    private JButton selectDiscountPeriodButton;
    private JCheckBox donTChangeRecurringCheckBox;
    private JTextField loginTextField;
    private JPasswordField passwordPasswordField;
    private JPasswordField confirmPasswordPasswordField;
    private JLabel accountingPeriodLabel;
    private JDateTime startDateDateTime;
    private JDateTime expireDateDateTime;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    private int slinkId;
    private int tariffLinkId;
    HotspotSL hotspotSL;
    private static final Logger logger = Utils.getLogger();

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    public AddHotspotServiceLinkDialog(int n, int n2, int n3, String string, int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.hotspotSL = new HotspotSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
            this.expireDateDateTime.setDate(new Date(2000000000000L));
            this.donTChangeRecurringCheckBox.setSelected("1".equals(Settings.getValueFromPerst("RecalcAbonHotspotSL")));
        } else {
            this.loadHotspotSL();
            this.disableSelectElements();
        }
        if (n5 != 0) {
            this.discountPeriod = n6;
            this.disableDiscountElements();
        }
    }

    private void disableSelectElements() {
        this.selectDiscountPeriodButton.setEnabled(false);
        this.startDateDateTime.setEnabled(false);
        this.expireDateDateTime.setEnabled(false);
        this.donTChangeRecurringCheckBox.setEnabled(false);
    }

    private void disableDiscountElements() {
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        this.selectDiscountPeriodButton.setEnabled(false);
    }

    private void loadHotspotSL() {
        try {
            this.hotspotSL = SLFunctions.getHotspotSL(this.slinkId);
            this.startDateDateTime.setDate(new Date((long)this.hotspotSL.getStartDate() * 1000L));
            this.expireDateDateTime.setDate(new Date((long)this.hotspotSL.getExpireDate() * 1000L));
            this.discountPeriod = this.hotspotSL.getDiscountPeriodId();
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            this.donTChangeRecurringCheckBox.setSelected(this.hotspotSL.isUnabon());
            this.loginTextField.setText(this.hotspotSL.getHotspotLogin());
            this.passwordPasswordField.setText(this.hotspotSL.getHotspotPassword());
            this.confirmPasswordPasswordField.setText(this.hotspotSL.getHotspotPassword());
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException.getMessage(), urfaException);
        }
    }

    public AddHotspotServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
    }

    public AddHotspotServiceLinkDialog() {
        this.$$$setupUI$$$();
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(430, 350);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Hotspot service link"));
        this.setIconImage(imageIcon.getImage());
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddHotspotServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddHotspotServiceLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddHotspotServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddHotspotServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectDiscountPeriodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddHotspotServiceLinkDialog.this.selectDiscountPeriod();
            }
        });
    }

    private void selectDiscountPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.buttonOK.setEnabled(true);
            this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        }
    }

    private void onOK() {
        if (this.discountPeriod == 0) {
            Dialogs.showErrorDialog("Discount period doesn't selected");
            return;
        }
        if (new String(this.passwordPasswordField.getPassword()).compareTo(new String(this.confirmPasswordPasswordField.getPassword())) != 0) {
            Dialogs.showErrorDialog("Password doesn't match");
            return;
        }
        if (!Checkers.loginSLOk(this.loginTextField.getText())) {
            Dialogs.showErrorDialog("Login is incorrect");
            return;
        }
        this.hotspotSL.setAccountId(this.aid);
        this.hotspotSL.setUserId(this.uid);
        this.hotspotSL.setDiscountPeriodId(this.discountPeriod);
        this.hotspotSL.setExpireDate((int)(this.expireDateDateTime.getDate().getTime() / 1000L));
        this.hotspotSL.setServiceId(this.serviceId);
        this.hotspotSL.setServiceType(4);
        this.hotspotSL.setStartDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        this.hotspotSL.setHotspotLogin(this.loginTextField.getText());
        this.hotspotSL.setHotspotPassword(new String(this.passwordPasswordField.getPassword()));
        this.hotspotSL.setUnabon(this.donTChangeRecurringCheckBox.isSelected());
        this.hotspotSL.setTariffLinkId(this.tariffLinkId);
        this.hotspotSL.setSlinkId(this.slinkId);
        try {
            if (this.slinkId == 0) {
                SLFunctions.addHotspotSL(this.hotspotSL);
            } else {
                SLFunctions.editHotspotSL(this.hotspotSL);
            }
            this.dispose();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog(urfaException.getMessage());
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.startDateDateTime = new JDateTime();
        this.startDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startDateDateTime.getButton().setText("");
        this.expireDateDateTime = new JDateTime();
        this.expireDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/up16.png")));
        this.expireDateDateTime.getButton().setText("");
        this.expireDateDateTime.setInfinity(true);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel6, gridBagConstraints);
        jPanel6.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Hotspot service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Expire date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountingPeriodLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)this.accountingPeriodLabel, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.serviceNameTextField, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        this.selectDiscountPeriodButton = new JButton();
        this.selectDiscountPeriodButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectDiscountPeriodButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.selectDiscountPeriodButton, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.loginTextField, gridBagConstraints);
        this.passwordPasswordField = new JPasswordField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.passwordPasswordField, gridBagConstraints);
        this.confirmPasswordPasswordField = new JPasswordField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.confirmPasswordPasswordField, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password confirm"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.startDateDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.expireDateDateTime, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel18, gridBagConstraints);
        this.donTChangeRecurringCheckBox = new JCheckBox();
        this.donTChangeRecurringCheckBox.setEnabled(true);
        this.$$$loadButtonText$$$(this.donTChangeRecurringCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't charge recurring fee"));
        this.donTChangeRecurringCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't charge slink hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.donTChangeRecurringCheckBox, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel19, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel22, gridBagConstraints);
        jLabel4.setLabelFor(this.loginTextField);
        jLabel5.setLabelFor(this.passwordPasswordField);
        jLabel6.setLabelFor(this.confirmPasswordPasswordField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

