/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.account.accountsdialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetAccountExternalId;
import biz.netup.control.transport.urfa.functions.UrfaGetSetting;
import biz.netup.control.transport.urfa.functions.UrfaIsAccountExternalIdUsed;
import biz.netup.control.transport.urfa.functions.UrfaSetAccountExternalId;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.accounts.AccountFunctions;
import biz.netup.projects.utmadmin.functions.objects.Account;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.PermissionTextField;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserAccountEditDialog
extends DialogModel {
    private JPanel contentPane;
    private JTextField accountIdTextField;
    private JComboBox blockedComboBox;
    private JTextField vatRateTextField;
    private JTextField saleTaxRateTextField;
    private JTextField creditTextField;
    private JTextField balanceTextField;
    private JCheckBox donTChargeRecurringCheckBox;
    private JCheckBox decreasePrepaidTrafficCheckBox;
    private JComboBox internetStatusComboBox;
    private JCheckBox blockPeriodCheckBox;
    private JDateTime startPeriodDateTime;
    private JDateTime endPeriodDateTime;
    private JCheckBox unlimitedModeCheckBox;
    private JLabel accountLabel;
    private JLabel balanceLabel;
    private JTextField textField1;
    private PermissionTextField externalIdTextField;
    private JLabel externalIdLabel;
    private int prevBlockState;
    private int aid;
    private int uid;
    private String externalIdStart = "";

    private void changeBlockStatus() {
        if (this.blockPeriodCheckBox.isSelected()) {
            this.startPeriodDateTime.setEnabled(true);
            this.endPeriodDateTime.setEnabled(true);
        } else {
            this.startPeriodDateTime.setEnabled(false);
            this.endPeriodDateTime.setEnabled(false);
        }
    }

    private void initFields() throws UrfaException {
        if (this.aid == 0) {
            this.blockPeriodCheckBox.setEnabled(false);
            this.balanceLabel.setEnabled(false);
            this.accountLabel.setEnabled(false);
            if (Utils.isAdmin()) {
                UrfaGetSetting urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("default_vat_rate");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    try {
                        this.vatRateTextField.setText("" + Double.parseDouble(urfaGetSetting.getValue()[0]) * 100.0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.log(2, "default_vat_rate format is incorrect");
                    }
                }
                urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("block_recalc_abon");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    try {
                        this.donTChargeRecurringCheckBox.setSelected(Integer.parseInt(urfaGetSetting.getValue()[0]) == 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.log(2, "block_recalc_abon format is incorrect");
                    }
                }
                urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("block_recalc_prepaid");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    try {
                        this.decreasePrepaidTrafficCheckBox.setSelected(Integer.parseInt(urfaGetSetting.getValue()[0]) == 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.log(2, "block_recalc_prepaid format is incorrect");
                    }
                }
            }
            this.blockedComboBox.removeItemAt(5);
        } else {
            int n;
            Account account = AccountFunctions.getAccount(this.aid);
            this.accountIdTextField.setText("" + account.getAccountId());
            this.internetStatusComboBox.setSelectedIndex(account.getIntStatus());
            this.prevBlockState = n = account.getBlocked();
            if (n == 0) {
                this.blockedComboBox.setSelectedIndex(0);
                this.blockPeriodCheckBox.setEnabled(false);
                this.blockedComboBox.removeItemAt(5);
            } else if ((n & 0x100) != 0) {
                if ((n & 0x200) > 0 && (n & 0x400) > 0) {
                    this.blockedComboBox.setSelectedIndex(4);
                } else if ((n & 0x200) > 0) {
                    this.blockedComboBox.setSelectedIndex(2);
                } else if ((n & 0x400) > 0) {
                    this.blockedComboBox.setSelectedIndex(3);
                } else {
                    this.blockedComboBox.setSelectedIndex(1);
                }
                this.blockedComboBox.removeItemAt(5);
            } else {
                this.blockedComboBox.setSelectedIndex(5);
            }
            this.vatRateTextField.setText("" + (double)((long)(account.getVatRate() * 10000.0)) / 100.0);
            this.creditTextField.setText("" + (double)((long)(account.getCredit() * 1000.0)) / 1000.0);
            this.saleTaxRateTextField.setText("" + (double)((long)(account.getSaleTaxRate() * 10000.0)) / 100.0);
            this.balanceTextField.setText("" + (double)((long)(account.getBalance() * 1000.0)) / 1000.0);
            if (account.blockRecalcPrepaid == 0) {
                this.decreasePrepaidTrafficCheckBox.setSelected(true);
            }
            if (account.blockRecalcAbon == 0) {
                this.donTChargeRecurringCheckBox.setSelected(true);
            }
            if (Utils.isAdmin()) {
                if (account.getUnlimited() == 1) {
                    this.unlimitedModeCheckBox.setSelected(true);
                }
                if (UrfaManagerImpl.getInstance().isPermitted(8249)) {
                    UrfaGetAccountExternalId urfaGetAccountExternalId = new UrfaGetAccountExternalId(UrfaManagerImpl.getInstance());
                    urfaGetAccountExternalId.setAid(this.aid);
                    urfaGetAccountExternalId.call();
                    this.externalIdTextField.setText(urfaGetAccountExternalId.getExternalId());
                    this.externalIdStart = urfaGetAccountExternalId.getExternalId();
                }
            }
        }
    }

    private int createAccount() throws UrfaException {
        return AccountFunctions.addAccount(this.uid);
    }

    private void saveAccount() throws UrfaException {
        Account account = new Account();
        account.setAccountId(this.aid);
        int n = 0;
        int n2 = this.blockedComboBox.getSelectedIndex();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 256;
        } else if (n2 == 2) {
            n = 768;
        } else if (n2 == 3) {
            n = 1280;
        } else if (n2 == 4) {
            n = 1792;
        } else if (n2 == 5) {
            n = this.prevBlockState;
        }
        account.setBlocked(n);
        if (this.blockPeriodCheckBox.isSelected()) {
            account.setStartDate((int)(this.startPeriodDateTime.getDate().getTime() / 1000L));
            account.setEndDate((int)(this.endPeriodDateTime.getDate().getTime() / 1000L));
        }
        account.setCredit(Double.parseDouble(this.creditTextField.getText()));
        account.setIntStatus(this.internetStatusComboBox.getSelectedIndex());
        if (this.donTChargeRecurringCheckBox.isSelected()) {
            account.setBlockRecalcAbon(0);
        } else {
            account.setBlockRecalcAbon(1);
        }
        if (this.decreasePrepaidTrafficCheckBox.isSelected()) {
            account.setBlockRecalcPrepaid(0);
        } else {
            account.setBlockRecalcPrepaid(1);
        }
        account.setSaleTaxRate(Double.parseDouble(this.saleTaxRateTextField.getText()) / 100.0);
        account.setVatRate(Double.parseDouble(this.vatRateTextField.getText()) / 100.0);
        if (Utils.isAdmin()) {
            account.setUnlimited(this.unlimitedModeCheckBox.isSelected() ? 1 : 0);
        }
        AccountFunctions.editAccount(account);
    }

    public UserAccountEditDialog() {
        this.$$$setupUI$$$();
    }

    public UserAccountEditDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.contentPane;
    }

    @Override
    public String getItemName() {
        return "Account";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.aid = (Integer)this.item.get("aid");
        this.uid = (Integer)this.item.get("uid");
        if (!Utils.isAdmin()) {
            this.unlimitedModeCheckBox.setVisible(false);
            this.externalIdTextField.setVisible(false);
            this.externalIdLabel.setVisible(false);
        }
        this.internetStatusComboBox.addItem(this.resource.getString("Off"));
        this.internetStatusComboBox.addItem(this.resource.getString("On"));
        this.blockedComboBox.addItem(this.resource.getString("No"));
        this.blockedComboBox.addItem(this.resource.getString("Yes"));
        this.blockedComboBox.addItem(this.resource.getString("Yes (RRF)"));
        this.blockedComboBox.addItem(this.resource.getString("Yes (RPR)"));
        this.blockedComboBox.addItem(this.resource.getString("Yes (RRF and RPR)"));
        this.blockedComboBox.addItem(this.resource.getString("Yes (non admin block)"));
        this.initFields();
        this.blockPeriodCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAccountEditDialog.this.changeBlockStatus();
            }
        });
        this.blockedComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UserAccountEditDialog.this.blockedComboBox.getSelectedIndex() == 0) {
                    UserAccountEditDialog.this.blockPeriodCheckBox.setSelected(false);
                    UserAccountEditDialog.this.blockPeriodCheckBox.setEnabled(false);
                } else {
                    UserAccountEditDialog.this.blockPeriodCheckBox.setEnabled(true);
                }
            }
        });
        this.unlimitedModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UserAccountEditDialog.this.unlimitedModeCheckBox.isSelected() && !Dialogs.showYesNoDialog(UserAccountEditDialog.this.resource.getString("Unlimited warning"))) {
                    UserAccountEditDialog.this.unlimitedModeCheckBox.setSelected(false);
                }
            }
        });
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.aid == 0) {
            this.aid = this.createAccount();
            if (this.aid != 0) {
                this.saveAccount();
            }
        } else {
            this.saveAccount();
        }
        if (!this.externalIdStart.equals(this.externalIdTextField.getText()) && UrfaManagerImpl.getInstance().isPermitted(new int[]{8248, 8250})) {
            UrfaSetAccountExternalId urfaSetAccountExternalId = new UrfaSetAccountExternalId(UrfaManagerImpl.getInstance());
            urfaSetAccountExternalId.setAid(this.aid);
            urfaSetAccountExternalId.setExternalId(this.externalIdTextField.getText());
            urfaSetAccountExternalId.call();
            if (urfaSetAccountExternalId.getResult() <= 0) {
                this.log.log(1, this.resource.getString("External account ID") + " " + this.resource.getString("field is invalid"));
                this.externalIdTextField.requestFocus();
                this.externalIdTextField.setBackground(new Color(255, 204, 204));
                throw new UrfaException(this.resource.getString("External account ID") + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkDouble(this.vatRateTextField, "VAT rate");
        this.checkDouble(this.saleTaxRateTextField, "Sale tax rate");
        this.checkDouble(this.creditTextField, "Credit");
        if (!this.settingListeners) {
            if (Double.parseDouble(this.vatRateTextField.getText()) != 0.0 && (Double.parseDouble(this.vatRateTextField.getText()) < 1.0 || Double.parseDouble(this.vatRateTextField.getText()) > 100.0) && JOptionPane.showConfirmDialog(this, this.resource.getString("Are you sure") + " \"" + this.resource.getString("VAT rate") + "\" = " + this.vatRateTextField.getText() + "%?", "Warning", 2) != 0) {
                throw new IllegalArgumentException("");
            }
            if (Double.parseDouble(this.saleTaxRateTextField.getText()) != 0.0 && (Double.parseDouble(this.saleTaxRateTextField.getText()) < 1.0 || Double.parseDouble(this.saleTaxRateTextField.getText()) > 100.0) && JOptionPane.showConfirmDialog(this, this.resource.getString("Are you sure") + " \"" + this.resource.getString("Sale tax rate") + "\" = " + this.saleTaxRateTextField.getText() + "%?", "Warning", 2) != 0) {
                throw new IllegalArgumentException("");
            }
            if (!this.externalIdStart.equals(this.externalIdTextField.getText())) {
                try {
                    if (UrfaManagerImpl.getInstance().isPermitted(new int[]{8248, 8250})) {
                        UrfaIsAccountExternalIdUsed urfaIsAccountExternalIdUsed = new UrfaIsAccountExternalIdUsed(UrfaManagerImpl.getInstance());
                        urfaIsAccountExternalIdUsed.setExternalId(this.externalIdTextField.getText());
                        urfaIsAccountExternalIdUsed.call();
                        if (urfaIsAccountExternalIdUsed.getAid() != 0 && urfaIsAccountExternalIdUsed.getAid() != this.aid) {
                            this.log.log(1, this.resource.getString("External account ID") + " - " + this.resource.getString("already exists"));
                            this.externalIdTextField.requestFocus();
                            this.externalIdTextField.setBackground(new Color(255, 204, 204));
                            throw new IllegalArgumentException();
                        }
                    }
                }
                catch (UrfaException urfaException) {
                    this.log.log(1, urfaException);
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void createUIComponents() {
        this.startPeriodDateTime = new JDateTime();
        this.startPeriodDateTime.setDate(TZ.getCoreTime());
        this.startPeriodDateTime.setEnabled(false);
        this.endPeriodDateTime = new JDateTime();
        this.endPeriodDateTime.setDate(new Date(2000000000000L));
        this.endPeriodDateTime.setEnabled(false);
        this.externalIdTextField = new PermissionTextField(new int[]{8249, 8248});
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.contentPane.setMinimumSize(new Dimension(480, 250));
        this.contentPane.setPreferredSize(new Dimension(480, 250));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setMinimumSize(new Dimension(509, 294));
        jPanel.add((Component)jPanel2, "Center");
        this.accountIdTextField = new JTextField();
        this.accountIdTextField.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.accountIdTextField, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Block ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.vatRateTextField = new JTextField();
        this.vatRateTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.vatRateTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Sale tax rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel8, gridBagConstraints);
        this.accountLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.accountLabel, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("VAT rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.blockedComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.blockedComboBox, gridBagConstraints);
        this.saleTaxRateTextField = new JTextField();
        this.saleTaxRateTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.saleTaxRateTextField, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel10, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Internet status"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        this.internetStatusComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.internetStatusComboBox, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridBagLayout());
        jPanel12.add((Component)jPanel13, "East");
        jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.blockPeriodCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.blockPeriodCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Block period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel13.add((Component)this.blockPeriodCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel13.add((Component)this.endPeriodDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel13.add((Component)this.startPeriodDateTime, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel13.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridBagLayout());
        jPanel12.add((Component)jPanel15, "West");
        this.unlimitedModeCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.unlimitedModeCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Unlimited account"));
        this.unlimitedModeCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Unlimited mode hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel15.add((Component)this.unlimitedModeCheckBox, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jPanel15.add((Component)jPanel16, gridBagConstraints);
        jPanel16.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("In blocked state")));
        this.donTChargeRecurringCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.donTChargeRecurringCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't charge recurring fee"));
        this.donTChargeRecurringCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't charge hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel16.add((Component)this.donTChargeRecurringCheckBox, gridBagConstraints);
        this.decreasePrepaidTrafficCheckBox = new JCheckBox();
        this.decreasePrepaidTrafficCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(this.decreasePrepaidTrafficCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Decrease prepaid traffic"));
        this.decreasePrepaidTrafficCheckBox.setToolTipText(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Decrease prepaid traffic hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel16.add((Component)this.decreasePrepaidTrafficCheckBox, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel15.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel18, gridBagConstraints);
        this.creditTextField = new JTextField();
        this.creditTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.creditTextField, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Credit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        this.balanceLabel = new JLabel();
        this.$$$loadLabelText$$$(this.balanceLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ballance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.balanceLabel, gridBagConstraints);
        this.balanceTextField = new JTextField();
        this.balanceTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.balanceTextField, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel19, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel21, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("External account ID"));
        jLabel8.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel8, gridBagConstraints);
        this.textField1 = new JTextField();
        this.textField1.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.textField1, gridBagConstraints);
        this.externalIdLabel = new JLabel();
        this.$$$loadLabelText$$$(this.externalIdLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("External account ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.externalIdLabel, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel22, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.externalIdTextField, gridBagConstraints);
        jLabel.setLabelFor(this.blockedComboBox);
        jLabel2.setLabelFor(this.saleTaxRateTextField);
        this.accountLabel.setLabelFor(this.accountIdTextField);
        jLabel3.setLabelFor(this.vatRateTextField);
        jLabel4.setLabelFor(this.internetStatusComboBox);
        jLabel5.setLabelFor(this.creditTextField);
        this.balanceLabel.setLabelFor(this.balanceTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

