/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetUaparamList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.dealer.permissions.PermissionFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.projects.utmadmin.functions.objects.UTMUser;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.BlocksReportNew;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.BurntPaymentReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.DHSReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.DetailedTrafficReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.GeneralReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.GeneralReportNewAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.GraphReport;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.InvoicesTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.OtherChargesReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.PaymentsReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.ServicesReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.ServicesReportNewAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.TelephonyReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.TrafficReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.UserChangeLogAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.dealers.MainDealersTab;
import biz.netup.projects.utmadmin.gui.userframe.BottomButtons;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.UserSwithAndPortTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.account.UserAccountsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.UserSLinksTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tl.UserTLinksTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tp.UserTechParamsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserAdditionalParamsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserContacts2Tab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserContactsNewTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserContactsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserContractsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserGroupsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserMainParamsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserMiscTab;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.table.TablePanel;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.PrintDialog;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;

public class UserFrame
extends TabbedWindow {
    private UTMUser user;
    private BottomButtons bb;
    private UserMainParamsTab main;
    private UserAdditionalParamsTab additional;
    private UserContactsTab contacts;
    private UserContacts2Tab contacts2;
    private TabPanel contactsNew;
    private UserMiscTab misc;
    private TabPanel accounts;
    private TabPanel tl;
    private TabPanel sl;
    private TabPanel tp;
    TabPanel groups;
    TabPanel snp;
    TabPanel contracts;
    TabPanel blockReportAdmin;
    TabPanel trafficReportAdmin;
    TabPanel paymentsReportAdmin;
    TabPanel dhsReportAdmin;
    TabPanel generalReportAdmin;
    TabPanel telReportAdmin;
    TabPanel serviceReportAdmin;
    TabPanel detailedTrafficReportAdmin;
    TabPanel userChangeLog;
    TabPanel burntPaymentReportAdmin;
    TabPanel invoices;
    TabPanel graphReport;
    TabPanel generalReportNew;
    TabPanel serviceReportNew;
    TabPanel otherChargesReport;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton applyButton;
    private JButton refreshButton;
    private Map<Component, String> editMap;

    public UserFrame(int n) {
        super(n);
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }

    private void initButtons() {
        this.buttonOK = this.bb.getButtonOK();
        this.buttonCancel = this.bb.getButtonCancel();
        this.applyButton = this.bb.getApplyButton();
        this.refreshButton = this.bb.getRefreshButton();
    }

    private void docForUser() {
        PrintDialog printDialog = new PrintDialog(false, null);
        try {
            String string = DocFunctions.generateDocForUser(this.id);
            while (string.indexOf("@PAGE_SEPARATOR@") != -1) {
                printDialog.addPage(string.substring(0, string.indexOf("@PAGE_SEPARATOR@")));
                string = string.substring(string.indexOf("@PAGE_SEPARATOR@") + "@PAGE_SEPARATOR@".length());
            }
            printDialog.addPage(string);
            printDialog.getEditButton().setVisible(false);
            printDialog.setVisible(true);
        }
        catch (UrfaException urfaException) {
            log.error(urfaException);
        }
    }

    private void refresh() {
        if (Dialogs.showYesNoDialog("All changes will be lost. Are you sure?")) {
            try {
                this.setUserData(UserFunctions.getUser(this.id));
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
            this.accounts.refresh();
            this.tl.refresh();
            this.sl.refresh();
            if (this.snp.isAllowedRefresh()) {
                this.snp.refresh();
            }
            if (this.contactsNew != null && this.contactsNew.isAllowedRefresh()) {
                this.contactsNew.refresh();
            }
            this.buttonsStart();
        }
    }

    private void applyChanges() throws UrfaException {
        UserFunctions.editUser(this.getUserData());
    }

    private boolean propertiesIsOk() {
        if (!this.loginIsOk()) {
            Dialogs.showErrorDialog("Login is incorrect");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        if (this.main.getPassword().compareTo(this.main.getConfirmPassword()) != 0) {
            Dialogs.showErrorDialog("Password doesn't match");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        return true;
    }

    private boolean loginIsOk() {
        return this.main.getLogin().length() != 0 && Checkers.loginOk(this.main.getLogin());
    }

    private void onOK() {
        if (this.propertiesIsOk()) {
            try {
                this.applyChanges();
                if (this.snp.isAllowedRefresh()) {
                    ((UserSwithAndPortTab)this.snp).save();
                }
                if (this.contactsNew != null && this.contactsNew.isAllowedRefresh()) {
                    ((UserContactsNewTab)this.contactsNew).save();
                }
                MainFrame.getInstance().refreshUsers();
                this.dispose();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().error("User not saved", urfaException);
            }
        }
    }

    private void onApply() {
        if (this.propertiesIsOk()) {
            try {
                this.applyChanges();
                if (this.snp.isAllowedRefresh()) {
                    ((UserSwithAndPortTab)this.snp).save();
                }
                if (this.contactsNew != null && this.contactsNew.isAllowedRefresh()) {
                    ((UserContactsNewTab)this.contactsNew).save();
                }
                this.buttonsStart();
                MainFrame.getInstance().refreshUsers();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().error("User not saved", urfaException);
            }
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private UTMUser getUserData() {
        UTMUser uTMUser = new UTMUser();
        uTMUser.uid = this.id;
        uTMUser.login = this.main.getLogin();
        uTMUser.password = this.main.getPassword();
        uTMUser.fullName = this.main.getFullName();
        uTMUser.isJuridical = this.contacts.getLegalPersonCheckBox() ? 1 : 0;
        uTMUser.jurAddress = this.contacts.getLegalAddress();
        uTMUser.actAddress = this.contacts.getActualAddress();
        uTMUser.flatNumber = this.contacts.getApartment();
        uTMUser.entrance = this.contacts.getPorch();
        uTMUser.floor = this.contacts.getFloor();
        uTMUser.district = this.contacts.getDistrict();
        uTMUser.building = this.contacts.getBuilding();
        uTMUser.passport = this.additional.getPassport();
        uTMUser.houseId = this.contacts.getBuildingID();
        uTMUser.workTel = this.contacts.getWorkPhone();
        uTMUser.homeTel = this.contacts.getHomePhone();
        uTMUser.mobTel = this.contacts.getMobilePhone();
        uTMUser.webPage = this.contacts.getWebPage();
        uTMUser.icqNumber = this.contacts.getIcqNumber();
        uTMUser.taxNumber = this.additional.getItin();
        uTMUser.kppNumber = this.additional.getRegCode();
        uTMUser.email = this.contacts.getEmail();
        uTMUser.bankId = this.additional.getBankId();
        uTMUser.bankAccount = this.additional.getBankAccount();
        uTMUser.comments = this.additional.getComments();
        uTMUser.personalManager = this.additional.getPersonalManager();
        uTMUser.connectDate = (int)(this.additional.getConnectionDate().getTime() / 1000L);
        uTMUser.isSendInvoice = this.contacts.getSendInvoicesToEmailCheckBox() ? 1 : 0;
        int n = uTMUser.advancePayment = this.main.getPaymentInAdvance() ? 1 : 0;
        if (Utils.isAdmin()) {
            uTMUser.parameterId1 = new int[this.additional.getAdditionalParameters().getTableModel().data.size()];
            uTMUser.parameterValue1 = new String[this.additional.getAdditionalParameters().getTableModel().data.size()];
            int n2 = 0;
            for (Map<String, Object> map : this.additional.getAdditionalParameters().getTableModel().data) {
                uTMUser.parameterId1[n2] = (Integer)map.get("id");
                uTMUser.parameterValue1[n2++] = map.get("value").toString();
            }
        } else {
            uTMUser.parameterId1 = new int[0];
            uTMUser.parameterValue1 = new String[0];
        }
        return uTMUser;
    }

    private void setUserData(UTMUser uTMUser) {
        Cloneable cloneable;
        this.main.setLoginTextField(uTMUser.login);
        this.main.setIDTextField(this.id);
        this.main.setPasswordField(uTMUser.password);
        this.main.setConfirmPasswordField(uTMUser.password);
        this.main.setFullNameTextField(uTMUser.fullName);
        this.main.setPrimaryAccountTextField("" + uTMUser.basicAccount);
        this.main.setPaymentInAdvanceCheckBox(uTMUser.advancePayment == 1);
        this.additional.setBankAccountField(uTMUser.bankAccount);
        this.additional.setBankNameField(uTMUser.bankId);
        this.additional.setCommentsTextArea(uTMUser.comments);
        this.additional.setConnectionDate(new Date((long)uTMUser.connectDate * 1000L));
        this.additional.setItinField(uTMUser.taxNumber);
        this.additional.setPassportField(uTMUser.passport);
        this.additional.setPersonalManagerField(uTMUser.personalManager);
        this.additional.setRegCodeField(uTMUser.kppNumber);
        if (Utils.isAdmin()) {
            this.additional.getAdditionalParameters().getTableModel().removeAllRows();
            cloneable = new HashMap<Integer, String>();
            UrfaGetUaparamList urfaGetUaparamList = new UrfaGetUaparamList(UrfaManagerImpl.getInstance());
            try {
                urfaGetUaparamList.call();
                for (int i = 0; i < urfaGetUaparamList.getUparamSize(); ++i) {
                    if (urfaGetUaparamList.getVisible1()[i] != 1) continue;
                    cloneable.put(urfaGetUaparamList.getId1()[i], urfaGetUaparamList.getDisplayName1()[i]);
                }
            }
            catch (UrfaException urfaException) {
                log.error(urfaException);
            }
            for (int i = 0; i < uTMUser.parameterId1.length; ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", uTMUser.parameterId1[i]);
                hashMap.put("name", uTMUser.parameterName1[i]);
                hashMap.put("value", uTMUser.parameterValue1[i]);
                if (!cloneable.containsKey(uTMUser.parameterId1[i])) continue;
                cloneable.remove(uTMUser.parameterId1[i]);
                this.additional.getAdditionalParameters().getTableModel().addRow(hashMap);
            }
            for (Integer n : cloneable.keySet()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", n);
                hashMap.put("name", cloneable.get(n));
                hashMap.put("value", "");
                this.additional.getAdditionalParameters().getTableModel().addRow(hashMap);
            }
            this.main.getLinkToDealerButton().setVisible(true);
            this.main.getLinkToDealerButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserFrame.this.linkToDealer();
                }
            });
            Permissions.apply((JComponent)this.main.getLinkToDealerButton(), "link_to_dealer");
            Permissions.apply((JComponent)this.main.getGenerateDocumentForUserButton(), "generate_doc");
        } else {
            this.additional.getApPanel().setVisible(false);
        }
        this.contacts.setActualAddressTextField(uTMUser.actAddress);
        this.contacts.setApartmentTextField(uTMUser.flatNumber);
        this.contacts.setBuildingIDTextField(uTMUser.houseId);
        this.contacts.setBuildingTextField(uTMUser.building);
        this.contacts.setDistrictTextField(uTMUser.district);
        this.contacts.setEmailTextField(uTMUser.email);
        this.contacts.setFloorTextField(uTMUser.floor);
        this.contacts.setHomePhoneTextField(uTMUser.homeTel);
        this.contacts.setIcqNumberTextField(uTMUser.icqNumber);
        this.contacts.setLegalAddressTextField(uTMUser.jurAddress);
        this.contacts.setLegalPersonCheckBox(uTMUser.isJuridical == 1);
        this.contacts.setMobilePhoneTextField(uTMUser.mobTel);
        this.contacts.setPorchTextField(uTMUser.entrance);
        if (uTMUser.email.isEmpty()) {
            this.contacts.setSendInvoicesToEmailCheckBox(false);
            this.contacts.sendInvoices().setEnabled(false);
        } else {
            this.contacts.setSendInvoicesToEmailCheckBox(uTMUser.isSendInvoice == 1);
        }
        this.contacts.setWebPageTextField(uTMUser.webPage);
        this.contacts.setWorkPhoneTextField(uTMUser.workTel);
        cloneable = new SimpleDateFormat();
        this.misc.setCreatedByTextField(Resolve.getUserName(uTMUser.whoCreate));
        this.misc.setModifiedByTextField(Resolve.getUserName(uTMUser.whoChange));
        this.misc.setCreatedOnTextField(((DateFormat)cloneable).format(new Date((long)uTMUser.createDate * 1000L)));
        this.misc.setModifiedLastTimeOnTextField(((DateFormat)cloneable).format(new Date((long)uTMUser.lastChangeDate * 1000L)));
    }

    private void linkToDealer() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainDealersTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            PermissionFunctions.changePerm((Integer)selectFromTableDialogModel.getItem().get("id"), 1, new int[]{this.id}, 1);
        }
    }

    public int getUid() {
        return this.id;
    }

    private void registerButtons() {
        this.registerComponent(this.main.getLoginTextField());
        this.registerComponent(this.main.getFullNameTextField());
        this.registerComponent(this.main.getPasswordField());
        this.registerComponent(this.main.getConfirmPasswordField());
        this.registerComponent(this.main.getPaymentInAdvanceCheckBox());
        this.registerComponent(this.additional.getPassportField());
        this.registerComponent(this.additional.getItinField());
        this.registerComponent(this.additional.getRegCodeField());
        this.registerComponent(this.additional.getBankNameField());
        this.registerComponent(this.additional.getBankAccountField());
        this.registerComponent(this.additional.getCommentsTextArea());
        this.registerComponent(this.additional.getPersonalManagerField());
        this.registerComponent(this.additional.getConnectionDateDateTime());
        this.registerComponent(this.additional.getAdditionalParameters());
        this.registerComponent(this.contacts.getWebPageTextField());
        this.registerComponent(this.contacts.getLegalPersonCheckBoxC());
        this.registerComponent(this.contacts.getLegalAddressTextField());
        this.registerComponent(this.contacts.getActualAddressTextField());
        this.registerComponent(this.contacts.getApartmentTextField());
        this.registerComponent(this.contacts.getPorchTextField());
        this.registerComponent(this.contacts.getFloorTextField());
        this.registerComponent(this.contacts.getDistrictTextField());
        this.registerComponent(this.contacts.getWorkPhoneTextField());
        this.registerComponent(this.contacts.getIcqNumberTextField());
        this.registerComponent(this.contacts.getHomePhoneTextField());
        this.registerComponent(this.contacts.getMobilePhoneTextField());
        this.registerComponent(this.contacts.getEmailTextField());
        this.registerComponent(this.contacts.getBuildingTextField());
        this.registerComponent(this.contacts.getSendInvoicesToEmailCheckBoxC());
        this.registerComponent(this.contacts.getBuildingIDTextField());
        if (Utils.isAdmin()) {
            if (this.snp != null && this.snp.isAllowedRefresh()) {
                this.registerComponent(((UserSwithAndPortTab)this.snp).getRemoteSwitchComboBox());
                this.registerComponent(((UserSwithAndPortTab)this.snp).getPortTextField());
                this.registerComponent(((UserSwithAndPortTab)this.snp).getCurrencyComboBox());
            }
            if (this.contactsNew != null && this.contactsNew.isAllowedRefresh()) {
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getEMailTextField1());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getPositionNameTextField1());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getFullNameTextField1());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getReasonTextField1());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getShortNameTextField1());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getTelephoneTextField1());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getEMailTextField2());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getPositionNameTextField2());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getFullNameTextField2());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getReasonTextField2());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getShortNameTextField2());
                this.registerComponent(((UserContactsNewTab)this.contactsNew).getTelephoneTextField2());
            }
        }
    }

    private void registerComponent(final Component component) {
        if (component instanceof JTextComponent) {
            this.editMap.put(component, ((JTextComponent)component).getText());
            ((JTextComponent)component).addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    if (!((String)UserFrame.this.editMap.get(component)).equals(((JTextComponent)component).getText())) {
                        UserFrame.this.editMap.put(component, ((JTextComponent)component).getText());
                        UserFrame.this.buttonsEdit();
                    }
                }
            });
        }
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserFrame.this.buttonsEdit();
                }
            });
        }
        if (component instanceof JDateTime) {
            ((JDateTime)component).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    UserFrame.this.buttonsEdit();
                }
            });
        }
        if (component instanceof TablePanel) {
            ((TablePanel)((Object)component)).getTableModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    UserFrame.this.buttonsEdit();
                }
            });
        }
        if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserFrame.this.buttonsEdit();
                }
            });
        }
    }

    private void buttonsStart() {
        this.buttonOK.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.buttonCancel.setText(this.resource.getString("Close"));
    }

    private void buttonsEdit() {
        if (Permissions.isPermitted("edit_user")) {
            this.buttonOK.setEnabled(true);
            this.applyButton.setEnabled(true);
            this.buttonCancel.setText(this.resource.getString("Cancel"));
        }
    }

    @Override
    protected void init() {
        this.editMap = new HashMap<Component, String>();
        this.iconPanel.setVisible(false);
        this.bb = new BottomButtons();
        this.initButtons();
        this.user = new UTMUser();
        try {
            this.user = UserFunctions.getUser(this.id);
        }
        catch (UrfaException urfaException) {
            log.error(urfaException);
        }
        if (Utils.isAdmin()) {
            this.tp = new UserTechParamsTab(this.id);
            this.groups = new UserGroupsTab(this.id);
            this.snp = new UserSwithAndPortTab(this.id);
            this.contactsNew = new UserContactsNewTab(this.id);
            this.snp.getPanel();
            this.contactsNew.getPanel();
            this.contracts = new UserContractsTab(this.id);
        }
        this.blockReportAdmin = new BlocksReportNew(this.id);
        this.trafficReportAdmin = new TrafficReportAdmin(this.id);
        this.paymentsReportAdmin = new PaymentsReportAdmin(this.id);
        this.dhsReportAdmin = new DHSReportAdmin(this.id);
        this.generalReportAdmin = new GeneralReportAdmin(this.id);
        this.telReportAdmin = new TelephonyReportAdmin(this.id);
        this.serviceReportAdmin = new ServicesReportAdmin(this.id);
        this.detailedTrafficReportAdmin = new DetailedTrafficReportAdmin(this.id);
        this.userChangeLog = new UserChangeLogAdmin(this.id);
        this.burntPaymentReportAdmin = new BurntPaymentReportAdmin(this.id);
        this.invoices = new InvoicesTab(this.id);
        this.graphReport = new GraphReport(this.id);
        this.generalReportNew = new GeneralReportNewAdmin(this.id);
        this.serviceReportNew = new ServicesReportNewAdmin(this.id);
        this.otherChargesReport = new OtherChargesReportAdmin(this.id);
        this.main = new UserMainParamsTab();
        this.additional = new UserAdditionalParamsTab();
        this.contacts = new UserContactsTab();
        this.contacts2 = new UserContacts2Tab(this.id);
        this.misc = new UserMiscTab();
        this.accounts = new UserAccountsTab(this.id, this.user.basicAccount);
        this.tl = new UserTLinksTab(this.id);
        this.sl = new UserSLinksTab(this.id);
        if (this.id == 0) {
            return;
        }
        this.setTitle(this.resource.getString("User") + " " + this.user.getLogin());
        this.setUserData(this.user);
        this.registerButtons();
        this.buttonsStart();
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserFrame.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserFrame.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UserFrame.this.onCancel();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserFrame.this.onApply();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserFrame.this.refresh();
            }
        });
        this.main.getGenerateDocumentForUserButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserFrame.this.docForUser();
            }
        });
        this.main.getRefreshButton().setEnabled(false);
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(1080, 650);
    }

    @Override
    protected String getWindowTitle() {
        return "User";
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.main);
        vector.add(this.additional);
        vector.add(this.contacts);
        if (Utils.isAdmin()) {
            if (this.contactsNew.isAllowedRefresh()) {
                vector.add(this.contactsNew);
            } else {
                vector.add(this.contacts2);
            }
            vector.add(this.groups);
            vector.add(this.snp);
            vector.add(this.contracts);
        } else {
            vector.add(this.contacts2);
        }
        vector.add(this.misc);
        vector.add(this.accounts);
        vector.add(this.sl);
        vector.add(this.tl);
        if (Utils.isAdmin()) {
            vector.add(this.tp);
        }
        vector.add(this.generalReportAdmin);
        vector.add(this.generalReportNew);
        vector.add(this.blockReportAdmin);
        vector.add(this.trafficReportAdmin);
        vector.add(this.telReportAdmin);
        vector.add(this.dhsReportAdmin);
        vector.add(this.paymentsReportAdmin);
        vector.add(this.serviceReportAdmin);
        vector.add(this.serviceReportNew);
        vector.add(this.otherChargesReport);
        if (Utils.isAdmin()) {
            vector.add(this.detailedTrafficReportAdmin);
            vector.add(this.invoices);
            vector.add(this.userChangeLog);
            vector.add(this.burntPaymentReportAdmin);
            vector.add(this.graphReport);
        }
        return vector;
    }
}

