/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.serviceframe.forms;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.TClassFunctions;
import biz.netup.projects.utmadmin.functions.objects.TClass;
import biz.netup.projects.utmadmin.gui.serviceframe.ServiceFrame;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ServiceIPGroupsTab
extends TabPanel {
    TClass[] tclasses;
    private Map<String, TClass> classMap = new LinkedHashMap<String, TClass>();
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    private TablePanelImpl groupsTablePanel;
    private JComboBox groupTypeComboBox;
    private JComboBox classIDComboBox;
    private ServiceFrame serviceFrame;

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return "Service";
    }

    @Override
    public String getTabName() {
        return "Groups";
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    public boolean isMax() {
        return "max".compareTo((String)this.groupTypeComboBox.getSelectedItem()) == 0;
    }

    public void setPanelEnabled(boolean bl) {
        this.groupsTablePanel.unregisterAllButtons();
        this.deleteButton.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.classIDComboBox.setEnabled(bl);
        this.groupTypeComboBox.setEnabled(bl);
        if (bl) {
            this.groupsTablePanel.registerMultiRowButton(this.deleteButton);
            if (this.groupsTablePanel.getSelectedTableRows().length > 0) {
                this.deleteButton.setEnabled(true);
            }
        }
    }

    public ServiceIPGroupsTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/service/groups_24.png")));
        this.$$$setupUI$$$();
        this.fillGroups();
        this.fillClassId();
        this.groupsTablePanel.registerMultiRowButton(this.deleteButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceIPGroupsTab.this.addTB();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceIPGroupsTab.this.removeTB();
            }
        });
        this.groupTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceIPGroupsTab.this.checkLock();
            }
        });
    }

    public ServiceIPGroupsTab(ServiceFrame serviceFrame) {
        this();
        this.serviceFrame = serviceFrame;
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void refreshTable() {
    }

    private void createTable() {
        this.groupsTablePanel = new TablePanelImpl(this.getClass().getName() + "_groups", true);
        MapTableModel mapTableModel = this.groupsTablePanel.getTableModel();
        mapTableModel.addColumn("tclass_name", "Traffic class", true, false);
        this.groupsTablePanel.setEditable(false);
        this.groupsTablePanel.setAppendable(false);
        this.groupsTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                if (!ServiceIPGroupsTab.this.addButton.isEnabled()) {
                    return null;
                }
                JMenuItem jMenuItem = new JMenuItem(ServiceIPGroupsTab.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(ServiceIPGroupsTab.this.resource.getString("Add"));
                JMenuItem jMenuItem3 = new JMenuItem(ServiceIPGroupsTab.this.resource.getString("Remove"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ServiceIPGroupsTab.this.refreshTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ServiceIPGroupsTab.this.addTB();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ServiceIPGroupsTab.this.removeTB();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem3, jMenuItem};
                }
                return new JMenuItem[]{jMenuItem3, jMenuItem};
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.groupsTablePanel.applyTableSettings();
    }

    private void addTB() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("tclass", this.classMap.get(this.classIDComboBox.getSelectedItem()).getTclassId());
        hashMap.put("tclass_name", this.classMap.get(this.classIDComboBox.getSelectedItem()).getTclassName());
        for (Map<String, Object> map : this.groupsTablePanel.getTableModel().data) {
            if (map.get("tclass") != hashMap.get("tclass")) continue;
            Dialogs.showErrorDialog("Attempt to add one more group value for tclass");
            return;
        }
        if ("max".compareTo((String)this.groupTypeComboBox.getSelectedItem()) == 0) {
            hashMap.put("group_id", 1);
            hashMap.put("group", "max");
        } else {
            hashMap.put("group_id", 2);
            hashMap.put("group", "sum");
        }
        this.groupsTablePanel.getTableModel().addRow(hashMap);
        this.groupsTablePanel.repaint();
        this.checkLock();
        this.fillClassId();
    }

    private void removeTB() {
        if (Dialogs.showYesNoDialog(this.resource.getString("delete_warn") + " \"" + this.resource.getString(this.getTabName()) + "\"?")) {
            for (Map<String, Object> map : this.groupsTablePanel.getSelectedTableRows()) {
                this.groupsTablePanel.getTableModel().removeRow(map);
            }
        }
        this.checkLock();
        this.fillClassId();
    }

    public Component getTab() {
        return this.mainPanel;
    }

    public Vector<Map<String, Object>> getData() {
        return this.groupsTablePanel.getTableModel().data;
    }

    public void setData(Vector<Map<String, Object>> vector) {
        this.groupsTablePanel.getTableModel().removeAllRows();
        for (Map<String, Object> map : vector) {
            this.groupsTablePanel.getTableModel().addRow(map);
        }
        this.fillClassId();
    }

    private void checkLock() {
        this.serviceFrame.checkIPService();
    }

    private void fillClassId() {
        if (!UrfaManagerImpl.getInstance().isPermitted(8960)) {
            return;
        }
        try {
            this.tclasses = TClassFunctions.getTclassList();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        this.classMap.clear();
        this.classIDComboBox.removeAllItems();
        for (int i = 0; i < this.tclasses.length; ++i) {
            boolean bl = true;
            for (Map<String, Object> map : this.groupsTablePanel.getTableModel().data) {
                if (!map.get("tclass").equals(this.tclasses[i].getTclassId())) continue;
                bl = false;
            }
            if (!bl) continue;
            this.classMap.put(this.tclasses[i].getTclassName() + " (" + this.tclasses[i].getTclassId() + ")", this.tclasses[i]);
        }
        if (this.classMap.size() == 0) {
            this.addButton.setEnabled(false);
        } else {
            for (String string : this.classMap.keySet()) {
                this.classIDComboBox.addItem(string);
            }
        }
    }

    private void fillGroups() {
        this.groupTypeComboBox.addItem("max");
        this.groupTypeComboBox.addItem("sum");
        this.groupTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("max".compareTo((String)ServiceIPGroupsTab.this.groupTypeComboBox.getSelectedItem()) == 0) {
                    for (Map<String, Object> map : ((ServiceIPGroupsTab)ServiceIPGroupsTab.this).groupsTablePanel.getTableModel().data) {
                        map.put("group_id", 1);
                        map.put("group", "max");
                    }
                } else {
                    for (Map<String, Object> map : ((ServiceIPGroupsTab)ServiceIPGroupsTab.this).groupsTablePanel.getTableModel().data) {
                        map.put("group_id", 2);
                        map.put("group", "sum");
                    }
                }
                ServiceIPGroupsTab.this.groupsTablePanel.repaint();
            }
        });
    }

    public void setSum() {
        this.groupTypeComboBox.setSelectedIndex(1);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)this.groupsTablePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.groupTypeComboBox = new JComboBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.groupTypeComboBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Group"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.classIDComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.classIDComboBox, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel8, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

