/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.serviceframe;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddDialupService;
import biz.netup.control.transport.urfa.functions.UrfaAddHotspotService;
import biz.netup.control.transport.urfa.functions.UrfaAddIptrafficService;
import biz.netup.control.transport.urfa.functions.UrfaAddIptrafficServiceBatch;
import biz.netup.control.transport.urfa.functions.UrfaAddIptrafficServiceInt;
import biz.netup.control.transport.urfa.functions.UrfaAddOnceServiceNew;
import biz.netup.control.transport.urfa.functions.UrfaAddPeriodicServiceBatch;
import biz.netup.control.transport.urfa.functions.UrfaAddServiceInt;
import biz.netup.control.transport.urfa.functions.UrfaAddServiceToTariff;
import biz.netup.control.transport.urfa.functions.UrfaAddTelephonyService;
import biz.netup.control.transport.urfa.functions.UrfaGetDialupService;
import biz.netup.control.transport.urfa.functions.UrfaGetDirections;
import biz.netup.control.transport.urfa.functions.UrfaGetHotspotNetworks;
import biz.netup.control.transport.urfa.functions.UrfaGetHotspotService;
import biz.netup.control.transport.urfa.functions.UrfaGetIptrafficService;
import biz.netup.control.transport.urfa.functions.UrfaGetOnceServiceNew;
import biz.netup.control.transport.urfa.functions.UrfaGetPeriodicService;
import biz.netup.control.transport.urfa.functions.UrfaGetRadiusAttr;
import biz.netup.control.transport.urfa.functions.UrfaGetTelZones;
import biz.netup.control.transport.urfa.functions.UrfaGetTelephonyService;
import biz.netup.control.transport.urfa.functions.UrfaGetTimeRanges;
import biz.netup.control.transport.urfa.functions.UrfaGetTrafficAggregationInterval;
import biz.netup.control.transport.urfa.functions.UrfaIsServiceUsed;
import biz.netup.control.transport.urfa.functions.UrfaSetHotspotNetworks;
import biz.netup.control.transport.urfa.functions.UrfaSetRadiusAttr;
import biz.netup.control.transport.urfa.functions.UrfaSetTrafficAggregationInterval;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.TClassFunctions;
import biz.netup.projects.utmadmin.functions.objects.TClass;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tp.TPDialog;
import biz.netup.projects.utmadmin.gui.serviceframe.BottomButtons;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceDialupTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceHotspotANTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceHotspotMainTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceIPGroupsTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceIPMainTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceIPPTTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceIPTBTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceMainTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceOnceTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServicePeriodicTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceRadiusTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceTelPriceTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceTelTBTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceTelTab;
import biz.netup.projects.utmadmin.gui.serviceframe.forms.ServiceTimeRangesTab;
import biz.netup.swing.table.DoubleCellEditor;
import biz.netup.swing.table.TablePanel;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.hs.BytesTextField;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ServiceFrame
extends TabbedWindow {
    private JButton buttonOK;
    private JButton buttonCancel;
    private BottomButtons bb;
    protected Logger log = Utils.getLogger();
    private TClass[] tclasses;
    private Map<Integer, String> tclassNames;
    private ServiceMainTab main;
    private ServiceOnceTab once;
    private ServicePeriodicTab periodic;
    private ServiceIPMainTab ipMain;
    private ServiceIPTBTab ipTB;
    private ServiceIPPTTab ippt;
    private ServiceIPGroupsTab ipGr;
    private ServiceRadiusTab radius;
    private ServiceTimeRangesTab tr;
    private ServiceHotspotMainTab hotspotMain;
    private ServiceHotspotANTab hotspotAN;
    private ServiceDialupTab dialup;
    private ServiceTelTab tel;
    private ServiceTelPriceTab telPrice;
    private ServiceTelTBTab telTB;
    TabPanel[] allTabsToDisable = new TabPanel[]{this.once, this.periodic, this.ipMain, this.ipTB, this.ippt, this.ipGr, this.tr, this.hotspotMain, this.dialup};
    private int serviceId = 0;
    private int tariffId = 0;
    private int newTariffId = 0;
    private int type = 0;
    private int parentId = 0;
    private boolean toTariff = false;
    private boolean okPressed = false;
    private TPDialog tpd;

    public ServiceFrame(int n, int n2, int n3) {
        this(n, n2, n3, false, null);
    }

    public ServiceFrame(int n, int n2, int n3, boolean bl, TPDialog tPDialog) {
        this.tariffId = n2;
        this.toTariff = bl;
        this.tpd = tPDialog;
        this.newTariffId = n2;
        this.serviceId = n;
        this.type = n3;
        if (n != 0) {
            try {
                this.tclasses = TClassFunctions.getTclassList();
                this.tclassNames = new HashMap<Integer, String>();
                for (TClass tClass : this.tclasses) {
                    this.tclassNames.put(tClass.getTclassId(), tClass.getTclassName());
                }
                this.load();
            }
            catch (UrfaException urfaException) {
                this.log.error("Cannot load TC", urfaException);
            }
        } else {
            this.main.changeType(1);
        }
        this.checkToTariff();
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceFrame.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceFrame.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ServiceFrame.this.onCancel();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void load() throws UrfaException {
        this.main.changeType(this.type);
        this.main.setEdit();
        switch (this.type) {
            case 1: {
                this.loadOnce();
                break;
            }
            case 2: {
                this.loadPeriodic();
                break;
            }
            case 3: {
                this.loadIP();
                break;
            }
            case 4: {
                this.loadHotspot();
                break;
            }
            case 5: {
                this.loadDialup();
                break;
            }
            case 6: {
                this.loadTel();
            }
        }
        UrfaIsServiceUsed urfaIsServiceUsed = new UrfaIsServiceUsed(UrfaManagerImpl.getInstance());
        urfaIsServiceUsed.setSid(this.serviceId);
        urfaIsServiceUsed.call();
        if (urfaIsServiceUsed.getLinksCount() > 0) {
            for (TabPanel tabPanel : this.allTabsToDisable) {
                if (tabPanel != null) {
                    tabPanel.setReadOnly();
                }
                if (this.ipMain != null) {
                    this.ipMain.dynamicIPAddressAllocationCheckBox.setEnabled(true);
                    this.ipMain.getTrafficAggregationPeriodCheckBox().setEnabled(true);
                    ServiceIPMainTab.unsetReadOnlyForComponent(this.ipMain.getTrafficAggregationPeriodSpinner());
                    this.ipMain.getTrafficAggregationPeriodLabel().setEnabled(true);
                }
                if (this.hotspotMain != null) {
                    this.hotspotMain.dynamicIPAddressAllocationCheckBox.setEnabled(true);
                }
                if (this.dialup == null) continue;
                this.dialup.dynamicIPAddressAllocationCheckBox.setEnabled(true);
            }
        }
        if (this.parentId != 0) {
            this.main.setTPorFictive();
        }
    }

    private void loadTel() throws UrfaException {
        int n;
        UrfaGetTelephonyService urfaGetTelephonyService = new UrfaGetTelephonyService(UrfaManagerImpl.getInstance());
        urfaGetTelephonyService.setServiceId(this.serviceId);
        urfaGetTelephonyService.call();
        this.main.setFictiveServiceOnlyForCheckBox(urfaGetTelephonyService.getParentId() == this.serviceId);
        this.main.setAttachByDefaultCheckBox(urfaGetTelephonyService.getLinkByDefault() == 1);
        this.main.setCommentTextField(urfaGetTelephonyService.getComment());
        this.main.setNameTextField(urfaGetTelephonyService.getServiceName());
        this.tel.setBeginDate(new Date((long)urfaGetTelephonyService.getStartDate() * 1000L));
        this.tel.setChargeMethodComboBox(urfaGetTelephonyService.getDiscountMethod() - 1);
        this.tel.setCostTextField("" + urfaGetTelephonyService.getCost());
        this.tel.setEndDate(new Date((long)urfaGetTelephonyService.getExpireDate() * 1000L));
        this.tel.setFreeTimeSpinner(urfaGetTelephonyService.getFreeTime());
        this.tel.setLimitOfSimultaneousSessionsSpinner(urfaGetTelephonyService.getRadiusSessionsLimit());
        this.tel.setNextPeriodStepSpinner(urfaGetTelephonyService.getIncrementalInterval());
        this.tel.setStartingPeriodLenghtSpinner(urfaGetTelephonyService.getFirstInterval());
        this.tel.setStartingPeriodStepSpinner(urfaGetTelephonyService.getFirstIntervalAround());
        this.tel.setTunitSizeSpinner(urfaGetTelephonyService.getUnitSize());
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        UrfaGetDirections urfaGetDirections = new UrfaGetDirections(UrfaManagerImpl.getInstance());
        urfaGetDirections.call();
        for (int i = 0; i < urfaGetDirections.getCount(); ++i) {
            hashMap.put(urfaGetDirections.getId1()[i], urfaGetDirections.getName1()[i]);
        }
        UrfaGetTelZones urfaGetTelZones = new UrfaGetTelZones(UrfaManagerImpl.getInstance());
        urfaGetTelZones.call();
        for (int i = 0; i < urfaGetTelZones.getZonesCount(); ++i) {
            hashMap.put(urfaGetTelZones.getId1()[i], urfaGetTelZones.getName1()[i]);
        }
        UrfaGetTimeRanges urfaGetTimeRanges = new UrfaGetTimeRanges(UrfaManagerImpl.getInstance());
        urfaGetTimeRanges.call();
        for (n = 0; n < urfaGetTimeRanges.getSizeTr(); ++n) {
            hashMap2.put(urfaGetTimeRanges.getRangeId1()[n], urfaGetTimeRanges.getTrName1()[n]);
        }
        for (n = 0; n < urfaGetTelephonyService.getCount(); ++n) {
            int n2;
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            hashMap3.put("name", hashMap.get(urfaGetTelephonyService.getDirections1()[n]));
            hashMap3.put("id", urfaGetTelephonyService.getDirections1()[n]);
            this.telPrice.getZdMap().add(urfaGetTelephonyService.getDirections1()[n]);
            for (n2 = 0; n2 < urfaGetTelephonyService.getTimerangeCountArray1()[n]; ++n2) {
                if (!this.telPrice.getTrMap().containsKey(urfaGetTelephonyService.getTimerangeId2()[n][n2])) {
                    this.telPrice.getTrMap().put(urfaGetTelephonyService.getTimerangeId2()[n][n2], (String)hashMap2.get(urfaGetTelephonyService.getTimerangeId2()[n][n2]));
                    this.telPrice.getPricesTablePanel().getTableModel().addColumn((String)hashMap2.get(urfaGetTelephonyService.getTimerangeId2()[n][n2]) + " (" + urfaGetTelephonyService.getTimerangeId2()[n][n2] + ")", (String)hashMap2.get(urfaGetTelephonyService.getTimerangeId2()[n][n2]) + " (" + urfaGetTelephonyService.getTimerangeId2()[n][n2] + ")", true, true);
                    this.telPrice.getPricesTablePanel().setCellEditor((String)hashMap2.get(urfaGetTelephonyService.getTimerangeId2()[n][n2]) + " (" + urfaGetTelephonyService.getTimerangeId2()[n][n2] + ")", new DoubleCellEditor());
                }
                hashMap3.put((String)hashMap2.get(urfaGetTelephonyService.getTimerangeId2()[n][n2]) + " (" + urfaGetTelephonyService.getTimerangeId2()[n][n2] + ")", urfaGetTelephonyService.getCost2()[n][n2]);
            }
            for (n2 = 0; n2 < urfaGetTelephonyService.getBordersCountArray1()[n]; ++n2) {
                HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
                hashMap4.put("name", hashMap.get(urfaGetTelephonyService.getDirections1()[n]));
                hashMap4.put("id", urfaGetTelephonyService.getDirections1()[n]);
                hashMap4.put("border", urfaGetTelephonyService.getTarifQuantity2()[n][n2]);
                hashMap4.put("coefficient", urfaGetTelephonyService.getCostB2()[n][n2]);
                if (urfaGetTelephonyService.getTarifQuantity2()[n][n2] == 0L && urfaGetTelephonyService.getCostB2()[n][n2] == 1.0 && urfaGetTelephonyService.getBordersCountArray1()[n] <= 1) continue;
                this.telTB.getTelTBTablePanel().getTableModel().addRow(hashMap4);
            }
            this.telPrice.getPricesTablePanel().getTableModel().addRow(hashMap3);
        }
        this.loadRadius();
        this.parentId = urfaGetTelephonyService.getParentId();
        this.tariffId = urfaGetTelephonyService.getTariffId();
        this.setParentId();
    }

    private void setParentId() {
        if (this.parentId != 0) {
            this.main.setParentTextField("" + this.parentId);
            this.main.setConnectByDefaultVisible(true);
        }
    }

    private void loadDialup() throws UrfaException {
        UrfaGetDialupService urfaGetDialupService = new UrfaGetDialupService(UrfaManagerImpl.getInstance());
        urfaGetDialupService.setSid(this.serviceId);
        urfaGetDialupService.call();
        this.main.setFictiveServiceOnlyForCheckBox(urfaGetDialupService.getParentId() == this.serviceId);
        this.main.setAttachByDefaultCheckBox(urfaGetDialupService.getLinkByDefault() == 1);
        this.main.setCommentTextField(urfaGetDialupService.getComment());
        this.main.setNameTextField(urfaGetDialupService.getServiceName());
        this.dialup.setBeginDate(new Date((long)urfaGetDialupService.getStartDate() * 1000L));
        this.dialup.setChargeMethodComboBox(urfaGetDialupService.getDiscountMethod() - 1);
        this.dialup.setCostTextField("" + urfaGetDialupService.getCost());
        this.dialup.setEndDate(new Date((long)urfaGetDialupService.getExpireDate() * 1000L));
        this.dialup.setPoolNameTextField("" + urfaGetDialupService.getPoolName());
        this.dialup.setMaximumTimeoutTextField("" + urfaGetDialupService.getMaxTimeout());
        this.dialup.setLimitOfSimultaneousSessionsTextField(urfaGetDialupService.getRadiusSessionsLimit());
        this.dialup.setLoginPrefixTextField(urfaGetDialupService.getLoginPrefix());
        this.dialup.setDynamicIPAddressAllocationCheckBox(urfaGetDialupService.getIsDynamic() == 1);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaGetDialupService.getCostSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("range_id", urfaGetDialupService.getId1()[i]);
            hashMap.put("range_name", urfaGetDialupService.getTrTime1()[i]);
            hashMap.put("cost", urfaGetDialupService.getParam1()[i]);
            vector.add(hashMap);
        }
        this.tr.setData(vector);
        this.loadRadius();
        this.parentId = urfaGetDialupService.getParentId();
        this.tariffId = urfaGetDialupService.getTariffId();
        this.setParentId();
    }

    private void loadHotspot() throws UrfaException {
        UrfaGetHotspotService urfaGetHotspotService = new UrfaGetHotspotService(UrfaManagerImpl.getInstance());
        urfaGetHotspotService.setSid(this.serviceId);
        urfaGetHotspotService.call();
        this.main.setFictiveServiceOnlyForCheckBox(urfaGetHotspotService.getParentId() == this.serviceId);
        this.main.setAttachByDefaultCheckBox(urfaGetHotspotService.getLinkByDefault() == 1);
        this.main.setCommentTextField(urfaGetHotspotService.getComment());
        this.main.setNameTextField(urfaGetHotspotService.getServiceName());
        this.hotspotMain.setBeginDate(new Date((long)urfaGetHotspotService.getStartDate() * 1000L));
        this.hotspotMain.setChargeMethodComboBox(urfaGetHotspotService.getDiscountMethod() - 1);
        this.hotspotMain.setCostTextField(urfaGetHotspotService.getCost());
        this.hotspotMain.setEndDate(new Date((long)urfaGetHotspotService.getExpireDate() * 1000L));
        this.hotspotMain.setIncomingMbyteCostTextField("" + urfaGetHotspotService.getRecvCost());
        this.hotspotMain.setBandwidthLimitTextField("" + urfaGetHotspotService.getRadiusSessionsLimit());
        this.hotspotMain.setDynamicIPAddressAllocationCheckBox(urfaGetHotspotService.getIsDynamic() == 1);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaGetHotspotService.getCostSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("range_id", urfaGetHotspotService.getParam21()[i]);
            hashMap.put("range_name", urfaGetHotspotService.getTrTime1()[i]);
            hashMap.put("cost", urfaGetHotspotService.getParam11()[i]);
            vector.add(hashMap);
        }
        this.tr.setData(vector);
        if (UrfaManagerImpl.getInstance().isPermitted(66049)) {
            this.loadHotspotAN();
        }
        this.loadRadius();
        this.parentId = urfaGetHotspotService.getParentId();
        this.tariffId = urfaGetHotspotService.getTariffId();
        this.setParentId();
    }

    private void loadHotspotAN() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetHotspotNetworks urfaGetHotspotNetworks = new UrfaGetHotspotNetworks(UrfaManagerImpl.getInstance());
        urfaGetHotspotNetworks.setServiceId(this.serviceId);
        urfaGetHotspotNetworks.call();
        for (int i = 0; i < urfaGetHotspotNetworks.getCnt(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("network", urfaGetHotspotNetworks.getIp1()[i]);
            hashMap.put("mask", urfaGetHotspotNetworks.getMask1()[i]);
            hashMap.put("network_str", Resolve.ip_toString(urfaGetHotspotNetworks.getIp1()[i]));
            hashMap.put("mask_str", Resolve.ip_toString(urfaGetHotspotNetworks.getMask1()[i]));
            vector.add(hashMap);
        }
        this.hotspotAN.setData(vector);
    }

    private void loadIP() throws UrfaException {
        int n;
        HashMap<String, Object> hashMap;
        UrfaGetIptrafficService urfaGetIptrafficService = new UrfaGetIptrafficService(UrfaManagerImpl.getInstance());
        urfaGetIptrafficService.setSid(this.serviceId);
        urfaGetIptrafficService.call();
        this.main.setFictiveServiceOnlyForCheckBox(urfaGetIptrafficService.getParentId() == this.serviceId);
        this.main.setAttachByDefaultCheckBox(urfaGetIptrafficService.getLinkByDefault() == 1);
        this.main.setCommentTextField(urfaGetIptrafficService.getComment());
        this.main.setNameTextField(urfaGetIptrafficService.getServiceName());
        this.ipMain.setBeginDate(new Date((long)urfaGetIptrafficService.getStartDate() * 1000L));
        this.ipMain.setChargeMethodComboBox(urfaGetIptrafficService.getDiscountMethod() - 1);
        this.ipMain.setCostTextField("" + urfaGetIptrafficService.getCost());
        this.ipMain.setEndDate(new Date((long)urfaGetIptrafficService.getExpireDate() * 1000L));
        this.ipMain.setResetPrepaidTrafficCheckBox(urfaGetIptrafficService.getNullServicePrepaid() == 1);
        this.ipMain.setDynamicIPAddressAllocationCheckBox(urfaGetIptrafficService.getIsDynamic() == 1);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaGetIptrafficService.getPrepaidCount(); ++i) {
            if (urfaGetIptrafficService.getTclassPArray1()[i] == -1 || urfaGetIptrafficService.getPrepaidAmount1()[i] == 0L) continue;
            hashMap = new HashMap<String, Object>();
            hashMap.put("tclass", urfaGetIptrafficService.getTclassPArray1()[i]);
            hashMap.put("tclass_name", this.tclassNames.get(urfaGetIptrafficService.getTclassPArray1()[i]));
            hashMap.put("volume", urfaGetIptrafficService.getPrepaidAmount1()[i]);
            hashMap.put("volume_str", BytesTextField.getString(urfaGetIptrafficService.getPrepaidAmount1()[i]));
            hashMap.put("prepayment", urfaGetIptrafficService.getPrepaidMax1()[i]);
            hashMap.put("prepayment_str", BytesTextField.getString(urfaGetIptrafficService.getPrepaidMax1()[i]));
            vector.add(hashMap);
        }
        this.ippt.setData(vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        vector = new Vector();
        boolean bl = false;
        for (n = 0; n < urfaGetIptrafficService.getTclassId2groupSize(); ++n) {
            if (urfaGetIptrafficService.getTclassId1()[n] != -1) {
                hashMap = new HashMap();
                hashMap.put("tclass", urfaGetIptrafficService.getTclassId1()[n]);
                hashMap.put("tclass_name", this.tclassNames.get(urfaGetIptrafficService.getTclassId1()[n]));
                if (urfaGetIptrafficService.getTclassGroupId1()[n] == 1) {
                    hashMap.put("group_id", 1);
                    hashMap.put("group", "max");
                    hashSet.add(urfaGetIptrafficService.getTclassId1()[n]);
                } else {
                    hashMap.put("group_id", 2);
                    hashMap.put("group", "sum");
                    bl = true;
                }
                vector.add(hashMap);
            }
            this.ipGr.setData(vector);
            if (!bl) continue;
            this.ipGr.setSum();
        }
        vector = new Vector();
        for (n = 0; n < urfaGetIptrafficService.getBordersCount(); ++n) {
            if (urfaGetIptrafficService.getTclassBArray1()[n] == -1) continue;
            for (int i = 0; i < urfaGetIptrafficService.getBordersSizeArray1()[n]; ++i) {
                hashMap = new HashMap();
                if (hashSet.contains(urfaGetIptrafficService.getTclassBArray1()[n])) {
                    hashMap.put("tclass", 0);
                    hashMap.put("tclass_name", Utils.getResource().getString("Max group"));
                } else {
                    hashMap.put("tclass", urfaGetIptrafficService.getTclassBArray1()[n]);
                    hashMap.put("tclass_name", this.tclassNames.get(urfaGetIptrafficService.getTclassBArray1()[n]));
                }
                hashMap.put("volume", urfaGetIptrafficService.getBorderId2()[n][i]);
                hashMap.put("volume_str", BytesTextField.getString(urfaGetIptrafficService.getBorderId2()[n][i]));
                hashMap.put("cost", urfaGetIptrafficService.getBorderCost2()[n][i]);
                vector.add(hashMap);
            }
        }
        this.ipTB.setData(vector);
        this.loadRadius();
        this.parentId = urfaGetIptrafficService.getParentId();
        this.tariffId = urfaGetIptrafficService.getTariffId();
        this.setParentId();
        this.checkIPService();
        if (UrfaManagerImpl.getInstance().isPermitted(new int[]{66051, 66052})) {
            UrfaGetTrafficAggregationInterval urfaGetTrafficAggregationInterval = new UrfaGetTrafficAggregationInterval(UrfaManagerImpl.getInstance());
            urfaGetTrafficAggregationInterval.setServiceId(this.serviceId);
            urfaGetTrafficAggregationInterval.call();
            if (urfaGetTrafficAggregationInterval.getAggregationInterval() > 0) {
                this.ipMain.getTrafficAggregationPeriodCheckBox().setSelected(false);
                this.ipMain.getTrafficAggregationPeriodSpinner().setEnabled(true);
                this.ipMain.getTrafficAggregationPeriodSpinner().setValue(urfaGetTrafficAggregationInterval.getAggregationInterval());
            } else {
                this.ipMain.getTrafficAggregationPeriodCheckBox().setSelected(true);
                this.ipMain.getTrafficAggregationPeriodSpinner().setEnabled(false);
            }
        }
    }

    private void loadRadius() {
        UrfaGetRadiusAttr urfaGetRadiusAttr = new UrfaGetRadiusAttr(UrfaManagerImpl.getInstance());
        urfaGetRadiusAttr.setSid(this.serviceId);
        urfaGetRadiusAttr.setSt(this.type);
        try {
            urfaGetRadiusAttr.call();
            Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
            for (int i = 0; i < urfaGetRadiusAttr.getRadiusDataSize(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("vendor", urfaGetRadiusAttr.getVendor1()[i]);
                hashMap.put("attribute", urfaGetRadiusAttr.getAttr1()[i]);
                if (urfaGetRadiusAttr.getParam11()[i] == 1) {
                    hashMap.put("param", 1);
                    hashMap.put("value", urfaGetRadiusAttr.getValStr1()[i]);
                    hashMap.put("value_show", urfaGetRadiusAttr.getValStr1()[i]);
                } else if (urfaGetRadiusAttr.getParam11()[i] == 0) {
                    hashMap.put("param", urfaGetRadiusAttr.getParam11()[i]);
                    hashMap.put("value", urfaGetRadiusAttr.getValNum1()[i]);
                    hashMap.put("value_show", urfaGetRadiusAttr.getValNum1()[i]);
                } else if (urfaGetRadiusAttr.getParam11()[i] == 2) {
                    hashMap.put("param", urfaGetRadiusAttr.getParam11()[i]);
                    hashMap.put("value", urfaGetRadiusAttr.getValNum1()[i]);
                    hashMap.put("value_show", Resolve.ip_toString(urfaGetRadiusAttr.getValNum1()[i]));
                }
                vector.add(hashMap);
            }
            this.radius.setData(vector);
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot set RADIUS attributes", urfaException);
        }
    }

    private void loadPeriodic() throws UrfaException {
        UrfaGetPeriodicService urfaGetPeriodicService = new UrfaGetPeriodicService(UrfaManagerImpl.getInstance());
        urfaGetPeriodicService.setSid(this.serviceId);
        urfaGetPeriodicService.call();
        this.main.setFictiveServiceOnlyForCheckBox(urfaGetPeriodicService.getParentId() == this.serviceId);
        this.main.setAttachByDefaultCheckBox(urfaGetPeriodicService.getLinkByDefault() == 1);
        this.main.setCommentTextField(urfaGetPeriodicService.getComment());
        this.main.setNameTextField(urfaGetPeriodicService.getServiceName());
        this.periodic.setBeginDate(new Date((long)urfaGetPeriodicService.getStartDate() * 1000L));
        this.periodic.setChargeMethodComboBox(urfaGetPeriodicService.getDiscountMethod() - 1);
        this.periodic.setCostTextField("" + urfaGetPeriodicService.getCost());
        this.periodic.setEndDate(new Date((long)urfaGetPeriodicService.getExpireDate() * 1000L));
        this.parentId = urfaGetPeriodicService.getParentId();
        this.tariffId = urfaGetPeriodicService.getTariffId();
        this.setParentId();
    }

    private void loadOnce() throws UrfaException {
        UrfaGetOnceServiceNew urfaGetOnceServiceNew = new UrfaGetOnceServiceNew(UrfaManagerImpl.getInstance());
        urfaGetOnceServiceNew.setSid(this.serviceId);
        urfaGetOnceServiceNew.call();
        this.main.setFictiveServiceOnlyForCheckBox(urfaGetOnceServiceNew.getParentId() == this.serviceId);
        this.main.setAttachByDefaultCheckBox(urfaGetOnceServiceNew.getLinkByDefault() == 1);
        this.main.setCommentTextField(urfaGetOnceServiceNew.getComment());
        this.main.setNameTextField(urfaGetOnceServiceNew.getServiceName());
        this.once.setCostTextField("" + urfaGetOnceServiceNew.getCost());
        this.once.setDeleteFromGroup(urfaGetOnceServiceNew.getDropFromGroup());
        this.parentId = urfaGetOnceServiceNew.getParentId();
        this.tariffId = urfaGetOnceServiceNew.getTariffId();
        this.setParentId();
    }

    public void changeLeftMenu(int n) {
        this.type = n;
        this.setTabPanels(this.getTabPanels());
    }

    private void onOK() {
        if (this.toTariff) {
            if (this.addServiceToTariff() == 0) {
                this.okPressed = true;
                this.dispose();
            }
        } else if (this.createService() == 0) {
            this.okPressed = true;
            this.dispose();
        }
        MainFrame.getInstance().refreshServices();
    }

    private int addServiceToTariff() {
        UrfaAddServiceToTariff urfaAddServiceToTariff = new UrfaAddServiceToTariff(UrfaManagerImpl.getInstance());
        try {
            this.checkName((TabPanel)this.main, this.main.nameTextField, "Name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
        if (this.main.getTypeComboBox() == 1) {
            try {
                this.checkDouble(this.once, this.once.costTextField, "Cost");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.once.getCostTextField());
            urfaAddServiceToTariff.setCost(d);
            int n = this.once.getDeleteFromGroup();
        } else if (this.main.getTypeComboBox() == 2) {
            try {
                this.checkDouble(this.periodic, this.periodic.costTextField, "Cost");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.periodic.getCostTextField());
            urfaAddServiceToTariff.setCost(d);
            urfaAddServiceToTariff.setDiscountMethod(this.periodic.getChargeMethodComboBox() + 1);
            urfaAddServiceToTariff.setExpireDate((int)(this.periodic.getEndDate().getTime() / 1000L));
            urfaAddServiceToTariff.setStartDate((int)(this.periodic.getBeginDate().getTime() / 1000L));
        } else if (this.main.getTypeComboBox() == 3) {
            try {
                this.checkDouble(this.ipMain, this.ipMain.costTextField, "Cost");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            int n = 0;
            if (this.ipGr.getData().size() > 0 && "max".compareTo((String)this.ipGr.getData().get(0).get("group")) == 0) {
                if (this.ipGr.getData().size() == 1) {
                    this.log.log(1, "Only 1 group of type maximum");
                    return -1;
                }
                n = (Integer)this.ipGr.getData().get(0).get("tclass");
            }
            for (Map<String, Object> map : this.ipTB.getData()) {
                if ((Integer)map.get("tclass") != 0) continue;
                if (n == 0) {
                    this.log.log(1, "No groups of maximum type");
                    return -1;
                }
                map.put("tclass", n);
            }
            double d = Double.parseDouble(this.ipMain.getCostTextField());
            urfaAddServiceToTariff.setCost(d);
            urfaAddServiceToTariff.setDiscountMethod(this.ipMain.getChargeMethodComboBox() + 1);
            urfaAddServiceToTariff.setExpireDate((int)(this.ipMain.getEndDate().getTime() / 1000L));
            urfaAddServiceToTariff.setStartDate((int)(this.ipMain.getBeginDate().getTime() / 1000L));
            urfaAddServiceToTariff.setNullServicePrepaid(this.ipMain.getResetPrepaidTrafficCheckBox() ? 1 : 0);
            urfaAddServiceToTariff.setIsDynamic(this.ipMain.getDynamicIPAddressAllocationCheckBox() ? 1 : 0);
            if (this.ippt.getType() == 1) {
                urfaAddServiceToTariff.setTclassP1(ArrayFromVector.getIntArrayFromData(this.ippt.getData(), "tclass"));
                urfaAddServiceToTariff.setSizeP1(ArrayFromVector.getLongArrayFromData(this.ippt.getData(), "volume"));
                for (Map<String, Object> map : this.ippt.getData()) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("tclass", map.get("tclass"));
                    hashMap.put("volume", 0L);
                    hashMap.put("cost", 0.0);
                    boolean bl = true;
                    for (Map<String, Object> map2 : this.ipTB.getData()) {
                        if (!map2.get("tclass").equals(map.get("tclass"))) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    this.ipTB.getData().add(hashMap);
                }
                urfaAddServiceToTariff.setTcid1(new int[0]);
                urfaAddServiceToTariff.setGid1(new int[0]);
            } else {
                urfaAddServiceToTariff.setTcid1(ArrayFromVector.getIntArrayFromData(this.ipGr.getData(), "tclass"));
                urfaAddServiceToTariff.setGid1(ArrayFromVector.getIntArrayFromData(this.ipGr.getData(), "group_id"));
                urfaAddServiceToTariff.setTclassP1(new int[0]);
                urfaAddServiceToTariff.setSizeP1(new long[0]);
            }
            urfaAddServiceToTariff.setTclassB1(ArrayFromVector.getIntArrayFromData(this.ipTB.getData(), "tclass"));
            urfaAddServiceToTariff.setSizeB1(ArrayFromVector.getLongArrayFromData(this.ipTB.getData(), "volume"));
            urfaAddServiceToTariff.setCostB1(ArrayFromVector.getDoubleArrayFromData(this.ipTB.getData(), "cost"));
        } else if (this.main.getTypeComboBox() == 4) {
            try {
                this.checkDouble(this.hotspotMain, this.hotspotMain.costTextField, "Cost");
                this.checkTablePanel(this.tr, this.tr.getTbTablePanel(), "Time costs");
                this.checkIntGreaterZero(this.hotspotMain, this.hotspotMain.bandwidthLimitTextField, "Limit of simultaneous sessions");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.hotspotMain.getCostTextField());
            urfaAddServiceToTariff.setCost(d);
            urfaAddServiceToTariff.setDiscountMethod(this.hotspotMain.getChargeMethodComboBox() + 1);
            urfaAddServiceToTariff.setExpireDate((int)(this.hotspotMain.getEndDate().getTime() / 1000L));
            urfaAddServiceToTariff.setStartDate((int)(this.hotspotMain.getBeginDate().getTime() / 1000L));
            urfaAddServiceToTariff.setIsDynamic(this.hotspotMain.getDynamicIPAddressAllocationCheckBox() ? 1 : 0);
            urfaAddServiceToTariff.setCost1(ArrayFromVector.getDoubleArrayFromData(this.tr.getData(), "cost"));
            urfaAddServiceToTariff.setId1(ArrayFromVector.getIntArrayFromData(this.tr.getData(), "range_id"));
            urfaAddServiceToTariff.setRadiusSessionsLimit(Integer.parseInt(this.hotspotMain.getBandwidthLimitTextField()));
            urfaAddServiceToTariff.setNet1(new int[0]);
            urfaAddServiceToTariff.setMask1(new int[0]);
        } else if (this.main.getTypeComboBox() == 5) {
            try {
                this.checkDouble(this.dialup, this.dialup.costTextField, "Cost");
                this.checkIntOrEmpty(this.dialup, this.dialup.limitOfSimultaneousSessionsTextField, "Limit of simultaneous sessions");
                this.checkInt(this.dialup, this.dialup.maximumTimeoutTextField, "Maximum timeout");
                this.checkTablePanel(this.tr, this.tr.getTbTablePanel(), "Time costs");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.dialup.getCostTextField());
            urfaAddServiceToTariff.setCost(d);
            urfaAddServiceToTariff.setDiscountMethod(this.dialup.getChargeMethodComboBox() + 1);
            urfaAddServiceToTariff.setExpireDate((int)(this.dialup.getEndDate().getTime() / 1000L));
            urfaAddServiceToTariff.setStartDate((int)(this.dialup.getBeginDate().getTime() / 1000L));
            urfaAddServiceToTariff.setIsDynamic(this.dialup.getDynamicIPAddressAllocationCheckBox() ? 1 : 0);
            int n = Integer.parseInt(this.dialup.getLimitOfSimultaneousSessionsTextField());
            urfaAddServiceToTariff.setNullServicePrepaid(n);
            int n2 = Integer.parseInt(this.dialup.getMaximumTimeoutTextField());
            urfaAddServiceToTariff.setMaxTimeout(n2);
            urfaAddServiceToTariff.setPoolName(this.dialup.getPoolNameTextField());
            urfaAddServiceToTariff.setLoginPrefix(this.dialup.getLoginPrefixTextField());
            urfaAddServiceToTariff.setCost1(ArrayFromVector.getDoubleArrayFromData(this.tr.getData(), "cost"));
            urfaAddServiceToTariff.setId1(ArrayFromVector.getIntArrayFromData(this.tr.getData(), "range_id"));
        } else if (this.main.getTypeComboBox() == 6) {
            try {
                this.checkDouble(this.tel, this.tel.costTextField, "Cost");
                this.checkTablePanel(this.telPrice, this.telPrice.getPricesTablePanel(), "Price editor");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.tel.getCostTextField());
            urfaAddServiceToTariff.setCost(d);
            urfaAddServiceToTariff.setDiscountMethod(this.tel.getChargeMethodComboBox() + 1);
            urfaAddServiceToTariff.setExpireDate((int)(this.tel.getEndDate().getTime() / 1000L));
            urfaAddServiceToTariff.setStartDate((int)(this.tel.getBeginDate().getTime() / 1000L));
            urfaAddServiceToTariff.setFreeTime(this.tel.getFreeTimeSpinner());
            urfaAddServiceToTariff.setRadiusSessionsLimit((int)this.tel.getLimitOfSimultaneousSessionsSpinner());
            urfaAddServiceToTariff.setIncrementalInterval(this.tel.getNextPeriodStepSpinner());
            urfaAddServiceToTariff.setFirstInterval(this.tel.getStartingPeriodLenghtSpinner());
            urfaAddServiceToTariff.setFirstIntervalAround(this.tel.getStartingPeriodStepSpinner());
            urfaAddServiceToTariff.setIntervalSize(this.tel.getTunitSizeSpinner());
            int[] nArray = new int[this.telPrice.getPricesTablePanel().getTable().getRowCount()];
            int[][] nArrayArray = new int[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            double[][] dArrayArray = new double[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            long[][] lArrayArray = new long[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            double[][] dArrayArray2 = new double[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            for (int i = 0; i < this.telPrice.getPricesTablePanel().getTable().getRowCount(); ++i) {
                int n;
                int n3;
                nArray[i] = (Integer)this.telPrice.getPricesTablePanel().getTableModel().data.get(i).get("id");
                nArrayArray[i] = new int[this.telPrice.getTrMap().size()];
                dArrayArray[i] = new double[this.telPrice.getTrMap().size()];
                for (n3 = 0; n3 < this.telPrice.getTrMap().keySet().size(); ++n3) {
                    nArrayArray[i][n3] = (Integer)this.telPrice.getTrMap().keySet().toArray()[n3];
                    dArrayArray[i][n3] = (Double)this.telPrice.getPricesTablePanel().getTableModel().data.get(i).get(this.telPrice.getTrMap().get((Integer)this.telPrice.getTrMap().keySet().toArray()[n3]) + " (" + this.telPrice.getTrMap().keySet().toArray()[n3] + ")");
                }
                n3 = 0;
                Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
                for (n = 0; n < this.telTB.getTelTBTablePanel().getTable().getRowCount(); ++n) {
                    if (!this.telTB.getTelTBTablePanel().getTableModel().data.get(n).get("id").equals(this.telPrice.getPricesTablePanel().getTableModel().data.get(i).get("id"))) continue;
                    vector.add(this.telTB.getTelTBTablePanel().getTableModel().data.get(n));
                    if (!this.telTB.getTelTBTablePanel().getTableModel().data.get(n).get("border").equals(0L)) continue;
                    n3 = 1;
                }
                if (vector.size() == 0 || n3 == 0) {
                    HashMap<String, Number> hashMap = new HashMap<String, Number>();
                    hashMap.put("border", 0L);
                    hashMap.put("coefficient", 1.0);
                    vector.add(hashMap);
                }
                lArrayArray[i] = new long[vector.size()];
                dArrayArray2[i] = new double[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    lArrayArray[i][n] = (Long)((Map)vector.get(n)).get("border");
                    dArrayArray2[i][n] = (Double)((Map)vector.get(n)).get("coefficient");
                }
            }
            urfaAddServiceToTariff.setBordersBord2(lArrayArray);
            urfaAddServiceToTariff.setBordersCoef2(dArrayArray2);
            urfaAddServiceToTariff.setDirections1(nArray);
            urfaAddServiceToTariff.setTimerangesCost2(dArrayArray);
            urfaAddServiceToTariff.setTimerangesId2(nArrayArray);
        } else {
            return -1;
        }
        urfaAddServiceToTariff.setServiceType(this.main.getTypeComboBox());
        urfaAddServiceToTariff.setParentId(this.serviceId);
        if (this.main.getAttachByDefault()) {
            urfaAddServiceToTariff.setLinkByDefault(1);
        }
        urfaAddServiceToTariff.setServiceName(this.main.getNameTextField());
        urfaAddServiceToTariff.setComment(this.main.getCommentTextField());
        urfaAddServiceToTariff.setTariffId(this.newTariffId);
        try {
            urfaAddServiceToTariff.call();
            if (this.tpd != null) {
                this.tpd.refreshDetails();
            }
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot save service", urfaException);
            return -1;
        }
        return 0;
    }

    private void setRadius(int n) {
        UrfaSetRadiusAttr urfaSetRadiusAttr = new UrfaSetRadiusAttr(UrfaManagerImpl.getInstance());
        urfaSetRadiusAttr.setSid(n);
        urfaSetRadiusAttr.setSt(this.main.getTypeComboBox());
        int n2 = this.radius.getData().size();
        urfaSetRadiusAttr.setCnt(n2);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (Integer)this.radius.getData().get(i).get("attribute");
            nArray3[i] = (Integer)this.radius.getData().get(i).get("vendor");
            nArray4[i] = (Integer)this.radius.getData().get(i).get("param");
            if (nArray4[i] == 1) {
                nArray2[i] = 0;
                stringArray[i] = (String)this.radius.getData().get(i).get("value");
                continue;
            }
            nArray2[i] = (Integer)this.radius.getData().get(i).get("value");
            stringArray[i] = "";
        }
        urfaSetRadiusAttr.setAttr1(nArray);
        urfaSetRadiusAttr.setCval1(stringArray);
        urfaSetRadiusAttr.setIval1(nArray2);
        urfaSetRadiusAttr.setVendor1(nArray3);
        urfaSetRadiusAttr.setParam11(nArray4);
        try {
            urfaSetRadiusAttr.call();
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot set RADIUS attributes", urfaException);
        }
    }

    private int createService() {
        UrfaAddServiceInt urfaAddServiceInt;
        try {
            this.checkName((TabPanel)this.main, this.main.nameTextField, "Name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
        if (this.main.getTypeComboBox() == 1) {
            urfaAddServiceInt = new UrfaAddOnceServiceNew(UrfaManagerImpl.getInstance());
            try {
                this.checkDouble(this.once, this.once.costTextField, "Cost");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.once.getCostTextField());
            ((UrfaAddOnceServiceNew)urfaAddServiceInt).setCost(d);
            int n = this.once.getDeleteFromGroup();
            ((UrfaAddOnceServiceNew)urfaAddServiceInt).setDropFromGroup(n);
        } else if (this.main.getTypeComboBox() == 2) {
            urfaAddServiceInt = new UrfaAddPeriodicServiceBatch(UrfaManagerImpl.getInstance());
            try {
                this.checkDouble(this.periodic, this.periodic.costTextField, "Cost");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.periodic.getCostTextField());
            ((UrfaAddPeriodicServiceBatch)urfaAddServiceInt).setCost(d);
            ((UrfaAddPeriodicServiceBatch)urfaAddServiceInt).setDiscountMethodT(this.periodic.getChargeMethodComboBox() + 1);
            ((UrfaAddPeriodicServiceBatch)urfaAddServiceInt).setExpireDate((int)(this.periodic.getEndDate().getTime() / 1000L));
            ((UrfaAddPeriodicServiceBatch)urfaAddServiceInt).setStartDate((int)(this.periodic.getBeginDate().getTime() / 1000L));
        } else if (this.main.getTypeComboBox() == 3) {
            urfaAddServiceInt = this.serviceId == 0 ? new UrfaAddIptrafficServiceBatch(UrfaManagerImpl.getInstance()) : new UrfaAddIptrafficService(UrfaManagerImpl.getInstance());
            try {
                this.checkDouble(this.ipMain, this.ipMain.costTextField, "Cost");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            int n = 0;
            if (this.ipGr.getData().size() > 0 && "max".compareTo((String)this.ipGr.getData().get(0).get("group")) == 0) {
                if (this.ipGr.getData().size() == 1) {
                    this.log.log(1, "Only 1 group of type maximum");
                    return -1;
                }
                n = (Integer)this.ipGr.getData().get(0).get("tclass");
            }
            for (Map<String, Object> map : this.ipTB.getData()) {
                if ((Integer)map.get("tclass") != 0) continue;
                if (n == 0) {
                    this.log.log(1, "No groups of maximum type");
                    return -1;
                }
                map.put("tclass", n);
            }
            double d = Double.parseDouble(this.ipMain.getCostTextField());
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setCost(d);
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setDiscountMethodT(this.ipMain.getChargeMethodComboBox() + 1);
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setExpireDate((int)(this.ipMain.getEndDate().getTime() / 1000L));
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setStartDate((int)(this.ipMain.getBeginDate().getTime() / 1000L));
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setNullServicePrepaid(this.ipMain.getResetPrepaidTrafficCheckBox() ? 1 : 0);
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setIsDynamic(this.ipMain.getDynamicIPAddressAllocationCheckBox() ? 1 : 0);
            if (this.ippt.getType() == 1) {
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setTclassP1(ArrayFromVector.getIntArrayFromData(this.ippt.getData(), "tclass"));
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setSizeP1(ArrayFromVector.getLongArrayFromData(this.ippt.getData(), "volume"));
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setSizeMaxP1(ArrayFromVector.getLongArrayFromData(this.ippt.getData(), "prepayment"));
                for (Map<String, Object> map : this.ippt.getData()) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("tclass", map.get("tclass"));
                    hashMap.put("volume", 0L);
                    hashMap.put("cost", 0.0);
                    boolean bl = true;
                    for (Map<String, Object> map2 : this.ipTB.getData()) {
                        if (!map2.get("tclass").equals(map.get("tclass"))) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    this.ipTB.getData().add(hashMap);
                }
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setTcid1(new int[0]);
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setGid1(new int[0]);
            } else {
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setTcid1(ArrayFromVector.getIntArrayFromData(this.ipGr.getData(), "tclass"));
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setGid1(ArrayFromVector.getIntArrayFromData(this.ipGr.getData(), "group_id"));
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setTclassP1(new int[0]);
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setSizeP1(new long[0]);
                ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setSizeMaxP1(new long[0]);
            }
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setTclassB1(ArrayFromVector.getIntArrayFromData(this.ipTB.getData(), "tclass"));
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setSizeB1(ArrayFromVector.getLongArrayFromData(this.ipTB.getData(), "volume"));
            ((UrfaAddIptrafficServiceInt)urfaAddServiceInt).setCostB1(ArrayFromVector.getDoubleArrayFromData(this.ipTB.getData(), "cost"));
        } else if (this.main.getTypeComboBox() == 4) {
            urfaAddServiceInt = new UrfaAddHotspotService(UrfaManagerImpl.getInstance());
            try {
                this.checkDouble(this.hotspotMain, this.hotspotMain.costTextField, "Cost");
                this.checkIntGreaterZero(this.hotspotMain, this.hotspotMain.bandwidthLimitTextField, "Limit of simultaneous sessions");
                this.checkTablePanel(this.tr, this.tr.getTbTablePanel(), "Time costs");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.hotspotMain.getCostTextField());
            ((UrfaAddHotspotService)urfaAddServiceInt).setCost(d);
            ((UrfaAddHotspotService)urfaAddServiceInt).setDiscountMethod(this.hotspotMain.getChargeMethodComboBox() + 1);
            ((UrfaAddHotspotService)urfaAddServiceInt).setExpireDate((int)(this.hotspotMain.getEndDate().getTime() / 1000L));
            ((UrfaAddHotspotService)urfaAddServiceInt).setStartDate((int)(this.hotspotMain.getBeginDate().getTime() / 1000L));
            ((UrfaAddHotspotService)urfaAddServiceInt).setIsDynamic(this.hotspotMain.getDynamicIPAddressAllocationCheckBox() ? 1 : 0);
            ((UrfaAddHotspotService)urfaAddServiceInt).setRadiusSessionsLimit(Integer.parseInt(this.hotspotMain.getBandwidthLimitTextField()));
            ((UrfaAddHotspotService)urfaAddServiceInt).setRateLimit("");
            ((UrfaAddHotspotService)urfaAddServiceInt).setCostP1(ArrayFromVector.getDoubleArrayFromData(this.tr.getData(), "cost"));
            ((UrfaAddHotspotService)urfaAddServiceInt).setIdP1(ArrayFromVector.getIntArrayFromData(this.tr.getData(), "range_id"));
        } else if (this.main.getTypeComboBox() == 5) {
            urfaAddServiceInt = new UrfaAddDialupService(UrfaManagerImpl.getInstance());
            try {
                this.checkDouble(this.dialup, this.dialup.costTextField, "Cost");
                this.checkInt(this.dialup, this.dialup.maximumTimeoutTextField, "Maximum timeout");
                this.checkIntOrEmpty(this.dialup, this.dialup.limitOfSimultaneousSessionsTextField, "Limit of simultaneous sessions");
                this.checkTablePanel(this.tr, this.tr.getTbTablePanel(), "Time costs");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.dialup.getCostTextField());
            ((UrfaAddDialupService)urfaAddServiceInt).setCost(d);
            ((UrfaAddDialupService)urfaAddServiceInt).setDiscountMethod(this.dialup.getChargeMethodComboBox() + 1);
            ((UrfaAddDialupService)urfaAddServiceInt).setExpireDate((int)(this.dialup.getEndDate().getTime() / 1000L));
            ((UrfaAddDialupService)urfaAddServiceInt).setStartDate((int)(this.dialup.getBeginDate().getTime() / 1000L));
            ((UrfaAddDialupService)urfaAddServiceInt).setIsDynamic(this.dialup.getDynamicIPAddressAllocationCheckBox() ? 1 : 0);
            int n = Integer.parseInt(this.dialup.getLimitOfSimultaneousSessionsTextField());
            ((UrfaAddDialupService)urfaAddServiceInt).setRadiusSessionsLimit(n);
            int n2 = Integer.parseInt(this.dialup.getMaximumTimeoutTextField());
            ((UrfaAddDialupService)urfaAddServiceInt).setMaxTimeout(n2);
            ((UrfaAddDialupService)urfaAddServiceInt).setPoolName(this.dialup.getPoolNameTextField());
            ((UrfaAddDialupService)urfaAddServiceInt).setLoginPrefix(this.dialup.getLoginPrefixTextField());
            ((UrfaAddDialupService)urfaAddServiceInt).setRangeCost1(ArrayFromVector.getDoubleArrayFromData(this.tr.getData(), "cost"));
            ((UrfaAddDialupService)urfaAddServiceInt).setRangeId1(ArrayFromVector.getIntArrayFromData(this.tr.getData(), "range_id"));
        } else if (this.main.getTypeComboBox() == 6) {
            urfaAddServiceInt = new UrfaAddTelephonyService(UrfaManagerImpl.getInstance());
            try {
                this.checkDouble(this.tel, this.tel.costTextField, "Cost");
                this.checkTablePanel(this.telPrice, this.telPrice.getPricesTablePanel(), "Price editor");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            double d = Double.parseDouble(this.tel.getCostTextField());
            ((UrfaAddTelephonyService)urfaAddServiceInt).setCost(d);
            ((UrfaAddTelephonyService)urfaAddServiceInt).setDiscountMethod(this.tel.getChargeMethodComboBox() + 1);
            ((UrfaAddTelephonyService)urfaAddServiceInt).setExpireDate((int)(this.tel.getEndDate().getTime() / 1000L));
            ((UrfaAddTelephonyService)urfaAddServiceInt).setStartDate((int)(this.tel.getBeginDate().getTime() / 1000L));
            if (this.tel.getFreeTimeSpinner() < 0L || this.tel.getLimitOfSimultaneousSessionsSpinner() < 0L || this.tel.getNextPeriodStepSpinner() < 0L || this.tel.getStartingPeriodLenghtSpinner() < 0L || this.tel.getStartingPeriodStepSpinner() < 0L || this.tel.getTunitSizeSpinner() < 0L) {
                Dialogs.showErrorDialog("Illegal number format");
                this.setTab(this.tel, this.tel.getSideMenuItem());
                return -1;
            }
            ((UrfaAddTelephonyService)urfaAddServiceInt).setFreeTime(this.tel.getFreeTimeSpinner());
            ((UrfaAddTelephonyService)urfaAddServiceInt).setRadiusSessionsLimit((int)this.tel.getLimitOfSimultaneousSessionsSpinner());
            ((UrfaAddTelephonyService)urfaAddServiceInt).setIncrementalInterval(this.tel.getNextPeriodStepSpinner());
            ((UrfaAddTelephonyService)urfaAddServiceInt).setFirstInterval(this.tel.getStartingPeriodLenghtSpinner());
            ((UrfaAddTelephonyService)urfaAddServiceInt).setFirstIntervalAround(this.tel.getStartingPeriodStepSpinner());
            ((UrfaAddTelephonyService)urfaAddServiceInt).setIntervalSize(this.tel.getTunitSizeSpinner());
            int[] nArray = new int[this.telPrice.getPricesTablePanel().getTable().getRowCount()];
            int[][] nArrayArray = new int[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            double[][] dArrayArray = new double[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            long[][] lArrayArray = new long[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            double[][] dArrayArray2 = new double[this.telPrice.getPricesTablePanel().getTable().getRowCount()][];
            for (int i = 0; i < this.telPrice.getPricesTablePanel().getTable().getRowCount(); ++i) {
                int n;
                int n3;
                nArray[i] = (Integer)this.telPrice.getPricesTablePanel().getTableModel().data.get(i).get("id");
                nArrayArray[i] = new int[this.telPrice.getTrMap().size()];
                dArrayArray[i] = new double[this.telPrice.getTrMap().size()];
                for (n3 = 0; n3 < this.telPrice.getTrMap().keySet().size(); ++n3) {
                    nArrayArray[i][n3] = (Integer)this.telPrice.getTrMap().keySet().toArray()[n3];
                    dArrayArray[i][n3] = (Double)this.telPrice.getPricesTablePanel().getTableModel().data.get(i).get(this.telPrice.getTrMap().get((Integer)this.telPrice.getTrMap().keySet().toArray()[n3]) + " (" + this.telPrice.getTrMap().keySet().toArray()[n3] + ")");
                }
                n3 = 0;
                Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
                for (n = 0; n < this.telTB.getTelTBTablePanel().getTable().getRowCount(); ++n) {
                    if (!this.telTB.getTelTBTablePanel().getTableModel().data.get(n).get("id").equals(this.telPrice.getPricesTablePanel().getTableModel().data.get(i).get("id"))) continue;
                    vector.add(this.telTB.getTelTBTablePanel().getTableModel().data.get(n));
                    if (!this.telTB.getTelTBTablePanel().getTableModel().data.get(n).get("border").equals(0L)) continue;
                    n3 = 1;
                }
                if (vector.size() == 0 || n3 == 0) {
                    HashMap<String, Number> hashMap = new HashMap<String, Number>();
                    hashMap.put("border", 0L);
                    hashMap.put("coefficient", 1.0);
                    vector.add(hashMap);
                }
                lArrayArray[i] = new long[vector.size()];
                dArrayArray2[i] = new double[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    lArrayArray[i][n] = (Long)((Map)vector.get(n)).get("border");
                    dArrayArray2[i][n] = (Double)((Map)vector.get(n)).get("coefficient");
                }
            }
            ((UrfaAddTelephonyService)urfaAddServiceInt).setBordersBord2(lArrayArray);
            ((UrfaAddTelephonyService)urfaAddServiceInt).setBordersCoef2(dArrayArray2);
            ((UrfaAddTelephonyService)urfaAddServiceInt).setDirections1(nArray);
            ((UrfaAddTelephonyService)urfaAddServiceInt).setTimerangesCost2(dArrayArray);
            ((UrfaAddTelephonyService)urfaAddServiceInt).setTimerangesId2(nArrayArray);
        } else {
            return -1;
        }
        if (this.parentId != 0) {
            int n;
            try {
                n = Integer.parseInt(this.main.getParentTextField());
            }
            catch (NumberFormatException numberFormatException) {
                n = this.parentId;
            }
            urfaAddServiceInt.setParentId(n);
        }
        if (this.main.getFictiveServiceOnlyForCheckBox()) {
            urfaAddServiceInt.setParentId(-1);
        }
        if (this.main.getAttachByDefault()) {
            urfaAddServiceInt.setLinkByDefault(1);
        }
        urfaAddServiceInt.setServiceName(this.main.getNameTextField());
        urfaAddServiceInt.setComment(this.main.getCommentTextField());
        urfaAddServiceInt.setServiceId(this.serviceId);
        urfaAddServiceInt.setTariffId(this.tariffId);
        try {
            urfaAddServiceInt.call();
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot save service", urfaException);
            return -1;
        }
        if (this.main.getTypeComboBox() >= 3 && this.main.getTypeComboBox() <= 6 && this.main.getTypeComboBox() != 4) {
            if (this.serviceId == 0) {
                this.setRadius(urfaAddServiceInt.getServiceId());
            } else {
                this.setRadius(this.serviceId);
            }
        }
        if (this.main.getTypeComboBox() == 4) {
            this.setHotspotAN(urfaAddServiceInt.getServiceId());
        }
        if (this.main.getTypeComboBox() == 3 && UrfaManagerImpl.getInstance().isPermitted(new int[]{66051, 66052}) && !this.ipMain.getTrafficAggregationPeriodCheckBox().isSelected() && !this.ipMain.getTrafficAggregationPeriodSpinner().getValue().equals(0)) {
            UrfaSetTrafficAggregationInterval urfaSetTrafficAggregationInterval = new UrfaSetTrafficAggregationInterval(UrfaManagerImpl.getInstance());
            if (this.serviceId == 0) {
                urfaSetTrafficAggregationInterval.setServiceId(urfaAddServiceInt.getServiceId());
            } else {
                urfaSetTrafficAggregationInterval.setServiceId(this.serviceId);
            }
            urfaSetTrafficAggregationInterval.setAggregationInterval((Integer)this.ipMain.getTrafficAggregationPeriodSpinner().getValue());
            try {
                urfaSetTrafficAggregationInterval.call();
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setHotspotAN(int n) {
        if (!UrfaManagerImpl.getInstance().isPermitted(new int[]{66049, 66050})) {
            return;
        }
        UrfaSetHotspotNetworks urfaSetHotspotNetworks = new UrfaSetHotspotNetworks(UrfaManagerImpl.getInstance());
        urfaSetHotspotNetworks.setServiceId(n);
        urfaSetHotspotNetworks.setIp1(ArrayFromVector.getIntArrayFromData(this.hotspotAN.getData(), "network"));
        urfaSetHotspotNetworks.setMask1(ArrayFromVector.getIntArrayFromData(this.hotspotAN.getData(), "mask"));
        urfaSetHotspotNetworks.setCnt(ArrayFromVector.getIntArrayFromData(this.hotspotAN.getData(), "network").length);
        try {
            urfaSetHotspotNetworks.call();
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot save allowed networks", urfaException);
        }
    }

    private void onCancel() {
        this.dispose();
    }

    public void checkIPService() {
        this.setTabPanels(this.getTabPanels());
        this.ipGr.setPanelEnabled(this.ipTB.getData().size() == 0);
        if (this.ipGr.isMax()) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Map<String, Object> map : this.ipGr.getData()) {
                hashSet.add((Integer)map.get("tclass"));
            }
            this.ipTB.setExcludeSet(hashSet);
        } else {
            this.ipTB.setExcludeSet(null);
        }
    }

    public ServiceTelPriceTab getTelPrice() {
        return this.telPrice;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(int n) {
        this.serviceId = n;
    }

    public int getTariffId() {
        return this.tariffId;
    }

    public void setTariffId(int n) {
        this.tariffId = n;
    }

    public void setFictive() {
        this.main.setFictiveServiceOnlyForCheckBox(true);
        this.main.getAttachByDefaultCheckBox().setSelected(true);
        this.main.getAttachByDefaultCheckBox().setEnabled(true);
        this.main.setConnectByDefaultVisible(true);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    protected void checkInt(TabPanel tabPanel, JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        try {
            Integer.parseInt(jTextComponent.getText());
            jTextComponent.setBackground(Color.WHITE);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            this.setTab(tabPanel, tabPanel.getSideMenuItem());
            jTextComponent.requestFocus();
            jTextComponent.setBackground(new Color(255, 204, 204));
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
        }
    }

    protected void checkIntGreaterZero(TabPanel tabPanel, JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        try {
            int n = Integer.parseInt(jTextComponent.getText());
            if (n < 0) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                this.setTab(tabPanel, tabPanel.getSideMenuItem());
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            jTextComponent.setBackground(Color.WHITE);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            this.setTab(tabPanel, tabPanel.getSideMenuItem());
            jTextComponent.requestFocus();
            jTextComponent.setBackground(new Color(255, 204, 204));
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
        }
    }

    protected void checkIntOrEmpty(TabPanel tabPanel, JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (jTextComponent.getText().isEmpty()) {
            jTextComponent.setBackground(Color.WHITE);
            return;
        }
        this.checkInt(tabPanel, jTextComponent, string);
    }

    protected void checkDouble(TabPanel tabPanel, JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        try {
            Double.parseDouble(jTextComponent.getText());
            jTextComponent.setBackground(Color.WHITE);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            this.setTab(tabPanel, tabPanel.getSideMenuItem());
            jTextComponent.requestFocus();
            jTextComponent.setBackground(new Color(255, 204, 204));
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
        }
    }

    protected void checkName(TabPanel tabPanel, JComboBox jComboBox, String string) throws IllegalArgumentException {
        if (jComboBox.getSelectedItem().toString().isEmpty()) {
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            jComboBox.setBackground(new Color(255, 204, 204));
            this.setTab(tabPanel, tabPanel.getSideMenuItem());
            jComboBox.requestFocus();
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
        }
        jComboBox.setBackground(Color.WHITE);
    }

    protected void checkTablePanel(TabPanel tabPanel, TablePanel tablePanel, String string) throws IllegalArgumentException {
        if (tablePanel.getTable().getRowCount() == 0) {
            this.setTab(tabPanel, tabPanel.getSideMenuItem());
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("table is empty"));
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("table is empty"));
        }
    }

    protected void checkName(TabPanel tabPanel, JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (jTextComponent.getText().isEmpty()) {
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            jTextComponent.setBackground(new Color(255, 204, 204));
            this.setTab(tabPanel, tabPanel.getSideMenuItem());
            jTextComponent.requestFocus();
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
        }
        jTextComponent.setBackground(Color.WHITE);
    }

    @Override
    protected void init() {
        this.iconPanel.setVisible(false);
        this.bb = new BottomButtons();
        this.initButtons();
        this.main = new ServiceMainTab(this);
        this.once = new ServiceOnceTab();
        this.periodic = new ServicePeriodicTab();
        this.ipMain = new ServiceIPMainTab();
        this.ipTB = new ServiceIPTBTab(this);
        this.ippt = new ServiceIPPTTab(this);
        this.ipGr = new ServiceIPGroupsTab(this);
        this.radius = new ServiceRadiusTab();
        this.tr = new ServiceTimeRangesTab();
        this.hotspotMain = new ServiceHotspotMainTab();
        this.hotspotAN = new ServiceHotspotANTab();
        this.dialup = new ServiceDialupTab();
        this.tel = new ServiceTelTab();
        this.telPrice = new ServiceTelPriceTab();
        this.telTB = new ServiceTelTBTab(this);
    }

    private void checkToTariff() {
        if (this.toTariff || !UrfaManagerImpl.getInstance().isPermitted(new int[]{66051, 66052})) {
            this.ipMain.getTrafficAggregationPeriodLabel().setVisible(false);
            this.ipMain.getTrafficAggregationPeriodSpinner().setVisible(false);
            this.ipMain.getTrafficAggregationPeriodCheckBox().setVisible(false);
        }
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected String getWindowTitle() {
        return "Service";
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.main);
        switch (this.type) {
            case 1: {
                vector.add(this.once);
                break;
            }
            case 2: {
                vector.add(this.periodic);
                break;
            }
            case 3: {
                vector.add(this.ipMain);
                vector.add(this.ipTB);
                if (!this.toTariff) {
                    vector.add(this.radius);
                }
                if (this.ipGr.getData().size() > 0) {
                    vector.add(this.ipGr);
                    break;
                }
                if (this.ippt.getData().size() > 0) {
                    vector.add(this.ippt);
                    break;
                }
                vector.add(this.ipGr);
                vector.add(this.ippt);
                break;
            }
            case 4: {
                vector.add(this.hotspotMain);
                if (UrfaManagerImpl.getInstance().isPermitted(new int[]{66049, 66050}) && this.tariffId == 0) {
                    vector.add(this.hotspotAN);
                }
                vector.add(this.tr);
                break;
            }
            case 5: {
                vector.add(this.dialup);
                vector.add(this.tr);
                if (this.toTariff) break;
                vector.add(this.radius);
                break;
            }
            case 6: {
                vector.add(this.tel);
                vector.add(this.telPrice);
                vector.add(this.telTB);
                if (this.toTariff) break;
                vector.add(this.radius);
            }
        }
        return vector;
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }

    private void initButtons() {
        this.buttonOK = this.bb.getButtonOK();
        this.buttonCancel = this.bb.getButtonCancel();
    }
}

