/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.searchframe;

import biz.netup.projects.utmadmin.functions.dealer.main.cards.CardsFunctions;
import biz.netup.projects.utmadmin.functions.objects.SearchConditions;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.DateTimeCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SearchCardFrame
extends JFrame {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton findNowButton;
    private JButton clearButton;
    private TablePanelImpl usersTablePanel;
    private JComboBox andOrComboBox;
    private JButton addButton;
    private JButton deleteButton;
    private TablePanelImpl customSearchTablePanel;
    private ResourceBundleWrapper resource = Utils.getResource();
    private Map<String, Integer> whatData;
    private Map<String, Integer> criteriaData;
    private Map<String, Integer> criteriaDataDate;
    private boolean updatingTable = false;

    public SearchCardFrame() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.findNowButton);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(800, 600));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Search"));
        this.setIconImage(imageIcon.getImage());
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame.this.onOK();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SearchCardFrame.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.findNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame.this.refreshTable();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame.this.addSearchCriteria();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame.this.deleteSearchCriteria();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame.this.clearAll();
            }
        });
    }

    private void onOK() {
        this.dispose();
    }

    private void clearAll() {
        this.customSearchTablePanel.getTableModel().removeAllRows();
        this.usersTablePanel.getTableModel().removeAllRows();
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.createUsersTable();
        this.createCustomSearchTable();
        this.andOrComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.resource.getString("All conditions"));
        defaultComboBoxModel.addElement(this.resource.getString("At least one condition"));
        this.andOrComboBox.setModel(defaultComboBoxModel);
    }

    void fillCombo() {
        this.whatData = new LinkedHashMap<String, Integer>();
        this.whatData.put(this.resource.getString("ID"), 1);
        this.whatData.put(this.resource.getString("Pool ID"), 2);
        this.whatData.put(this.resource.getString("Secret"), 3);
        this.whatData.put(this.resource.getString("Balance"), 4);
        this.whatData.put(this.resource.getString("Currency"), 5);
        this.whatData.put(this.resource.getString("Use before"), 6);
        this.whatData.put(this.resource.getString("Tariff ID"), 7);
        this.whatData.put(this.resource.getString("Is used"), 8);
        this.criteriaData = new LinkedHashMap<String, Integer>();
        this.criteriaData.put(this.resource.getString("contains"), 1);
        this.criteriaData.put(this.resource.getString("not contains"), 11);
        this.criteriaData.put(this.resource.getString("equals"), 3);
        this.criteriaData.put(this.resource.getString("not equals"), 4);
        this.criteriaData.put(this.resource.getString("higher"), 7);
        this.criteriaData.put(this.resource.getString("lower"), 8);
        this.criteriaData.put(this.resource.getString("higher or equals"), 9);
        this.criteriaData.put(this.resource.getString("lower or equals"), 10);
        this.criteriaDataDate = new LinkedHashMap<String, Integer>();
        this.criteriaDataDate.put(this.resource.getString("equals"), 3);
        this.criteriaDataDate.put(this.resource.getString("not equals"), 4);
        this.criteriaDataDate.put(this.resource.getString("higher"), 7);
        this.criteriaDataDate.put(this.resource.getString("lower"), 8);
        this.criteriaDataDate.put(this.resource.getString("higher or equals"), 9);
        this.criteriaDataDate.put(this.resource.getString("lower or equals"), 10);
    }

    private void createCustomSearchTable() {
        this.customSearchTablePanel = new TablePanelImpl(this.getClass().getName() + "_customSearch", true);
        MapTableModel mapTableModel = this.customSearchTablePanel.getTableModel();
        mapTableModel.addColumn("field", "Field:", true, true);
        mapTableModel.addColumn("condition", "Condition:", true, true);
        mapTableModel.addColumn("value", "Value:", true, true);
        this.customSearchTablePanel.setEditable(true);
        this.customSearchTablePanel.setAppendable(false);
        this.customSearchTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(SearchCardFrame.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(SearchCardFrame.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchCardFrame.this.deleteSearchCriteria();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchCardFrame.this.addSearchCriteria();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem2, jMenuItem};
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.customSearchTablePanel.applyTableSettings();
        this.fillCombo();
        JComboBox<String> jComboBox = new JComboBox<String>();
        final JComboBox<String> jComboBox2 = new JComboBox<String>();
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        for (String string : this.whatData.keySet()) {
            jComboBox3.addItem(string);
        }
        for (String string : this.criteriaData.keySet()) {
            jComboBox.addItem(string);
        }
        for (String string : this.criteriaDataDate.keySet()) {
            jComboBox2.addItem(string);
        }
        this.customSearchTablePanel.setCellEditor("field", new ComboBoxCellEditor(jComboBox3, true, false));
        this.customSearchTablePanel.setCellEditor("condition", new ComboBoxCellEditor(jComboBox, true, false));
        this.customSearchTablePanel.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                System.out.println("e.getColumn()" + tableModelEvent.getColumn());
                System.out.println("e.getFirstRow()" + tableModelEvent.getFirstRow());
                System.out.println("e.getType()" + tableModelEvent.getType());
                if (tableModelEvent.getColumn() == 0 && tableModelEvent.getFirstRow() >= 0 && !((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field").equals(((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("old_field")) && !SearchCardFrame.this.updatingTable) {
                    SearchCardFrame.this.updatingTable = true;
                    ((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("old_field", ((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field"));
                    int n = (Integer)SearchCardFrame.this.whatData.get(((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field"));
                    if (n == 6 || n == 8) {
                        HashMap<String, DefaultCellEditor> hashMap = new HashMap<String, DefaultCellEditor>();
                        hashMap.put("value", new DateTimeCellEditor("Not defined", true));
                        hashMap.put("condition", new ComboBoxCellEditor(jComboBox2, true, false));
                        ((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                        ((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchCardFrame.this.resource.getString("equals"));
                        ((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                    } else {
                        ((SearchCardFrame)SearchCardFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", null);
                    }
                    SearchCardFrame.this.customSearchTablePanel.getTableModel().fireTableDataChanged();
                    SearchCardFrame.this.updatingTable = false;
                }
            }
        });
    }

    private void addSearchCriteria() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("condition", this.resource.getString("contains"));
        hashMap.put("field", this.resource.getString("ID"));
        this.customSearchTablePanel.getTableModel().addRow(hashMap);
    }

    private void deleteSearchCriteria() {
        for (Map<String, Object> map : this.customSearchTablePanel.getSelectedTableRows()) {
            this.customSearchTablePanel.getTableModel().removeRow(map);
        }
    }

    private void createUsersTable() {
        this.usersTablePanel = new TablePanelImpl(this.getClass().getName() + "_sr", true);
        MapTableModel mapTableModel = this.usersTablePanel.getTableModel();
        mapTableModel.addColumn("id", "Card ID", true, false);
        mapTableModel.addColumn("pool_id", "Pool ID", true, false);
        mapTableModel.addColumn("password", "Password", true, false);
        mapTableModel.addColumn("balance", "Balance", true, false);
        mapTableModel.addColumn("currency", "Currency", true, false);
        mapTableModel.addColumn("use_before", "Use before", true, false);
        mapTableModel.addColumn("period_of_use", "Period of use", true, false);
        mapTableModel.addColumn("used_at", "Used at", true, false);
        mapTableModel.addColumn("tariff", "Tariff", true, false);
        this.usersTablePanel.setEditable(false);
        this.usersTablePanel.setAppendable(false);
        this.usersTablePanel.applyTableSettings();
    }

    public void refreshTable() {
        this.usersTablePanel.getTableModel().removeAllRows();
        for (Map<String, Object> map : CardsFunctions.searchCards(this.getSearchCriteria())) {
            this.usersTablePanel.getTableModel().addRow(map);
        }
    }

    private SearchConditions getSearchCriteria() {
        SearchConditions searchConditions = new SearchConditions();
        searchConditions.selectType = this.andOrComboBox.getSelectedIndex();
        for (Map<String, Object> map : this.customSearchTablePanel.getTableModel().data) {
            searchConditions.addCondition(this.whatData.get(map.get("field")), this.criteriaData.get(map.get("condition")), map.get("value"));
        }
        return searchConditions;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.contentPane.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Close"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.buttonOK, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel9.add((Component)jPanel10, gridBagConstraints);
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        this.findNowButton = new JButton();
        this.$$$loadButtonText$$$(this.findNowButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Find now"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.findNowButton, gridBagConstraints);
        this.clearButton = new JButton();
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.clearButton, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel10.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel9.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel9.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridBagLayout());
        jPanel15.add((Component)jPanel16, "Center");
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel16.add((Component)jPanel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel17.add((Component)this.andOrComboBox, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 4, 0);
        jPanel17.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton = new JButton();
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel17.add((Component)this.deleteButton, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel17.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel17.add((Component)jPanel19, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel17.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel16.add((Component)jPanel21, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel21.add((Component)this.customSearchTablePanel, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel21.add((Component)jPanel22, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel23, gridBagConstraints);
        jPanel23.add((Component)this.usersTablePanel, "Center");
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout(new GridBagLayout());
        this.contentPane.add((Component)jPanel24, "West");
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel24.add((Component)jPanel25, gridBagConstraints);
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

