/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.switchtariff;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteSwitchTariffSettings;
import biz.netup.control.transport.urfa.functions.UrfaEditSwitchTariffSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchTariffSettings;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.UpDownButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.switchtariff.SwitchTariffDialog;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SwitchTariffTab
extends TabPanelWithTable {
    private int priority = 0;
    private Set<Integer> groups;

    public SwitchTariffTab() {
        this.setRefreshPermission(new int[]{86016});
        this.setAddPermission(new int[]{86017, 9216});
        this.setEditPermission(new int[]{86018});
        this.setDeletePermission(new int[]{86019});
    }

    @Override
    public String getTabName() {
        return "Switch tariff";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "User settings";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", "ID");
        hashMap.put("group_id", "Group ID");
        hashMap.put("group_name", "Group name");
        hashMap.put("priority", "Priority");
        hashMap.put("is_enabled", "Is enabled");
        return hashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        this.priority = 0;
        UrfaGetSwitchTariffSettings urfaGetSwitchTariffSettings = new UrfaGetSwitchTariffSettings(UrfaManagerImpl.getInstance());
        urfaGetSwitchTariffSettings.call();
        this.groups = new HashSet<Integer>();
        for (int n : urfaGetSwitchTariffSettings.getGroupId1()) {
            this.groups.add(n);
        }
        for (int i = 0; i < urfaGetSwitchTariffSettings.getCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetSwitchTariffSettings.getId1()[i]);
            hashMap.put("group_id", urfaGetSwitchTariffSettings.getGroupId1()[i]);
            if (urfaGetSwitchTariffSettings.getGroupId1()[i] != 0) {
                hashMap.put("group_name", Resolve.getGroupName(urfaGetSwitchTariffSettings.getGroupId1()[i]));
                hashMap.put("delete", 1);
            } else {
                hashMap.put("group_name", this.resource.getString("All"));
                hashMap.put("delete", 0);
            }
            hashMap.put("is_enabled", urfaGetSwitchTariffSettings.getIsEnabled1()[i]);
            hashMap.put("priority", urfaGetSwitchTariffSettings.getPriopity1()[i]);
            if (i < urfaGetSwitchTariffSettings.getCount() - 2) {
                hashMap.put("down", 1);
            } else {
                hashMap.put("down", 0);
            }
            if (i < urfaGetSwitchTariffSettings.getCount() - 1 && i != 0) {
                hashMap.put("up", 1);
            } else {
                hashMap.put("up", 0);
            }
            if (this.priority < urfaGetSwitchTariffSettings.getPriopity1()[i] + 1) {
                this.priority = urfaGetSwitchTariffSettings.getPriopity1()[i] + 1;
            }
            hashMap.put("tps", urfaGetSwitchTariffSettings.getTpId2()[i]);
            hashMap.put("service_id", urfaGetSwitchTariffSettings.getServiceId2()[i]);
            hashMap.put("min_balance", urfaGetSwitchTariffSettings.getMinBalance2()[i]);
            hashMap.put("use_min_balance", urfaGetSwitchTariffSettings.getUseMinBalance2()[i]);
            hashMap.put("free_balance", urfaGetSwitchTariffSettings.getFreeBalance2()[i]);
            hashMap.put("use_free_balance", urfaGetSwitchTariffSettings.getUseFreeBalance2()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    protected void init() {
        super.init();
        UpDownButtons upDownButtons = new UpDownButtons();
        this.getAdditionalButtonPanel2().add(upDownButtons.getButtonPanel());
        this.mainTablePanel.registerFieldButtonBlock(this.deleteButton, "delete", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getUpButton(), "up", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getDownButton(), "down", 0);
        this.mainTablePanel.registerOneRowButton(upDownButtons.getUpButton());
        this.mainTablePanel.registerOneRowButton(upDownButtons.getDownButton());
        upDownButtons.getUpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwitchTariffTab.this.up();
            }
        });
        upDownButtons.getDownButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwitchTariffTab.this.down();
            }
        });
    }

    private void up() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i <= 0) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i - 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    private void change(Map<String, Object> map, Map<String, Object> map2) {
        try {
            UrfaEditSwitchTariffSettings urfaEditSwitchTariffSettings = new UrfaEditSwitchTariffSettings(UrfaManagerImpl.getInstance());
            urfaEditSwitchTariffSettings.setId((Integer)map.get("id"));
            urfaEditSwitchTariffSettings.setGroupId((Integer)map.get("group_id"));
            urfaEditSwitchTariffSettings.setIsEnabled((Integer)map.get("is_enabled"));
            urfaEditSwitchTariffSettings.setPriopity((Integer)map2.get("priority"));
            urfaEditSwitchTariffSettings.setTpId1((int[])map.get("tps"));
            urfaEditSwitchTariffSettings.setServiceId1((int[])map.get("service_id"));
            urfaEditSwitchTariffSettings.setMinBalance1((double[])map.get("min_balance"));
            urfaEditSwitchTariffSettings.setUseMinBalance1((int[])map.get("use_min_balance"));
            urfaEditSwitchTariffSettings.setFreeBalance1((double[])map.get("free_balance"));
            urfaEditSwitchTariffSettings.setUseFreeBalance1((int[])map.get("use_free_balance"));
            urfaEditSwitchTariffSettings.call();
            urfaEditSwitchTariffSettings = new UrfaEditSwitchTariffSettings(UrfaManagerImpl.getInstance());
            urfaEditSwitchTariffSettings.setId((Integer)map2.get("id"));
            urfaEditSwitchTariffSettings.setGroupId((Integer)map2.get("group_id"));
            urfaEditSwitchTariffSettings.setIsEnabled((Integer)map2.get("is_enabled"));
            urfaEditSwitchTariffSettings.setPriopity((Integer)map.get("priority"));
            urfaEditSwitchTariffSettings.setTpId1((int[])map2.get("tps"));
            urfaEditSwitchTariffSettings.setServiceId1((int[])map2.get("service_id"));
            urfaEditSwitchTariffSettings.setMinBalance1((double[])map2.get("min_balance"));
            urfaEditSwitchTariffSettings.setUseMinBalance1((int[])map2.get("use_min_balance"));
            urfaEditSwitchTariffSettings.setFreeBalance1((double[])map2.get("free_balance"));
            urfaEditSwitchTariffSettings.setUseFreeBalance1((int[])map2.get("use_free_balance"));
            urfaEditSwitchTariffSettings.call();
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private void down() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i >= this.mainTablePanel.getTableModel().data.size() - 2) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i + 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    @Override
    protected void add() {
        this.log.log(10, "Add element - " + this.getTabName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("groups", this.groups);
        hashMap.put("priority", this.priority);
        this.getItemDialog(hashMap).run(this);
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDeleteSwitchTariffSettings urfaDeleteSwitchTariffSettings = new UrfaDeleteSwitchTariffSettings(UrfaManagerImpl.getInstance());
        urfaDeleteSwitchTariffSettings.setId((Integer)map.get("id"));
        urfaDeleteSwitchTariffSettings.call();
        if (urfaDeleteSwitchTariffSettings.getResult() == -1) {
            throw new UrfaException(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot delete item(s)"));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new SwitchTariffDialog(map);
    }
}

