/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.users;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaChangeIntstatForUser;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.main.usersandgroups.users.UsersFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.accounts.AccountFunctions;
import biz.netup.projects.utmadmin.functions.objects.Account;
import biz.netup.projects.utmadmin.gui.adduserframe.AddUserFrame;
import biz.netup.projects.utmadmin.gui.cardclear.CardClearWizard;
import biz.netup.projects.utmadmin.gui.custom.newpayment.NewPaymentDialog;
import biz.netup.projects.utmadmin.gui.searchframe.SearchFrame;
import biz.netup.projects.utmadmin.gui.userframe.UserFrame;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

public class MainUsersTab
extends TabPanel {
    private JPanel panel1;
    private JButton addButton;
    private JButton newPaymentButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton searchButton;
    private JButton refreshButton;
    private JComboBox pageComboBox;
    private JTextField usersPerPageTextField;
    TablePanelImpl mainTable;
    private JLabel ofLabel;
    private JButton clearButton;
    private JLabel totalUsersLabel;
    private int usersCount = 0;
    private Integer usersPerPage = 100;
    private int usersFrom;
    private int usersTo;
    private boolean card;

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public char getShortcut() {
        if (this.card) {
            return 'C';
        }
        return 'U';
    }

    public MainUsersTab(boolean bl) {
        this.setRefreshPermission(new int[]{8209, 8193});
        this.card = bl;
        this.registerShortcut();
        if (bl) {
            this.setSmallIcon(new ImageIcon(this.getClass().getResource("cards_24.png")));
            this.setBigIcon(new ImageIcon(this.getClass().getResource("cards.png")));
        } else {
            this.setSmallIcon(new ImageIcon(this.getClass().getResource("users_24.png")));
            this.setBigIcon(new ImageIcon(this.getClass().getResource("users.png")));
        }
        this.createTable();
        this.$$$setupUI$$$();
    }

    @Override
    public String getGroupName() {
        return "Users and groups";
    }

    private void search() {
        SearchFrame searchFrame = new SearchFrame();
        searchFrame.setVisible(true);
    }

    private void changePage() {
        try {
            if (this.pageComboBox.getSelectedIndex() >= 0) {
                this.usersFrom = this.pageComboBox.getSelectedIndex() * this.usersPerPage;
                this.usersTo = this.usersFrom + this.usersPerPage - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect number");
        }
    }

    private void generatePagePanel() {
        try {
            if (this.usersPerPage == 0) {
                this.changeUsersPerPage();
            }
            Integer n = this.pageComboBox.getSelectedIndex();
            ActionListener[] actionListenerArray = this.pageComboBox.getActionListeners();
            int n2 = actionListenerArray.length;
            for (int i = 0; i < n2; ++i) {
                ActionListener actionListener = actionListenerArray[i];
                this.pageComboBox.removeActionListener(actionListener);
            }
            this.usersCount = UsersFunctions.getUsersCount(this.card);
            int n3 = this.usersCount % this.usersPerPage == 0 ? this.usersCount / this.usersPerPage : this.usersCount / this.usersPerPage + 1;
            this.pageComboBox.removeAllItems();
            for (n2 = 0; n2 < n3; ++n2) {
                this.pageComboBox.addItem(n2 + 1);
            }
            if (n == -1) {
                this.usersFrom = 0;
                this.usersTo = this.usersPerPage - 1;
            } else {
                if (this.pageComboBox.getItemCount() > n) {
                    this.pageComboBox.setSelectedIndex(n);
                }
                this.changePage();
            }
            this.ofLabel.setText(" " + n3);
            this.pageComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainUsersTab.this.changePage();
                    MainUsersTab.this.refreshTable();
                }
            });
            this.totalUsersLabel.setText("" + this.usersCount);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect number");
        }
    }

    private void deleteUser() {
        if (Dialogs.showYesNoDialog("Delete user(s)?")) {
            for (Map<String, Object> map : this.mainTable.getSelectedTableRows()) {
                int n = (Integer)map.get("uid");
                try {
                    UsersFunctions.deleteUser(n);
                }
                catch (UrfaException urfaException) {
                    Dialogs.showErrorDialog(urfaException.getMessage());
                }
            }
            this.refresh();
        }
    }

    public void refreshTable() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.mainTable.getSelectedTableRows().length != 0) {
            for (Map<String, Object> map : this.mainTable.getSelectedTableRows()) {
                hashSet.add((Integer)map.get("uid"));
            }
        }
        int n = this.mainTable.getTableModel().getSortOrder();
        int n2 = this.mainTable.getTableModel().getSortedColumn();
        Resolve.userLogins = new HashMap<Integer, String>();
        this.mainTable.getTableModel().removeAllRows();
        for (Map<String, Object> map : UsersFunctions.getUsersTableData(this.usersFrom, this.usersTo, this.card)) {
            Resolve.userLogins.put((Integer)map.get("id"), (String)map.get("login"));
            this.mainTable.getTableModel().addRow(map);
        }
        if (n2 != -1) {
            this.mainTable.getTableModel().setColumnSortOrder(n2, n);
        }
        if (hashSet.size() != 0) {
            for (int i = 0; i < this.mainTable.getTableModel().getRowCount(); ++i) {
                if (!hashSet.contains((Integer)this.mainTable.getTableModel().getRow(i).get("uid"))) continue;
                this.mainTable.getTable().addRowSelectionInterval(i, i);
            }
        }
    }

    private void newPayment() {
        NewPaymentDialog newPaymentDialog = new NewPaymentDialog((Integer)this.mainTable.getSelectedTableRows()[0].get("uid"), 0);
        newPaymentDialog.setVisible(true);
        if (newPaymentDialog.isOkPressed()) {
            this.refresh();
        }
    }

    private void editUser() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this, "Dialog - " + MainUsersTab.this.resource.getString("User"));
                UserFrame userFrame = new UserFrame((Integer)MainUsersTab.this.mainTable.getSelectedTableRows()[0].get("uid"));
                UTMTrayIcon.getInstance().removeProcess(this);
                userFrame.setVisible(true);
            }
        };
        thread.start();
    }

    private void addUser() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this);
                AddUserFrame addUserFrame = new AddUserFrame();
                UTMTrayIcon.getInstance().removeProcess(this);
                addUserFrame.setVisible(true);
            }
        };
        thread.start();
    }

    private void createUIComponents() {
    }

    private void turnInternetOn() {
        for (Map<String, Object> map : this.mainTable.getSelectedTableRows()) {
            Object object;
            if (Utils.isAdmin()) {
                object = new UrfaChangeIntstatForUser(UrfaManagerImpl.getInstance());
                ((UrfaChangeIntstatForUser)object).setUserId((Integer)map.get("uid"));
                ((UrfaChangeIntstatForUser)object).setNeedBlock(0);
                try {
                    ((UrfaChangeIntstatForUser)object).call();
                }
                catch (UrfaException urfaException) {
                    this.log.error("Error updating accounts list", urfaException);
                }
                continue;
            }
            try {
                object = AccountFunctions.getAccount((Integer)map.get("master_account"));
                ((Account)object).setIntStatus(1);
                AccountFunctions.editAccount((Account)object);
            }
            catch (UrfaException urfaException) {
                this.log.error("Error updating accounts list", urfaException);
            }
        }
        this.refresh();
    }

    private void turnInternetOff() {
        for (Map<String, Object> map : this.mainTable.getSelectedTableRows()) {
            Object object;
            if (Utils.isAdmin()) {
                object = new UrfaChangeIntstatForUser(UrfaManagerImpl.getInstance());
                ((UrfaChangeIntstatForUser)object).setUserId((Integer)map.get("uid"));
                ((UrfaChangeIntstatForUser)object).setNeedBlock(1);
                try {
                    ((UrfaChangeIntstatForUser)object).call();
                }
                catch (UrfaException urfaException) {
                    urfaException.printStackTrace();
                }
                continue;
            }
            try {
                object = AccountFunctions.getAccount((Integer)map.get("master_account"));
                ((Account)object).setIntStatus(0);
                AccountFunctions.editAccount((Account)object);
            }
            catch (UrfaException urfaException) {
                this.log.error("Error updating accounts list", urfaException);
            }
        }
        this.refresh();
    }

    private void createTable() {
        this.mainTable = new TablePanelImpl(this.getClass().getName() + "_users", true);
        MapTableModel mapTableModel = this.mainTable.getTableModel();
        mapTableModel.addColumn("uid", "UID", true, false);
        mapTableModel.addColumn("login", "Login", true, false);
        mapTableModel.addColumn("master_account", "Master account", true, false);
        mapTableModel.addColumn("full_name", "Full name", true, false);
        mapTableModel.addColumn("status", "Block ID", true, false);
        mapTableModel.addColumn("ballance", "Ballance", true, false);
        mapTableModel.addColumn("ip_vpn", "IP (VPN)", true, false);
        mapTableModel.addColumn("ip_not_vpn", "IP (not VPN)", true, false);
        this.mainTable.setEditable(false);
        this.mainTable.setAppendable(false);
        this.mainTable.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(MainUsersTab.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(MainUsersTab.this.resource.getString("Remove"));
                JMenuItem jMenuItem3 = new JMenuItem(MainUsersTab.this.resource.getString("Edit"));
                JMenuItem jMenuItem4 = new JMenuItem(MainUsersTab.this.resource.getString("New payment"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainUsersTab.this.refresh();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainUsersTab.this.deleteUser();
                    }
                });
                jMenuItem2.setVisible(Permissions.isPermitted("delete_user"));
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainUsersTab.this.editUser();
                    }
                });
                jMenuItem3.setVisible(Permissions.isPermitted("view_user"));
                if (!Permissions.isPermitted("edit_user")) {
                    jMenuItem3.setText(MainUsersTab.this.resource.getString("Read"));
                }
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainUsersTab.this.newPayment();
                    }
                });
                jMenuItem4.setVisible(Permissions.isPermitted("new_payment"));
                JMenuItem jMenuItem5 = new JMenuItem(MainUsersTab.this.resource.getString("Turn Internet on"));
                JMenuItem jMenuItem6 = new JMenuItem(MainUsersTab.this.resource.getString("Turn Internet off"));
                jMenuItem5.setVisible(Permissions.isPermitted("change_intstat_for_user"));
                jMenuItem6.setVisible(Permissions.isPermitted("change_intstat_for_user"));
                jMenuItem6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainUsersTab.this.turnInternetOff();
                    }
                });
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainUsersTab.this.turnInternetOn();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem2, jMenuItem5, jMenuItem6, jMenuItem};
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem3);
                arrayList.add(jMenuItem2);
                arrayList.add(jMenuItem5);
                arrayList.add(jMenuItem6);
                arrayList.add(jMenuItem4);
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                if (Permissions.isPermitted("view_user")) {
                    MainUsersTab.this.editUser();
                }
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.mainTable.applyTableSettings();
        this.mainTable.setCellRenderer("uid", new CustomCellRenderer());
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.panel1.add((Component)jPanel, "Center");
        jPanel.add((Component)this.mainTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.panel1.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel3, "West");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Users per page"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Page"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("of"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        this.pageComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.pageComboBox, gridBagConstraints);
        this.usersPerPageTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        jPanel3.add((Component)this.usersPerPageTextField, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel9, gridBagConstraints);
        this.ofLabel = new JLabel();
        this.ofLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.ofLabel, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)jPanel11, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("of"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel12, gridBagConstraints);
        this.totalUsersLabel = new JLabel();
        this.totalUsersLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.totalUsersLabel, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridBagLayout());
        this.panel1.add((Component)jPanel14, "North");
        this.newPaymentButton = new JButton();
        this.newPaymentButton.setEnabled(true);
        this.newPaymentButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/money16.png")));
        this.$$$loadButtonText$$$(this.newPaymentButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("New payment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.newPaymentButton, gridBagConstraints);
        this.searchButton = new JButton();
        this.searchButton.setEnabled(true);
        this.searchButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/find16.png")));
        this.$$$loadButtonText$$$(this.searchButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.searchButton, gridBagConstraints);
        this.refreshButton = new JButton();
        this.refreshButton.setEnabled(true);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
        this.$$$loadButtonText$$$(this.refreshButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Refresh"));
        this.refreshButton.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.refreshButton, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/adduser16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.addButton, gridBagConstraints);
        this.editButton = new JButton();
        this.editButton.setEnabled(true);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edituser16.png")));
        this.$$$loadButtonText$$$(this.editButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.editButton, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/deleteuser16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.deleteButton, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel19, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel22, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel23, gridBagConstraints);
        this.clearButton = new JButton();
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        this.clearButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel14.add((Component)this.clearButton, gridBagConstraints);
        jLabel2.setLabelFor(this.pageComboBox);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }

    @Override
    public String getTabName() {
        if (this.card) {
            return "Card Users";
        }
        return "Users";
    }

    @Override
    protected void refreshTab() throws UrfaException {
        this.generatePagePanel();
        this.refreshTable();
    }

    @Override
    protected Component getMainPanel() {
        this.mainTable.registerOneRowButton(this.editButton);
        this.mainTable.registerMultiRowButton(this.deleteButton);
        this.mainTable.registerOneRowButton(this.newPaymentButton);
        this.generatePagePanel();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.addUser();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.editUser();
            }
        });
        this.newPaymentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.newPayment();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.deleteUser();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.refresh();
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.search();
            }
        });
        this.usersPerPageTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MainUsersTab.this.changeUsersPerPage();
            }
        });
        this.usersPerPageTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.changeUsersPerPage();
            }
        });
        this.pageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.changePage();
                MainUsersTab.this.refreshTable();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUsersTab.this.clear();
            }
        });
        return this.panel1;
    }

    private void clear() {
        CardClearWizard cardClearWizard = new CardClearWizard();
        cardClearWizard.setVisible(true);
    }

    private void changeUsersPerPage() {
        int n;
        try {
            n = Integer.parseInt(this.usersPerPageTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException("value <= 0");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.usersPerPageTextField.setText(this.usersPerPage.toString());
            this.usersPerPageTextField.repaint();
            numberFormatException.printStackTrace();
            return;
        }
        if (n == this.usersPerPage) {
            return;
        }
        this.usersPerPage = n;
        if (this.usersPerPage > 0) {
            Settings.writeValueToPerst("UsersPerPage", "" + this.usersPerPage);
        }
        this.refresh();
    }

    @Override
    protected void init() {
        Permissions.apply((JComponent)this.addButton, "add_user_new");
        Permissions.apply((JComponent)this.editButton, "view_user");
        if (!Permissions.isPermitted("edit_user")) {
            this.editButton.setText(this.resource.getString("Read"));
        }
        Permissions.apply((JComponent)this.deleteButton, "delete_user");
        if (this.deleteButton.isEnabled()) {
            this.mainTable.getTable().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (127 == keyEvent.getKeyCode() && MainUsersTab.this.mainTable.getSelectedTableRows().length > 0) {
                        MainUsersTab.this.deleteUser();
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        }
        Permissions.apply((JComponent)this.searchButton, "search_user");
        Permissions.apply((JComponent)this.newPaymentButton, "new_payment");
        if (!Settings.getValueFromPerst("UsersPerPage").isEmpty()) {
            try {
                this.usersPerPage = Integer.parseInt(Settings.getValueFromPerst("UsersPerPage"));
            }
            catch (NumberFormatException numberFormatException) {
                this.usersPerPage = 100;
            }
            if (this.usersPerPage > 0) {
                this.usersPerPageTextField.setText(new Integer(this.usersPerPage).toString());
            } else {
                this.usersPerPageTextField.setText("100");
                this.usersPerPage = 100;
            }
        } else {
            this.usersPerPageTextField.setText("100");
            this.usersPerPage = 100;
            Settings.writeValueToPerst("UsersPerPage", "" + this.usersPerPage);
        }
        if (this.card) {
            this.addButton.setVisible(false);
            this.searchButton.setVisible(false);
            this.clearButton.setVisible(true);
        }
        super.init();
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Integer n3 = (Integer)MainUsersTab.this.mainTable.getTableModel().getRow(n).get("int_status");
            super.setForeground(Color.BLACK);
            if (-1 == n3) {
                super.setBackground(new Color(255, 255, 153));
            } else if (0 == n3) {
                super.setBackground(new Color(255, 153, 153));
            } else if (1 == n3) {
                super.setBackground(new Color(153, 255, 153));
            }
            return component;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }
}

