/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tp;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetTariffsList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveTariff;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tp.TPDialog;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainTPTab
extends TabPanelWithTable {
    public MainTPTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/tariff_plans_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/tariff_plans.png")));
        this.setRefreshPermission(new int[]{12304});
        this.setAddPermission(new int[]{12306});
        this.setReadPermission(new int[]{12305});
        this.setEditPermission(new int[]{12307, 12308, 12309});
        this.setDeletePermission(new int[]{12315});
    }

    @Override
    public char getShortcut() {
        return 'T';
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Tariff Plans";
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("created_on", "Created on");
        linkedHashMap.put("created_by", "Created by");
        linkedHashMap.put("modified_on", "Modified on");
        linkedHashMap.put("modified_by", "Modified by");
        linkedHashMap.put("expires_on", "Expires on");
        linkedHashMap.put("reset_balance_at_the_accounting_period_end", "Reset balance at the accounting period end");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetTariffsList urfaGetTariffsList = new UrfaGetTariffsList(UrfaManagerImpl.getInstance());
        urfaGetTariffsList.call();
        for (int i = 0; i < urfaGetTariffsList.getTariffsCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetTariffsList.getId1()[i]);
            hashMap.put("name", urfaGetTariffsList.getName1()[i]);
            hashMap.put("created_on", new Date((long)urfaGetTariffsList.getCreateDate1()[i] * 1000L));
            hashMap.put("created_by", Resolve.getUserName(urfaGetTariffsList.getWhoCreate1()[i]));
            hashMap.put("modified_on", new Date((long)urfaGetTariffsList.getChangeCreate1()[i] * 1000L));
            hashMap.put("modified_by", Resolve.getUserName(urfaGetTariffsList.getWhoChange1()[i]));
            hashMap.put("expires_on", new Date((long)urfaGetTariffsList.getExpireDate1()[i] * 1000L));
            hashMap.put("blocked", urfaGetTariffsList.getIsBlocked1()[i]);
            hashMap.put("Reset_balance_at_the_accounting_period_end", urfaGetTariffsList.getBalanceRollover1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveTariff urfaRemoveTariff = new UrfaRemoveTariff(UrfaManagerImpl.getInstance());
        urfaRemoveTariff.setTid((Integer)map.get("id"));
        urfaRemoveTariff.call();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new TPDialog(map);
    }

    @Override
    protected void init() {
        super.init();
        CheckboxCellRenderer checkboxCellRenderer = new CheckboxCellRenderer(false);
        this.getMainTablePanel().setCellRenderer("blocked", checkboxCellRenderer);
        this.getMainTablePanel().setCellRenderer("reset_ballance_at_account_period_end", checkboxCellRenderer);
    }
}

