/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.telzones;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddDirectionToZone;
import biz.netup.control.transport.urfa.functions.UrfaAddZoneNew;
import biz.netup.control.transport.urfa.functions.UrfaDelDirFromZone;
import biz.netup.control.transport.urfa.functions.UrfaGetDirections;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.teldirections.MainTDTab;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ZoneForm
extends DialogModel {
    private JTextField IDTextField;
    private JTextField nameTextField;
    private JPanel directionPanel;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel mainPanel;
    private TablePanelImpl directionsTablePanel;
    UrfaGetDirections urfaGetDirections;
    private Set<Integer> directions;
    private Set<Integer> initialDirections;

    public ZoneForm() {
        this.$$$setupUI$$$();
    }

    public ZoneForm(Map<String, Object> map) {
        super(map);
    }

    private void deleteDirections() {
        for (Map<String, Object> map : this.directionsTablePanel.getSelectedTableRows()) {
            this.directions.remove(map.get("id"));
        }
        this.directionsTablePanel.getTableModel().removeAllRows();
        this.fillDirectionsTable();
    }

    private void addDirections() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainTDTab());
        selectFromTableDialogModel.setMultiRowSelection(true);
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            for (Map<String, Object> map : selectFromTableDialogModel.getResult()) {
                this.directions.add((Integer)map.get("id"));
            }
            this.directionsTablePanel.getTableModel().removeAllRows();
            this.fillDirectionsTable();
        }
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        if (this.isAddMode()) {
            this.directionPanel.setVisible(false);
            this.mainPanel.setPreferredSize(new Dimension(350, 60));
            this.mainPanel.setMinimumSize(new Dimension(350, 60));
        } else {
            this.mainPanel.setPreferredSize(new Dimension(350, 400));
            this.mainPanel.setMinimumSize(new Dimension(350, 400));
        }
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Telephone zone";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.IDTextField.setText("" + this.getItem().get("id"));
            this.nameTextField.setText("" + this.getItem().get("name"));
            int[] nArray = (int[])this.getItem().get("directions_id_array");
            this.directions = new HashSet<Integer>();
            this.initialDirections = new HashSet<Integer>();
            for (int n : nArray) {
                this.directions.add(n);
                this.initialDirections.add(n);
            }
            this.urfaGetDirections = new UrfaGetDirections(UrfaManagerImpl.getInstance());
            this.urfaGetDirections.call();
            this.fillDirectionsTable();
            this.directionsTablePanel.registerMultiRowButton(this.deleteButton);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ZoneForm.this.addDirections();
                }
            });
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ZoneForm.this.deleteDirections();
                }
            });
        }
    }

    private void fillDirectionsTable() {
        for (int i = 0; i < this.urfaGetDirections.getCount(); ++i) {
            if (!this.directions.contains(this.urfaGetDirections.getId1()[i])) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", this.urfaGetDirections.getId1()[i]);
            hashMap.put("prefix", this.urfaGetDirections.getPrefix1()[i]);
            hashMap.put("name", this.urfaGetDirections.getName1()[i]);
            hashMap.put("created_on", new Date((long)this.urfaGetDirections.getCreateDate1()[i] * 1000L));
            this.directionsTablePanel.getTableModel().addRow(hashMap);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaAddZoneNew urfaAddZoneNew = new UrfaAddZoneNew(UrfaManagerImpl.getInstance());
        if (this.isAddMode()) {
            urfaAddZoneNew.setId(0);
            urfaAddZoneNew.setName(this.nameTextField.getText());
            urfaAddZoneNew.call();
        } else {
            urfaAddZoneNew.setId((Integer)this.getItem().get("id"));
            urfaAddZoneNew.setName(this.nameTextField.getText());
            urfaAddZoneNew.call();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Object object = this.directions.iterator();
            while (object.hasNext()) {
                int n = object.next();
                if (this.initialDirections.contains(n)) continue;
                hashSet.add(n);
            }
            object = new UrfaAddDirectionToZone(UrfaManagerImpl.getInstance());
            ((UrfaAddDirectionToZone)object).setZoneId((Integer)this.getItem().get("id"));
            ((UrfaAddDirectionToZone)object).setDirId1(hashSet.toArray(new Integer[hashSet.size()]));
            ((UrfaAddDirectionToZone)object).call();
            for (int n : this.initialDirections) {
                if (this.directions.contains(n)) continue;
                UrfaDelDirFromZone urfaDelDirFromZone = new UrfaDelDirFromZone(UrfaManagerImpl.getInstance());
                urfaDelDirFromZone.setDirId(n);
                urfaDelDirFromZone.setZoneId((Integer)this.getItem().get("id"));
                urfaDelDirFromZone.call();
            }
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameTextField, "Name");
    }

    protected void createUIComponents() {
        this.createDirectionsTable();
    }

    private void createDirectionsTable() {
        this.directionsTablePanel = new TablePanelImpl(this.getClass().getName() + "_directions", true);
        MapTableModel mapTableModel = this.directionsTablePanel.getTableModel();
        mapTableModel.addColumn("id", "ID", true, false);
        mapTableModel.addColumn("name", "Name", true, false);
        mapTableModel.addColumn("prefix", "Prefix", true, false);
        mapTableModel.addColumn("created_on", "Created on", true, false);
        this.directionsTablePanel.setEditable(false);
        this.directionsTablePanel.setAppendable(false);
        this.directionsTablePanel.applyTableSettings();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(350, 204));
        this.mainPanel.setPreferredSize(new Dimension(350, 204));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.directionPanel = new JPanel();
        this.directionPanel.setLayout(new GridBagLayout());
        this.directionPanel.setMinimumSize(new Dimension(10, 300));
        this.directionPanel.setPreferredSize(new Dimension(10, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.directionPanel, gridBagConstraints);
        this.directionPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Directions")));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.directionPanel.add((Component)jPanel, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.directionPanel.add((Component)jPanel6, gridBagConstraints);
        this.directionsTablePanel.setMinimumSize(new Dimension(0, 66));
        this.directionsTablePanel.setPreferredSize(new Dimension(0, 66));
        jPanel6.add((Component)this.directionsTablePanel, "Center");
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

