/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tc;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddTclass2;
import biz.netup.control.transport.urfa.functions.UrfaEditTclass;
import biz.netup.control.transport.urfa.functions.UrfaEditTclassInt;
import biz.netup.control.transport.urfa.functions.UrfaGetTclass;
import biz.netup.control.transport.urfa.functions.UrfaGetTimeRanges;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tc.SubclassDialog;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.export.ExportClass;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TCDialog
extends DialogModel {
    private JTextField trafficClassNameTextField;
    private JComboBox timeRangeComboBox;
    private JButton colorButton;
    private JComboBox localTrafficPolicyComboBox;
    private JCheckBox displayCheckBox;
    private JButton deleteButton;
    private JButton addButton;
    private JButton editButton;
    private JTextField classIDTextField;
    private JPanel mainPanel;
    private TablePanelImpl subclassesTablePanel;
    private JCheckBox fillInCheckBox;
    private JCheckBox donTSaveCheckBox;
    private JButton exportButton;
    private JButton importButton;
    private HashMap<Integer, String> trs;
    private boolean init = false;

    public TCDialog() {
        this.$$$setupUI$$$();
    }

    public TCDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Traffic class";
    }

    private void init() {
        this.subclassesTablePanel.registerOneRowButton(this.editButton);
        this.subclassesTablePanel.registerMultiRowButton(this.deleteButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCDialog.this.addSubclass();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCDialog.this.editSubclass();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCDialog.this.deleteSubclass();
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportClass.exportToCsv(TCDialog.this.subclassesTablePanel);
            }
        });
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExportClass.importFromCsv(TCDialog.this.subclassesTablePanel)) {
                    // empty if block
                }
            }
        });
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCDialog.this.colorChange();
            }
        });
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        UrfaGetTimeRanges urfaGetTimeRanges = new UrfaGetTimeRanges(UrfaManagerImpl.getInstance());
        urfaGetTimeRanges.call();
        this.trs = new HashMap();
        this.trs.put(0, this.resource.getString("Not defined"));
        for (int i = 0; i < urfaGetTimeRanges.getSizeTr(); ++i) {
            this.trs.put(urfaGetTimeRanges.getRangeId1()[i], urfaGetTimeRanges.getTrName1()[i] + " (" + urfaGetTimeRanges.getRangeId1()[i] + ")");
        }
        this.timeRangeComboBox.removeAllItems();
        for (String string : this.trs.values()) {
            this.timeRangeComboBox.addItem(string);
        }
        this.localTrafficPolicyComboBox.removeAllItems();
        this.localTrafficPolicyComboBox.addItem(this.resource.getString("to receiver"));
        this.localTrafficPolicyComboBox.addItem(this.resource.getString("to sender"));
        this.localTrafficPolicyComboBox.addItem(this.resource.getString("both"));
        if (!this.isAddMode()) {
            UrfaGetTclass urfaGetTclass = new UrfaGetTclass(UrfaManagerImpl.getInstance());
            urfaGetTclass.setTclassId((Integer)this.item.get("id"));
            urfaGetTclass.call();
            this.classIDTextField.setText("" + this.item.get("id"));
            this.classIDTextField.setEditable(false);
            this.trafficClassNameTextField.setText(urfaGetTclass.getTclassName());
            this.timeRangeComboBox.setSelectedItem(this.trs.get(urfaGetTclass.getTimeRangeId()));
            this.colorButton.setBackground(new Color(urfaGetTclass.getGraphColor()));
            this.localTrafficPolicyComboBox.setSelectedIndex(urfaGetTclass.getLocalTrafPolicy());
            this.displayCheckBox.setSelected(urfaGetTclass.getIsDisplay() == 1);
            this.fillInCheckBox.setSelected(urfaGetTclass.getIsFill() == 1);
            this.donTSaveCheckBox.setSelected(urfaGetTclass.getDontSave() == 1);
            for (int i = 0; i < urfaGetTclass.getTclassCount(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("out_of_network", Resolve.ip_toString(urfaGetTclass.getSaddr1()[i]));
                hashMap.put("smask", Resolve.ip_toString(urfaGetTclass.getSaddrMask1()[i]));
                hashMap.put("out_of_network_ip", urfaGetTclass.getSaddr1()[i]);
                hashMap.put("smask_ip", urfaGetTclass.getSaddrMask1()[i]);
                if (urfaGetTclass.getUseSport1()[i] == 1) {
                    hashMap.put("sport", urfaGetTclass.getSport1()[i]);
                    hashMap.put("use_sport", 1);
                } else {
                    hashMap.put("sport", "");
                    hashMap.put("use_sport", 0);
                }
                if (urfaGetTclass.getUseInput1()[i] == 1) {
                    hashMap.put("incoming", urfaGetTclass.getInput1()[i]);
                    hashMap.put("use_incoming", 1);
                } else {
                    hashMap.put("incoming", "");
                    hashMap.put("use_incoming", 0);
                }
                if (urfaGetTclass.getUseSrcAs1()[i] == 1) {
                    hashMap.put("src_as", urfaGetTclass.getSrcAs1()[i]);
                    hashMap.put("use_src_as", 1);
                } else {
                    hashMap.put("src_as", "");
                    hashMap.put("use_src_as", 0);
                }
                hashMap.put("to_network", Resolve.ip_toString(urfaGetTclass.getDaddr1()[i]));
                hashMap.put("dmask", Resolve.ip_toString(urfaGetTclass.getDaddrMask1()[i]));
                hashMap.put("to_network_ip", urfaGetTclass.getDaddr1()[i]);
                hashMap.put("dmask_ip", urfaGetTclass.getDaddrMask1()[i]);
                if (urfaGetTclass.getUseDport1()[i] == 1) {
                    hashMap.put("dport", urfaGetTclass.getDport1()[i]);
                    hashMap.put("use_dport", 1);
                } else {
                    hashMap.put("dport", "");
                    hashMap.put("use_dport", 0);
                }
                if (urfaGetTclass.getUseOutput1()[i] == 1) {
                    hashMap.put("outgoing", urfaGetTclass.getOutput1()[i]);
                    hashMap.put("use_outgoing", 1);
                } else {
                    hashMap.put("outgoing", "");
                    hashMap.put("use_outgoing", 0);
                }
                if (urfaGetTclass.getUseDstAs1()[i] == 1) {
                    hashMap.put("dst_as", urfaGetTclass.getDstAs1()[i]);
                    hashMap.put("use_dst_as", 1);
                } else {
                    hashMap.put("dst_as", "");
                    hashMap.put("use_dst_as", 0);
                }
                if (urfaGetTclass.getUseProto1()[i] == 1) {
                    hashMap.put("proto", urfaGetTclass.getProto1()[i]);
                    hashMap.put("use_proto", 1);
                } else {
                    hashMap.put("proto", "");
                    hashMap.put("use_proto", 0);
                }
                if (urfaGetTclass.getUseTos1()[i] == 1) {
                    hashMap.put("tos", urfaGetTclass.getTos1()[i]);
                    hashMap.put("use_tos", 1);
                } else {
                    hashMap.put("tos", "");
                    hashMap.put("use_tos", 0);
                }
                if (urfaGetTclass.getUseNexthop1()[i] == 1) {
                    hashMap.put("next_router", Resolve.ip_toString(urfaGetTclass.getNexthop1()[i]));
                    hashMap.put("next_router_ip", urfaGetTclass.getNexthop1()[i]);
                    hashMap.put("use_next_router", 1);
                } else {
                    hashMap.put("next_router", "");
                    hashMap.put("next_router_ip", "");
                    hashMap.put("use_next_router", 0);
                }
                if (urfaGetTclass.getUseTcpFlags1()[i] == 1) {
                    hashMap.put("tcp_flags", urfaGetTclass.getTcpFlags1()[i]);
                    hashMap.put("use_tcp_flags", 1);
                } else {
                    hashMap.put("tcp_flags", "");
                    hashMap.put("use_tcp_flags", 0);
                }
                hashMap.put("skip", urfaGetTclass.getSkip1()[i]);
                hashMap.put("router_ip", Resolve.ip_toString(urfaGetTclass.getIpFrom1()[i]));
                hashMap.put("router_ip_ip", urfaGetTclass.getIpFrom1()[i]);
                this.subclassesTablePanel.getTableModel().addRow(hashMap);
            }
        }
    }

    private void addSubclass() {
        SubclassDialog subclassDialog = new SubclassDialog(null);
        subclassDialog.load();
        if (subclassDialog.isOkPressed()) {
            this.subclassesTablePanel.getTableModel().addRow(subclassDialog.getSubclass());
        }
    }

    private void editSubclass() {
        SubclassDialog subclassDialog = new SubclassDialog(this.subclassesTablePanel.getSelectedTableRows()[0]);
        subclassDialog.load();
        if (subclassDialog.isOkPressed()) {
            this.subclassesTablePanel.getTableModel().removeRow(this.subclassesTablePanel.getSelectedTableRows()[0]);
            this.subclassesTablePanel.getTableModel().addRow(subclassDialog.getSubclass());
        }
    }

    private void deleteSubclass() {
        for (Map<String, Object> map : this.subclassesTablePanel.getSelectedTableRows()) {
            this.subclassesTablePanel.getTableModel().removeRow(map);
        }
    }

    private void colorChange() {
        Color color = JColorChooser.showDialog(this, "Select color", Color.GREEN);
        if (color != null) {
            this.colorButton.setBackground(color);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaEditTclassInt urfaEditTclassInt = this.isAddMode() ? new UrfaAddTclass2(UrfaManagerImpl.getInstance()) : new UrfaEditTclass(UrfaManagerImpl.getInstance());
        urfaEditTclassInt.setSaddr1(ArrayFromVector.getIpArrayFromData(this.subclassesTablePanel.getTableModel().data, "out_of_network"));
        urfaEditTclassInt.setSaddrMask1(ArrayFromVector.getIpArrayFromData(this.subclassesTablePanel.getTableModel().data, "smask"));
        urfaEditTclassInt.setSport1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "sport"));
        urfaEditTclassInt.setInput1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "incoming"));
        urfaEditTclassInt.setSrcAs1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "src_as"));
        urfaEditTclassInt.setDaddr1(ArrayFromVector.getIpArrayFromData(this.subclassesTablePanel.getTableModel().data, "to_network"));
        urfaEditTclassInt.setDaddrMask1(ArrayFromVector.getIpArrayFromData(this.subclassesTablePanel.getTableModel().data, "dmask"));
        urfaEditTclassInt.setDport1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "dport"));
        urfaEditTclassInt.setOutput1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "outgoing"));
        urfaEditTclassInt.setDstAs1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "dst_as"));
        urfaEditTclassInt.setProto1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "proto"));
        urfaEditTclassInt.setTos1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "tos"));
        urfaEditTclassInt.setNexthop1(ArrayFromVector.getIpArrayFromData(this.subclassesTablePanel.getTableModel().data, "next_router"));
        urfaEditTclassInt.setTcpFlags1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "tcp_flags"));
        urfaEditTclassInt.setSkip1(ArrayFromVector.getIntArrayFromData(this.subclassesTablePanel.getTableModel().data, "skip"));
        urfaEditTclassInt.setIpFrom1(ArrayFromVector.getIpArrayFromData(this.subclassesTablePanel.getTableModel().data, "router_ip"));
        urfaEditTclassInt.setUseDport1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "dport"));
        urfaEditTclassInt.setUseSport1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "sport"));
        urfaEditTclassInt.setUseDstAs1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "dst_as"));
        urfaEditTclassInt.setUseSrcAs1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "src_as"));
        urfaEditTclassInt.setUseInput1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "incoming"));
        urfaEditTclassInt.setUseOutput1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "outgoing"));
        urfaEditTclassInt.setUseNexthop1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "next_router"));
        urfaEditTclassInt.setUseProto1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "proto"));
        urfaEditTclassInt.setUseTcpFlags1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "tcp_flags"));
        urfaEditTclassInt.setUseTos1(ArrayFromVector.getIsEmptyArrayFromData(this.subclassesTablePanel.getTableModel().data, "tos"));
        urfaEditTclassInt.setDontSave(this.donTSaveCheckBox.isSelected() ? 1 : 0);
        urfaEditTclassInt.setGraphColor(this.colorButton.getBackground().getRGB());
        urfaEditTclassInt.setIsDisplay(this.displayCheckBox.isSelected() ? 1 : 0);
        urfaEditTclassInt.setIsFill(this.fillInCheckBox.isSelected() ? 1 : 0);
        urfaEditTclassInt.setLocalTrafPolicy(this.localTrafficPolicyComboBox.getSelectedIndex());
        urfaEditTclassInt.setTclassCount(this.subclassesTablePanel.getTable().getRowCount());
        urfaEditTclassInt.setTclassId(Integer.parseInt(this.classIDTextField.getText()));
        for (Integer n : this.trs.keySet()) {
            if (!this.trs.get(n).equals(this.timeRangeComboBox.getSelectedItem())) continue;
            urfaEditTclassInt.setTimeRangeId(n);
        }
        urfaEditTclassInt.setTclassName(this.trafficClassNameTextField.getText());
        urfaEditTclassInt.call();
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkInt(this.classIDTextField, "ID");
        this.checkName(this.trafficClassNameTextField, "Name");
        this.checkTablePanel(this.subclassesTablePanel, "Traffic subclasses");
    }

    protected void createUIComponents() {
        this.createSubclassesTable();
        this.colorButton = new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        };
        this.colorButton.setBackground(Color.GREEN);
    }

    private void createSubclassesTable() {
        this.subclassesTablePanel = new TablePanelImpl(this.getClass().getName() + "_directions", true);
        MapTableModel mapTableModel = this.subclassesTablePanel.getTableModel();
        mapTableModel.addColumn("out_of_network", "Out of network", true, false);
        mapTableModel.addColumn("smask", "Src mask", true, false);
        mapTableModel.addColumn("sport", "Src port", true, false);
        mapTableModel.addColumn("incoming", "Incoming", true, false);
        mapTableModel.addColumn("src_as", "Src_as", true, false);
        mapTableModel.addColumn("to_network", "To network", true, false);
        mapTableModel.addColumn("dmask", "Dst mask", true, false);
        mapTableModel.addColumn("dport", "Dst port", true, false);
        mapTableModel.addColumn("outgoing", "Outgoing", true, false);
        mapTableModel.addColumn("dst_as", "Dst_as", true, false);
        mapTableModel.addColumn("proto", "Proto", true, false);
        mapTableModel.addColumn("tos", "Tos", true, false);
        mapTableModel.addColumn("next_router", "Next router", true, false);
        mapTableModel.addColumn("tcp_flags", "TCP flags", true, false);
        mapTableModel.addColumn("skip", "Skip", true, false);
        mapTableModel.addColumn("router_ip", "Router IP", true, false);
        this.subclassesTablePanel.setEditable(false);
        this.subclassesTablePanel.setAppendable(false);
        this.subclassesTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                TCDialog.this.editSubclass();
            }
        });
        this.subclassesTablePanel.setCellRenderer("skip", new CheckboxCellRenderer(false));
        this.subclassesTablePanel.applyTableSettings();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(700, 450));
        this.mainPanel.setPreferredSize(new Dimension(700, 450));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Class ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Time range"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Traffic class name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        this.trafficClassNameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.trafficClassNameTextField, gridBagConstraints);
        this.timeRangeComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.timeRangeComboBox, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Traffic subclasses")));
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        this.editButton = new JButton();
        this.editButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.editButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.editButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add((Component)this.subclassesTablePanel, "Center");
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        this.exportButton = new JButton();
        this.$$$loadButtonText$$$(this.exportButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Export"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.exportButton, gridBagConstraints);
        this.importButton = new JButton();
        this.$$$loadButtonText$$$(this.importButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Import"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.importButton, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel10, gridBagConstraints);
        this.classIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.classIDTextField, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel17, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Graph color"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        this.colorButton.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.colorButton, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Local traffic policy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel5, gridBagConstraints);
        this.localTrafficPolicyComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.localTrafficPolicyComboBox, gridBagConstraints);
        this.donTSaveCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.donTSaveCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Don't save"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.donTSaveCheckBox, gridBagConstraints);
        this.fillInCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.fillInCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Fill in"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.fillInCheckBox, gridBagConstraints);
        this.displayCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.displayCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Display"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.displayCheckBox, gridBagConstraints);
        jLabel.setLabelFor(this.classIDTextField);
        jLabel2.setLabelFor(this.timeRangeComboBox);
        jLabel3.setLabelFor(this.trafficClassNameTextField);
        jLabel5.setLabelFor(this.localTrafficPolicyComboBox);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

