/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.services;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetServicesList;
import biz.netup.control.transport.urfa.functions.UrfaIsServiceUsed;
import biz.netup.control.transport.urfa.functions.UrfaRemoveService;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.serviceframe.ServiceFrame;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.control.types.ServiceType;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class MainServicesTab
extends TabPanelWithTable {
    public static final int FICTIVE_SERVICE = 1;
    public static final int COMMON_SERVICE = 2;

    public MainServicesTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/services_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/services.png")));
        this.setRefreshPermission(new int[]{8449});
        this.setAddPermission(new int[]{9216, 8960, 65538, 8704, 20560, 20562, 8470, 8480, 8481, 8456, 8461, 20565, 8454, 8455, 8459});
        this.setEditPermission(new int[]{9216, 8960, 65538, 8704, 20560, 20562, 8470, 8480, 8481, 8456, 8461, 20565, 8452, 8453, 8454, 8455, 8457, 8458, 8459, 8469});
        this.setDeletePermission(new int[]{65537, 8462});
    }

    @Override
    public char getShortcut() {
        return 'S';
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Services";
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("type", "Type");
        linkedHashMap.put("comment", "Comment");
        linkedHashMap.put("status", "Status");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetServicesList urfaGetServicesList = new UrfaGetServicesList(UrfaManagerImpl.getInstance());
        urfaGetServicesList.setWhichService(1);
        urfaGetServicesList.call();
        for (int i = 0; i < urfaGetServicesList.getServicesCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetServicesList.getServiceIdArray1()[i]);
            hashMap.put("type", ServiceType.getName(urfaGetServicesList.getServiceTypeArray1()[i]));
            hashMap.put("type_id", urfaGetServicesList.getServiceTypeArray1()[i]);
            hashMap.put("name", urfaGetServicesList.getServiceNameArray1()[i]);
            hashMap.put("comment", urfaGetServicesList.getServiceCommentArray1()[i]);
            hashMap.put("tp", urfaGetServicesList.getServiceCommentArray1()[i]);
            if (urfaGetServicesList.getServiceStatusArray1()[i] == 0) {
                hashMap.put("status", Utils.getResource().getString("Common service"));
                hashMap.put("status_id", 0);
            } else {
                hashMap.put("status", Utils.getResource().getString("Tariff plan") + ": \"" + urfaGetServicesList.getTariffNameArray1()[i] + "\"");
                hashMap.put("status_id", 1);
            }
            if (urfaGetServicesList.getServiceStatusArray1()[i] == 1) continue;
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaIsServiceUsed urfaIsServiceUsed = new UrfaIsServiceUsed(UrfaManagerImpl.getInstance());
        urfaIsServiceUsed.setSid((Integer)map.get("id"));
        urfaIsServiceUsed.call();
        if (urfaIsServiceUsed.getLinksCount() == 0) {
            UrfaRemoveService urfaRemoveService = new UrfaRemoveService(UrfaManagerImpl.getInstance());
            urfaRemoveService.setSid((Integer)map.get("id"));
            urfaRemoveService.call();
        } else {
            Dialogs.showInfoDialog(this.resource.getString("Cannot delete service id") + " " + map.get("id") + ", " + this.resource.getString("slinks count") + " " + urfaIsServiceUsed.getLinksCount());
        }
    }

    @Override
    protected void edit() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this);
                ServiceFrame serviceFrame = new ServiceFrame((Integer)MainServicesTab.this.mainTablePanel.getSelectedTableRows()[0].get("id"), 0, (Integer)MainServicesTab.this.mainTablePanel.getSelectedTableRows()[0].get("type_id"));
                UTMTrayIcon.getInstance().removeProcess(this);
                serviceFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected void add() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this, "Dialog - " + MainServicesTab.this.resource.getString("Service"));
                ServiceFrame serviceFrame = new ServiceFrame(0, 0, 0);
                UTMTrayIcon.getInstance().removeProcess(this);
                serviceFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected void read() {
        this.edit();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        if (mapArray.length == 1) {
            JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Copy"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceFrame serviceFrame = new ServiceFrame((Integer)MainServicesTab.this.mainTablePanel.getSelectedTableRows()[0].get("id"), 0, (Integer)MainServicesTab.this.mainTablePanel.getSelectedTableRows()[0].get("type_id"));
                    serviceFrame.setServiceId(0);
                    serviceFrame.setTariffId(0);
                    serviceFrame.setVisible(true);
                    MainServicesTab.this.refresh();
                }
            });
            return new JMenuItem[]{jMenuItem};
        }
        return null;
    }

    @Override
    protected void init() {
        super.init();
        this.mainTablePanel.registerFieldButton(this.deleteButton, "status_id", 0);
    }
}

