/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.reports;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGenerateDocForUser;
import biz.netup.control.transport.urfa.functions.UrfaGetInvoicesList;
import biz.netup.control.transport.urfa.functions.UrfaInvoicesListForDealer;
import biz.netup.control.transport.urfa.functions.UrfaSendInvoice2mail;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.invoice.InvoiceDialog;
import biz.netup.projects.utmadmin.gui.custom.newpayment.NewPaymentDialog;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.PrintEditDialog;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialog.PrintDialog;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class InvoicesTab
extends ReportTab {
    public InvoicesTab(int n, boolean bl) {
        super(n, bl);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9216, 32769});
        } else {
            this.setRefreshPermission(new int[]{77862});
        }
    }

    @Override
    protected void init() {
        super.init();
        this.getApPanel().setVisible(false);
        if (this.uid != 0) {
            this.accountComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if ((Integer)InvoicesTab.this.accountMap.get(InvoicesTab.this.accountComboBox.getSelectedItem()) != 0) {
                        InvoicesTab.this.newInvoiceButton.setEnabled(true);
                    } else {
                        InvoicesTab.this.newInvoiceButton.setEnabled(false);
                    }
                }
            });
            this.newInvoiceButton.setVisible(true);
            this.newInvoiceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("aid", InvoicesTab.this.aid);
                    new InvoiceDialog(hashMap).load();
                }
            });
            this.accountComboBox.removeItem("---");
        }
        this.getReportTablePanel().setCellRenderer("is_payed", new CheckboxCellRenderer(false));
    }

    public InvoicesTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9216, 32769});
        } else {
            this.setRefreshPermission(new int[]{77862});
        }
    }

    public InvoicesTab(int n) {
        super(n);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9216, 32769});
        } else {
            this.setRefreshPermission(new int[]{77862});
        }
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("internal_number", "Internal number");
        linkedHashMap.put("external_number", "External number");
        linkedHashMap.put("account_id", "Account ID");
        linkedHashMap.put("full_name", "Full name");
        linkedHashMap.put("date", "Time");
        linkedHashMap.put("is_payed", "Is payed");
        linkedHashMap.put("sum", "Sum");
        return linkedHashMap;
    }

    @Override
    protected JMenuItem[] getMenuItems(final Map<String, Object>[] mapArray) {
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Invoice"));
        JMenuItem jMenuItem2 = new JMenuItem(this.resource.getString("Account invoice"));
        JMenuItem jMenuItem3 = new JMenuItem(this.resource.getString("Report of completion"));
        JMenuItem jMenuItem4 = new JMenuItem(this.resource.getString("Print invoices"));
        JMenuItem jMenuItem5 = new JMenuItem(this.resource.getString("Print invoices by account"));
        JMenuItem jMenuItem6 = new JMenuItem(this.resource.getString("Send to email"));
        JMenuItem jMenuItem7 = new JMenuItem(this.resource.getString("Pay"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.invoice(mapArray);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.viewInvoice(mapArray);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.viewAct(mapArray);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.printInv(mapArray);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.printInvByAcc(mapArray);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.send(mapArray);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoicesTab.this.pay(mapArray);
            }
        });
        if (mapArray.length == 1) {
            if ((Integer)mapArray[0].get("is_payed") == 0) {
                return new JMenuItem[]{jMenuItem7, jMenuItem, jMenuItem2, jMenuItem3, jMenuItem6};
            }
            return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3, jMenuItem6};
        }
        if (mapArray.length > 1) {
            return new JMenuItem[]{jMenuItem4, jMenuItem5, jMenuItem6};
        }
        return new JMenuItem[0];
    }

    private void pay(Map<String, Object>[] mapArray) {
        NewPaymentDialog newPaymentDialog = new NewPaymentDialog((Integer)mapArray[0].get("uid"), (Integer)mapArray[0].get("account_id"));
        newPaymentDialog.setPaidToInvoice((Integer)mapArray[0].get("id"));
        newPaymentDialog.setVisible(true);
        if (newPaymentDialog.isOkPressed()) {
            this.refresh();
        }
    }

    private void send(Map<String, Object>[] mapArray) {
        try {
            for (Map<String, Object> map : mapArray) {
                UrfaSendInvoice2mail urfaSendInvoice2mail = new UrfaSendInvoice2mail(UrfaManagerImpl.getInstance());
                urfaSendInvoice2mail.setAid((Integer)map.get("account_id"));
                urfaSendInvoice2mail.setInvcId((Integer)map.get("id"));
                urfaSendInvoice2mail.call();
            }
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot send e-mail", urfaException);
        }
    }

    private void printInvByAcc(final Map<String, Object>[] mapArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PrintDialog printDialog = new PrintDialog(true, null);
                printDialog.getEditButton().setVisible(false);
                try {
                    for (Map map : mapArray) {
                        UrfaGenerateDocForUser urfaGenerateDocForUser = new UrfaGenerateDocForUser(UrfaManagerImpl.getInstance());
                        urfaGenerateDocForUser.setBaseId((Integer)map.get("id"));
                        urfaGenerateDocForUser.setDocTemplateId(0);
                        urfaGenerateDocForUser.setDocTypeId(6);
                        urfaGenerateDocForUser.setUserId(0);
                        urfaGenerateDocForUser.call();
                        printDialog.addPage(urfaGenerateDocForUser.getText());
                    }
                    printDialog.setVisible(true);
                }
                catch (UrfaException urfaException) {
                    InvoicesTab.this.log.error("Cannot load invoices", urfaException);
                }
            }
        };
        thread.start();
    }

    private void printInv(final Map<String, Object>[] mapArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PrintDialog printDialog = new PrintDialog(false, null);
                printDialog.getEditButton().setVisible(false);
                try {
                    for (Map map : mapArray) {
                        UrfaGenerateDocForUser urfaGenerateDocForUser = new UrfaGenerateDocForUser(UrfaManagerImpl.getInstance());
                        urfaGenerateDocForUser.setBaseId((Integer)map.get("id"));
                        urfaGenerateDocForUser.setDocTemplateId(0);
                        urfaGenerateDocForUser.setDocTypeId(5);
                        urfaGenerateDocForUser.setUserId(0);
                        urfaGenerateDocForUser.call();
                        printDialog.addPage(urfaGenerateDocForUser.getText());
                    }
                    printDialog.setVisible(true);
                }
                catch (UrfaException urfaException) {
                    InvoicesTab.this.log.error("Cannot load invoices", urfaException);
                }
            }
        };
        thread.start();
    }

    private void viewInvoice(Map<String, Object>[] mapArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("base_id", mapArray[0].get("id"));
        hashMap.put("user_id", 0);
        hashMap.put("template_id", 0);
        hashMap.put("doc_type_id", 6);
        new PrintEditDialog(hashMap).run();
    }

    private void invoice(Map<String, Object>[] mapArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("base_id", mapArray[0].get("id"));
        hashMap.put("user_id", 0);
        hashMap.put("template_id", 0);
        hashMap.put("doc_type_id", 5);
        new PrintEditDialog(hashMap).run();
    }

    private void viewAct(Map<String, Object>[] mapArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("base_id", mapArray[0].get("id"));
        hashMap.put("user_id", 0);
        hashMap.put("template_id", 0);
        hashMap.put("doc_type_id", 8);
        new PrintEditDialog(hashMap).run();
    }

    @Override
    public void setTableData() throws UrfaException {
        if (Utils.isAdmin() && this.did == 0) {
            UrfaGetInvoicesList urfaGetInvoicesList = new UrfaGetInvoicesList(UrfaManagerImpl.getInstance(), this);
            urfaGetInvoicesList.setTimeEnd(this.getEndTime());
            urfaGetInvoicesList.setTimeStart(this.getStartTime());
            urfaGetInvoicesList.setAid(this.aid);
            urfaGetInvoicesList.setGid(this.getGroupId());
            urfaGetInvoicesList.call();
        } else {
            UrfaInvoicesListForDealer urfaInvoicesListForDealer = new UrfaInvoicesListForDealer(UrfaManagerImpl.getInstance(), this);
            urfaInvoicesListForDealer.setEndDate(this.getEndTime());
            urfaInvoicesListForDealer.setStartDate(this.getStartTime());
            urfaInvoicesListForDealer.setDealerId(this.did);
            urfaInvoicesListForDealer.call();
        }
    }

    @Override
    public String getTabName() {
        return "Invoices";
    }
}

