/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteDocTemplate;
import biz.netup.control.transport.urfa.functions.UrfaGetDocTemplatesList;
import biz.netup.control.transport.urfa.functions.UrfaGetDocTypesList;
import biz.netup.control.transport.urfa.functions.UrfaSetDefaultDocTemplate;
import biz.netup.control.transport.urfa.functions.UrfaUpdateTemplatesFromDb;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.AdditionalButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.TemplateDialog;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class MainTemplatesTab
extends TabPanelWithTable {
    public static final int USERS_INFO_SHEET = 2;
    public static final int CONTRACT = 3;
    public static final int RECEIPT = 4;
    public static final int INVOICE = 5;
    public static final int TAX_INVOICE = 6;
    public static final int REPORT_OF_COMPLETION_FOR_INDIVIDUAL = 7;
    public static final int REPORT_OF_COMPLETION_FOR_LEGAL = 8;
    public static final int INDIVIDUAL_INVOICE = 9;
    public static final int INVOICE_WEB = 25;
    public static final int INDIVIDUAL_INVOICE_WEB = 26;
    public static final int RECEIPT_WEB = 27;
    public static final Set<Integer> AVAILABLE_TYPES = new HashSet<Integer>();

    public MainTemplatesTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/document_templates.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/document_templates_24.png")));
        this.setRefreshPermission(new int[]{28708, 28706});
        this.setAddPermission(new int[]{28704});
        this.setDeletePermission(new int[]{28710});
        this.setReadPermission(new int[]{28707, 28728});
        this.setEditPermission(new int[]{28705});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Templates of documents";
    }

    @Override
    public String getGroupName() {
        return "Options";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("type", "Type");
        linkedHashMap.put("type_id", "Type ID");
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("template_id", "Template ID");
        linkedHashMap.put("date_of_creation", "Date of creation");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("use_by_default", "Use by default");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetDocTypesList urfaGetDocTypesList = new UrfaGetDocTypesList(UrfaManagerImpl.getInstance());
        urfaGetDocTypesList.call();
        for (int i = 0; i < urfaGetDocTypesList.getCount(); ++i) {
            if (!this.isAvailable(urfaGetDocTypesList.getId1()[i])) continue;
            UrfaGetDocTemplatesList urfaGetDocTemplatesList = new UrfaGetDocTemplatesList(UrfaManagerImpl.getInstance());
            urfaGetDocTemplatesList.setDocTypeId(urfaGetDocTypesList.getId1()[i]);
            urfaGetDocTemplatesList.call();
            for (int j = 0; j < urfaGetDocTemplatesList.getCount(); ++j) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "".equals(Resolve.getTemplateType(urfaGetDocTypesList.getId1()[i])) ? urfaGetDocTemplatesList.getDocName1()[j] : Resolve.getTemplateType(urfaGetDocTypesList.getId1()[i]));
                hashMap.put("type_id", urfaGetDocTypesList.getId1()[i]);
                hashMap.put("id", urfaGetDocTemplatesList.getId1()[j]);
                hashMap.put("template_id", urfaGetDocTemplatesList.getDocId1()[j]);
                hashMap.put("date_of_creation", new Date((long)urfaGetDocTemplatesList.getDate1()[j] * 1000L));
                hashMap.put("name", urfaGetDocTemplatesList.getDocName1()[j]);
                hashMap.put("use_by_default", urfaGetDocTemplatesList.getDef1()[j]);
                vector.add(hashMap);
            }
        }
        return vector;
    }

    boolean isAvailable(int n) {
        return AVAILABLE_TYPES.contains(n);
    }

    @Override
    protected void init() {
        super.init();
        CheckboxCellRenderer checkboxCellRenderer = new CheckboxCellRenderer(false);
        this.getMainTablePanel().setCellRenderer("use_by_default", checkboxCellRenderer);
        AdditionalButtons additionalButtons = new AdditionalButtons();
        Permissions.apply((JComponent)additionalButtons.getDefaultButton(), "set_default_doc_template");
        Permissions.apply((JComponent)additionalButtons.getUploadButton(), "update_templates_from_db");
        this.getMainTablePanel().registerOneRowButton(additionalButtons.getDefaultButton());
        this.getAdditionalButtonPanel2().add((Component)additionalButtons.getPanel1(), "Center");
        additionalButtons.getDefaultButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UrfaSetDefaultDocTemplate urfaSetDefaultDocTemplate = new UrfaSetDefaultDocTemplate(UrfaManagerImpl.getInstance());
                urfaSetDefaultDocTemplate.setDocType((Integer)MainTemplatesTab.this.getMainTablePanel().getSelectedTableRows()[0].get("type_id"));
                urfaSetDefaultDocTemplate.setTemplateId((Integer)MainTemplatesTab.this.getMainTablePanel().getSelectedTableRows()[0].get("template_id"));
                try {
                    urfaSetDefaultDocTemplate.call();
                }
                catch (UrfaException urfaException) {
                    MainTemplatesTab.this.log.error("Cannot update data", urfaException);
                }
                MainTemplatesTab.this.refresh();
            }
        });
        additionalButtons.getUploadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Dialogs.showYesNoDialog("Are you sure?")) {
                    UrfaUpdateTemplatesFromDb urfaUpdateTemplatesFromDb = new UrfaUpdateTemplatesFromDb(UrfaManagerImpl.getInstance());
                    try {
                        urfaUpdateTemplatesFromDb.call();
                    }
                    catch (UrfaException urfaException) {
                        MainTemplatesTab.this.log.error("Cannot update data", urfaException);
                    }
                    MainTemplatesTab.this.refresh();
                }
            }
        });
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDeleteDocTemplate urfaDeleteDocTemplate = new UrfaDeleteDocTemplate(UrfaManagerImpl.getInstance());
        urfaDeleteDocTemplate.setDocTemplId((Integer)map.get("template_id"));
        urfaDeleteDocTemplate.call();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new TemplateDialog(map);
    }

    static {
        AVAILABLE_TYPES.add(2);
        AVAILABLE_TYPES.add(3);
        AVAILABLE_TYPES.add(4);
        AVAILABLE_TYPES.add(5);
        AVAILABLE_TYPES.add(6);
        AVAILABLE_TYPES.add(7);
        AVAILABLE_TYPES.add(8);
        AVAILABLE_TYPES.add(9);
        AVAILABLE_TYPES.add(25);
        AVAILABLE_TYPES.add(26);
        AVAILABLE_TYPES.add(27);
    }
}

