/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.ipzones;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddIpzone;
import biz.netup.control.transport.urfa.functions.UrfaGetIpzone;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.subnet.SubnetDialog;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IPZoneDialog
extends DialogModel {
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    private JTextField IDTextField;
    private JTextField nameTextField;
    private TablePanelImpl subnetsTablePanel;
    private JLabel IDLabel;

    public IPZoneDialog() {
        this.$$$setupUI$$$();
    }

    public IPZoneDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "IP zone";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            UrfaGetIpzone urfaGetIpzone = new UrfaGetIpzone(UrfaManagerImpl.getInstance());
            urfaGetIpzone.setId((Integer)this.item.get("id"));
            urfaGetIpzone.call();
            this.IDTextField.setText("" + this.item.get("id"));
            this.nameTextField.setText(urfaGetIpzone.getName());
            for (int i = 0; i < urfaGetIpzone.getCount(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("network_ip", urfaGetIpzone.getNet1()[i]);
                hashMap.put("mask_ip", urfaGetIpzone.getMask1()[i]);
                hashMap.put("gateway_ip", urfaGetIpzone.getGateaway1()[i]);
                hashMap.put("network", Resolve.ip_toString(urfaGetIpzone.getNet1()[i]));
                hashMap.put("mask", Resolve.ip_toString(urfaGetIpzone.getMask1()[i]));
                hashMap.put("gateway", Resolve.ip_toString(urfaGetIpzone.getGateaway1()[i]));
                this.subnetsTablePanel.getTableModel().addRow(hashMap);
            }
        } else {
            this.IDLabel.setVisible(false);
            this.IDTextField.setVisible(false);
        }
        this.subnetsTablePanel.registerMultiRowButton(this.deleteButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPZoneDialog.this.addSubnet();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPZoneDialog.this.deleteSubnet();
            }
        });
    }

    private void addSubnet() {
        SubnetDialog subnetDialog = new SubnetDialog(null);
        subnetDialog.load();
        if (subnetDialog.isOkPressed()) {
            this.subnetsTablePanel.getTableModel().addRow(subnetDialog.getItem());
        }
    }

    private void deleteSubnet() {
        for (Map<String, Object> map : this.subnetsTablePanel.getSelectedTableRows()) {
            this.subnetsTablePanel.getTableModel().removeRow(map);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaAddIpzone urfaAddIpzone = new UrfaAddIpzone(UrfaManagerImpl.getInstance());
        if (!this.isAddMode()) {
            urfaAddIpzone.setId((Integer)this.item.get("id"));
        }
        urfaAddIpzone.setName(this.nameTextField.getText());
        urfaAddIpzone.setCount(this.subnetsTablePanel.getTable().getRowCount());
        urfaAddIpzone.setGateaway1(ArrayFromVector.getIntArrayFromData(this.subnetsTablePanel.getTableModel().data, "gateway_ip"));
        urfaAddIpzone.setMask1(ArrayFromVector.getIntArrayFromData(this.subnetsTablePanel.getTableModel().data, "mask_ip"));
        urfaAddIpzone.setNet1(ArrayFromVector.getIntArrayFromData(this.subnetsTablePanel.getTableModel().data, "network_ip"));
        urfaAddIpzone.call();
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameTextField, "Name");
        this.checkTablePanel(this.subnetsTablePanel, "Subnets");
    }

    protected void createUIComponents() {
        this.createSubnetsTable();
    }

    private void createSubnetsTable() {
        this.subnetsTablePanel = new TablePanelImpl(this.getClass().getName() + "_subnets", true);
        MapTableModel mapTableModel = this.subnetsTablePanel.getTableModel();
        mapTableModel.addColumn("network", "Network", true, false);
        mapTableModel.addColumn("mask", "Mask", true, false);
        mapTableModel.addColumn("gateway", "Gateway", true, false);
        this.subnetsTablePanel.setEditable(false);
        this.subnetsTablePanel.setAppendable(false);
        this.subnetsTablePanel.applyTableSettings();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(400, 450));
        this.mainPanel.setPreferredSize(new Dimension(400, 450));
        this.IDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.IDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.IDLabel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Subnets")));
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add((Component)this.subnetsTablePanel, "Center");
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameTextField, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        this.IDLabel.setLabelFor(this.IDTextField);
        jLabel.setLabelFor(this.nameTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

