/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetHousesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings.BuildingDialog;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainBuildingsTab
extends TabPanelWithTable {
    public MainBuildingsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/buildings.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/buildings_24.png")));
        this.setRefreshPermission(new int[]{10256});
        this.setAddPermission(new int[]{10240, 10257});
        this.setReadPermission(new int[]{10258});
        this.setEditPermission(new int[]{10240, 10257});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    protected boolean useFilter() {
        return true;
    }

    @Override
    public String getTabName() {
        return "Buildings";
    }

    @Override
    public String getGroupName() {
        return "Reference book";
    }

    @Override
    public int getMode() {
        return 3;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("ip_zone_id", "IP zone ID");
        linkedHashMap.put("connected_on", "Connected on");
        linkedHashMap.put("zip_code", "ZIP code");
        linkedHashMap.put("country", "Country");
        linkedHashMap.put("province/state", "Province/State");
        linkedHashMap.put("city", "City");
        linkedHashMap.put("street", "Street");
        linkedHashMap.put("building_#", "Building #");
        linkedHashMap.put("constr.#", "Constr.#");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetHousesList urfaGetHousesList = new UrfaGetHousesList(UrfaManagerImpl.getInstance());
        urfaGetHousesList.call();
        for (int i = 0; i < urfaGetHousesList.getHousesSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetHousesList.getHouseId1()[i]);
            hashMap.put("ip_zone_id", urfaGetHousesList.getIpZoneId1()[i]);
            hashMap.put("connected_on", new SimpleDateFormat("dd.MM.yyyy").format(new Date((long)urfaGetHousesList.getConnectDate1()[i] * 1000L)));
            hashMap.put("zip_code", urfaGetHousesList.getPostCode1()[i]);
            hashMap.put("country", urfaGetHousesList.getCountry1()[i]);
            hashMap.put("province/state", urfaGetHousesList.getRegion1()[i]);
            hashMap.put("city", urfaGetHousesList.getCity1()[i]);
            hashMap.put("street", urfaGetHousesList.getStreet1()[i]);
            hashMap.put("building_#", urfaGetHousesList.getNumber1()[i]);
            hashMap.put("constr.#", urfaGetHousesList.getBuilding1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new BuildingDialog(map);
    }
}

