/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.messages;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetSentMessagesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.messages.MainInboxMessagesTab;
import biz.netup.utmutils.control.resolvers.Resolve;
import java.awt.Color;
import java.awt.Font;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainOutboxMessagesTab
extends MainInboxMessagesTab {
    public MainOutboxMessagesTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("messages.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("messages_24.png")));
        this.setRefreshPermission(new int[]{20491, 20494, 20493, 20492, 20528, 20529});
    }

    @Override
    public String getTabName() {
        return "Outbox messages";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("status", "Status");
        linkedHashMap.put("check", "Flag");
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("sent", "Sent");
        linkedHashMap.put("receiver_type", "Receiver type");
        linkedHashMap.put("receiver", "Receiver");
        linkedHashMap.put("subject", "Subject");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetSentMessagesList urfaGetSentMessagesList = new UrfaGetSentMessagesList(UrfaManagerImpl.getInstance());
        urfaGetSentMessagesList.setTimeStart(0L);
        urfaGetSentMessagesList.setTimeEnd(new Date().getTime() / 1000L);
        urfaGetSentMessagesList.call();
        for (int i = 0; i < urfaGetSentMessagesList.getMessageSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetSentMessagesList.getId1()[i]);
            hashMap.put("sent", new Date((long)urfaGetSentMessagesList.getSendDate1()[i] * 1000L));
            switch (urfaGetSentMessagesList.getRecieverType1()[i]) {
                case 0: {
                    hashMap.put("receiver_type", this.resource.getString("User"));
                    hashMap.put("receiver", Resolve.getUserName(urfaGetSentMessagesList.getRecieverId1()[i]));
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                    break;
                }
                case 4: {
                    hashMap.put("receiver_type", this.resource.getString("For all"));
                    hashMap.put("receiver", "");
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                    break;
                }
                case 1: {
                    hashMap.put("receiver_type", this.resource.getString("Group"));
                    hashMap.put("receiver", Resolve.getGroupName(urfaGetSentMessagesList.getRecieverId1()[i]));
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                    break;
                }
                case 3: {
                    hashMap.put("receiver_type", this.resource.getString("System group"));
                    hashMap.put("receiver", Resolve.getSystemGroupName(urfaGetSentMessagesList.getRecieverId1()[i]));
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                }
            }
            hashMap.put("subject", urfaGetSentMessagesList.getSubject1()[i]);
            hashMap.put("flag", urfaGetSentMessagesList.getFlag1()[i]);
            if ((urfaGetSentMessagesList.getFlag1()[i] & 1) > 0) {
                hashMap.put("X-ICON", this.states.n);
                Font font = this.getMainTablePanel().getFont().deriveFont(1);
                hashMap.put("X-FONT", font);
                hashMap.put("status", "  ");
            } else if ((urfaGetSentMessagesList.getFlag1()[i] & 4) > 0 && (urfaGetSentMessagesList.getFlag1()[i] & 2) > 0) {
                hashMap.put("X-ICON", this.states.rf);
                hashMap.put("status", " ");
            } else if ((urfaGetSentMessagesList.getFlag1()[i] & 4) > 0) {
                hashMap.put("X-ICON", this.states.f);
                hashMap.put("status", "   ");
            } else if ((urfaGetSentMessagesList.getFlag1()[i] & 2) > 0) {
                hashMap.put("X-ICON", this.states.r);
                hashMap.put("status", "    ");
            }
            hashMap.put("check", (urfaGetSentMessagesList.getFlag1()[i] & 8) > 0 ? 1 : 0);
            if ((urfaGetSentMessagesList.getFlag1()[i] & 8) > 0) {
                hashMap.put("X-FONT-COLOR", new Color(255, 51, 51));
            }
            if ((urfaGetSentMessagesList.getFlag1()[i] & 0x10) != 0) continue;
            vector.add(hashMap);
        }
        return vector;
    }
}

