/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.messages;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetMessagesListNew;
import biz.netup.control.transport.urfa.functions.UrfaGetSentMessagesList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveMessageFlag;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.messages.DeleteButton;
import biz.netup.projects.utmadmin.gui.mainframe.forms.messages.MessagesTemplate;
import biz.netup.utmutils.control.resolvers.Resolve;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainDeletedMessagesTab
extends MessagesTemplate {
    private DeleteButton db;
    Set<Integer> messages = new HashSet<Integer>();

    public MainDeletedMessagesTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("messages.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("messages_24.png")));
        this.setRefreshPermission(new int[]{20491, 20494, 20493, 20492, 20528, 20529});
    }

    @Override
    public String getTabName() {
        return "Deleted messages";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("status", "Status");
        linkedHashMap.put("check", "Flag");
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("type", "Type");
        linkedHashMap.put("sent", "Sent");
        linkedHashMap.put("from", "From");
        linkedHashMap.put("receiver_type", "Receiver type");
        linkedHashMap.put("receiver", "Receiver");
        linkedHashMap.put("subject", "Subject");
        return linkedHashMap;
    }

    @Override
    protected void init() {
        super.init();
        this.db = new DeleteButton();
        this.getAdditionalButtonsPanel().add((Component)this.db.getPanel(), "Center");
        this.getMainTablePanel().registerMultiRowButton(this.db.getUndeleteButton());
        this.db.getUndeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainDeletedMessagesTab.this.delete();
            }
        });
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        HashMap<String, Object> hashMap;
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetMessagesListNew urfaGetMessagesListNew = new UrfaGetMessagesListNew(UrfaManagerImpl.getInstance());
        urfaGetMessagesListNew.setTimeStart(0L);
        urfaGetMessagesListNew.setTimeEnd(new Date().getTime() / 1000L);
        urfaGetMessagesListNew.call();
        for (int i = 0; i < urfaGetMessagesListNew.getMessageSize(); ++i) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("type", this.resource.getString("Inbox message"));
            hashMap.put("id", urfaGetMessagesListNew.getId1()[i]);
            hashMap.put("sent", new Date((long)urfaGetMessagesListNew.getSendDate1()[i] * 1000L));
            hashMap.put("from", Resolve.getUserName(urfaGetMessagesListNew.getSenderId1()[i]));
            hashMap.put("from_int", urfaGetMessagesListNew.getSenderId1()[i]);
            hashMap.put("subject", urfaGetMessagesListNew.getSubject1()[i]);
            hashMap.put("flag", urfaGetMessagesListNew.getFlag1()[i]);
            hashMap.put("forwarded", (urfaGetMessagesListNew.getFlag1()[i] & 4) > 0 ? 1 : 0);
            hashMap.put("replyed", (urfaGetMessagesListNew.getFlag1()[i] & 2) > 0 ? 1 : 0);
            if ((urfaGetMessagesListNew.getFlag1()[i] & 1) > 0) {
                hashMap.put("X-ICON", this.states.n);
                Font font = this.getMainTablePanel().getFont().deriveFont(1);
                hashMap.put("X-FONT", font);
                hashMap.put("status", "  ");
            } else if ((urfaGetMessagesListNew.getFlag1()[i] & 4) > 0 && (urfaGetMessagesListNew.getFlag1()[i] & 2) > 0) {
                hashMap.put("X-ICON", this.states.rf);
                hashMap.put("status", " ");
            } else if ((urfaGetMessagesListNew.getFlag1()[i] & 4) > 0) {
                hashMap.put("X-ICON", this.states.f);
                hashMap.put("status", "   ");
            } else if ((urfaGetMessagesListNew.getFlag1()[i] & 2) > 0) {
                hashMap.put("X-ICON", this.states.r);
                hashMap.put("status", "    ");
            }
            hashMap.put("check", (urfaGetMessagesListNew.getFlag1()[i] & 8) > 0 ? 1 : 0);
            if ((urfaGetMessagesListNew.getFlag1()[i] & 8) > 0) {
                hashMap.put("X-FONT-COLOR", new Color(255, 51, 51));
            }
            if ((urfaGetMessagesListNew.getFlag1()[i] & 0x10) <= 0) continue;
            vector.add(hashMap);
        }
        UrfaGetSentMessagesList urfaGetSentMessagesList = new UrfaGetSentMessagesList(UrfaManagerImpl.getInstance());
        urfaGetSentMessagesList.setTimeStart(0L);
        urfaGetSentMessagesList.setTimeEnd(new Date().getTime() / 1000L);
        urfaGetSentMessagesList.call();
        for (int i = 0; i < urfaGetSentMessagesList.getMessageSize(); ++i) {
            hashMap = new HashMap();
            hashMap.put("type", this.resource.getString("Sent message"));
            hashMap.put("id", urfaGetSentMessagesList.getId1()[i]);
            hashMap.put("sent", new Date((long)urfaGetSentMessagesList.getSendDate1()[i] * 1000L));
            switch (urfaGetSentMessagesList.getRecieverType1()[i]) {
                case 0: {
                    hashMap.put("receiver_type", this.resource.getString("User"));
                    hashMap.put("receiver", Resolve.getUserName(urfaGetSentMessagesList.getRecieverId1()[i]));
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                    break;
                }
                case 4: {
                    hashMap.put("receiver_type", this.resource.getString("For all"));
                    hashMap.put("receiver", "");
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                    break;
                }
                case 1: {
                    hashMap.put("receiver_type", this.resource.getString("Group"));
                    hashMap.put("receiver", Resolve.getGroupName(urfaGetSentMessagesList.getRecieverId1()[i]));
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                    break;
                }
                case 3: {
                    hashMap.put("receiver_type", this.resource.getString("System group"));
                    hashMap.put("receiver", Resolve.getSystemGroupName(urfaGetSentMessagesList.getRecieverId1()[i]));
                    hashMap.put("receiver_id", urfaGetSentMessagesList.getRecieverId1()[i]);
                }
            }
            hashMap.put("subject", urfaGetSentMessagesList.getSubject1()[i]);
            hashMap.put("flag", urfaGetSentMessagesList.getFlag1()[i]);
            if ((urfaGetSentMessagesList.getFlag1()[i] & 1) > 0) {
                hashMap.put("X-ICON", this.states.n);
                Font font = this.getMainTablePanel().getFont().deriveFont(1);
                hashMap.put("X-FONT", font);
                hashMap.put("status", "  ");
            } else if ((urfaGetSentMessagesList.getFlag1()[i] & 4) > 0 && (urfaGetSentMessagesList.getFlag1()[i] & 2) > 0) {
                hashMap.put("X-ICON", this.states.rf);
                hashMap.put("status", " ");
            } else if ((urfaGetSentMessagesList.getFlag1()[i] & 4) > 0) {
                hashMap.put("X-ICON", this.states.f);
                hashMap.put("status", "   ");
            } else if ((urfaGetSentMessagesList.getFlag1()[i] & 2) > 0) {
                hashMap.put("X-ICON", this.states.r);
                hashMap.put("status", "    ");
            }
            hashMap.put("check", (urfaGetSentMessagesList.getFlag1()[i] & 8) > 0 ? 1 : 0);
            if ((urfaGetSentMessagesList.getFlag1()[i] & 8) > 0) {
                hashMap.put("X-FONT-COLOR", new Color(255, 51, 51));
            }
            if ((urfaGetSentMessagesList.getFlag1()[i] & 0x10) <= 0) continue;
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveMessageFlag urfaRemoveMessageFlag = new UrfaRemoveMessageFlag(UrfaManagerImpl.getInstance());
        urfaRemoveMessageFlag.setMessageId((Integer)map.get("id"));
        urfaRemoveMessageFlag.setFlag(16);
        urfaRemoveMessageFlag.call();
    }
}

