/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaCardPoolList;
import biz.netup.control.transport.urfa.functions.UrfaMoveExpiredCards;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc.AddPC;
import biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc.AdditionalButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc.MoreInfoDialog;
import biz.netup.projects.utmadmin.gui.searchframe.SearchCardFrame;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class MainPrepaidCardsTab
extends TabPanelWithTable {
    public MainPrepaidCardsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("cards.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("cards_24.png")));
        this.setRefreshPermission(new int[]{16897});
    }

    @Override
    public String getTabName() {
        return "Card Pools";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "Users and groups";
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("volume", "Cards count");
        linkedHashMap.put("cards_activated", "Cards activated");
        linkedHashMap.put("created", "Created");
        linkedHashMap.put("last_update", "Last update");
        return linkedHashMap;
    }

    @Override
    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Add"));
        JMenuItem jMenuItem2 = new JMenuItem(this.resource.getString("Clear"));
        JMenuItem jMenuItem3 = new JMenuItem(this.resource.getString("More info"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPrepaidCardsTab.this.addCards();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPrepaidCardsTab.this.clear();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPrepaidCardsTab.this.moreInfo();
            }
        });
        if (mapArray.length == 1) {
            return new JMenuItem[]{jMenuItem, jMenuItem3, jMenuItem2};
        }
        return new JMenuItem[0];
    }

    private void addCards() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", this.mainTablePanel.getSelectedTableRows()[0].get("id"));
        new AddPC(hashMap).run(this);
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaCardPoolList urfaCardPoolList = new UrfaCardPoolList(UrfaManagerImpl.getInstance());
        urfaCardPoolList.call();
        for (int i = 0; i < urfaCardPoolList.getInfoSize(); ++i) {
            HashMap<String, Comparable<Integer>> hashMap = new HashMap<String, Comparable<Integer>>();
            hashMap.put("id", Integer.valueOf(urfaCardPoolList.getPoolId1()[i]));
            hashMap.put("volume", Integer.valueOf(urfaCardPoolList.getCards1()[i]));
            hashMap.put("cards_activated", Integer.valueOf(urfaCardPoolList.getCardsUsed1()[i]));
            hashMap.put("created", new Date((long)urfaCardPoolList.getFirstUpdate1()[i] * 1000L));
            hashMap.put("last_update", new Date((long)urfaCardPoolList.getLastUpdate1()[i] * 1000L));
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    protected void init() {
        super.init();
        AdditionalButtons additionalButtons = new AdditionalButtons();
        this.getAdditionalButtonsPanel().add((Component)additionalButtons.getPanel1(), "Center");
        this.getMainTablePanel().registerOneRowButton(additionalButtons.getMoreInfoButton());
        additionalButtons.getSearchButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchCardFrame searchCardFrame = new SearchCardFrame();
                searchCardFrame.setVisible(true);
            }
        });
        additionalButtons.getMoreInfoButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPrepaidCardsTab.this.moreInfo();
            }
        });
        additionalButtons.getClearButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPrepaidCardsTab.this.clear();
            }
        });
        additionalButtons.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPrepaidCardsTab.this.add();
            }
        });
    }

    private void moreInfo() {
        new MoreInfoDialog(this.mainTablePanel.getSelectedTableRows()[0]).run(this);
    }

    private void clear() {
        try {
            UrfaMoveExpiredCards urfaMoveExpiredCards = new UrfaMoveExpiredCards(UrfaManagerImpl.getInstance());
            urfaMoveExpiredCards.call();
            this.refresh();
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot clear", urfaException);
        }
    }

    @Override
    protected void add() {
        new AddPC(null).run(this);
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    protected void doubleClick() {
        new MoreInfoDialog(this.mainTablePanel.getSelectedTableRows()[0]).run(this);
    }
}

