/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.cards.pc;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaCardPoolAdd;
import biz.netup.control.transport.urfa.functions.UrfaGetCurrencyList;
import biz.netup.control.transport.urfa.functions.UrfaGetSetting;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tp.MainTPTab;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class AddPC
extends DialogModel {
    private JPanel panel1;
    private JTextField volumeTextField;
    private JTextField balanceTextField;
    private JComboBox currencyComboBox;
    private JComboBox PINCodeLengthComboBox;
    private JCheckBox randomNumbersRadioButton;
    private JCheckBox uniquePINRadioButton;
    private JSpinner daysSpinner;
    private JTextField tariffIDTextField;
    private JButton selectButton;
    private JDateTime useBeforeDateTime;
    private JTextField IDTextField;
    private Map<Integer, String> currencyMap;

    public AddPC() {
        this.$$$setupUI$$$();
    }

    public AddPC(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.panel1;
    }

    @Override
    public String getItemName() {
        return "Cards pool";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.IDTextField.setText("" + this.item.get("id"));
        }
        this.fillComboBoxes();
        this.selectDefaulCurrency();
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainTPTab());
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    AddPC.this.tariffIDTextField.setText("" + selectFromTableDialogModel.getItem().get("id"));
                }
            }
        });
    }

    private void fillComboBoxes() throws UrfaException {
        UrfaGetCurrencyList urfaGetCurrencyList = new UrfaGetCurrencyList(UrfaManagerImpl.getInstance());
        urfaGetCurrencyList.call();
        this.currencyMap = new HashMap<Integer, String>();
        this.currencyComboBox.removeAllItems();
        for (int i = 0; i < urfaGetCurrencyList.getCurrencySize(); ++i) {
            this.currencyMap.put(urfaGetCurrencyList.getId1()[i], urfaGetCurrencyList.getCurrencyBriefName1()[i]);
            this.currencyComboBox.addItem(urfaGetCurrencyList.getCurrencyBriefName1()[i]);
        }
    }

    private void selectDefaulCurrency() throws UrfaException {
        UrfaGetSetting urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
        urfaGetSetting.setVariable("system_currency");
        urfaGetSetting.call();
        if (urfaGetSetting.getValuesCount() > 0) {
            this.currencyComboBox.setSelectedItem(this.currencyMap.get(Integer.parseInt(urfaGetSetting.getValue()[0])));
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaCardPoolAdd urfaCardPoolAdd = new UrfaCardPoolAdd(UrfaManagerImpl.getInstance());
        urfaCardPoolAdd.setBalance(Double.parseDouble(this.balanceTextField.getText()));
        for (int n : this.currencyMap.keySet()) {
            if (!this.currencyComboBox.getSelectedItem().equals(this.currencyMap.get(n))) continue;
            urfaCardPoolAdd.setCurrency(n);
        }
        urfaCardPoolAdd.setDays((Integer)this.daysSpinner.getValue());
        urfaCardPoolAdd.setExpire((int)(this.useBeforeDateTime.getDate().getTime() / 1000L));
        urfaCardPoolAdd.setPoolId(Integer.parseInt(this.IDTextField.getText()));
        urfaCardPoolAdd.setSize(Integer.parseInt(this.volumeTextField.getText()));
        urfaCardPoolAdd.setServiceId(Integer.parseInt(this.tariffIDTextField.getText()));
        urfaCardPoolAdd.setSecSize(Integer.parseInt("" + this.PINCodeLengthComboBox.getSelectedItem()));
        if (this.randomNumbersRadioButton.isSelected()) {
            urfaCardPoolAdd.setRandom(1);
        } else if (this.uniquePINRadioButton.isSelected()) {
            urfaCardPoolAdd.setRandom(2);
        } else {
            urfaCardPoolAdd.setRandom(0);
        }
        urfaCardPoolAdd.call();
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkDouble(this.balanceTextField, "Balance");
        this.checkInt(this.volumeTextField, "Volume");
        this.checkInt(this.IDTextField, "ID");
    }

    private void createUIComponents() {
        this.useBeforeDateTime = new JDateTime(false);
        this.useBeforeDateTime.setInfinity(false);
        Date date = new Date();
        date.setMonth(date.getMonth() + 6);
        this.useBeforeDateTime.setDate(date);
        this.daysSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Tariff ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Activate before"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Random numbers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("PIN code length"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Currency"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Balance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cards count"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel7, gridBagConstraints);
        this.volumeTextField = new JTextField();
        this.volumeTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.volumeTextField, gridBagConstraints);
        this.balanceTextField = new JTextField();
        this.balanceTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.balanceTextField, gridBagConstraints);
        this.PINCodeLengthComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("8");
        defaultComboBoxModel.addElement("12");
        defaultComboBoxModel.addElement("16");
        this.PINCodeLengthComboBox.setModel(defaultComboBoxModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.PINCodeLengthComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.panel1.add((Component)this.useBeforeDateTime, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Days to use"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.daysSpinner, gridBagConstraints);
        this.tariffIDTextField = new JTextField();
        this.tariffIDTextField.setEditable(false);
        this.tariffIDTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.tariffIDTextField, gridBagConstraints);
        this.selectButton = new JButton();
        this.$$$loadButtonText$$$(this.selectButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.selectButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)jPanel10, gridBagConstraints);
        this.currencyComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.currencyComboBox, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)jLabel9, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        this.IDTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)this.IDTextField, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panel1.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.panel1.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)jPanel13, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Unique PIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel12.add((Component)jLabel10, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel12.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel12.add((Component)jPanel15, gridBagConstraints);
        this.randomNumbersRadioButton = new JCheckBox();
        this.randomNumbersRadioButton.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel12.add((Component)this.randomNumbersRadioButton, gridBagConstraints);
        this.uniquePINRadioButton = new JCheckBox();
        this.uniquePINRadioButton.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel12.add((Component)this.uniquePINRadioButton, gridBagConstraints);
        jLabel.setLabelFor(this.tariffIDTextField);
        jLabel4.setLabelFor(this.PINCodeLengthComboBox);
        jLabel5.setLabelFor(this.currencyComboBox);
        jLabel6.setLabelFor(this.balanceTextField);
        jLabel7.setLabelFor(this.volumeTextField);
        jLabel8.setLabelFor(this.daysSpinner);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

