/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.additional.plugins;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaLiburfaList;
import biz.netup.control.transport.urfa.functions.UrfaLiburfaLoad;
import biz.netup.control.transport.urfa.functions.UrfaLiburfaUnload;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.additional.plugins.LibURFAButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.additional.plugins.LibURFADialog;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class MainLibURFAPluginsTab
extends TabPanelWithTable {
    public MainLibURFAPluginsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/additional/LibURFA_plugins.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/additional/LibURFA_plugins_24.png")));
        this.setRefreshPermission(new int[]{64});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "LibURFA Plugins";
    }

    @Override
    public String getGroupName() {
        return "Additional features";
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("module", "Module");
        linkedHashMap.put("version", "Version");
        linkedHashMap.put("path", "Path");
        return linkedHashMap;
    }

    @Override
    protected void init() {
        super.init();
        LibURFAButtons libURFAButtons = new LibURFAButtons();
        Permissions.apply((JComponent)libURFAButtons.getLoadButton(), "liburfa-load");
        Permissions.apply((JComponent)libURFAButtons.getReloadButton(), "liburfa-reload");
        Permissions.apply((JComponent)libURFAButtons.getUnloadButton(), "liburfa-unload");
        this.getAdditionalButtonsPanel().add((Component)libURFAButtons.getMainPanel(), "Center");
        this.mainTablePanel.registerOneRowButton(libURFAButtons.getReloadButton());
        this.mainTablePanel.registerOneRowButton(libURFAButtons.getUnloadButton());
        libURFAButtons.getLoadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainLibURFAPluginsTab.this.load();
            }
        });
        libURFAButtons.getReloadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainLibURFAPluginsTab.this.reload();
            }
        });
        libURFAButtons.getUnloadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainLibURFAPluginsTab.this.unload();
            }
        });
    }

    private void unload() {
        UrfaLiburfaUnload urfaLiburfaUnload = new UrfaLiburfaUnload(UrfaManagerImpl.getInstance());
        urfaLiburfaUnload.setData((String)this.mainTablePanel.getSelectedTableRows()[0].get("module"));
        try {
            urfaLiburfaUnload.call();
            if (!urfaLiburfaUnload.getError().isEmpty()) {
                throw new UrfaException(urfaLiburfaUnload.getError());
            }
            this.refresh();
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot unload plugin", urfaException);
        }
    }

    private void reload() {
        UrfaLiburfaUnload urfaLiburfaUnload = new UrfaLiburfaUnload(UrfaManagerImpl.getInstance());
        urfaLiburfaUnload.setData((String)this.mainTablePanel.getSelectedTableRows()[0].get("module"));
        try {
            urfaLiburfaUnload.call();
            if (!urfaLiburfaUnload.getError().isEmpty()) {
                throw new UrfaException(urfaLiburfaUnload.getError());
            }
            UrfaLiburfaLoad urfaLiburfaLoad = new UrfaLiburfaLoad(UrfaManagerImpl.getInstance());
            urfaLiburfaLoad.setData((String)this.mainTablePanel.getSelectedTableRows()[0].get("path"));
            try {
                urfaLiburfaLoad.call();
                this.refresh();
            }
            catch (UrfaException urfaException) {
                this.log.error("Cannot load plugin", urfaException);
            }
        }
        catch (UrfaException urfaException) {
            this.log.error("Cannot unload plugin", urfaException);
        }
    }

    private void load() {
        LibURFADialog libURFADialog = new LibURFADialog(null);
        libURFADialog.run(this);
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaLiburfaList urfaLiburfaList = new UrfaLiburfaList(UrfaManagerImpl.getInstance());
        urfaLiburfaList.call();
        for (int i = 0; i < urfaLiburfaList.getSize(); ++i) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("module", urfaLiburfaList.getModule1()[i]);
            hashMap.put("version", urfaLiburfaList.getVersion1()[i]);
            hashMap.put("path", urfaLiburfaList.getPath1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }
}

