/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.subnet;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.iptextfield.IPTextField;
import biz.netup.utmutils.swing.iptextfield.MaskTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SubnetDialog
extends DialogModel {
    private JPanel mPanel;
    private IPTextField networkTextField;
    private IPTextField gatewayTextField;
    private MaskTextField maskTextField;

    public SubnetDialog() {
        this.$$$setupUI$$$();
    }

    public SubnetDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mPanel;
    }

    @Override
    public String getItemName() {
        return "Subnet";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.networkTextField.setText((String)this.item.get("network"));
            this.maskTextField.setText((String)this.item.get("mask"));
            this.gatewayTextField.setText((String)this.item.get("gateway"));
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("network", this.networkTextField.getText());
        hashMap.put("mask", this.maskTextField.getText());
        hashMap.put("gateway", this.gatewayTextField.getText());
        try {
            hashMap.put("network_ip", Resolve.parse_ip(this.networkTextField.getText()));
            hashMap.put("mask_ip", Resolve.parse_mask(this.maskTextField.getText()));
            hashMap.put("gateway_ip", Resolve.parse_ip(this.gatewayTextField.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setItem(hashMap);
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkIP(this.networkTextField, "Network");
        this.checkMask(this.maskTextField, "Mask");
        this.checkIP(this.gatewayTextField, "Gateway");
    }

    private void $$$setupUI$$$() {
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setMinimumSize(new Dimension(240, 90));
        this.mPanel.setPreferredSize(new Dimension(240, 90));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Network"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Gateway"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Mask"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mPanel.add((Component)jPanel, gridBagConstraints);
        this.networkTextField = new IPTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.networkTextField, gridBagConstraints);
        this.gatewayTextField = new IPTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.gatewayTextField, gridBagConstraints);
        this.maskTextField = new MaskTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.maskTextField, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mPanel;
    }
}

