/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.invoice;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaNewInvoice;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.PrintEditDialog;
import biz.netup.swing.table.DoubleCellEditor;
import biz.netup.swing.table.IntegerCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class InvoiceDialog
extends DialogModel {
    private JPanel panel1;
    private JButton removeButton;
    private JButton addButton;
    private TablePanelImpl mainTablePanel;

    public InvoiceDialog() {
        this.$$$setupUI$$$();
    }

    public InvoiceDialog(Map<String, Object> map) {
        super(map);
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void createTable() {
        this.mainTablePanel = new TablePanelImpl(this.getClass().getName() + "_invoice", true);
        MapTableModel mapTableModel = this.mainTablePanel.getTableModel();
        mapTableModel.addColumn("position_name", "Position name", true, true);
        mapTableModel.addColumn("quantity", "Quantity", true, true);
        mapTableModel.addColumn("cost_per_unit", "Cost per unit", true, true);
        mapTableModel.addColumn("cost", "Cost", true, false);
        this.mainTablePanel.setEditable(true);
        this.mainTablePanel.setAppendable(false);
        this.mainTablePanel.applyTableSettings();
        this.mainTablePanel.setCellEditor("quantity", new IntegerCellEditor());
        this.mainTablePanel.setCellEditor("cost_per_unit", new DoubleCellEditor());
        this.mainTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("cost", (Double)map.get("cost_per_unit") * (double)((Integer)map.get("quantity")).intValue());
            }
        });
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.panel1;
    }

    @Override
    public String getItemName() {
        return "Invoice";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("position_name", "---");
                hashMap.put("quantity", 0);
                hashMap.put("cost_per_unit", 0.0);
                hashMap.put("cost", 0.0);
                InvoiceDialog.this.mainTablePanel.getTableModel().addRow(hashMap);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map<String, Object> map : InvoiceDialog.this.mainTablePanel.getSelectedTableRows()) {
                    InvoiceDialog.this.mainTablePanel.getTableModel().removeRow(map);
                }
            }
        });
        this.mainTablePanel.registerMultiRowButton(this.removeButton);
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaNewInvoice urfaNewInvoice = new UrfaNewInvoice(UrfaManagerImpl.getInstance());
        urfaNewInvoice.setAccountId((Integer)this.item.get("aid"));
        urfaNewInvoice.setGenDate((int)(new Date().getTime() / 1000L));
        urfaNewInvoice.setName1(ArrayFromVector.getStringArrayFromData(this.mainTablePanel.getTableModel().data, "position_name"));
        urfaNewInvoice.setBaseCost1(ArrayFromVector.getDoubleArrayFromData(this.mainTablePanel.getTableModel().data, "cost_per_unit"));
        double[] dArray = new double[this.mainTablePanel.getTableModel().data.size()];
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            dArray[i] = ArrayFromVector.getIntArrayFromData(this.mainTablePanel.getTableModel().data, "quantity")[i];
        }
        urfaNewInvoice.setQnt1(dArray);
        urfaNewInvoice.setSumCost1(ArrayFromVector.getDoubleArrayFromData(this.mainTablePanel.getTableModel().data, "cost"));
        urfaNewInvoice.call();
        if (urfaNewInvoice.getId() > 0) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("base_id", urfaNewInvoice.getId());
            hashMap.put("user_id", 0);
            hashMap.put("template_id", 0);
            hashMap.put("doc_type_id", 5);
            new PrintEditDialog(hashMap).run();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkTablePanel(this.mainTablePanel, "Invoice");
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout(0, 0));
        this.panel1.setMinimumSize(new Dimension(270, 300));
        this.panel1.setPreferredSize(new Dimension(270, 300));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.panel1.add((Component)jPanel, "North");
        this.removeButton = new JButton();
        this.$$$loadButtonText$$$(this.removeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        this.panel1.add((Component)this.mainTablePanel, "Center");
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

