/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.adduserframe;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddUserNew;
import biz.netup.control.transport.urfa.functions.UrfaGetSetting;
import biz.netup.control.transport.urfa.functions.UrfaGetUaparamList;
import biz.netup.control.transport.urfa.functions.UrfaSaveAccount;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.adduser.adduser.AddUserFunction;
import biz.netup.projects.utmadmin.functions.objects.UTMUser;
import biz.netup.projects.utmadmin.gui.adduserframe.BottomButtons;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.projects.utmadmin.gui.userframe.UserFrame;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.UserSwithAndPortTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserAdditionalParamsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserContactsTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.user.UserMainParamsTab;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class AddUserFrame
extends TabbedWindow {
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton applyButton;
    private BottomButtons bb;
    private UserMainParamsTab main;
    private UserAdditionalParamsTab additional;
    private UserContactsTab contacts;
    private UserSwithAndPortTab snp;
    private static final Logger logger = Utils.getLogger();

    private void applyUser() {
        if (this.propertiesIsOk()) {
            try {
                int n = this.save();
                if (n == 0) {
                    Dialogs.showErrorDialog("Error creating user: Login duplicated");
                    return;
                }
                UserFrame userFrame = new UserFrame(n);
                MainFrame.getInstance().refreshUsers();
                this.dispose();
                userFrame.setVisible(true);
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(urfaException.getMessage());
            }
        }
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }

    private void initButtons() {
        this.buttonOK = this.bb.getButtonOK();
        this.buttonCancel = this.bb.getButtonCancel();
        this.applyButton = this.bb.getApplyButton();
    }

    private void onOK() {
        if (this.propertiesIsOk()) {
            try {
                if (this.save() == 0) {
                    Dialogs.showErrorDialog("Error creating user: Login duplicated");
                    return;
                }
                this.dispose();
                MainFrame.getInstance().refreshUsers();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(urfaException.getMessage());
            }
        }
    }

    private int save() throws UrfaException {
        if (Utils.isAdmin() && UrfaManagerImpl.getInstance().isPermitted(8485)) {
            UrfaAddUserNew urfaAddUserNew = new UrfaAddUserNew(UrfaManagerImpl.getInstance());
            UTMUser uTMUser = this.getUserData();
            urfaAddUserNew.setLogin(uTMUser.login);
            urfaAddUserNew.setPassword(uTMUser.password);
            urfaAddUserNew.setFullName(uTMUser.fullName);
            urfaAddUserNew.setActAddress(uTMUser.actAddress);
            urfaAddUserNew.setIsJuridical(uTMUser.isJuridical);
            urfaAddUserNew.setJurAddress(uTMUser.jurAddress);
            urfaAddUserNew.setActAddress(uTMUser.actAddress);
            urfaAddUserNew.setFlatNumber(uTMUser.flatNumber);
            urfaAddUserNew.setEntrance(uTMUser.entrance);
            urfaAddUserNew.setFloor(uTMUser.floor);
            urfaAddUserNew.setDistrict(uTMUser.district);
            urfaAddUserNew.setBuilding(uTMUser.building);
            urfaAddUserNew.setPassport(uTMUser.passport);
            urfaAddUserNew.setHouseId(uTMUser.houseId);
            urfaAddUserNew.setWorkTel(uTMUser.workTel);
            urfaAddUserNew.setHomeTel(uTMUser.homeTel);
            urfaAddUserNew.setMobTel(uTMUser.mobTel);
            urfaAddUserNew.setWebPage(uTMUser.webPage);
            urfaAddUserNew.setIcqNumber(uTMUser.icqNumber);
            urfaAddUserNew.setTaxNumber(uTMUser.taxNumber);
            urfaAddUserNew.setKppNumber(uTMUser.kppNumber);
            urfaAddUserNew.setEmail(uTMUser.email);
            urfaAddUserNew.setBankId(uTMUser.bankId);
            urfaAddUserNew.setBankAccount(uTMUser.bankAccount);
            urfaAddUserNew.setComments(uTMUser.comments);
            urfaAddUserNew.setPersonalManager(uTMUser.personalManager);
            urfaAddUserNew.setConnectDate(uTMUser.connectDate);
            urfaAddUserNew.setIsSendInvoice(uTMUser.isSendInvoice);
            urfaAddUserNew.setAdvancePayment(uTMUser.advancePayment);
            urfaAddUserNew.setParametersCount(uTMUser.parametersCount);
            urfaAddUserNew.setParameterId1(uTMUser.parameterId1);
            urfaAddUserNew.setParameterValue1(uTMUser.parameterValue1);
            urfaAddUserNew.setSwitchId(this.snp.getRouterId());
            urfaAddUserNew.setPortNumber(this.snp.getPort());
            urfaAddUserNew.setBindedCurrencyId(this.snp.getCurrencyId());
            urfaAddUserNew.call();
            if (urfaAddUserNew.getBasicAccount() == 0) {
                return 0;
            }
            if (Utils.isAdmin()) {
                UrfaSaveAccount urfaSaveAccount = new UrfaSaveAccount(UrfaManagerImpl.getInstance());
                urfaSaveAccount.setAccountId(urfaAddUserNew.getBasicAccount());
                UrfaGetSetting urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("default_vat_rate");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    try {
                        urfaSaveAccount.setVatRate(Double.parseDouble(urfaGetSetting.getValue()[0]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.log(2, "VAT format is incorrect");
                    }
                }
                urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("block_recalc_abon");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    try {
                        urfaSaveAccount.setBlockRecalcAbon(Integer.parseInt(urfaGetSetting.getValue()[0]) == 1 ? 0 : 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.log(2, "block_recalc_abon format is incorrect");
                        urfaSaveAccount.setBlockRecalcAbon(1);
                    }
                } else {
                    urfaSaveAccount.setBlockRecalcAbon(1);
                }
                urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("block_recalc_prepaid");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    try {
                        urfaSaveAccount.setBlockRecalcPrepaid(Integer.parseInt(urfaGetSetting.getValue()[0]) == 1 ? 0 : 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.log(2, "block_recalc_prepaid format is incorrect");
                        urfaSaveAccount.setBlockRecalcPrepaid(1);
                    }
                } else {
                    urfaSaveAccount.setBlockRecalcPrepaid(1);
                }
                urfaSaveAccount.call();
            }
            return urfaAddUserNew.getUserId();
        }
        int n = AddUserFunction.addUser(this.getUserData());
        if (n != 0) {
            this.snp.setUid(n);
            this.snp.save();
        }
        return n;
    }

    private UTMUser getUserData() {
        UTMUser uTMUser = new UTMUser();
        uTMUser.login = this.main.getLogin();
        uTMUser.password = this.main.getPassword();
        uTMUser.fullName = this.main.getFullName();
        uTMUser.isJuridical = this.contacts.getLegalPersonCheckBox() ? 1 : 0;
        uTMUser.jurAddress = this.contacts.getLegalAddress();
        uTMUser.actAddress = this.contacts.getActualAddress();
        uTMUser.flatNumber = this.contacts.getApartment();
        uTMUser.entrance = this.contacts.getPorch();
        uTMUser.floor = this.contacts.getFloor();
        uTMUser.district = this.contacts.getDistrict();
        uTMUser.building = this.contacts.getBuilding();
        uTMUser.passport = this.additional.getPassport();
        uTMUser.houseId = this.contacts.getBuildingID();
        uTMUser.workTel = this.contacts.getWorkPhone();
        uTMUser.homeTel = this.contacts.getHomePhone();
        uTMUser.mobTel = this.contacts.getMobilePhone();
        uTMUser.webPage = this.contacts.getWebPage();
        uTMUser.icqNumber = this.contacts.getIcqNumber();
        uTMUser.taxNumber = this.additional.getItin();
        uTMUser.kppNumber = this.additional.getRegCode();
        uTMUser.email = this.contacts.getEmail();
        uTMUser.bankId = this.additional.getBankId();
        uTMUser.bankAccount = this.additional.getBankAccount();
        uTMUser.comments = this.additional.getComments();
        uTMUser.personalManager = this.additional.getPersonalManager();
        uTMUser.connectDate = (int)(this.additional.getConnectionDate().getTime() / 1000L);
        uTMUser.isSendInvoice = this.contacts.getSendInvoicesToEmailCheckBox() ? 1 : 0;
        uTMUser.advancePayment = this.main.getPaymentInAdvance() ? 1 : 0;
        uTMUser.parametersCount = this.additional.additionalParameters.getTableModel().getRowCount();
        uTMUser.parameterId1 = ArrayFromVector.getIntArrayFromData(this.additional.additionalParameters.getTableModel().data, "id");
        uTMUser.parameterValue1 = ArrayFromVector.getStringArrayFromData(this.additional.additionalParameters.getTableModel().data, "value");
        return uTMUser;
    }

    private boolean propertiesIsOk() {
        if (!this.loginIsOk()) {
            Dialogs.showErrorDialog("Login is incorrect");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        if (this.main.getPassword().compareTo(this.main.getConfirmPassword()) != 0) {
            Dialogs.showErrorDialog("Password doesn't match");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        return true;
    }

    private boolean loginIsOk() {
        if (this.main.getLogin().length() == 0) {
            return false;
        }
        return Checkers.loginOk(this.main.getLogin());
    }

    private void onCancel() {
        this.dispose();
    }

    @Override
    protected void init() {
        this.iconPanel.setVisible(false);
        this.bb = new BottomButtons();
        this.initButtons();
        this.main = new UserMainParamsTab();
        this.additional = new UserAdditionalParamsTab();
        this.contacts = new UserContactsTab();
        this.snp = new UserSwithAndPortTab(0);
        this.snp.getPanel();
        this.main.createUserModeOn();
        String string = Resolve.getPassword();
        this.main.setPrimaryAccountTextField(string);
        this.main.setPasswordField(string);
        this.main.setConfirmPasswordField(string);
        this.main.disableID();
        this.main.getGenerateDocumentForUserButton().setVisible(false);
        if (Utils.isAdmin() && UrfaManagerImpl.getInstance().isPermitted(8485)) {
            this.additional.getAdditionalParameters().getTableModel().removeAllRows();
            UrfaGetUaparamList urfaGetUaparamList = new UrfaGetUaparamList(UrfaManagerImpl.getInstance());
            try {
                urfaGetUaparamList.call();
                for (int i = 0; i < urfaGetUaparamList.getUparamSize(); ++i) {
                    if (urfaGetUaparamList.getVisible1()[i] != 1) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("id", urfaGetUaparamList.getId1()[i]);
                    hashMap.put("name", urfaGetUaparamList.getDisplayName1()[i]);
                    this.additional.getAdditionalParameters().getTableModel().addRow(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                this.additional.getApPanel().setVisible(false);
            }
        } else {
            this.additional.getApPanel().setVisible(false);
        }
        this.additional.getConnectionDateLabel().setVisible(false);
        this.additional.getConnectionDateDateTime().setVisible(false);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddUserFrame.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddUserFrame.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddUserFrame.this.onCancel();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddUserFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddUserFrame.this.applyUser();
            }
        });
        this.main.getRefreshButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Resolve.getPassword();
                AddUserFrame.this.main.setPrimaryAccountTextField(string);
                AddUserFrame.this.main.setPasswordField(string);
                AddUserFrame.this.main.setConfirmPasswordField(string);
            }
        });
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(950, 600);
    }

    @Override
    protected String getWindowTitle() {
        return "Add user";
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.main);
        vector.add(this.additional);
        vector.add(this.contacts);
        if (Utils.isAdmin()) {
            vector.add(this.snp);
        }
        return vector;
    }
}

