/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.objects.telephonyServ;

import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DlgVoIPpriceListEd
extends JDialog
implements KeyListener {
    private Logger log = Utils.getLogger();
    private JPanel jPanel;
    private JPanel jPanel_up;
    private JPanel jPanel_down;
    private JPanel jPanel_down_up;
    private JPanel jPanel_down_down;
    private JTextField jCost;
    private JPanel jPanel_Buttons;
    private JButton jButton_Ok;
    private JButton jButton_Cancel;
    private static final int width = 500;
    private static final Dimension vskip = new Dimension(250, 10);
    private int res;
    private double cost;
    private TreeMap borders;
    private JTable jTable;
    private TableModel table_model;
    private Vector column_names;
    private JScrollPane jScrollPane;
    private PopupMenu MyMenu;

    public boolean ok() {
        return this.res != 0;
    }

    public double getCost() {
        return this.cost;
    }

    public TreeMap getBorders() {
        return this.borders;
    }

    public DlgVoIPpriceListEd(JDialog jDialog, String string, double d, TreeMap treeMap) {
        super(jDialog, string, true);
        this.setSize(400, 300);
        this.setResizable(false);
        this.borders = treeMap;
        this.cost = d;
        try {
            this.init();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.log(0, "Error edit cost: " + exception.getMessage());
        }
    }

    private void init() throws Exception {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Insets insets = new Insets(1, 10, 10, 10);
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout(5, 5));
        this.jPanel.setBorder(BorderFactory.createTitledBorder(Utils.getResource().getString("Edit cost")));
        this.jPanel_up = new InsetPanel(insets);
        this.jPanel_down = new InsetPanel(insets);
        this.jPanel.add((Component)this.jPanel_up, "North");
        this.jPanel.add((Component)this.jPanel_down, "Center");
        this.jPanel_up.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL("", Box.createRigidArea(vskip), gridBagLayout, gridBagConstraints, this.jPanel_up);
        gridBagConstraints.gridwidth = 1;
        this.jCost = new JTextField("" + this.cost);
        this.jCost.addKeyListener(this);
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL(Utils.getResource().getString("Cost"), this.jCost, gridBagLayout, gridBagConstraints, this.jPanel_up);
        this.column_names = new Vector();
        this.column_names.add(Utils.getResource().getString("Border"));
        this.column_names.add(Utils.getResource().getString("Coefficient"));
        if (this.borders.size() == 0) {
            this.borders.put(new Long(0L), new Double(1.0));
        }
        this.table_model = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return DlgVoIPpriceListEd.this.column_names.size();
            }

            @Override
            public int getRowCount() {
                return DlgVoIPpriceListEd.this.borders.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return DlgVoIPpriceListEd.this.borders.keySet().toArray()[n];
                }
                if (n2 == 1) {
                    return DlgVoIPpriceListEd.this.borders.get(DlgVoIPpriceListEd.this.borders.keySet().toArray()[n]);
                }
                return new String("Unknown");
            }

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return new Long(0L).getClass();
                }
                if (n == 1) {
                    return new Double(0.0).getClass();
                }
                return new String("").getClass();
            }

            @Override
            public String getColumnName(int n) {
                return (String)DlgVoIPpriceListEd.this.column_names.get(n);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                Object object2 = DlgVoIPpriceListEd.this.borders.keySet().toArray()[n];
                Object v = DlgVoIPpriceListEd.this.borders.get(DlgVoIPpriceListEd.this.borders.keySet().toArray()[n]);
                DlgVoIPpriceListEd.this.borders.remove(object2);
                if (n2 == 1) {
                    DlgVoIPpriceListEd.this.borders.put(object2, object);
                } else if (n2 == 0) {
                    DlgVoIPpriceListEd.this.borders.put(object, v);
                }
                DlgVoIPpriceListEd.this.refresh_table();
            }
        };
        gridBagConstraints.gridwidth = 0;
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setPreferredSize(new Dimension(100, 200));
        this.MyMenu = new PopupMenu();
        MenuItem menuItem = new MenuItem(Utils.getResource().getString("Add"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DlgVoIPpriceListEd.this.Button_Add_actionPerformed(actionEvent);
            }
        });
        this.MyMenu.add(menuItem);
        menuItem = new MenuItem(Utils.getResource().getString("Delete"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DlgVoIPpriceListEd.this.Button_Delete_actionPerformed(actionEvent);
            }
        });
        this.MyMenu.add(menuItem);
        this.refresh_table();
        this.addLabeledComponentToGBL(Utils.getResource().getString("Borders"), this.jScrollPane, gridBagLayout, gridBagConstraints, this.jPanel_up);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add((Component)this.jPanel, "North");
        this.getContentPane().add(Box.createRigidArea(new Dimension(1, 5)));
        this.jPanel_Buttons = new JPanel();
        this.jPanel_Buttons.setLayout(new BoxLayout(this.jPanel_Buttons, 0));
        this.jButton_Ok = new JButton(Utils.getResource().getString("OK"));
        this.jButton_Cancel = new JButton(Utils.getResource().getString("Cancel"));
        this.jPanel_Buttons.add(this.jButton_Ok);
        this.jPanel_Buttons.add(this.jButton_Cancel);
        this.getContentPane().add(this.jPanel_Buttons);
        this.getContentPane().add(Box.createRigidArea(new Dimension(1, 5)));
        this.jButton_Ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DlgVoIPpriceListEd.this.jButton_Ok_actionPerformed();
            }
        });
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DlgVoIPpriceListEd.this.jButton_Cancel_actionPerformed();
            }
        });
        this.res = 0;
    }

    private void refresh_table() {
        if (this.jTable != null) {
            this.jScrollPane.getViewport().remove(this.jTable);
        }
        this.jTable = new JTable(this.table_model);
        this.jTable.add(this.MyMenu);
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DlgVoIPpriceListEd.this.t_mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DlgVoIPpriceListEd.this.t_mouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DlgVoIPpriceListEd.this.t_mouseDoubleClick(mouseEvent);
            }
        });
        this.jTable.setSelectionMode(0);
        this.jScrollPane.getViewport().add(this.jTable);
    }

    private void t_mousePressed(MouseEvent mouseEvent) {
        int n = this.jTable.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        this.jTable.setRowSelectionInterval(n, n);
    }

    private void t_mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.MyMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void t_mouseDoubleClick(MouseEvent mouseEvent) {
    }

    private void Button_Add_actionPerformed(ActionEvent actionEvent) {
        this.borders.put(new Long((Long)this.borders.lastKey() + 1L), new Double(1.0));
        this.refresh_table();
    }

    private void Button_Delete_actionPerformed(ActionEvent actionEvent) {
        int n = this.jTable.getSelectedRow();
        Object object = this.borders.keySet().toArray()[n];
        this.borders.remove(object);
        this.refresh_table();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.jButton_Ok_actionPerformed();
        } else if (n == 27) {
            this.jButton_Cancel_actionPerformed();
        }
    }

    private void jButton_Ok_actionPerformed() {
        if (this.jCost.getText().length() == 0) {
            this.log.log(2, "Cost is empty");
            this.jCost.requestFocus();
            return;
        }
        try {
            this.cost = Double.parseDouble(this.jCost.getText());
            if (this.cost < 0.0) {
                throw new Exception("Cost is negative");
            }
        }
        catch (Exception exception) {
            this.log.log(1, "Error cost formt: " + exception.getMessage());
            return;
        }
        this.res = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton_Cancel_actionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void addLabeledComponentToGBL(String string, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container) {
        JLabel jLabel = new JLabel(string);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        if (component == null) {
            component = new JLabel("");
        }
        gridBagLayout.setConstraints(jLabel, gridBagConstraints2);
        container.add(jLabel);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    class InsetPanel
    extends JPanel {
        Insets i;

        InsetPanel(Insets insets) {
            this.i = insets;
        }

        @Override
        public Insets getInsets() {
            return this.i;
        }
    }
}

