/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.dealer.user.tarification.accounts;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddAccount;
import biz.netup.control.transport.urfa.functions.UrfaDealerAddAccount;
import biz.netup.control.transport.urfa.functions.UrfaDealerDeleteAccount;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetAccountInfo;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetUserAccountList;
import biz.netup.control.transport.urfa.functions.UrfaDealerSaveAccount;
import biz.netup.control.transport.urfa.functions.UrfaGetAccountinfo;
import biz.netup.control.transport.urfa.functions.UrfaGetUserAccountList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveAccount;
import biz.netup.control.transport.urfa.functions.UrfaSaveAccount;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.Account;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AccountFunctions {
    public static int addAccount(int n) throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaAddAccount urfaAddAccount = new UrfaAddAccount(UrfaManagerImpl.getInstance());
            urfaAddAccount.setUserId(n);
            urfaAddAccount.setIsBasic(0);
            urfaAddAccount.call();
            if (urfaAddAccount.getAccountId() != 0) {
                return urfaAddAccount.getAccountId();
            }
            JOptionPane.showMessageDialog(null, "Error creating account", "Error", 0);
        } else {
            UrfaDealerAddAccount urfaDealerAddAccount = new UrfaDealerAddAccount(UrfaManagerImpl.getInstance());
            urfaDealerAddAccount.setUserId(n);
            urfaDealerAddAccount.setIsBasic(0);
            urfaDealerAddAccount.call();
            if (urfaDealerAddAccount.getAccountId() != 0) {
                return urfaDealerAddAccount.getAccountId();
            }
            JOptionPane.showMessageDialog(null, "Error creating account", "Error", 0);
        }
        return 0;
    }

    public static void deleteAccount(int n) {
        if (Utils.isAdmin()) {
            UrfaRemoveAccount urfaRemoveAccount = new UrfaRemoveAccount(UrfaManagerImpl.getInstance());
            urfaRemoveAccount.setAccountId(n);
            try {
                urfaRemoveAccount.call();
            }
            catch (UrfaException urfaException) {
                JOptionPane.showMessageDialog(null, "Error deleting account AID = " + n + ": \n" + urfaException.getMessage(), "Error", 0);
            }
        } else {
            UrfaDealerDeleteAccount urfaDealerDeleteAccount = new UrfaDealerDeleteAccount(UrfaManagerImpl.getInstance());
            urfaDealerDeleteAccount.setAccountId(n);
            try {
                urfaDealerDeleteAccount.call();
            }
            catch (UrfaException urfaException) {
                JOptionPane.showMessageDialog(null, "Error deleting account AID = " + n + ": \n" + urfaException.getMessage(), "Error", 0);
            }
        }
    }

    public static void editAccount(Account account) throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaSaveAccount urfaSaveAccount = new UrfaSaveAccount(UrfaManagerImpl.getInstance());
            urfaSaveAccount.setAccountId(account.getAccountId());
            urfaSaveAccount.setBlockEndDate(account.getEndDate());
            urfaSaveAccount.setBlockStartDate(account.getStartDate());
            urfaSaveAccount.setBlockRecalcAbon(account.getBlockRecalcAbon());
            urfaSaveAccount.setBlockRecalcPrepaid(account.getBlockRecalcPrepaid());
            urfaSaveAccount.setCredit(account.getCredit());
            urfaSaveAccount.setIntStatus(account.getIntStatus());
            urfaSaveAccount.setIsBlocked(account.getBlocked());
            urfaSaveAccount.setSaleTaxRate(account.getSaleTaxRate());
            urfaSaveAccount.setUnlimited(account.getUnlimited());
            urfaSaveAccount.setVatRate(account.getVatRate());
            urfaSaveAccount.call();
        } else {
            UrfaDealerSaveAccount urfaDealerSaveAccount = new UrfaDealerSaveAccount(UrfaManagerImpl.getInstance());
            urfaDealerSaveAccount.setAccountId(account.getAccountId());
            urfaDealerSaveAccount.setBlockEndDate(account.getEndDate());
            urfaDealerSaveAccount.setBlockStartDate(account.getStartDate());
            urfaDealerSaveAccount.setBlockRecalcAbon(account.getBlockRecalcAbon());
            urfaDealerSaveAccount.setBlockRecalcPrepaid(account.getBlockRecalcPrepaid());
            urfaDealerSaveAccount.setCredit(account.getCredit());
            urfaDealerSaveAccount.setIntStatus(account.getIntStatus());
            urfaDealerSaveAccount.setIsBlocked(account.getBlocked());
            urfaDealerSaveAccount.setSaleTaxRate(account.getSaleTaxRate());
            urfaDealerSaveAccount.setUnlimited(account.getUnlimited());
            urfaDealerSaveAccount.setVatRate(account.getVatRate());
            urfaDealerSaveAccount.call();
        }
    }

    public static Account getAccount(int n) throws UrfaException {
        Account account = new Account();
        if (Utils.isAdmin()) {
            UrfaGetAccountinfo urfaGetAccountinfo = new UrfaGetAccountinfo(UrfaManagerImpl.getInstance());
            urfaGetAccountinfo.setAccountId(n);
            urfaGetAccountinfo.call();
            account.accountId = n;
            account.balance = urfaGetAccountinfo.getBalance();
            account.blockRecalcAbon = urfaGetAccountinfo.getBlockRecalcAbon();
            account.blockRecalcPrepaid = urfaGetAccountinfo.getBlockRecalcPrepaid();
            account.credit = urfaGetAccountinfo.getCredit();
            account.intStatus = urfaGetAccountinfo.getIntStatus();
            account.isBlocked = urfaGetAccountinfo.getIsBlocked();
            account.saleTaxRate = urfaGetAccountinfo.getSaleTaxRate();
            account.unlimited = urfaGetAccountinfo.getUnlimited();
            account.vatRate = urfaGetAccountinfo.getVatRate();
        } else {
            UrfaDealerGetAccountInfo urfaDealerGetAccountInfo = new UrfaDealerGetAccountInfo(UrfaManagerImpl.getInstance());
            urfaDealerGetAccountInfo.setAccountId(n);
            urfaDealerGetAccountInfo.call();
            account.accountId = urfaDealerGetAccountInfo.getAccountId();
            account.balance = urfaDealerGetAccountInfo.getBalance();
            account.blockRecalcAbon = urfaDealerGetAccountInfo.getBlockRecalcAbon();
            account.blockRecalcPrepaid = urfaDealerGetAccountInfo.getBlockRecalcPrepaid();
            account.credit = urfaDealerGetAccountInfo.getCredit();
            account.intStatus = urfaDealerGetAccountInfo.getIntStatus();
            account.isBlocked = urfaDealerGetAccountInfo.getIsBlocked();
            account.saleTaxRate = urfaDealerGetAccountInfo.getSaleTaxRate();
            account.unlimited = urfaDealerGetAccountInfo.getUnlimited();
            account.vatRate = urfaDealerGetAccountInfo.getVatRate();
        }
        return account;
    }

    public static Vector<Map<String, Object>> getAccountsDetailed(int n) {
        Vector<Map<String, Object>> vector;
        if (Utils.isAdmin()) {
            vector = new Vector<Map<String, Object>>();
            try {
                int[] nArray;
                for (int n2 : nArray = AccountFunctions.getAccounts(n)) {
                    UrfaGetAccountinfo urfaGetAccountinfo = new UrfaGetAccountinfo(UrfaManagerImpl.getInstance());
                    urfaGetAccountinfo.setAccountId(n2);
                    urfaGetAccountinfo.call();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("aid", n2);
                    hashMap.put("id", n2);
                    hashMap.put("uid", n);
                    hashMap.put("block_id", Resolve.getBlockTypeName(urfaGetAccountinfo.getIsBlocked()));
                    hashMap.put("internet_status", urfaGetAccountinfo.getIntStatus() == 1);
                    hashMap.put("vat_rate", urfaGetAccountinfo.getVatRate());
                    hashMap.put("credit", urfaGetAccountinfo.getCredit());
                    hashMap.put("sale_tax_rate", urfaGetAccountinfo.getSaleTaxRate());
                    hashMap.put("ballance", urfaGetAccountinfo.getBalance());
                    hashMap.put("is_prepaid", urfaGetAccountinfo.getBlockRecalcPrepaid() == 0);
                    hashMap.put("is_recalculate", urfaGetAccountinfo.getBlockRecalcAbon() == 0);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                JOptionPane.showMessageDialog(null, "Error getting accounts list: \n" + urfaException.getMessage(), "Error", 0);
            }
        } else {
            vector = new Vector();
            try {
                int[] nArray;
                for (int n3 : nArray = AccountFunctions.getAccounts(n)) {
                    UrfaDealerGetAccountInfo urfaDealerGetAccountInfo = new UrfaDealerGetAccountInfo(UrfaManagerImpl.getInstance());
                    urfaDealerGetAccountInfo.setAccountId(n3);
                    urfaDealerGetAccountInfo.call();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("aid", urfaDealerGetAccountInfo.getAccountId());
                    hashMap.put("id", urfaDealerGetAccountInfo.getAccountId());
                    hashMap.put("uid", n);
                    hashMap.put("block_id", Resolve.getBlockTypeName(urfaDealerGetAccountInfo.getIsBlocked()));
                    hashMap.put("internet_status", urfaDealerGetAccountInfo.getIntStatus() == 1);
                    hashMap.put("vat_rate", urfaDealerGetAccountInfo.getVatRate());
                    hashMap.put("credit", urfaDealerGetAccountInfo.getCredit());
                    hashMap.put("sale_tax_rate", urfaDealerGetAccountInfo.getSaleTaxRate());
                    hashMap.put("ballance", urfaDealerGetAccountInfo.getBalance());
                    hashMap.put("is_prepaid", urfaDealerGetAccountInfo.getBlockRecalcPrepaid() == 0 ? 1 : 0);
                    hashMap.put("is_recalculate", urfaDealerGetAccountInfo.getBlockRecalcAbon() == 0 ? 1 : 0);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                JOptionPane.showMessageDialog(null, "Error getting accounts list: \n" + urfaException.getMessage(), "Error", 0);
            }
        }
        return vector;
    }

    public static int[] getAccounts(int n) throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaGetUserAccountList urfaGetUserAccountList = new UrfaGetUserAccountList(UrfaManagerImpl.getInstance());
            urfaGetUserAccountList.setUserId(n);
            urfaGetUserAccountList.call();
            return urfaGetUserAccountList.getAccount1();
        }
        UrfaDealerGetUserAccountList urfaDealerGetUserAccountList = new UrfaDealerGetUserAccountList(UrfaManagerImpl.getInstance());
        urfaDealerGetUserAccountList.setUserId(n);
        urfaDealerGetUserAccountList.call();
        return urfaDealerGetUserAccountList.getAccount1();
    }
}

