/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.dealer.custom;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetFreeIpsForHouse;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetHousesList;
import biz.netup.control.transport.urfa.functions.UrfaGetFreeIpsForHouse;
import biz.netup.control.transport.urfa.functions.UrfaGetHouse;
import biz.netup.control.transport.urfa.functions.UrfaGetHousesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class HouseFunctions {
    public static Vector<Map<String, Object>> getHousesList() {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        if (Utils.isAdmin()) {
            UrfaGetHousesList urfaGetHousesList = new UrfaGetHousesList(UrfaManagerImpl.getInstance());
            try {
                urfaGetHousesList.call();
                for (int i = 0; i < urfaGetHousesList.getHousesSize(); ++i) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("id", urfaGetHousesList.getHouseId1()[i]);
                    hashMap.put("ip_zone_id", urfaGetHousesList.getIpZoneId1()[i]);
                    hashMap.put("connected_on", new Date((long)urfaGetHousesList.getConnectDate1()[i] * 1000L));
                    hashMap.put("zip", urfaGetHousesList.getPostCode1()[i]);
                    hashMap.put("country", urfaGetHousesList.getCountry1()[i]);
                    hashMap.put("state", urfaGetHousesList.getRegion1()[i]);
                    hashMap.put("city", urfaGetHousesList.getCity1()[i]);
                    hashMap.put("street", urfaGetHousesList.getStreet1()[i]);
                    hashMap.put("building_n", urfaGetHousesList.getNumber1()[i]);
                    hashMap.put("constr_n", urfaGetHousesList.getBuilding1()[i]);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
            return vector;
        }
        UrfaDealerGetHousesList urfaDealerGetHousesList = new UrfaDealerGetHousesList(UrfaManagerImpl.getInstance());
        try {
            urfaDealerGetHousesList.call();
            for (int i = 0; i < urfaDealerGetHousesList.getHousesSize(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", urfaDealerGetHousesList.getHouseId1()[i]);
                hashMap.put("ip_zone_id", urfaDealerGetHousesList.getIpZoneId1()[i]);
                hashMap.put("connected_on", new Date((long)urfaDealerGetHousesList.getConnectDate1()[i] * 1000L));
                hashMap.put("zip", urfaDealerGetHousesList.getPostCode1()[i]);
                hashMap.put("country", urfaDealerGetHousesList.getCountry1()[i]);
                hashMap.put("state", urfaDealerGetHousesList.getRegion1()[i]);
                hashMap.put("city", urfaDealerGetHousesList.getCity1()[i]);
                hashMap.put("street", urfaDealerGetHousesList.getStreet1()[i]);
                hashMap.put("building_n", urfaDealerGetHousesList.getNumber1()[i]);
                hashMap.put("constr_n", urfaDealerGetHousesList.getBuilding1()[i]);
                vector.add(hashMap);
            }
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        return vector;
    }

    public static String getHouseName(int n) {
        if (Utils.isAdmin()) {
            UrfaGetHouse urfaGetHouse = new UrfaGetHouse(UrfaManagerImpl.getInstance());
            urfaGetHouse.setHouseId(n);
            try {
                urfaGetHouse.call();
                String string = "";
                string = string + (urfaGetHouse.getPostCode().isEmpty() ? "" : urfaGetHouse.getPostCode() + ", ");
                string = string + (urfaGetHouse.getCountry().isEmpty() ? "" : urfaGetHouse.getCountry() + ", ");
                string = string + (urfaGetHouse.getRegion().isEmpty() ? "" : urfaGetHouse.getRegion() + ", ");
                string = string + (urfaGetHouse.getCity().isEmpty() ? "" : urfaGetHouse.getCity() + ", ");
                string = string + (urfaGetHouse.getStreet().isEmpty() ? "" : urfaGetHouse.getStreet() + ", ");
                string = string + (urfaGetHouse.getNumber().isEmpty() ? "" : urfaGetHouse.getNumber() + ", ");
                string = string + urfaGetHouse.getBuilding();
                if (string.endsWith(", ")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        } else {
            for (Map<String, Object> map : HouseFunctions.getHousesList()) {
                if ((Integer)map.get("id") != n) continue;
                String string = "";
                string = string + (((String)map.get("zip")).isEmpty() ? "" : (String)map.get("zip") + ", ");
                string = string + (((String)map.get("country")).isEmpty() ? "" : (String)map.get("country") + ", ");
                string = string + (((String)map.get("state")).isEmpty() ? "" : (String)map.get("state") + ", ");
                string = string + (((String)map.get("city")).isEmpty() ? "" : (String)map.get("city") + ", ");
                string = string + (((String)map.get("street")).isEmpty() ? "" : (String)map.get("street") + ", ");
                string = string + (((String)map.get("building_n")).isEmpty() ? "" : (String)map.get("building_n") + ", ");
                if ((string = string + (String)map.get("constr_n")).endsWith(", ")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
        }
        return "";
    }

    public static Vector<Map<String, Object>> getFreeIps(int n) {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        if (Utils.isAdmin()) {
            UrfaGetFreeIpsForHouse urfaGetFreeIpsForHouse = new UrfaGetFreeIpsForHouse(UrfaManagerImpl.getInstance());
            urfaGetFreeIpsForHouse.setHouseId(n);
            try {
                urfaGetFreeIpsForHouse.call();
                for (int i = 0; i < urfaGetFreeIpsForHouse.getIpsSize(); ++i) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("ip", urfaGetFreeIpsForHouse.getIpsIp1()[i]);
                    hashMap.put("zone", urfaGetFreeIpsForHouse.getZoneName1()[i]);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        } else {
            UrfaDealerGetFreeIpsForHouse urfaDealerGetFreeIpsForHouse = new UrfaDealerGetFreeIpsForHouse(UrfaManagerImpl.getInstance());
            urfaDealerGetFreeIpsForHouse.setHouseId(n);
            try {
                urfaDealerGetFreeIpsForHouse.call();
                for (int i = 0; i < urfaDealerGetFreeIpsForHouse.getIpsSize(); ++i) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("ip", urfaDealerGetFreeIpsForHouse.getIpsIp1()[i]);
                    hashMap.put("zone", urfaDealerGetFreeIpsForHouse.getZoneName1()[i]);
                    vector.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        }
        return vector;
    }
}

