/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class XmlInputStream
extends FilterInputStream {
    protected boolean valid = true;
    protected boolean eos = false;
    private static final Logger LOG = Logger.getLogger(XmlInputStream.class);

    public XmlInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        int n;
        if (!this.valid || this.eos) {
            return -1;
        }
        int n2 = n = super.read();
        if (n == -1) {
            LOG.info("invalidating input stream");
            this.valid = false;
            n2 = -1;
        }
        if (n == 0) {
            LOG.debug("sending end of stream");
            this.eos = true;
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        LOG.debug("read(buf, " + n + ", " + n2 + ")");
        if (!this.valid || this.eos) {
            return -1;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.read();
            if (n4 == -1) {
                LOG.debug("end of stream detected");
                break;
            }
            byArray[n + n3] = (byte)n4;
        }
        LOG.debug("bulk read returns " + n3);
        return n3;
    }

    public boolean valid() {
        return this.valid;
    }

    public void resetEos() {
        this.eos = false;
    }
}

