/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.event.Event;
import biz.netup.control.event.Header;
import biz.netup.control.event.Transaction;
import biz.netup.control.xml.parser.impl.EventsParser;
import biz.netup.control.xml.parser.impl.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransactionParser_v2
extends Parser {
    protected Transaction transaction = null;
    protected Header header = null;
    protected Vector<Event> events = null;
    private XMLReader xmlReader = null;
    private static final Logger LOG = Logger.getLogger(TransactionParser_v2.class);

    public TransactionParser_v2() throws SAXException {
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            LOG.error("cannot create a SAX2 XML reader", sAXException);
            throw sAXException;
        }
        this.xmlReader.setContentHandler(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (LOG.isDebugEnabled()) {
            String string4 = "";
            if (string != null && string.length() > 0) {
                string4 = string + ":";
            }
            string4 = string4 + string2;
            LOG.debug("startElement: " + string4);
        }
        if (!this.inside) {
            throw new IllegalStateException();
        }
        if (this.transaction == null) {
            if (!"http://www.netup.ru/transaction/2.0".equals(string) || !"transaction".equals(string2)) throw new SAXException("UnexpectedElement " + string + ":" + string2);
            this.transaction = new Transaction();
            this.events = new Vector();
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.transaction.setHeader(attributes.getQName(i), attributes.getValue(i));
            }
            return;
        } else {
            if (this.getNestedLevel() == 0) {
                if ("route".equals(string2)) {
                    this.setNested(new RouteParser());
                } else {
                    if (!"events".equals(string2)) throw new SAXException("UnexpectedElement " + string + ":" + string2);
                    this.setNested(new EventsParser());
                }
                this.forwardStartDocument();
            }
            this.forwardStartElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        if (LOG.isDebugEnabled()) {
            object = "";
            if (string != null && string.length() > 0) {
                object = string + ":";
            }
            object = (String)object + string2;
            LOG.debug("endElement: " + (String)object);
        }
        if (!this.inside) {
            throw new IllegalStateException();
        }
        if (this.getNestedLevel() > 0) {
            this.forwardEndElement(string, string2, string3);
        }
        if (this.getNestedLevel() == 0) {
            if (this.getNested() instanceof EventsParser) {
                this.forwardEndDocument();
                object = (EventsParser)this.getNested();
                for (Event event : ((EventsParser)object).getEvents()) {
                    this.transaction.addEvent(event);
                }
            }
            this.setNested(null);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        boolean bl = this.isWhitespace(cArray, n, n2);
        if (LOG.isDebugEnabled()) {
            String string = this.getThumbnail(cArray, n, n2, bl);
            LOG.debug("characters: " + string);
        }
        if (!this.inside) {
            throw new IllegalStateException();
        }
        if (this.getNestedLevel() == 0) {
            if (!bl) {
                LOG.error("the parser cannot accept character data at this moment");
                throw new SAXException("IllegalContent");
            }
        } else {
            this.forwardCharacters(cArray, n, n2);
        }
    }

    public Transaction getTransaction(InputStream inputStream) throws IOException, SAXException {
        InputSource inputSource = new InputSource(inputStream);
        this.xmlReader.parse(inputSource);
        return this.transaction;
    }

    private static class RouteParser
    extends Parser {
        private RouteParser() {
        }
    }
}

