/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.event.Transaction;
import biz.netup.control.handler.TransactionListenerException;
import biz.netup.control.xml.parser.AbstractXMLParser;
import biz.netup.control.xml.parser.XMLParserException;
import biz.netup.control.xml.parser.impl.TransactionParser_v2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AnotherTransactionStreamParser_v2
extends AbstractXMLParser {
    private static final Logger LOGGER = Logger.getLogger(AnotherTransactionStreamParser_v2.class);
    private static int bufferLength = 65536;
    private byte[] arrayBytes = new byte[bufferLength];
    private Vector<byte[]> bytes = new Vector();
    private boolean eos;
    private String log_name = "";
    private FileOutputStream log_file = null;

    private void writeLog(byte by) {
        try {
            if (null == this.log_file) {
                this.log_name = "transaction_log/" + new Date().getTime() + ".xml";
                this.log_file = new FileOutputStream(this.log_name);
            }
            if (null == this.log_file) {
                return;
            }
            if (0 == by) {
                this.log_file.close();
                this.log_file = null;
                return;
            }
            this.log_file.write(by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void parse(InputStream inputStream) throws IOException {
        LOGGER.debug("Start buffer filling");
        while (!this.eos) {
            int n = inputStream.read(this.arrayBytes);
            LOGGER.debug("Read = " + n);
            if (n < 0) {
                this.eos = true;
                if (this.bytes.size() > 0) {
                    LOGGER.warn("End of stream, parse");
                    this.callParser();
                } else {
                    LOGGER.debug("End of stream");
                }
                return;
            }
            this.fillBuffer(0, n);
        }
    }

    private void fillBuffer(int n, int n2) throws IOException {
        boolean bl = LOGGER.isDebugEnabled() && new File("transaction_log").canWrite();
        for (int i = n; i < n + n2; ++i) {
            if (bl) {
                this.writeLog(this.arrayBytes[i]);
            }
            if (this.arrayBytes[i] != 0) continue;
            LOGGER.debug("Zero found, parse");
            byte[] byArray = new byte[i - n];
            System.arraycopy(this.arrayBytes, n, byArray, 0, i - n);
            this.bytes.add(byArray);
            this.callParser();
            LOGGER.debug("Save tail (len = " + (n + n2 - i - 1) + ")");
            this.fillBuffer(i + 1, n + n2 - i - 1);
            return;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.arrayBytes, n, byArray, 0, n2);
        this.bytes.add(byArray);
    }

    private void callParser() throws IOException {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.bytes.size(); ++i) {
            n += this.bytes.get(i).length;
        }
        LOGGER.debug("Parse (length = " + n + ")");
        byte[] byArray = new byte[n];
        for (int i = 0; i < this.bytes.size(); ++i) {
            System.arraycopy(this.bytes.get(i), 0, byArray, n2, this.bytes.get(i).length);
            n2 += this.bytes.get(i).length;
        }
        this.parseBytes(new ByteArrayInputStream(byArray));
        this.bytes.clear();
    }

    private void parseBytes(ByteArrayInputStream byteArrayInputStream) throws IOException {
        TransactionParser_v2 transactionParser_v2;
        try {
            transactionParser_v2 = new TransactionParser_v2();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        try {
            Transaction transaction = transactionParser_v2.getTransaction(byteArrayInputStream);
            if (transaction.getTransactionSize() == 0) {
                this.fireException(new XMLParserException("Transaction is empty"));
            } else if (this.transactionListener != null) {
                try {
                    this.transactionListener.onTransaction(transaction);
                    LOGGER.debug("Transaction was sent");
                }
                catch (TransactionListenerException transactionListenerException) {
                    this.fireException(new XMLParserException(transactionListenerException));
                }
            }
        }
        catch (SAXException sAXException) {
            this.fireException(new XMLParserException(sAXException));
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.fireException(new XMLParserException(uTFDataFormatException));
        }
    }

    private void fireException(XMLParserException xMLParserException) {
        if (null != this.exceptionListener) {
            this.exceptionListener.onException(xMLParserException);
        } else {
            if (xMLParserException.getCause() instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)xMLParserException.getCause();
                Logger.getLogger(AnotherTransactionStreamParser_v2.class).error("Can't parse transaction " + this.log_name + " (line:" + sAXParseException.getLineNumber() + ", column:" + sAXParseException.getColumnNumber(), xMLParserException.getCause());
            }
            Logger.getLogger(AnotherTransactionStreamParser_v2.class).error("Can't parse transaction" + this.log_name, xMLParserException);
        }
    }

    @Override
    protected AbstractXMLParser newXMLParser() {
        return new AnotherTransactionStreamParser_v2();
    }
}

