/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaInvocationException;
import biz.netup.control.transport.urfa.UrfaManagerException;
import biz.netup.control.transport.urfa.impl.Attribute;
import biz.netup.control.transport.urfa.impl.ConnectionImpl;
import biz.netup.control.transport.urfa.impl.Packet;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.logindialog.DialogSplash;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

class UrfaInvocationImpl
implements UrfaInvocation {
    private int function;
    private int state;
    private boolean working;
    private UrfaManagerImpl manager;
    private ConnectionImpl connection;
    private Packet outgoing;
    private Iterator attr;
    private static final Logger logger = Logger.getLogger(UrfaInvocationImpl.class);
    private ResourceBundleWrapper resource = Utils.getResource();
    private int packetSize = 0;
    private boolean started = false;

    public UrfaInvocationImpl(ConnectionImpl connectionImpl, int n, UrfaManagerImpl urfaManagerImpl) {
        if (connectionImpl == null) {
            logger.error("UrfaInvocationImpl: null argument");
            throw new IllegalArgumentException();
        }
        this.function = n;
        this.connection = connectionImpl;
        this.manager = urfaManagerImpl;
        this.working = false;
        logger.info("Setting state to NOT_INVOKED");
        this.state = 0;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void invoke() throws UrfaInvocationException {
        DialogSplash.setStatus(this.resource.getString("Calling core function 0x") + Integer.toHexString(this.function));
        this.start();
        this.send();
        this.endOutput();
    }

    @Override
    public void close() throws UrfaInvocationException {
        Object object;
        if (this.state == 2) {
            logger.error("close: illegal state exception");
            throw new UrfaInvocationException("The state is already CLOSED");
        }
        logger.debug("invoke[" + this.function + "] : finishing");
        while (this.attr != null && this.attr.hasNext()) {
            object = (Attribute)this.attr.next();
            if (((Attribute)object).getType() != 4) continue;
            this.attr = null;
            this.offWorking();
        }
        while (this.working) {
            this.nextAttribute();
        }
        if (this.working) {
            try {
                object = this.connection.newPacket(200);
                Attribute attribute = this.connection.newAttribute(4);
                ((Packet)object).putAttribute(attribute);
                this.connection.sendPacket((Packet)object);
            }
            catch (UrfaException urfaException) {
                try {
                    this.connection.close();
                }
                catch (UrfaException urfaException2) {
                    logger.error("can't close connection", urfaException2);
                }
                if (this.manager.connectionResetListener != null) {
                    this.manager.connectionResetListener.onConnectionReset(null);
                }
                logger.error("close: sending of termination packet failed");
                throw new UrfaInvocationException("sending of termination packet failed", urfaException);
            }
        }
        try {
            this.manager.freeConnection(this.connection);
        }
        catch (UrfaManagerException urfaManagerException) {
            logger.error("freeInvocation failed" + urfaManagerException.getMessage());
            throw new UrfaInvocationException("freeInvocation failed", urfaManagerException);
        }
        this.connection = null;
        this.manager = null;
        logger.info("Switching state to CLOSED");
        this.state = 2;
        Utils.getLogger().log(10, "URFA call finished");
    }

    private void offWorking() {
        this.working = false;
        logger.info("invoke[" + this.function + "] : switching off working mode");
    }

    private Attribute nextAttribute() throws UrfaInvocationException {
        if (!this.working) {
            logger.error("nextAttribute: illegal state exception");
            throw new IllegalStateException();
        }
        if (this.attr == null || !this.attr.hasNext()) {
            try {
                Packet packet = this.connection.receivePacket();
                if (packet.getHeader().getCode() != 200) {
                    this.offWorking();
                }
                if (packet.hasAttribute(4)) {
                    this.offWorking();
                }
                this.attr = packet.hasAttribute(5) ? packet.getAttributes(5).iterator() : null;
            }
            catch (UrfaException urfaException) {
                logger.error("nextAttribute: failed");
                throw new UrfaInvocationException("nextAttribute failed", urfaException);
            }
        }
        return this.attr == null ? null : (Attribute)this.attr.next();
    }

    private void putAttribute(Attribute attribute) throws UrfaInvocationException {
        this.start();
        if (this.packetSize + attribute.header.getPacketSize() > 8000) {
            this.send();
            this.packetSize = 0;
        }
        this.packetSize += attribute.header.getPacketSize();
        try {
            if (this.outgoing == null) {
                this.outgoing = this.connection.newPacket(200);
            }
            this.outgoing.putAttribute(attribute);
        }
        catch (UrfaException urfaException) {
            logger.error("putAttribute: failed");
            throw new UrfaInvocationException("putAttribute failed", urfaException);
        }
    }

    @Override
    public int getInt() throws UrfaInvocationException {
        int n;
        if (!this.working) {
            logger.error("getInt: state not INVOKED");
            throw new UrfaInvocationException("Not invoked");
        }
        Attribute attribute = this.nextAttribute();
        try {
            n = attribute != null ? attribute.getInt() : 0;
        }
        catch (UrfaException urfaException) {
            logger.error("getInt failed");
            throw new UrfaInvocationException("getInt failed", urfaException);
        }
        return n;
    }

    @Override
    public void putInt(int n) throws UrfaInvocationException {
        Attribute attribute;
        if (this.state != 0) {
            logger.error("putInt: state not NOT_INVOKED");
            throw new UrfaInvocationException("Illegal invocation state");
        }
        try {
            attribute = this.connection.newAttribute(5);
            attribute.putInt(n);
        }
        catch (UrfaException urfaException) {
            logger.error("putInt: failed");
            throw new UrfaInvocationException("putInt failed", urfaException);
        }
        this.putAttribute(attribute);
    }

    @Override
    public long getLong() throws UrfaInvocationException {
        long l;
        if (!this.working) {
            logger.error("getLong: state not INVOKED");
            throw new UrfaInvocationException("Not invoked");
        }
        Attribute attribute = this.nextAttribute();
        try {
            l = attribute != null ? attribute.getLong() : 0L;
        }
        catch (UrfaException urfaException) {
            logger.error("getLong: failed");
            throw new UrfaInvocationException("getLong failed", urfaException);
        }
        return l;
    }

    @Override
    public void putLong(long l) throws UrfaInvocationException {
        Attribute attribute;
        if (this.state != 0) {
            logger.error("putLong: state not NOT_INVOKED");
            throw new UrfaInvocationException("Illegal invocation state");
        }
        try {
            attribute = this.connection.newAttribute(5);
            attribute.putLong(l);
        }
        catch (UrfaException urfaException) {
            logger.error("putLong: failed");
            throw new UrfaInvocationException("PutLongException", urfaException);
        }
        this.putAttribute(attribute);
    }

    @Override
    public boolean getBoolean() throws UrfaInvocationException {
        boolean bl;
        if (!this.working) {
            logger.error("getBoolean: state not INVOKED");
            throw new UrfaInvocationException("State not INVOKED");
        }
        Attribute attribute = this.nextAttribute();
        try {
            bl = attribute != null && attribute.getInt() != 0;
        }
        catch (UrfaException urfaException) {
            logger.error("getBoolean: failed");
            throw new UrfaInvocationException("getBoolean failed", urfaException);
        }
        return bl;
    }

    @Override
    public void putBoolean(boolean bl) throws UrfaInvocationException {
        Attribute attribute;
        if (this.state != 0) {
            logger.error("putBoolean: state not NOT_INVOKED");
            throw new UrfaInvocationException("Illegal invocation state");
        }
        try {
            attribute = this.connection.newAttribute(5);
            attribute.putInt(bl ? 1 : 0);
        }
        catch (UrfaException urfaException) {
            logger.error("putBoolean: failed");
            throw new UrfaInvocationException("putBoolean failed", urfaException);
        }
        this.putAttribute(attribute);
    }

    @Override
    public double getDouble() throws UrfaInvocationException {
        double d;
        if (!this.working) {
            logger.error("getDouble: state not INVOKED");
            throw new UrfaInvocationException("Not invoked ");
        }
        Attribute attribute = this.nextAttribute();
        try {
            d = attribute != null ? attribute.getDouble() : 0.0;
        }
        catch (UrfaException urfaException) {
            logger.error("getDouble: failed");
            throw new UrfaInvocationException("getDouble failed", urfaException);
        }
        return d;
    }

    @Override
    public void putDouble(double d) throws UrfaInvocationException {
        Attribute attribute;
        if (this.state != 0) {
            logger.error("putDouble: state not NOT_INVOKED");
            throw new UrfaInvocationException("Illegal invocation state");
        }
        try {
            attribute = this.connection.newAttribute(5);
            attribute.putDouble(d);
        }
        catch (UrfaException urfaException) {
            logger.error("putDoube: failed");
            throw new UrfaInvocationException("putDouble failed", urfaException);
        }
        this.putAttribute(attribute);
    }

    @Override
    public String getString() throws UrfaInvocationException {
        String string;
        if (!this.working) {
            logger.error("getString: state is not INVOKED");
            throw new UrfaInvocationException("Not invoked");
        }
        Attribute attribute = this.nextAttribute();
        try {
            string = attribute != null ? attribute.getString() : null;
        }
        catch (UrfaException urfaException) {
            logger.error("getString: failed");
            throw new UrfaInvocationException("getString failed", urfaException);
        }
        return string;
    }

    @Override
    public String getText() throws UrfaInvocationException {
        Object object;
        if (!this.working) {
            logger.error("getText: state is not INVOKED");
            throw new UrfaInvocationException("Not invoked");
        }
        int n = this.getInt();
        byte[] byArray = new byte[n * 8192];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            object = this.nextAttribute();
            n2 = ((Attribute)object).value.array().length;
            for (int j = 0; j < ((Attribute)object).value.array().length; ++j) {
                byArray[i * 8192 + j] = ((Attribute)object).value.array()[j];
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((n - 1) * 8192 + n2);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(byArray, 0, (n - 1) * 8192 + n2);
        byteBuffer.rewind();
        object = Charset.forName("UTF8").decode(byteBuffer).toString();
        return object;
    }

    @Override
    public void putString(String string) throws UrfaInvocationException {
        Attribute attribute;
        if (string == null) {
            throw new UrfaInvocationException("String is null");
        }
        if (this.state != 0) {
            logger.error("putString: state not NOT_INVOKED");
            throw new UrfaInvocationException("Illegal invocation state");
        }
        try {
            attribute = this.connection.newAttribute(5);
            attribute.putString(string);
        }
        catch (UrfaException urfaException) {
            logger.error("putString: failed");
            throw new UrfaInvocationException("putString failed", urfaException);
        }
        this.putAttribute(attribute);
    }

    @Override
    public Date getDate() throws UrfaInvocationException {
        int n = this.getInt();
        return new Date((long)n * 1000L);
    }

    @Override
    public void putDate(Date date) throws UrfaInvocationException {
        if (date == null) {
            this.putInt(0);
        } else {
            this.putInt((int)(date.getTime() / 1000L));
        }
    }

    @Override
    public Inet4Address getIp4() throws UrfaInvocationException {
        byte[] byArray;
        if (!this.working) {
            logger.error("getIp4: state is not INVOKED");
            throw new UrfaInvocationException("State is not INVOKED");
        }
        Attribute attribute = this.nextAttribute();
        if (attribute == null) {
            return null;
        }
        try {
            byArray = attribute.getByteArray();
        }
        catch (UrfaException urfaException) {
            logger.error("getIp4: failed");
            throw new UrfaInvocationException("getIp4 failed", urfaException);
        }
        try {
            return (Inet4Address)Inet4Address.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            logger.warn("getIp4: unknown host");
            return null;
        }
    }

    @Override
    public void putIp4(Inet4Address inet4Address) throws UrfaInvocationException {
        Attribute attribute;
        if (this.state != 0) {
            logger.error("putIp4: state not NOT_INVOKED");
            throw new UrfaInvocationException("Illegal invocation state");
        }
        try {
            attribute = this.connection.newAttribute(5);
            attribute.putByteArray(inet4Address.getAddress());
        }
        catch (UrfaException urfaException) {
            logger.error("putIp4: failed");
            throw new UrfaInvocationException("putIp4 failed", urfaException);
        }
        this.putAttribute(attribute);
    }

    @Override
    public void send() throws UrfaInvocationException {
        try {
            if (this.outgoing != null && this.outgoing.hasAttribute(5)) {
                this.connection.sendPacket(this.outgoing);
                this.outgoing = null;
            }
        }
        catch (UrfaException urfaException) {
            try {
                this.connection.close();
            }
            catch (UrfaException urfaException2) {
                logger.error("can't close connection", urfaException2);
            }
            if (this.manager.connectionResetListener != null) {
                this.manager.connectionResetListener.onConnectionReset(null);
            }
            logger.error("invoke[" + this.function + "]: sending attributes failed");
            throw new UrfaInvocationException("Sending attributes failed", urfaException);
        }
    }

    @Override
    public void start() throws UrfaInvocationException {
        if (!this.started) {
            Packet packet;
            Utils.getLogger().log(10, Permissions.isInitialized() ? "URFA call: " + Permissions.getInstance().getName(this.function) + " (0x" + Integer.toHexString(this.function) + ")" : "URFA call: 0x" + Integer.toHexString(this.function));
            if (this.state != 0) {
                logger.error("invoke: already invoked");
                throw new UrfaInvocationException("The state is not NOT_INVOKED");
            }
            logger.debug("invoke[" + this.function + "]: sending invoke packet");
            try {
                Packet packet2 = this.connection.newPacket(201);
                Attribute attribute = this.connection.newAttribute(3);
                attribute.putInt(this.function);
                packet2.putAttribute(attribute);
                this.connection.sendPacket(packet2);
            }
            catch (UrfaException urfaException) {
                try {
                    this.connection.close();
                }
                catch (UrfaException urfaException2) {
                    logger.error("can't close connection", urfaException2);
                }
                if (this.manager.connectionResetListener != null) {
                    this.manager.connectionResetListener.onConnectionReset(null);
                }
                logger.error("invoke[" + this.function + "]: error sending invoke packet");
                throw new UrfaInvocationException("Error sending invoke packet", urfaException);
            }
            logger.debug("invoke[" + this.function + "]: receiving invoke reply");
            try {
                packet = this.connection.receivePacket();
            }
            catch (UrfaException urfaException) {
                try {
                    this.connection.close();
                }
                catch (UrfaException urfaException3) {
                    logger.error("can't close connection", urfaException3);
                }
                if (this.manager.connectionResetListener != null) {
                    this.manager.connectionResetListener.onConnectionReset(null);
                }
                logger.error("invoke: coudn't receive invoke reply: " + urfaException.getMessage());
                throw new UrfaInvocationException(urfaException.getMessage(), urfaException);
            }
            try {
                if (packet.getHeader().getCode() != 200 || !packet.hasAttribute(3)) {
                    logger.error("invoke[" + this.function + "] failed: code = " + packet.getHeader().getCode() + ", has invoke attribute = " + packet.hasAttribute(3));
                    throw new UrfaInvocationException("BeginCallFailedException");
                }
            }
            catch (UrfaInvocationException urfaInvocationException) {
                logger.error("invoke: invocation failed");
                throw new UrfaInvocationException("Invoke failed", urfaInvocationException);
            }
            try {
                this.attr = packet.hasAttribute(5) ? packet.getAttributes(5).iterator() : null;
            }
            catch (UrfaException urfaException) {
                logger.error("invoke[" + this.function + "]: getAttributes exception");
                throw new UrfaInvocationException("getAttributes exception");
            }
            this.started = true;
        }
    }

    @Override
    public void endOutput() {
        logger.debug("invoke[" + this.function + "] : switching to working mode");
        this.working = true;
        logger.info("Switching state to INVOKED");
        this.state = 1;
    }
}

