/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.Attribute;
import biz.netup.control.transport.urfa.impl.Header;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class Packet {
    public static final int VERSION = 35;
    public static final String UNSUPPORTED_VERSION_EXCEPTION = "UnsupportedProtocolVersionException";
    private Header header;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    Packet(Header header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        this.header = header;
    }

    Packet(int n, int n2) throws UrfaException {
        if (n2 != 35) {
            throw new UrfaException(UNSUPPORTED_VERSION_EXCEPTION);
        }
        this.header = new Header();
        this.header.setCode(n);
        this.header.setVersion(n2);
    }

    public Header getHeader() {
        return this.header;
    }

    public int getHeaderSize() {
        return this.header.getHeaderSize();
    }

    public int getPacketSize() {
        return this.header.getPacketSize();
    }

    public boolean hasAttribute(int n) {
        for (Attribute attribute : this.attributes) {
            if (attribute.getType() != n) continue;
            return true;
        }
        return false;
    }

    public Collection<Attribute> getAttributes(int n) throws UrfaException {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Attribute attribute : this.attributes) {
            if (attribute.getType() != n) continue;
            arrayList.add(attribute);
        }
        if (arrayList.size() == 0) {
            throw new UrfaException("AttributeMissingException");
        }
        return arrayList;
    }

    public Attribute getAttribute(int n) throws UrfaException {
        return this.getAttribute(n, 0);
    }

    public Attribute getAttribute(int n, int n2) throws UrfaException {
        int n3 = 0;
        for (Attribute attribute : this.attributes) {
            if (attribute.getType() != n) continue;
            if (n3 == n2) {
                return attribute;
            }
            ++n3;
        }
        throw new UrfaException("AttributeMissingException");
    }

    public void putAttribute(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException();
        }
        this.attributes.add(attribute);
    }

    public void assemble() {
        int n = 0;
        for (Attribute attribute : this.attributes) {
            n += attribute.getHeader().getHeaderSize();
            n += attribute.getHeader().getPacketSize();
        }
        this.header.setPacketSize(n);
    }

    void parse(ByteBuffer byteBuffer) throws UrfaException {
        if (byteBuffer == null) {
            throw new IllegalArgumentException();
        }
        this.attributes.clear();
        while (byteBuffer.remaining() > 0) {
            Header header = new Header();
            header.parse(byteBuffer);
            Attribute attribute = new Attribute(header);
            attribute.parse(byteBuffer);
            this.attributes.add(attribute);
        }
    }

    void unparse(ByteBuffer byteBuffer) throws UrfaException {
        if (byteBuffer == null) {
            throw new IllegalArgumentException();
        }
        this.assemble();
        this.header.unparse(byteBuffer);
        for (Attribute attribute : this.attributes) {
            attribute.unparse(byteBuffer);
        }
    }

    public static Packet read(InputStream inputStream) throws IOException, UrfaException {
        Packet packet = null;
        Header header = new Header();
        ByteBuffer byteBuffer = Packet.read(inputStream, header.getHeaderSize());
        header.parse(byteBuffer);
        if (header.getVersion() == 35) {
            packet = new Packet(header);
            byteBuffer = Packet.read(inputStream, packet.getPacketSize());
            packet.parse(byteBuffer);
        }
        if (packet == null) {
            throw new UrfaException(UNSUPPORTED_VERSION_EXCEPTION);
        }
        return packet;
    }

    public static void write(OutputStream outputStream, Packet packet) throws UrfaException, IOException {
        packet.assemble();
        byte[] byArray = new byte[packet.getPacketSize() + packet.getHeaderSize()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        packet.unparse(byteBuffer);
        outputStream.write(byArray);
    }

    private static ByteBuffer read(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            throw new IOException("End of stream occured");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }
}

