/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.urfa.UrfaException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.apache.log4j.Logger;

class Header {
    public static final int CODE_SESSION_INIT = 192;
    public static final int CODE_ACCESS_REQUEST = 193;
    public static final int CODE_ACCESS_ACCEPT = 194;
    public static final int CODE_ACCESS_REJECT = 195;
    public static final int CODE_SESSION_DATA = 200;
    public static final int CODE_SESSION_CALL = 201;
    public static final int CODE_SESSION_TERM = 203;
    private int code;
    private int version;
    private int size = 4;
    private static boolean debug = false;
    private static final Logger LOG = Logger.getLogger(Header.class);

    Header() {
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getHeaderSize() {
        return 4;
    }

    public int getPacketSize() {
        return this.size - 4;
    }

    public void setPacketSize(int n) {
        this.size = n + 4;
    }

    public void parse(ByteBuffer byteBuffer) throws UrfaException {
        try {
            this.code = byteBuffer.get();
            if (this.code < 0) {
                this.code &= 0xFF;
            }
            this.version = byteBuffer.get();
            if (this.version < 0) {
                this.version &= 0xFF;
            }
            this.size = byteBuffer.getShort();
            if (this.size < 0) {
                this.size &= 0xFFFF;
            }
            if (debug) {
                LOG.debug("read: code = " + this.code + "[" + this.codeString() + "], version = " + this.version + ", size = " + this.size);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("ReadHeaderException", bufferUnderflowException);
        }
    }

    public void unparse(ByteBuffer byteBuffer) throws UrfaException {
        try {
            if (debug) {
                LOG.debug("write: code = " + this.code + "[" + this.codeString() + "], version = " + this.version + ", size = " + this.size);
            }
            byteBuffer.put((byte)this.code);
            byteBuffer.put((byte)this.version);
            byteBuffer.putShort((short)this.size);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("WriteHeaderException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("WriteHeaderException", readOnlyBufferException);
        }
    }

    private String codeString() {
        String[] stringArray = new String[]{"", "LOGIN_TYPE", "LOGIN", "CALL", "TERMINATION", "DATA", "KEY", "", "CHAP_CHALLENGE", "CHAP_RESPONSE", "SSL_REQUEST"};
        String[] stringArray2 = new String[]{"SESSION_INIT", "ACCESS_REQUEST", "ACCESS_ACCEPT", "ACCESS_REJECT", "", "", "", "", "SESSION_DATA", "SESSION_CALL", "", "SESSION_TERM"};
        if (this.code < 192) {
            return stringArray[this.code];
        }
        return stringArray2[this.code - 192];
    }
}

