/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.transport.ssl.SSLManagerException;
import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.Attribute;
import biz.netup.control.transport.urfa.impl.Packet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import org.apache.log4j.Logger;

public class ConnectionImpl {
    private SSLManager sslManager;
    private Socket socket;
    private InetAddress addr;
    private int port;
    private String login;
    private String password;
    private int protocolVersion;
    private static final int ENCRYPTION_NONE = 0;
    private static final int ENCRYPTION_SSL3_CERT = 3;
    private static final int ENCRYPTION_SSL3 = 2;

    public ConnectionImpl(SSLManager sSLManager) {
        this.sslManager = sSLManager;
    }

    public synchronized void reopen() throws UrfaException {
        this.open(this.addr, this.port, this.login, this.password);
    }

    public synchronized void open(InetAddress inetAddress, int n, String string, String string2) throws UrfaException {
        Socket socket;
        block22: {
            if (this.socket != null) {
                throw new IllegalStateException("Connection already opened");
            }
            this.addr = inetAddress;
            this.port = n;
            this.login = string;
            this.password = string2;
            try {
                socket = SocketFactory.getDefault().createSocket(inetAddress, n);
            }
            catch (IOException iOException) {
                throw new UrfaException(iOException.getMessage());
            }
            try {
                Packet packet;
                try {
                    packet = Packet.read(socket.getInputStream());
                }
                catch (IOException iOException) {
                    throw new UrfaException(iOException.getMessage());
                }
                this.protocolVersion = packet.getHeader().getVersion();
                if (packet.getHeader().getCode() != 192) {
                    throw new UrfaException("Invalid initial handshake packet");
                }
                Attribute attribute = null;
                try {
                    attribute = packet.getAttribute(8);
                }
                catch (UrfaException urfaException) {
                    try {
                        attribute = packet.getAttribute(6);
                    }
                    catch (UrfaException urfaException2) {
                        // empty catch block
                    }
                }
                if (attribute == null) {
                    throw new UrfaException("Invalid initial handshake packet");
                }
                Packet packet2 = this.createAccessRequest(string, string2, attribute.getByteArray());
                try {
                    Packet.write(socket.getOutputStream(), packet2);
                }
                catch (IOException iOException) {
                    throw new UrfaException(iOException.getMessage());
                }
                Packet packet3 = null;
                try {
                    packet3 = Packet.read(socket.getInputStream());
                }
                catch (IOException iOException) {
                    throw new UrfaException(iOException.getMessage());
                }
                if (packet3.getHeader().getCode() == 194) {
                    if (this.sslManager != null) {
                        socket = this.encryptionHandshake(socket, packet3, inetAddress, n);
                    }
                    break block22;
                }
                if (packet3.getHeader().getCode() == 195) {
                    throw new UrfaException("Access rejected");
                }
                throw new UrfaException("Invalid access reply exception");
            }
            catch (UrfaException urfaException) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw urfaException;
            }
        }
        this.socket = socket;
    }

    private Socket encryptionHandshake(Socket socket, Packet packet, InetAddress inetAddress, int n) throws UrfaException {
        int n2 = 0;
        try {
            Attribute attribute = packet.getAttribute(10);
            n2 = attribute.getInt();
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
        if (n2 != 2) {
            throw new UrfaException("Unsupported encryption method offered by server");
        }
        try {
            return this.sslManager.setSSL(socket);
        }
        catch (SSLManagerException sSLManagerException) {
            throw new UrfaException(sSLManagerException.getMessage(), sSLManagerException);
        }
    }

    public boolean validateConnection() throws UrfaException {
        if (this.socket == null) {
            throw new IllegalStateException("Connection is not open");
        }
        return this.socket.isConnected();
    }

    public void close() throws UrfaException {
        Logger logger = Logger.getLogger(ConnectionImpl.class);
        if (!this.validateConnection()) {
            logger.error("Connection already closed");
        }
        if (this.socket == null) {
            throw new IllegalStateException("Connection is not open");
        }
        Packet packet = new Packet(203, this.protocolVersion);
        try {
            this.sendPacket(packet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.closeSocket();
        this.socket = null;
    }

    private synchronized void closeSocket() {
        Logger logger = Logger.getLogger(ConnectionImpl.class);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            logger.warn(iOException);
        }
    }

    public boolean isClosed() {
        return this.socket == null || !this.socket.isConnected();
    }

    public Packet receivePacket() throws UrfaException {
        if (this.socket == null) {
            throw new IllegalStateException("Connection is not open");
        }
        Packet packet = null;
        try {
            packet = Packet.read(this.socket.getInputStream());
        }
        catch (IOException iOException) {
            throw new UrfaException(iOException.getMessage());
        }
        return packet;
    }

    public void sendPacket(Packet packet) throws UrfaException {
        try {
            Packet.write(this.socket.getOutputStream(), packet);
        }
        catch (IOException iOException) {
            throw new UrfaException(iOException.getMessage());
        }
    }

    public Packet newPacket(int n) throws UrfaException {
        return new Packet(n, this.protocolVersion);
    }

    public Attribute newAttribute(int n) throws UrfaException {
        return new Attribute(n, this.protocolVersion);
    }

    private Packet createAccessRequest(String string, String string2, byte[] byArray) throws UrfaException {
        Packet packet = new Packet(193, this.protocolVersion);
        Attribute attribute = this.newAttribute(2);
        attribute.putByteArray(string.getBytes());
        packet.putAttribute(attribute);
        attribute = this.newAttribute(9);
        attribute.putByteArray(this.chapResponse(string2, byArray));
        packet.putAttribute(attribute);
        attribute = this.newAttribute(8);
        attribute.putByteArray(byArray);
        packet.putAttribute(attribute);
        attribute = this.newAttribute(1);
        attribute.putInt(2);
        packet.putAttribute(attribute);
        attribute = this.newAttribute(10);
        if (this.sslManager == null) {
            attribute.putInt(0);
        } else {
            attribute.putInt(2);
        }
        packet.putAttribute(attribute);
        return packet;
    }

    private byte[] chapResponse(String string, byte[] byArray) throws UrfaException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UrfaException("MD5 is not supported", noSuchAlgorithmException);
        }
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update(string.getBytes());
        byte[] byArray2 = messageDigest.digest();
        messageDigest.reset();
        return byArray2;
    }

    boolean isAlive() {
        int n = 1;
        boolean bl = true;
        try {
            Packet packet = this.newPacket(201);
            Attribute attribute = this.newAttribute(3);
            attribute.putInt(n);
            packet.putAttribute(attribute);
            this.sendPacket(packet);
        }
        catch (UrfaException urfaException) {
            bl = false;
        }
        try {
            Packet packet = this.receivePacket();
        }
        catch (UrfaException urfaException) {
            bl = false;
        }
        return bl;
    }
}

