/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaSaveAccount {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inAccountId;
    private int inDiscountPeriodId = 0;
    private double inCredit;
    private int inIsBlocked;
    private int inBlockStartDate = (int)(System.currentTimeMillis() / 1000L);
    private int inBlockEndDate = 2000000000;
    private int inDealerAccountId;
    private double inVatRate;
    private double inSaleTaxRate;
    private int inIntStatus;
    private int inBlockRecalcAbon;
    private int inBlockRecalcPrepaid;
    private int inUnlimited;

    public UrfaSaveAccount(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(8242);
        try {
            urfaInvocation.putInt(this.inAccountId);
            urfaInvocation.putInt(this.inDiscountPeriodId);
            urfaInvocation.putDouble(this.inCredit);
            urfaInvocation.putInt(this.inIsBlocked);
            if (this.inIsBlocked != 0) {
                urfaInvocation.putInt(this.inBlockStartDate);
                urfaInvocation.putInt(this.inBlockEndDate);
            }
            urfaInvocation.putInt(this.inDealerAccountId);
            urfaInvocation.putDouble(this.inVatRate);
            urfaInvocation.putDouble(this.inSaleTaxRate);
            urfaInvocation.putInt(this.inIntStatus);
            urfaInvocation.putInt(this.inBlockRecalcAbon);
            urfaInvocation.putInt(this.inBlockRecalcPrepaid);
            urfaInvocation.putInt(this.inUnlimited);
            urfaInvocation.invoke();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setAccountId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inAccountId = n;
    }

    public void setDiscountPeriodId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDiscountPeriodId = n;
    }

    public void setCredit(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inCredit = d;
    }

    public void setIsBlocked(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIsBlocked = n;
    }

    public void setBlockStartDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockStartDate = n;
    }

    public void setBlockEndDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockEndDate = n;
    }

    public void setDealerAccountId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDealerAccountId = n;
    }

    public void setVatRate(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inVatRate = d;
    }

    public void setSaleTaxRate(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSaleTaxRate = d;
    }

    public void setIntStatus(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIntStatus = n;
    }

    public void setBlockRecalcAbon(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockRecalcAbon = n;
    }

    public void setBlockRecalcPrepaid(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockRecalcPrepaid = n;
    }

    public void setUnlimited(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inUnlimited = n;
    }
}

