/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import biz.netup.control.transport.urfa.functions.UrfaPushToReport;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class UrfaDealerTrafficReport
extends UrfaPushToReport {
    private boolean invoked = false;
    private int inType;
    private int inUserId = 0;
    private int inAccountId = 0;
    private int inGroupId = 0;
    private int inApid = 0;
    private int inTimeStart;
    private int inTimeEnd = (int)(System.currentTimeMillis() / 1000L);
    private double outBytesInKbyte;
    private int outUsersCount;
    private int outAtrSize;
    private int[] outAtrSizeArray1;
    private int[][] outAccountId2;
    private String[][] outLogin2;
    private int[][] outDiscountDate2;
    private int[][] outIpAddress2;
    private int[][] outTclass2;
    private double[][] outBaseCost2;
    private long[][] outBytes2;
    private double[][] outDiscount2;
    private int did;

    public UrfaDealerTrafficReport(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public UrfaDealerTrafficReport(UrfaManager urfaManager, ReportTab reportTab) {
        super(urfaManager, reportTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.did == 0 ? this.manager.startInvocation(1879048250) : this.manager.startInvocation(77860);
        try {
            if (this.did != 0) {
                urfaInvocation.putInt(this.did);
            }
            urfaInvocation.putInt(this.inType);
            urfaInvocation.putInt(this.inUserId);
            urfaInvocation.putInt(this.inAccountId);
            urfaInvocation.putInt(this.inGroupId);
            urfaInvocation.putInt(this.inApid);
            urfaInvocation.putInt(this.inTimeStart);
            urfaInvocation.putInt(this.inTimeEnd);
            urfaInvocation.invoke();
            this.outBytesInKbyte = urfaInvocation.getDouble();
            this.outUsersCount = urfaInvocation.getInt();
            for (int i = 0; i < this.outUsersCount; ++i) {
                this.outAtrSize = urfaInvocation.getInt();
                for (int j = 0; j < this.outAtrSize; ++j) {
                    int n = urfaInvocation.getInt();
                    String string = urfaInvocation.getString();
                    int n2 = 0;
                    if (this.inType != 0 && this.inType != 5) {
                        n2 = urfaInvocation.getInt();
                    }
                    int n3 = urfaInvocation.getInt();
                    double d = urfaInvocation.getDouble();
                    long l = urfaInvocation.getLong();
                    double d2 = urfaInvocation.getDouble();
                    this.row = new HashMap();
                    this.row.put("id", n);
                    this.row.put("login", string);
                    this.row.put("tclass", Resolve.getTCname(n3));
                    this.row.put("bytes", l);
                    this.row.put("mbytes", (double)l / (this.getBytesInKbyte() * this.getBytesInKbyte()));
                    this.row.put("base_cost", d);
                    this.row.put("discount", d2);
                    switch (this.inType) {
                        case 1: 
                        case 2: 
                        case 3: {
                            this.row.put("date", new SimpleDateFormat().format(new Date((long)n2 * 1000L)));
                            break;
                        }
                        case 4: {
                            this.row.put("ip", Resolve.ip_toString(n2));
                        }
                    }
                    if (this.addToReport(this.row)) continue;
                    return;
                }
            }
        }
        finally {
            if (!this.exit) {
                urfaInvocation.close();
            }
        }
    }

    public void setType(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inType = n;
    }

    public void setUserId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inUserId = n;
    }

    public void setAccountId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inAccountId = n;
    }

    public void setGroupId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inGroupId = n;
    }

    public void setApid(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inApid = n;
    }

    public void setTimeStart(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inTimeStart = n;
    }

    public void setTimeEnd(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inTimeEnd = n;
    }

    public double getBytesInKbyte() {
        if (this.invoked) {
            return this.outBytesInKbyte;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getUsersCount() {
        if (this.invoked) {
            return this.outUsersCount;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getAtrSize() {
        if (this.invoked) {
            return this.outAtrSize;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int[] getAtrSizeArray1() {
        if (this.invoked) {
            return this.outAtrSizeArray1;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int[][] getAccountId2() {
        if (this.invoked) {
            return this.outAccountId2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String[][] getLogin2() {
        if (this.invoked) {
            return this.outLogin2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int[][] getDiscountDate2() {
        if (this.invoked) {
            return this.outDiscountDate2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int[][] getIpAddress2() {
        if (this.invoked) {
            return this.outIpAddress2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int[][] getTclass2() {
        if (this.invoked) {
            return this.outTclass2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double[][] getBaseCost2() {
        if (this.invoked) {
            return this.outBaseCost2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public long[][] getBytes2() {
        if (this.invoked) {
            return this.outBytes2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double[][] getDiscount2() {
        if (this.invoked) {
            return this.outDiscount2;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public void setDid(int n) {
        this.did = n;
    }
}

