/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.ssl.impl;

import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.transport.ssl.SSLManagerException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class SSLManagerImpl
implements SSLManager {
    private SSLSocketFactory factory;
    private String[] protocols = new String[]{"SSLv3"};
    private String[] cipherSuites = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_RC4_128_MD5"};
    private X509Certificate certificate;
    private static final Logger LOG = Logger.getLogger(SSLManagerImpl.class);
    private static String ccseKeyStoreFilename = "ccse.keystore";
    private static String keyStoreType = "PKCS12";
    private static final char[] rootCAkeyStorePassword = "ccseKSpwd".toCharArray();
    private static char[] localKeyStorePassword = "ccseKSpwd".toCharArray();
    private static char[] localPrivateKeyPassword = "ccseKSpwd".toCharArray();
    private static final byte[] rootCA;

    @Override
    public SSLSocket setSSL(Socket socket) throws SSLManagerException {
        if (this.factory == null) {
            IllegalStateException illegalStateException = new IllegalStateException("SSLManagerImpl is not initialized");
            LOG.error(illegalStateException);
            throw illegalStateException;
        }
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)this.factory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
            throw new SSLManagerException(iOException.getMessage(), iOException);
        }
        this.initSocket(sSLSocket);
        SSLSession sSLSession = sSLSocket.getSession();
        if (!sSLSession.isValid()) {
            SSLManagerException sSLManagerException = new SSLManagerException("Couldn't establish a valid SSL session");
            LOG.debug(sSLManagerException);
            throw sSLManagerException;
        }
        return sSLSocket;
    }

    public static void setPassword(char[] cArray, char[] cArray2) {
        localKeyStorePassword = cArray;
        localPrivateKeyPassword = cArray2;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        LOG.debug("setting new cipher suites");
        this.cipherSuites = stringArray;
    }

    public void setEnabledProtocols(String[] stringArray) {
        LOG.debug("setting new protocols");
        this.protocols = stringArray;
    }

    public void init() throws GeneralSecurityException, IOException {
        InputStream inputStream = null;
        this.init(inputStream, localKeyStorePassword, keyStoreType, localPrivateKeyPassword, new ByteArrayInputStream(rootCA), rootCAkeyStorePassword);
    }

    public void init(InputStream inputStream, char[] cArray, String string, char[] cArray2, InputStream inputStream2, char[] cArray3) throws GeneralSecurityException, IOException {
        SSLContext sSLContext = SSLContext.getInstance("SSLv3");
        LOG.debug("Initializing SSLContext");
        sSLContext.init(null, null, null);
        this.factory = sSLContext.getSocketFactory();
        LOG.debug("Initialized");
    }

    protected void initSocket(SSLSocket sSLSocket) {
        sSLSocket.setEnabledProtocols(this.protocols);
        sSLSocket.setEnabledCipherSuites(this.cipherSuites);
        sSLSocket.setUseClientMode(true);
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(SSLManagerImpl.class.getName());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceBundle != null) {
            try {
                localKeyStorePassword = resourceBundle.getString("keyStorePassword").toCharArray();
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <keyStorePassword>");
            }
            try {
                localPrivateKeyPassword = resourceBundle.getString("privateKeyPassword").toCharArray();
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <privateKeyPassword");
            }
            try {
                ccseKeyStoreFilename = resourceBundle.getString("keyStoreFilename");
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <keyStoreFilename");
            }
            try {
                keyStoreType = resourceBundle.getString("keyStoreType");
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <keyStoreType");
            }
        }
        rootCA = new byte[]{-2, -19, -2, -19, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 2, 0, 6, 114, 111, 111, 116, 99, 97, 0, 0, 1, 6, -39, -80, -90, 76, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, -125, 48, -126, 4, 127, 48, -126, 3, 103, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -117, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 82, 85, 49, 15, 48, 13, 6, 3, 85, 4, 8, 19, 6, 77, 111, 115, 99, 111, 119, 49, 15, 48, 13, 6, 3, 85, 4, 7, 19, 6, 77, 111, 115, 99, 111, 119, 49, 19, 48, 17, 6, 3, 85, 4, 10, 19, 10, 78, 101, 116, 85, 80, 32, 73, 110, 99, 46, 49, 16, 48, 14, 6, 3, 85, 4, 11, 19, 7, 82, 111, 111, 116, 32, 67, 65, 49, 21, 48, 19, 6, 3, 85, 4, 3, 19, 12, 119, 119, 119, 46, 110, 101, 116, 117, 112, 46, 114, 117, 49, 28, 48, 26, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 13, 105, 110, 102, 111, 64, 110, 101, 116, 117, 112, 46, 114, 117, 48, 30, 23, 13, 48, 53, 49, 48, 48, 53, 48, 57, 52, 56, 49, 50, 90, 23, 13, 51, 51, 48, 53, 50, 54, 48, 57, 52, 56, 49, 50, 90, 48, -127, -117, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 82, 85, 49, 15, 48, 13, 6, 3, 85, 4, 8, 19, 6, 77, 111, 115, 99, 111, 119, 49, 15, 48, 13, 6, 3, 85, 4, 7, 19, 6, 77, 111, 115, 99, 111, 119, 49, 19, 48, 17, 6, 3, 85, 4, 10, 19, 10, 78, 101, 116, 85, 80, 32, 73, 110, 99, 46, 49, 16, 48, 14, 6, 3, 85, 4, 11, 19, 7, 82, 111, 111, 116, 32, 67, 65, 49, 21, 48, 19, 6, 3, 85, 4, 3, 19, 12, 119, 119, 119, 46, 110, 101, 116, 117, 112, 46, 114, 117, 49, 28, 48, 26, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 13, 105, 110, 102, 111, 64, 110, 101, 116, 117, 112, 46, 114, 117, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -91, -118, -28, -85, -16, -60, -1, 44, 65, -111, 108, 122, 98, -128, 8, 95, -79, -54, -53, 75, -66, 111, 30, -48, 72, 24, -67, 73, -91, -58, 93, -37, 14, -118, 24, 84, 36, -11, 119, -40, -2, 45, 118, -63, -103, -34, -106, 53, -109, 24, -60, 2, -56, -39, -19, 5, -52, 126, -61, 5, 84, 119, 7, 102, 106, -4, -47, -60, -27, 51, 53, -127, 6, -89, 35, -119, 34, 93, 50, -25, -13, 117, 68, 12, -43, 116, 19, 10, -15, -27, -45, -59, -102, -18, -2, 1, -68, -32, 73, -110, -77, -98, 24, -16, 103, 7, 61, 53, 57, 17, 94, -55, 120, 66, -51, 39, 91, 88, -47, 68, -58, -12, 11, -42, 0, 27, -23, -109, -35, 46, 40, -76, -16, 34, 120, -74, 93, -116, 54, -96, -72, -52, 45, -88, 104, -94, -45, 84, 12, 113, 95, 49, 72, -20, 8, -35, -43, 46, 55, 21, -7, 34, -39, 68, -77, -32, -128, 106, -72, -47, -126, -126, 96, -36, -96, 73, 61, -83, -118, 43, -76, -70, -95, -35, -6, -58, 110, 51, -42, -33, 37, 101, 35, 117, -89, -62, -109, 53, -116, -115, 38, -82, -59, 74, 12, 127, 0, 86, 126, 26, 46, -120, 111, -86, 29, -38, 39, -82, 85, 37, 117, -85, -16, 107, -14, -118, -68, 34, -6, 88, -80, -31, -74, 68, 32, -42, -110, 32, 62, 83, -47, 54, 57, 85, 93, -53, 108, -106, -91, 6, -92, -70, -62, -32, 10, 113, 2, 3, 1, 0, 1, -93, -127, -21, 48, -127, -24, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 5, 58, 53, 72, -64, -32, 73, 99, 85, 58, 71, -128, -120, 123, 120, -87, 106, -93, -35, -125, 48, -127, -72, 6, 3, 85, 29, 35, 4, -127, -80, 48, -127, -83, -128, 20, 5, 58, 53, 72, -64, -32, 73, 99, 85, 58, 71, -128, -120, 123, 120, -87, 106, -93, -35, -125, -95, -127, -111, -92, -127, -114, 48, -127, -117, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 82, 85, 49, 15, 48, 13, 6, 3, 85, 4, 8, 19, 6, 77, 111, 115, 99, 111, 119, 49, 15, 48, 13, 6, 3, 85, 4, 7, 19, 6, 77, 111, 115, 99, 111, 119, 49, 19, 48, 17, 6, 3, 85, 4, 10, 19, 10, 78, 101, 116, 85, 80, 32, 73, 110, 99, 46, 49, 16, 48, 14, 6, 3, 85, 4, 11, 19, 7, 82, 111, 111, 116, 32, 67, 65, 49, 21, 48, 19, 6, 3, 85, 4, 3, 19, 12, 119, 119, 119, 46, 110, 101, 116, 117, 112, 46, 114, 117, 49, 28, 48, 26, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 13, 105, 110, 102, 111, 64, 110, 101, 116, 117, 112, 46, 114, 117, -126, 1, 0, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -126, 1, 1, 0, 78, 84, 118, -44, -67, 87, 52, 28, 89, -32, 36, -3, -92, -5, 82, -93, -49, 81, -53, -99, -112, 85, -56, 42, 32, -11, -106, -119, 76, 19, 66, 51, -3, 91, 121, 56, -84, 58, 91, 21, 4, 24, 46, 26, 17, -119, 31, 30, 74, 74, -11, -124, 87, 63, 113, -103, 24, -98, 102, -59, 50, 48, 105, 118, 55, -92, 19, 56, 37, -117, -77, 85, 15, 1, 108, -16, -52, -16, 122, -52, 42, 122, -74, -54, -36, -19, -38, 55, 119, 79, 80, -128, 124, -12, -116, -72, -65, -9, -103, 123, 111, 117, 29, -69, -15, 116, -73, -126, 66, -69, 69, 90, 96, -1, 125, -77, -67, 81, 68, -9, -12, -64, -65, -21, 126, -119, -22, 14, 61, 60, 54, -11, 96, -102, 37, 62, -98, 14, 11, 72, -112, 33, -121, 85, -5, -61, 79, -20, -20, -60, -92, -85, 92, 95, 39, -72, 112, -59, -44, 2, 102, 22, 68, -127, -61, 76, -101, 120, -69, 87, 61, 79, -25, -31, 57, -12, -54, 12, 74, -72, -78, 14, -30, 53, 61, -62, -86, -95, 30, -5, 26, 2, -107, 33, 124, -83, 82, 1, -58, -68, -80, -50, 68, 121, 101, 55, -15, -47, 16, -118, -45, 34, -108, -120, 73, -72, 16, 87, -119, -63, -85, -108, -39, 37, -11, 89, 80, 90, -54, -73, 32, -50, -101, -89, 109, 68, 33, -70, -124, 43, 43, -86, 68, -67, -35, -112, -28, 75, 118, -5, -116, 23, -86, -101, -85, 119, -73, 6, 31, 17, -71, 127, -24, -65, -86, -88, -70, -54, 51, 41, 32, 105, 88, -111, 33, -61};
    }
}

