/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.impl;

import biz.netup.control.transport.UnsupportedProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

class Handshake {
    private Socket socket;
    private static final int[] signature = new int[]{223, 254, 237, 16};
    private static final int byte3Mask = 61440;
    private static final int byte2Mask = 3840;
    private static final int byte1Mask = 240;
    private static final int byte0Mask = 15;
    private static final int TCP = 1;
    private static final int SSL = 2;
    private static final int SSL_CERT = 4;
    private static final Logger LOG = Logger.getLogger(Handshake.class);

    Handshake() {
    }

    public void run(Socket socket) throws IOException {
        LOG.debug("Run handshake");
        this.socket = socket;
        this.readSignature();
        int n = this.readProtocolMask();
        int n2 = this.selectProtocol(n);
        if (n2 == 0) {
            throw new UnsupportedProtocolException();
        }
        this.writeSignature();
        this.writeProtocolMask(n2);
        this.flush();
    }

    private InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    private OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    private int selectProtocol(int n) {
        int n2 = 0;
        if ((n & 4) != 0) {
            n2 = 4;
        }
        LOG.debug("Selected protocol: " + n2);
        return n2;
    }

    private void readSignature() throws IOException {
        for (int i = 0; i < signature.length; ++i) {
            if (this.getInputStream().read() == signature[i]) continue;
            throw new UnsupportedProtocolException();
        }
    }

    private int readProtocolMask() throws IOException {
        int n = this.getInputStream().read();
        int n2 = this.getInputStream().read();
        int n3 = this.getInputStream().read();
        int n4 = this.getInputStream().read();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private void writeSignature() throws IOException {
        for (int i = 0; i < signature.length; ++i) {
            this.getOutputStream().write(signature[i]);
        }
    }

    private void writeProtocolMask(int n) throws IOException {
        this.getOutputStream().write(n & 0xF);
        this.getOutputStream().write((n & 0xF0) >> 8);
        this.getOutputStream().write((n & 0xF00) >> 16);
        this.getOutputStream().write((n & 0xF000) >> 24);
    }

    private void flush() throws IOException {
        this.getOutputStream().flush();
    }
}

