/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.impl;

import biz.netup.control.event.Event;
import biz.netup.control.event.Transaction;
import biz.netup.control.handler.TransactionListener;
import biz.netup.control.handler.TransactionListenerException;
import biz.netup.control.transport.Connection;
import biz.netup.control.transport.ConnectionManager;
import biz.netup.control.transport.ConnectionResetListener;
import biz.netup.control.transport.impl.ConnectionStorage;
import biz.netup.control.transport.impl.XMLParserThread;
import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.xml.parser.AbstractXMLParser;
import biz.netup.control.xml.serializer.TransactionSerializer;
import biz.netup.control.xml.serializer.TransactionStreamSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.log4j.Logger;

public class ConnectionManagerImpl
implements ConnectionManager {
    private TransactionListener transactionListener;
    private final List<ConnectionStorage> openedConnections = Collections.synchronizedList(new LinkedList());
    private Connection connectionPrototype;
    private AbstractXMLParser abstractXMLParserPrototype;
    private TransactionStreamSerializer transactionStreamSerializerPrototype;
    private SSLManager sslManager;
    private ConnectionResetListener listenerImpl = new ConnectionResetListenerImpl();
    private static final String EVENT_CONNECT = "netup:sys:connect";
    private static final String EVENT_DISCONNECT = "netup:sys:disconnect";
    private static final Logger LOGGER = Logger.getLogger(ConnectionManagerImpl.class);

    @Override
    public void setTransactionListener(TransactionListener transactionListener) {
        if (transactionListener == null) {
            LOGGER.warn("setTransactionListener(): transactionListener is null");
            throw new IllegalArgumentException("transactionListener");
        }
        this.transactionListener = transactionListener;
    }

    public void setSSLManager(SSLManager sSLManager) {
        this.sslManager = sSLManager;
    }

    public void setConnectionPrototype(Connection connection) {
        this.connectionPrototype = connection;
    }

    public void setAbstractXMLParserPrototype(AbstractXMLParser abstractXMLParser) {
        this.abstractXMLParserPrototype = abstractXMLParser;
    }

    public void setTransactionStreamSerializerPrototype(TransactionStreamSerializer transactionStreamSerializer) {
        this.transactionStreamSerializerPrototype = transactionStreamSerializer;
    }

    @Override
    public void onTransaction(Transaction transaction) throws TransactionListenerException {
        LOGGER.debug("Processing transaction");
        Iterator<Event> iterator = transaction.getEventIterator();
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (!this.processEvent(event)) continue;
            LOGGER.debug("System event " + event.getName() + " removed from transaction");
            iterator.remove();
        }
        this.sendTransaction(transaction);
    }

    private boolean processEvent(Event event) {
        LOGGER.debug("Processing event " + event.getName());
        if (event.getName().equals(EVENT_CONNECT)) {
            this.connect(event);
        } else if (event.getName().equals(EVENT_DISCONNECT)) {
            this.disconnect(event);
        } else {
            return false;
        }
        return true;
    }

    private void sendTransaction(Transaction transaction) {
        ConnectionStorage connectionStorage = this.selectConnection();
        if (connectionStorage != null) {
            this.sendTransaction(connectionStorage.serializer, transaction);
        } else {
            LOGGER.warn("No opened connections, do nothing");
        }
    }

    private void sendTransaction(TransactionSerializer transactionSerializer, Transaction transaction) {
        if (transaction == null || transaction.getTransactionSize() == 0) {
            return;
        }
        try {
            LOGGER.debug("Sending transaction to serializer");
            transactionSerializer.onTransaction(transaction);
        }
        catch (TransactionListenerException transactionListenerException) {
            LOGGER.error("Can't send transaction to serializer");
            transactionListenerException.printStackTrace();
        }
    }

    private ConnectionStorage selectConnection() {
        Iterator<ConnectionStorage> iterator = this.openedConnections.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private void connectionReset(Connection connection) {
        LOGGER.debug("Connection reset");
        Iterator<ConnectionStorage> iterator = this.openedConnections.iterator();
        while (iterator.hasNext()) {
            ConnectionStorage connectionStorage = iterator.next();
            if (connectionStorage.connection != connection) continue;
            iterator.remove();
            this.disconnect(connectionStorage);
        }
    }

    private void disconnect(ConnectionStorage connectionStorage) {
        if (connectionStorage != null) {
            connectionStorage.parserThread.shutdown();
            this.disconnected(connectionStorage.host, connectionStorage.port);
        }
    }

    private void disconnect(Event event) {
        String string = (String)event.getParameter("server_host");
        Integer n = (Integer)event.getParameter("server_port");
        if (string == null || n == null) {
            LOGGER.warn("disconnect event without mandatory fields");
            return;
        }
        Iterator<ConnectionStorage> iterator = this.openedConnections.iterator();
        while (iterator.hasNext()) {
            ConnectionStorage connectionStorage = iterator.next();
            if (!connectionStorage.connection.getHost().equals(string) || connectionStorage.connection.getPort() != n.intValue()) continue;
            iterator.remove();
            this.disconnect(connectionStorage);
        }
    }

    private void connect(Event event) {
        LOGGER.debug("connect()");
        if (this.transactionListener == null) {
            LOGGER.warn("connect(): transactionListener == null");
            throw new IllegalStateException("No transactionListener is set");
        }
        int n = 11760;
        Object object = event.getParameter("server_host");
        if (object == null || !(object instanceof String)) {
            LOGGER.error("Event " + event.getName() + " without mandatory field 'server_host'");
            return;
        }
        String string = (String)object;
        Object object2 = event.getParameter("server_port");
        if (object2 != null && object2 instanceof Integer) {
            n = (Integer)object2;
        } else {
            LOGGER.warn("Port not found in event");
        }
        LOGGER.info("Port = " + n);
        Connection connection = (Connection)this.connectionPrototype.clone();
        connection.setHost(string);
        connection.setPort(n);
        connection.setConnectionResetListener(this.listenerImpl);
        connection.setSSLManager(this.sslManager);
        try {
            connection.connect();
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.info("UnknownHostException: connection failed (" + unknownHostException.getMessage() + ")");
            this.connectionError(string, n, 1, "Unknown host");
            return;
        }
        catch (ConnectException connectException) {
            LOGGER.info("ConnectException: connection failed (" + connectException.getMessage() + ")");
            if (connectException.getMessage().equals("Connection refused")) {
                this.connectionError(string, n, 2, "Connection refused");
            } else {
                this.connectionError(string, n, 100, "Connection failed");
            }
            return;
        }
        catch (SSLException sSLException) {
            LOGGER.info("SSLException: Connection failed (" + sSLException.getMessage() + ")");
            if (sSLException.getCause() instanceof CertificateExpiredException) {
                this.connectionError(string, n, 6, sSLException.getMessage());
            } else if (sSLException.getCause() instanceof CertificateNotYetValidException) {
                this.connectionError(string, n, 7, sSLException.getMessage());
            } else {
                this.connectionError(string, n, 4, sSLException.getMessage());
            }
            return;
        }
        catch (IOException iOException) {
            LOGGER.info("Connection failed (" + iOException.getMessage() + ")");
            this.connectionError(string, n, 100, iOException.getMessage());
            return;
        }
        AbstractXMLParser abstractXMLParser = (AbstractXMLParser)this.abstractXMLParserPrototype.clone();
        abstractXMLParser.setTransactionListener(this.transactionListener);
        XMLParserThread xMLParserThread = new XMLParserThread(abstractXMLParser, connection.getInputStream());
        TransactionStreamSerializer transactionStreamSerializer = null;
        try {
            transactionStreamSerializer = (TransactionStreamSerializer)this.transactionStreamSerializerPrototype.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LOGGER.error("Can't clone TransactionStreamSerializer serializer");
        }
        OutputStream outputStream = connection.getOutputStream();
        if (outputStream == null) {
            LOGGER.warn("Connection has returned null as output stream!");
        }
        transactionStreamSerializer.setOutputStream(outputStream);
        ConnectionStorage connectionStorage = new ConnectionStorage(connection, xMLParserThread, transactionStreamSerializer, string, n);
        this.openedConnections.add(connectionStorage);
        Transaction transaction = new Transaction();
        transaction.addEvent(event);
        LOGGER.debug("Sending login transaction");
        this.sendTransaction(transaction);
        xMLParserThread.start();
    }

    private void connectionError(String string, int n, int n2, String string2) {
        Transaction transaction = new Transaction();
        Event event = new Event("netup:sys:modified_connection", "1.0");
        event.setParameter("server_host", string);
        event.setParameter("server_port", n);
        event.setParameter("state", 0);
        event.setParameter("error_code", n2);
        if (string2 != null) {
            event.setParameter("error_description", string2);
        }
        transaction.addEvent(event);
        this.sendToTransactionListener(transaction);
    }

    private void disconnected(String string, int n) {
        LOGGER.debug("Sending 'modified_connection' event with disconnected state (host=" + string + ", port=" + n + ")");
        Transaction transaction = new Transaction();
        Event event = new Event("netup:sys:modified_connection", "1.0");
        event.setParameter("server_host", string);
        event.setParameter("server_port", n);
        event.setParameter("state", 0);
        transaction.addEvent(event);
        this.sendToTransactionListener(transaction);
    }

    private void sendToTransactionListener(Transaction transaction) {
        if (this.transactionListener == null) {
            LOGGER.warn("sendToTransactionListener(): transactionListener == null");
            throw new IllegalStateException("No transactionListener is set");
        }
        try {
            this.transactionListener.onTransaction(transaction);
        }
        catch (TransactionListenerException transactionListenerException) {
            LOGGER.error("Can't send transaction to transactionListener");
        }
    }

    private class ConnectionResetListenerImpl
    implements ConnectionResetListener {
        private ConnectionResetListenerImpl() {
        }

        @Override
        public void onConnectionReset(Connection connection) {
            ConnectionManagerImpl.this.connectionReset(connection);
        }
    }
}

