/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.storage.impl;

import biz.netup.control.handler.TransactionListener;
import biz.netup.control.handler.TransactionListenerException;
import biz.netup.control.storage.ScheduledTransaction;
import biz.netup.control.storage.Storage;
import biz.netup.control.storage.StorageEvent;
import biz.netup.control.storage.StorageListener;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ScheduleExecutorImpl
implements Runnable {
    Logger log = Logger.getLogger(ScheduleExecutorImpl.class);
    Date currentDate;
    Storage storage;
    TransactionListener transactionListener;
    final TreeSet<ScheduledTransaction> schedules = new TreeSet<ScheduledTransaction>(new ScheduledTransactionComparator());
    StorageList storageListener = new StorageList();

    public ScheduleExecutorImpl(TransactionListener transactionListener, Storage storage) {
        this.storage = storage;
        this.transactionListener = transactionListener;
        this.currentDate = new Date();
        Iterator<ScheduledTransaction> iterator = storage.getEntities(ScheduledTransaction.class);
        while (iterator.hasNext()) {
            this.schedules.add(iterator.next());
        }
        storage.addListener(ScheduledTransaction.class, 7, this.storageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.log.info("Sheduler started");
        try {
            while (true) {
                long l;
                if (this.schedules.isEmpty()) {
                    Thread.sleep(5000L);
                    continue;
                }
                long l2 = this.schedules.first().getNextExecutionDate(this.currentDate).getTime();
                if (l2 - (l = System.currentTimeMillis()) > 0L) {
                    Thread.sleep(Math.min(l2 - l, 5000L));
                    continue;
                }
                TreeSet<ScheduledTransaction> treeSet = this.schedules;
                synchronized (treeSet) {
                    Vector<Object> vector = new Vector<Object>();
                    while (this.schedules.size() > 0 && this.schedules.first().getNextExecutionDate(this.currentDate).getTime() == l2) {
                        ScheduledTransaction scheduledTransaction = this.schedules.first();
                        vector.add(scheduledTransaction);
                        this.schedules.remove(scheduledTransaction);
                        try {
                            this.log.info("Sending transaction (" + new Date() + ")");
                            this.transactionListener.onTransaction(scheduledTransaction.transaction);
                        }
                        catch (TransactionListenerException transactionListenerException) {
                            this.log.error("", transactionListenerException);
                        }
                    }
                    this.currentDate = new Date(l2 + 1000L);
                    for (ScheduledTransaction scheduledTransaction : vector) {
                        this.schedules.add(scheduledTransaction);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.storage.removeListener(ScheduledTransaction.class, this.storageListener);
            return;
        }
    }

    private class StorageList
    implements StorageListener {
        private StorageList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storageChanged(StorageEvent storageEvent) {
            if (storageEvent.getObject() instanceof ScheduledTransaction) {
                ScheduledTransaction scheduledTransaction = (ScheduledTransaction)storageEvent.getObject();
                TreeSet<ScheduledTransaction> treeSet = ScheduleExecutorImpl.this.schedules;
                synchronized (treeSet) {
                    switch (storageEvent.getEventType()) {
                        case 1: {
                            ScheduleExecutorImpl.this.schedules.add(scheduledTransaction);
                            break;
                        }
                        case 4: {
                            ScheduleExecutorImpl.this.schedules.remove(scheduledTransaction);
                            break;
                        }
                    }
                }
            }
        }
    }

    class ScheduledTransactionComparator
    implements Comparator<ScheduledTransaction> {
        ScheduledTransactionComparator() {
        }

        @Override
        public int compare(ScheduledTransaction scheduledTransaction, ScheduledTransaction scheduledTransaction2) {
            long l = scheduledTransaction.getNextExecutionDate(ScheduleExecutorImpl.this.currentDate).getTime() - scheduledTransaction2.getNextExecutionDate(ScheduleExecutorImpl.this.currentDate).getTime();
            if (l == 0L) {
                l = scheduledTransaction.hashCode() - scheduledTransaction2.hashCode();
            }
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

