<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="UTF-8"/>

<!-- *************************** VARIABLES INIT *********************** -->
<xsl:key name="db_key" match="row_params" use="param_name"/>
<xsl:key name="db_key_row" match="row" use="row_name"/>
<xsl:template match="row">
</xsl:template>

<xsl:key name="data_key" match="data" use="var"/>

<xsl:variable name="dict_path" select="'dict.xml'"/>
<xsl:variable name="htpath"></xsl:variable>
<xsl:variable name="card-refresh-success">Succeded</xsl:variable>

<xsl:variable name="color_lt">#E0EED3</xsl:variable>
<xsl:variable name="color_dk">#43AA2E</xsl:variable>
<xsl:variable name="aaa">aaa5</xsl:variable>
<xsl:variable name="admin">admin5</xsl:variable>
<xsl:variable name="user">user5</xsl:variable>
<xsl:variable name="section"><xsl:value-of select="/UTM/@section"/></xsl:variable>
<xsl:variable name="pagetitle"><xsl:value-of select="/UTM/@pagetitle"/></xsl:variable>
<xsl:variable name="subsection"><xsl:value-of select="/UTM/@subsection"/></xsl:variable>
<xsl:variable name="menu"><xsl:value-of select="/UTM/@menu"/></xsl:variable>
<xsl:variable name="submenu"><xsl:value-of select="/UTM/@submenu"/></xsl:variable>


<!-- *********************** MAIN SECTION **************************** -->
<xsl:template match="/UTM">

<HTML>
 <HEAD>
  <TITLE>
	UTM:
  	<xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="$pagetitle"/></xsl:with-param></xsl:call-template>
  </TITLE>
  <LINK rel="stylesheet" type="text/css" href="{$htpath}/utm.css"/>
  <SCRIPT language="JavaScript" type="text/javascript" src="{$htpath}/utm.js"></SCRIPT>
  <xsl:if test="$section='refresh'">
    <META HTTP-EQUIV="PRAGMA" CONTENT="NO-CACHE"></META>
    <META HTTP-EQUIV="refresh" CONTENT="150"></META>
	<script type="text/javascript">
	setTimeout(' document.location=document.location' ,200000);

	<xsl:variable name="temp"><xsl:for-each select="key('data_key','referer')/value"> <xsl:value-of select="."/> </xsl:for-each></xsl:variable>
	<xsl:if test="$temp != ''">
		<xsl:variable name="do_redirect"><xsl:for-each select="key('data_key','do_redirect')/value"> <xsl:value-of select="."/> </xsl:for-each></xsl:variable>
		<xsl:if test="$do_redirect = 'yes'">
		window.open('<xsl:for-each select="key('data_key','referer')/value"> <xsl:value-of select="."/> </xsl:for-each>', 'URL', 'resizable,height=800,width=600,toolbar=1,menubar=1,scrollbars=1');
		</xsl:if>
	</xsl:if>

	</script>
  </xsl:if>
  </HEAD>
 <xsl:variable name="nomenuvar" select="@nomenu"/> 
 <BODY bgcolor="#FFFFFF" text="#000000" link="#003BA9" vlink="#E7651A" marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0">
 <xsl:choose>
 <xsl:when test="$nomenuvar = '1'">
     <xsl:apply-templates />
 </xsl:when>
 <xsl:otherwise>
  <TABLE width="100%" height="100%" cellspacing="0" cellpadding="0" border="0">
   <TR>
    <TD width="20%" class="menu-area">
     <xsl:if test="$menu!=&quot;&quot;">
      <xsl:for-each select="document($menu)/UTM/menu/item">
       <xsl:choose>
	<xsl:when test="@name=$section"><DIV class="mainmenu-act">
	<xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="@mvalue"/></xsl:with-param></xsl:call-template>
	</DIV></xsl:when>
        <xsl:otherwise><DIV class="mainmenu-inact"><A href="{@href}{$skey__}" target="_top">
	<xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="@mvalue"/></xsl:with-param></xsl:call-template>
	</A></DIV></xsl:otherwise>
       </xsl:choose>
      </xsl:for-each>
     </xsl:if>
	<BR />
	<DIV ALIGN="CENTER"><a href="http://www.netup.ru" target="_new"><img src="https://secure.netup.biz/utm.gif" border="0"></img></a></DIV>
    </TD>
    <TD width="80%" class="work-area">
     <TABLE width="100%" cellspacing="0" cellpadding="0" border="0" bgcolor="{$color_lt}">
	<TR><TD class="submenu-area">
     <xsl:for-each select="document($submenu)/UTM/menu/item">
      <xsl:choose>
       <xsl:when test="@name=$subsection"><SPAN class="submenu-act">
	<xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="@mvalue"/></xsl:with-param></xsl:call-template>
	</SPAN></xsl:when>
       <xsl:otherwise><SPAN class="submenu-inact"><A href="{@href}{$skey__}" target="_top">
	<xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="@mvalue"/></xsl:with-param></xsl:call-template>
	</A></SPAN></xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
     </TD></TR>
	</TABLE><BR />

     <xsl:apply-templates />
    </TD>
   </TR>
  </TABLE>
 </xsl:otherwise>
 </xsl:choose>
 </BODY>
</HTML>
</xsl:template>

<!-- *********************** TABLE SECTION **************************** -->

<!-- ************* TABS **************** -->

<!-- BEGIN == template for set present/not present table in HTML-form -->
<xsl:template match="table[@invisible]">

  <xsl:variable name="data_var"><xsl:value-of select="@invisible"/></xsl:variable>
  <xsl:variable name="var"><xsl:value-of select="key('data_key',$data_var)/value"/></xsl:variable>
 
  
  <xsl:if test="$var = '_YES_'">
    <!-- nothing adding to HTML-form -->
  </xsl:if>
    
  <xsl:if test="$var != '_YES_'">
    <!-- adding to HTML-form this table -->
	<xsl:call-template name="tables">
	    <xsl:with-param name="value">
		<xsl:value-of select="."/>
	    </xsl:with-param>
	</xsl:call-template>
  </xsl:if>

</xsl:template> 
<!-- END == template for set present/not present table in HTML-form -->

<xsl:template name="tables" match="table">
 <TABLE width="100%" cellspacing="0" cellpadding="0" border="0">
 <TR>
 <TD bgcolor="{$color_dk}">
   <TABLE width="100%" cellspacing="1" cellpadding="4" border="0">
   	<TR>
   	<xsl:for-each select="./tab">
        	<TD class="form-tab" align="center" width="10%" bgcolor="{$color_lt}">
			<xsl:call-template name="dict"><xsl:with-param name="value">
			<xsl:value-of select="."/>
			</xsl:with-param></xsl:call-template>
        	</TD>
   	</xsl:for-each>
	<xsl:for-each select="key('db_key_row','custom_tabs')/row_params/param_value">
        	<TD class="form-tab" align="center" width="10%" bgcolor="{$color_lt}">
			<xsl:value-of select="."/>
			<!-- <xsl:value-of select="./row_params/param_value"/> -->
        	</TD>
   	</xsl:for-each>
   	<xsl:for-each select="./tab_last">
        	<TD class="form-tab" align="center" width="10%" bgcolor="{$color_lt}">
			<xsl:call-template name="dict"><xsl:with-param name="value">
			<xsl:value-of select="."/>
			</xsl:with-param></xsl:call-template>
        	</TD>
   	</xsl:for-each>

	</TR>
     	<xsl:apply-templates select="field"/>
    </TABLE>
 </TD></TR>
 </TABLE>

</xsl:template>

<!-- ************* ROWS **************** -->
<xsl:template match="field[@type=&quot;static_val_table&quot;]">
<TR>
 <TD class="utm-table" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
  <TD class="utm-table" align="left">
    <xsl:apply-templates select="*"/>
  </TD>
</TR>
</xsl:template>

	<xsl:template match="field[@type=&quot;static_val_table_single&quot;]">
	  <xsl:variable name="prompt" select="@prompt"/>
	  <xsl:variable name="param"><xsl:value-of select="@param"/></xsl:variable>
	  <xsl:variable name="bold"><xsl:value-of select="@bold"/></xsl:variable>
	  <xsl:variable name="temp_1"><xsl:value-of select="@mult_param"/></xsl:variable>
	  <xsl:for-each select="key('db_key_row',$temp_1)">
			<TR>
		<xsl:if test="$prompt != ''">
			<xsl:choose>
			<xsl:when test="$bold != ''">
					<TD class="utm-table-bold" align="right">
						<xsl:call-template name="dict"><xsl:with-param name="value">
						<xsl:value-of select="$prompt"/>
						</xsl:with-param></xsl:call-template>
					</TD>
			</xsl:when>
			<xsl:otherwise>
					<TD class="utm-table" align="right">
						<xsl:call-template name="dict"><xsl:with-param name="value">
						<xsl:value-of select="$prompt"/>
						</xsl:with-param></xsl:call-template>
					</TD>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="$param = 'int_status'">
					<xsl:for-each select="key('db_key',$param)/param_value">
					<xsl:variable name="int_status"><xsl:value-of select="."/></xsl:variable>
						<TD class="utm-table" align="left">
					<xsl:choose>
					<xsl:when test="$int_status='1'">
								<xsl:call-template name="dict"><xsl:with-param name="value">M_INT_ON</xsl:with-param></xsl:call-template><xsl:text> </xsl:text>
						<A HREF="/cgi-bin/utm5/{$user}?skey={$skey__}&amp;cmd=user_reports&amp;int_status_cmd=invert">
								<xsl:call-template name="dict"><xsl:with-param name="value">M_INT_DO_OFF</xsl:with-param></xsl:call-template>
						</A>
					</xsl:when>
					<xsl:otherwise>
								<xsl:call-template name="dict"><xsl:with-param name="value">M_INT_OFF</xsl:with-param></xsl:call-template><xsl:text> </xsl:text>
						<A HREF="/cgi-bin/utm5/{$user}?skey={$skey__}&amp;cmd=user_reports&amp;int_status_cmd=invert">
								<xsl:call-template name="dict"><xsl:with-param name="value">M_INT_DO_ON</xsl:with-param></xsl:call-template>
						</A>
					</xsl:otherwise>
					</xsl:choose>
						</TD>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$param = 'is_blocked'">
					<xsl:for-each select="key('db_key',$param)/param_value">
					<xsl:variable name="block_status"><xsl:value-of select="."/></xsl:variable>
						<TD class="utm-table" align="left">
					<xsl:choose>
					<xsl:when test="$block_status='0'">
								<xsl:call-template name="dict"><xsl:with-param name="value">M_BLOCK_OFF</xsl:with-param></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
								<xsl:call-template name="dict"><xsl:with-param name="value">M_BLOCK_ON</xsl:with-param></xsl:call-template>
					</xsl:otherwise>
					</xsl:choose>
						</TD>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$param!=''">
					<xsl:for-each select="key('db_key',$param)/param_value">
				<xsl:choose>
                		<xsl:when test="$bold != ''">
        				  <TD class="utm-table-bold" align="left">
							<xsl:value-of select="."/>
        				  </TD>
						</xsl:when>
						<xsl:otherwise>
        				  <TD class="utm-table" align="left">
							<xsl:value-of select="."/>
        				  </TD>
						</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
        		<xsl:for-each select="./row_params/param_value">
			         <TD class="utm-table" align="{@align_param}" rowspan="{@row_cols}">
					<xsl:choose>
					<xsl:when test="@link != ''">
						<A HREF="/cgi-bin/utm5/{$user}?skey={$skey__}&amp;{@link}">
						<xsl:value-of select="."/>
						</A>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
					</xsl:choose>
				</TD>			
        			
				</xsl:for-each>
		</xsl:otherwise>
	</xsl:choose>
	</TR>
  </xsl:for-each>
</xsl:template>

<!-- *********************** FORMS SECTION **************************** -->

<xsl:template match="form">
 <!-- <xsl:variable name="form_name" select-of="{@name}"/> -->
 <FORM name="{@name}" accept-charset="UTF-8" action="{@action}" target="{@target}">
   <xsl:if test="@method"><xsl:attribute name="method"><xsl:value-of select="@method"/></xsl:attribute>
   </xsl:if> 
 <DIV class="form-tab"><TABLE cellspacing="5" cellpadding="3" border="0">
  <xsl:apply-templates />
  <TR><TD></TD><TD>
   <xsl:call-template name="buttons"/>
  </TD></TR>
 </TABLE></DIV>
 </FORM>
</xsl:template>

<xsl:template match="field[@type=&quot;static_val_form&quot;]">
  <xsl:variable name="temp"><xsl:value-of select="@mult_param"/></xsl:variable>
  <xsl:variable name="temp_value"><xsl:value-of select="key('data_key',$temp)/value"/></xsl:variable>
  <INPUT type="hidden" name="{@name}" value="{$temp_value}"/>
</xsl:template>


<xsl:template match="field[@type=&quot;hidden&quot;]">
	<xsl:choose>
	<xsl:when test="@name='skey'">
	<INPUT type="hidden" name="{@name}" value="{$skey__}"/>
	</xsl:when>
	<xsl:otherwise>

	<INPUT type="hidden" name="{@name}" value="{@value}"/>

	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="field[@type=&quot;select&quot;]">
<TR>
 <TD class="form-field" align="right">
   <xsl:call-template name="dict"><xsl:with-param name="value">
     <xsl:value-of select="prompt"/>
   </xsl:with-param></xsl:call-template>
 </TD>
 <TD>
   <SELECT class="form-field" name="{@name}">
     <xsl:for-each select="option">
	 <option class="form-field">
	   <xsl:attribute name="value">
	     <xsl:value-of select="@value"/>
	   </xsl:attribute>
	  <xsl:value-of select="@prompt"/>
	 </option>
     </xsl:for-each>
   </SELECT>
 </TD>
</TR>
</xsl:template>

<xsl:template match="field[@type=&quot;static&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
  <TD class="form-field" align="left">
    <xsl:value-of select="value"/>
  </TD>
</TR>
</xsl:template>

<xsl:template match="field[@type=&quot;static_val&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
  <TD class="form-field" align="left">
    <xsl:apply-templates/>
  </TD>
</TR>
</xsl:template>

<xsl:template match="field[@type=&quot;string&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
  <TD class="form-field" align="left"><INPUT type="text" class="form-field" size="40" name="{@name}" value="{value}"/></TD>
 </TR>
</xsl:template>

<xsl:template match="field[@type=&quot;text_area&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
  <TD class="form-field" align="left">
	<TEXTAREA NAME="{@name}" COLS="40" ROWS="10"></TEXTAREA>
  </TD> 
 </TR>
</xsl:template>

<xsl:template match="field[@type=&quot;checked_checkbox&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
 <TD class="form-field" align="left"><INPUT checked="1" type="checkbox" class="form-field" name="{@name}" value="{@value}"/></TD>
</TR>
</xsl:template>

<xsl:template match="field[@type=&quot;checkbox&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
 <TD class="form-field" align="left"><INPUT type="checkbox" class="form-field" name="{@name}" value="{@value}"/></TD>
</TR>
</xsl:template>

<xsl:template match="field[@type=&quot;password&quot;]">
<TR>
 <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
 </TD>
 <TD class="form-field" align="left"><INPUT type="password" class="form-field" size="40" name="{@name}" value="{value}"/></TD>
 </TR>
</xsl:template>

<xsl:template match="field[@type=&quot;ipmask&quot;]">
<TR>
 <TD class="form-field" align="right"><xsl:value-of select="prompt"/></TD>
 <TD class="form-field" align="left">
  <INPUT type="text" class="form-field" size="3" name="{@name}_ip_1" value="{value}"/>.<INPUT type="text" class="form-field" size="3" name="{@name}_ip_2" value="{value}"/>.<INPUT type="text" class="form-field" size="3" name="{@name}_ip_3" value="{value}"/>.<INPUT type="text" class="form-field" size="3" name="{@name}_ip_4" value="{value}"/>
  mask <INPUT type="text" class="form-field" size="3" name="{@name}_mask_1" value="{value}"/>.<INPUT type="text" class="form-field" size="3" name="{@name}_mask_2" value="{value}"/>.<INPUT type="text" class="form-field" size="3" name="{@name}_mask_3" value="{value}"/>.<INPUT type="text" class="form-field" size="3" name="{@name}_mask_4" value="{value}"/>
 </TD>
</TR>
</xsl:template>

<xsl:template match="field[@type=&quot;date_sel&quot;]">
  <TR>
    <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
    </TD>
    <TD>
      <TABLE border="0"> 
	<TR>
	<TD class="form-field" align="right">
	<SELECT name="s_hour">
	<xsl:for-each select="/UTM/db/dates/s_hour">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<SELECT name="s_min">
	<xsl:for-each select="/UTM/db/dates/s_min">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<xsl:text> </xsl:text>
	<SELECT name="s_mday">
	<xsl:for-each select="/UTM/db/dates/s_mday">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<SELECT name="s_mon">
	<xsl:for-each select="/UTM/db/dates/s_mon">
		<xsl:variable name="temp" select="."/>
		<xsl:variable name="temp_1" select="@value"/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp_1}" SELECTED="1">
			<xsl:call-template name="dict"><xsl:with-param name="value">
			<xsl:value-of select="$temp"/>
			</xsl:with-param></xsl:call-template>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp_1}">
			<xsl:call-template name="dict"><xsl:with-param name="value">
			<xsl:value-of select="$temp"/>
			</xsl:with-param></xsl:call-template>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<SELECT name="s_year">
	<xsl:for-each select="/UTM/db/dates/s_year">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	-
	<SELECT name="e_hour">
	<xsl:for-each select="/UTM/db/dates/e_hour">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<SELECT name="e_min">
	<xsl:for-each select="/UTM/db/dates/e_min">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<xsl:text> </xsl:text>
	<SELECT name="e_mday">
	<xsl:for-each select="/UTM/db/dates/e_mday">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<SELECT name="e_mon">
	<xsl:for-each select="/UTM/db/dates/e_mon">
		<xsl:variable name="temp" select="."/>
		<xsl:variable name="temp_1" select="@value"/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp_1}" SELECTED="1">
			<xsl:call-template name="dict"><xsl:with-param name="value">
			<xsl:value-of select="$temp"/>
			</xsl:with-param></xsl:call-template>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp_1}">
			<xsl:call-template name="dict"><xsl:with-param name="value">
			<xsl:value-of select="$temp"/>
			</xsl:with-param></xsl:call-template>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	<SELECT name="e_year">
	<xsl:for-each select="/UTM/db/dates/e_year">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
	</TD>
	</TR>
      </TABLE>
    </TD>
  </TR>
</xsl:template>

<xsl:template match="dates">
</xsl:template>

<xsl:template match="db">
</xsl:template>

<xsl:template match="field[@type=&quot;accounts_sel&quot;]">
  <TR>
    <TD class="form-field" align="right">
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@prompt"/>
	</xsl:with-param></xsl:call-template>
    </TD>
    <TD>
	<SELECT name="account">
	<xsl:for-each select="/UTM/db/accounts/accounts_list">
		<xsl:variable name="temp" select="."/>
		<xsl:choose>
		<xsl:when test="@selected != ''">
			<OPTION VALUE="{$temp}" SELECTED="1">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:when>
		<xsl:otherwise>
			<OPTION VALUE="{$temp}">
			<xsl:value-of select="$temp"/>
			</OPTION>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	</SELECT>
    </TD>
  </TR>
</xsl:template>

<!-- *********************** BUTTONS SECTION **************************** -->
<xsl:template name="buttons">
<xsl:for-each select="button">
 <xsl:choose>
  <xsl:when test="@type=&quot;ok&quot;">
   <xsl:variable name="temp">
     <xsl:call-template name="dict"><xsl:with-param name="value">
      <xsl:value-of select="@value"/></xsl:with-param>
     </xsl:call-template>
   </xsl:variable>
   <INPUT type="submit" class="form-button" value="{$temp}"/> 
  </xsl:when>
  <xsl:when test="@type=&quot;cancel&quot;">
   <xsl:variable name="temp"><xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template></xsl:variable>
   <INPUT type="button" class="form-button" value="{$temp}" onClick="javascript:self.close();"/>
  </xsl:when>
  <xsl:when test="@type=&quot;cancel_and_back&quot;">
   <xsl:variable name="temp"><xsl:call-template name="dict"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template></xsl:variable>
   <INPUT type="button" class="form-button" value="{$temp}" onClick="javascript:self.back();"/>
  </xsl:when>
 </xsl:choose>
</xsl:for-each>
</xsl:template>

<!-- *********************** DICTIONARY SECTION **************************** -->
<!-- for not present in html-form -->
<xsl:template match="dicts[@invisible]">
  <xsl:variable name="data_var"><xsl:value-of select="@invisible"/></xsl:variable>
  <xsl:variable name="var"><xsl:value-of select="key('data_key',$data_var)/value"/></xsl:variable>
 
  <xsl:if test="$var = '_YES_'">
    <!-- nothing adding to HTML-form -->
  </xsl:if>
  <xsl:if test="$var != '_YES_'">
    <!-- adding to HTML-form this table -->
	<xsl:call-template name="dicts">
	    <xsl:with-param name="value">
		<xsl:value-of select="."/>
	    </xsl:with-param>
	</xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="dicts" match="dicts">
 <xsl:choose>
 <xsl:when test="@bold != ''">
   <B>
   <xsl:call-template name="dict"><xsl:with-param name="value">
    <xsl:value-of select="@lstr"/></xsl:with-param>
   </xsl:call-template>
   </B>
 </xsl:when>
 <xsl:otherwise>
  <xsl:call-template name="dict"><xsl:with-param name="value">
   <xsl:value-of select="@lstr"/></xsl:with-param>
  </xsl:call-template>
 </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template name="dict">
  <xsl:param name="value"/>
  <xsl:value-of select="document($dict_path)/utm5_nls/lang[@id=$cur_lang]/utm5_msg[@id=$value]"/>
</xsl:template>

<!-- *********************** VARIABLES SECTION **************************** -->
<xsl:template name="data" match="data">
  <xsl:variable name="temp"><xsl:value-of select="@var"/></xsl:variable>
  <xsl:variable name="temp_value"><xsl:value-of select="key('data_key',$temp)/value"/></xsl:variable>
  <xsl:choose>

<!-- CHECK REPLENISH RESULT -->
  <xsl:when test="$temp = 'replenish_result_sum'">
    <xsl:choose>
    <xsl:when test="$temp_value &lt; '0'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_REPLENISH_ERROR</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:when test="$temp_value &gt; '0'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_REPLENISH_RESULT</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:when>
<!-- CHECK PASSWORD CHANGE RESULT -->
  <xsl:when test="$temp = 'password_change_result'">
    <xsl:choose>
    <xsl:when test="$temp_value = '1'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_PASSWORD_CHANGE_SUCCESS</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:when test="$temp_value = '2'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_PASSWORD_CHANGE_ERROR</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:when>
<!-- CHECK MESSAGE SEND RESULT -->
  <xsl:when test="$temp = 'add_message_result'">
    <xsl:choose>
    <xsl:when test="$temp_value = '0'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_SEND_MESSAGE_ERROR</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:when test="$temp_value &gt; '0'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_SEND_MESSAGE_OK</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:when>
<!-- LOGIN MESSAGES -->
  <xsl:when test="$temp = 'login_message'">
    <xsl:choose>
    <xsl:when test="$temp_value = '13'">
        <xsl:call-template name="dict">
            <xsl:with-param name="value">M_ACCESS_DENIED</xsl:with-param>
        </xsl:call-template>
        <BR /> <BR />
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:when>

  <xsl:otherwise>
   <xsl:for-each select="key('data_key',@var)/value">
	<xsl:value-of select="."/>
   </xsl:for-each>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- *********************** LINKS SECTION **************************** -->
<xsl:template match="simple_link">
	<BR/>
	<A href="{@href}"> 
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@mvalue"/>
	</xsl:with-param></xsl:call-template>
	</A>
</xsl:template>
<xsl:template match="simple_link2">
  <xsl:if test="$start__ != '-1'">
	<A href="/cgi-bin/utm5/{$user}?skey={$skey__}&amp;cmd=download&amp;start={$start__}&amp;end={$end__}"> 
	<xsl:call-template name="dict"><xsl:with-param name="value">
	<xsl:value-of select="@mvalue"/>
	</xsl:with-param></xsl:call-template>
	</A>
  </xsl:if>  
</xsl:template>
<!-- *********************** IMGS SECTION **************************** -->
<xsl:template match="img">
  <xsl:if test="$is_graph = '1'">
	<BR/>
	<img src="/cgi-bin/utm5/{$user}?skey={$skey__}&amp;cmd=graph&amp;start={$start__}&amp;end={$end__}">
	</img>
  </xsl:if>
</xsl:template>

<xsl:template match="img_simple">
	<BR/>
	<img src="{@value}">
	</img>
</xsl:template>

<!-- *********************** HTML TAGS SECTION **************************** -->
<xsl:template match="BR">
	<BR />
</xsl:template>

<!-- *********************** Kvit section ******************************* -->
<xsl:template match="kvit">

	<STYLE type="text/css">
	body
	{
		background:#FFFFFF;
		margin-left:30pt;
		margin-right:30pt;
		margin-top:0pt;
		margin-bottom:0pt;
	}
	P {
		font-size:9pt;
		font-family:Verdana,"MS Sans Serif",Geneva,Helvetica,sans-serif;
	}
	big {
		font-size:10pt;
		font-weight:bold;
	}
	strong {
		font-size:12pt;
		font-weight:bold;
	}
	small	{
		font-size:7pt;
	}
	TD {
		font-size:9pt;
		font-family:Verdana,"MS Sans Serif",Geneva,Helvetica,sans-serif;
	}
	</STYLE>

  <TABLE cellSpacing="0" cellPadding="1" width="100%" border="0">
  <TR>
    <TD vAlign="center" align="left" width="38%" height="230">
      <TABLE border="0" width="100%" height="100%">
        <TR><TD align="left" valign="top"><BIG>
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_IZVESHENIE</xsl:with-param>
			</xsl:call-template>
		</BIG></TD></TR>
        <TR><TD align="left" valign="bottom">
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_KASSIR</xsl:with-param>
			</xsl:call-template>
		</TD></TR>
      </TABLE>
    </TD>
    <TD vAlign="top" align="left" width="62%">
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAYM_RECV</xsl:with-param>
			</xsl:call-template>
		: <B>
			<xsl:value-of select="key('data_key','payment_recv')/value"/>
		</B>,<BR />
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_INN</xsl:with-param>
			</xsl:call-template>
		: <B>
			<xsl:value-of select="key('data_key','inn')/value"/>
		</B><BR />
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_R_SCHET</xsl:with-param>
			</xsl:call-template>
		: <B>
			<xsl:value-of select="key('data_key','bank_account')/value"/>
		</B><xsl:text>&#x20;</xsl:text><xsl:value-of select="key('data_key','bank_name')/value"/> , <xsl:value-of select="key('data_key','bank_city')/value"/><BR />
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_BANK_BIC</xsl:with-param>
			</xsl:call-template>
		: <B><xsl:value-of select="key('data_key','bank_bic')/value"/></B>, 
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_K_SCHET</xsl:with-param>
			</xsl:call-template>
		<B><xsl:text>&#x20;</xsl:text><xsl:value-of select="key('data_key','bank_ks')/value"/></B>
      <HR />
      <DIV align="center">
        <BIG><xsl:value-of select="key('data_key','full_name')/value"/></BIG><HR size="1" /><SMALL>(
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_F_I_O</xsl:with-param>
			</xsl:call-template>
		)</SMALL>
      </DIV>
      <TABLE border="1" cellspacing="0" width="100%">
        <TR>
          <TD align="center"><B>
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_BASIC_ACCOUNT</xsl:with-param>
			</xsl:call-template>
			</B></TD>
          <TD align="center"><B>
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAY_TYPE</xsl:with-param>
			</xsl:call-template>
			</B></TD>
          <TD align="center"><B>
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAY_SUM</xsl:with-param>
			</xsl:call-template>
			</B></TD>
        </TR><TR>
          <TD valign="middle" align="center"><STRONG><xsl:value-of select="key('data_key','basic_account')/value"/></STRONG></TD>
          <TD valign="middle" align="left">
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAY_COMM</xsl:with-param>
			</xsl:call-template>
			<BR /></TD>
          <TD valign="middle" align="right"><STRONG><TEXT> </TEXT></STRONG><BIG><xsl:value-of select="key('data_key','psum')/value"/></BIG></TD>
        </TR>
      </TABLE>
			<xsl:call-template name="dict">
            <xsl:with-param name="value">M_ADDRESS</xsl:with-param>
			</xsl:call-template>
		: <xsl:value-of select="key('data_key','actual_address')/value"/> <HR size="1"/>
      <TABLE border="0" width="100%" cellspacing="0" cellpadding="0"><TR>
        <TD align="right" valign="top">
          <TABLE border="0" cellspacing="0" cellpadding="0">
            <TR><TD><BIG>_________________</BIG></TD></TR>
            <TR><TD align="center"><SMALL>(
				<xsl:call-template name="dict">
				<xsl:with-param name="value">M_PAYER_SIG</xsl:with-param>
				</xsl:call-template>
			)</SMALL></TD></TR>
          </TABLE>
        </TD>
        <TD align="left" valign="top">
          <TABLE border="0" cellspacing="0" cellpadding="0">
            <TR><TD><BIG>"____"_________<TEXT> </TEXT>200___<TEXT> </TEXT></BIG></TD></TR>
            <TR><TD align="center"><SMALL>(
				<xsl:call-template name="dict">
				<xsl:with-param name="value">M_PAYM_DATE</xsl:with-param>
				</xsl:call-template>
			 )</SMALL></TD></TR>
          </TABLE>
        </TD>
      </TR></TABLE>
    </TD>
  </TR>
  </TABLE>
  <HR />
  <TABLE cellSpacing="0" cellPadding="1" width="100%" border="0">
  <TR>
    <TD vAlign="center" align="left" width="38%" height="230">
      <TABLE border="0" width="100%" height="100%">
        <TR><TD align="left" valign="top"><BIG>
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_KVIT</xsl:with-param>
            </xsl:call-template>
        </BIG></TD></TR>
        <TR><TD align="left" valign="bottom">
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_KASSIR</xsl:with-param>
            </xsl:call-template>
        </TD></TR>
      </TABLE>
    </TD>
    <TD vAlign="top" align="left" width="62%">
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAYM_RECV</xsl:with-param>
            </xsl:call-template>
        : <B>
            <xsl:value-of select="key('data_key','payment_recv')/value"/>
        </B>,<BR />
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_INN</xsl:with-param>
            </xsl:call-template>
        : <B>
            <xsl:value-of select="key('data_key','inn')/value"/>
        </B><BR />
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_R_SCHET</xsl:with-param>
            </xsl:call-template>
        : <B>
            <xsl:value-of select="key('data_key','bank_account')/value"/>
        </B><xsl:text>&#x20;</xsl:text><xsl:value-of select="key('data_key','bank_name')/value"/> , <xsl:value-of select="key('data_key','bank_city')/value"/><BR />
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_BANK_BIC</xsl:with-param>
            </xsl:call-template>
        : <B><xsl:value-of select="key('data_key','bank_bic')/value"/></B>,
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_K_SCHET</xsl:with-param>
            </xsl:call-template>
        <B><xsl:text>&#x20;</xsl:text><xsl:value-of select="key('data_key','bank_ks')/value"/></B>
      <HR />
      <DIV align="center">
        <BIG><xsl:value-of select="key('data_key','full_name')/value"/></BIG><HR size="1" /><SMALL>(
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_F_I_O</xsl:with-param>
            </xsl:call-template>
        )</SMALL>
      </DIV>
      <TABLE border="1" cellspacing="0" width="100%">
        <TR>
          <TD align="center"><B>
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_BASIC_ACCOUNT</xsl:with-param>
            </xsl:call-template>
            </B></TD>
          <TD align="center"><B>
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAY_TYPE</xsl:with-param>
            </xsl:call-template>
            </B></TD>
          <TD align="center"><B>
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAY_SUM</xsl:with-param>
            </xsl:call-template>
            </B></TD>
        </TR><TR>
          <TD valign="middle" align="center"><STRONG><xsl:value-of select="key('data_key','basic_account')/value"/></STRONG></TD>
          <TD valign="middle" align="left">
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_PAY_COMM</xsl:with-param>
            </xsl:call-template>
            <BR /></TD>
          <TD valign="middle" align="right"><STRONG><TEXT> </TEXT></STRONG><BIG><xsl:value-of select="key('data_key','psum')/value"/></BIG></TD>
        </TR>
      </TABLE>
            <xsl:call-template name="dict">
            <xsl:with-param name="value">M_ADDRESS</xsl:with-param>
            </xsl:call-template>
        : <xsl:value-of select="key('data_key','actual_address')/value"/> <HR size="1"/>
      <TABLE border="0" width="100%" cellspacing="0" cellpadding="0"><TR>
        <TD align="right" valign="top">
          <TABLE border="0" cellspacing="0" cellpadding="0">
            <TR><TD><BIG>_________________</BIG></TD></TR>
            <TR><TD align="center"><SMALL>(
                <xsl:call-template name="dict">
                <xsl:with-param name="value">M_PAYER_SIG</xsl:with-param>
                </xsl:call-template>
            )</SMALL></TD></TR>
          </TABLE>
        </TD>
        <TD align="left" valign="top">
          <TABLE border="0" cellspacing="0" cellpadding="0">
            <TR><TD><BIG>"____"_________<TEXT> </TEXT>200___<TEXT> </TEXT></BIG></TD></TR>
            <TR><TD align="center"><SMALL>(
                <xsl:call-template name="dict">
                <xsl:with-param name="value">M_PAYM_DATE</xsl:with-param>
                </xsl:call-template>
             )</SMALL></TD></TR>
          </TABLE>
        </TD>
      </TR></TABLE>
    </TD>
  </TR>
  </TABLE>
<HR />
</xsl:template>

</xsl:stylesheet>
