#!/usr/bin/perl
use Time::Local;
$old_date = time;
$acct_port = 1813;
$radgen_path = "/netup/utm5/bin/utm5_radgen";

$4{1} = 360;
$4{2} = 720;
$4{3} = 1080;

$5{1} = 360;
$5{2} = 720;
$5{3} = 1080;

$6{1} = 360;
$6{2} = 720;
$6{3} = 1080;

$login{1} = "dialup1";
$login{2} = "dialup2";
$login{3} = "dialup3";

#Set start date 1 april 2003 11:00 
#system ("date 0304011100 > /dev/null");

$work_date = timelocal (0,0,11,1,3,103);

if($^O eq "linux"){
	$linux = 1;
};

if($^O eq "solaris"){
	$solaris = 1;
};

while ($mon < 6){
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime($work_date);
  $work_date_norm = localtime ($work_date);
  $mon = $mon + 1;
  if($mon < 10){
	if($linux || $solaris){
  		$sys_date = "0".$mon;
	}else{
  		$sys_date = "03"."0".$mon;
	};
  }else{
	if($linux || $solaris){
  		$sys_date = $mon;
	}else{
  		$sys_date = "03".$mon;
	};
   };
  if($mday < 10){
	$sys_date = $sys_date."0".$mday;
  }else{
	$sys_date = $sys_date.$mday;
   };


  $tmp_date = $sys_date."1000";
  $tmp1_date = $sys_date."2200";
  $sys_date = $sys_date."1100";

  if($linux || $solaris){
	$sys_date = $sys_date."03";
	$tmp_date = $tmp_date."03";
	$tmp1_date = $tmp1_date."03";
  };

  print "work_date:$work_date_norm sys_date:$sys_date\n";

  # Set new date
  system("date $tmp_date");
  #sleep (2);
  #send -HUP to core
  sendhup();
  system("date $sys_date");

  # Send radius accounting packets
  for($i=1; $i<4; $i++){
	$sec = $$mon{$i};
	$cur_login = $login{$i};
	print ("Sending Accounting packet for user:$i login:$cur_login time:$sec \n");
	# Start packet
  	system("$radgen_path -h 127.0.0.1 -p $acct_port -s secret -a 0:1:0:$cur_login -a 0:32:0:localhost -a 0:40:1:1 -a 0:44:0:sessionid_$cur_login_$tmp_date -c 4"); 
	sleep (2);
	# Stop packet
  	system("$radgen_path -h 127.0.0.1 -p $acct_port -s secret -a 0:1:0:$cur_login -a 0:32:0:localhost -a 0:40:1:2 -a 0:44:0:sessionid_$cur_login_$tmp_date -a 0:46:1:$sec -c 4"); 
	sleep (2);
  };


  $work_date = $work_date + 86400;
  system("date $tmp1_date");

  # Send radius accounting packets
  for($i=1; $i<4; $i++){
	$sec = $$mon{$i};
	$cur_login = $login{$i};
	print ("Sending Accounting packet for user:$i login:$cur_login time:$sec \n");
	# Start packet
  	system("$radgen_path -h 127.0.0.1 -p $acct_port -s secret -a 0:1:0:$cur_login -a 0:32:0:localhost -a 0:40:1:1 -a 0:44:0:sessionid_$cur_login_$tmp_date -c 4"); 
	sleep (2);
	# Stop packet
  	system("$radgen_path -h 127.0.0.1 -p $acct_port -s secret -a 0:1:0:$cur_login -a 0:32:0:localhost -a 0:40:1:2 -a 0:44:0:sessionid_$cur_login_$tmp_date -a 0:46:1:$sec -c 4"); 
	sleep (2);
  };
  #sleep (2);
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime($work_date);
};

# Set system date to 1 july 2003
if($linux || $solaris){
  system ("date 0701000103");
}else{
  system ("date 0307010001");
};

sendhup();

print ("Return system date after all tests complete\n");


sub sendhup(){
  #send -HUP to core
  if($linux){
        system("killall -HUP utm5_core");
        sleep (6);
        system("killall -HUP utm5_core");
  };
  if($solaris){
        system("kill -HUP `cat /var/run/utm5_core.pid`");
        sleep (6);
        system("kill -HUP `cat /var/run/utm5_core.pid`");
  };

};
