#!/usr/bin/perl
use Time::Local;
$old_date = time;
$nf_port = 9996;

if($^O =~ m/.*Win32.*/){
	$flowgen_path = "utm5_flowg.exe";
}else{
	$flowgen_path = "/netup/utm5/bin/utm5_flowgen";
};

$4{1} = 0.5;
$4{2} = 2;
$4{3} = 4;
$4{4} = 10;
$4{5} = 40;

$5{1} = 1;
$5{2} = 2.5;
$5{3} = 5;
$5{4} = 20;
$5{5} = 50;

$6{1} = 1.5;
$6{2} = 3;
$6{3} = 6;
$6{4} = 30;
$6{5} = 60;

$ip{1} = "10.10.10.10";
$ip{2} = "10.10.10.11";
$ip{3} = "10.10.10.12";
$ip{4} = "10.10.10.13";
$ip{5} = "10.10.10.14";

#Set start date 1 april 2003 11:00 

printf "Running on:$^O \n";

$work_date = timelocal (0,0,0,1,3,103);

while ($ret_mon < 7){
  #set_date($work_date); #10:00
  sendhup();
  $ret_mon = set_date($work_date + 3600*10); #10:00

  # Send traffic
  for($i=1; $i<6; $i++){
	$mbytes = $$ret_mon{$i} * 1048576;
	$dst_ip = $ip{$i};
	$flowgen_cmd = $flowgen_path." -s 0.0.0.0 -c 1 -h 127.0.0.1 -p ".$nf_port." -b ".$mbytes." -d ".$dst_ip." >> flowgen.log";
	print ("Executing command:$flowgen_cmd\n");
	system("$flowgen_cmd");
  };

  $work_date = $work_date + 86400;
  $ret_mon = set_date($work_date); #00:00 + 1 day
  if($prev_month != $ret_mon){
	printf("Month changed. Waiting 30 sec ...\n");
	sleep (30);
  };
  $prev_month = $ret_mon;
};

$work_date = timelocal (0,0,0,1,6,103);
set_date($work_date); #Set system date to 1 july 2003
exit (0);

sub sendhup();
print ("Return system date after all tests complete\n");
sub sendhup(){
  #send -HUP to core
  if($^O eq "linux"){
        system("killall -HUP utm5_core");
        sleep (6);
        system("killall -HUP utm5_core");
  };
  if($^O eq "solaris"){
	printf ("Sending HUP to utm5_core\n");
        system("kill -HUP `cat /var/run/utm5_core.pid`");
        sleep (6);
        system("kill -HUP `cat /var/run/utm5_core.pid`");
  };
};

sub set_date(){
  $timestamp = shift;
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime($timestamp);
  $mon = $mon + 1;
  $mon_or = $mon;
  $year = $year - 100;

  if ($mon < 10){$mon="0".$mon};
  if ($mday < 10){$mday="0".$mday};
  if($hour < 10){$hour="0".$hour};
  if($min < 10){$min="0".$min};
  if($year < 10){$year ="0".$year};

  if ($^O eq "linux" || $^O eq "solaris"){
	#linux and solaris: date $mon$mday$year$hour$min
	$sys_date = $mon.$mday;
	$sys_time = $hour.$min;
    system("date $sys_date$sys_time$year");
  }elsif($^O =~ m/.*Win32.*/){
	#windows: date mm-dd-yy; time h:m
	$sys_date = $mday."-".$mon."-".$year;
	$sys_time = $hour.":".$min;
    system("time $sys_time");
    system("date $sys_date");
  }else{
	#freebsd: date $year$mon$mday$hour$min
	$sys_date = $year.$mon.$mday;
	$sys_time = $hour.$min;
    system("date $sys_date$sys_time");
  };
  printf ("set_date sys_date:$sys_date sys_time:$sys_time \n"); 
  return $mon_or;
};
