#!/bin/sh
# e-mail:info@netup.ru
# Copyright (c) 2001-2004 NetUP Inc. <info@netup.ru>. All rights reserved.
#
#$Id: utm5_backup.sh 4516 2004-08-30 05:32:48Z aospan $


# Now all parametrs get from.cfg
. /netup/utm5/utm5.cfg

sqldump_path=`which mysqldump`
database_password=--password=$database_password
backup_path=/netup/utm5/backup
dst_dir=`date +%y_%m_%d`

#do database copy
if [ "$database_type" = "mysql" ]
then
echo "Database type mysql. Dumping and archiving database ... please wait."
$sqldump_path -u $database_login $database_password $database | gzip > $backup_path/UTM5.$dst_dir.gz
echo "Done."
fi

# if postgresql
if [ "$database_type" = "postgres" ]
then
echo "Database type postgres. Dumping and archiving database ... please wait."
pg_dump -U $database_login $database | gzip > $backup_path/UTM5.$dst_dir.gz 
echo "Done."
fi
