#!/usr/bin/perl
# e-mail:info@netup.ru
# Copyright (c) 2001-2005 NetUP Inc. <info@netup.ru>. All rights reserved.
#

use Socket;
use DBD::mysql;
use DBI();
use Time::Local;
use Getopt::Std;

$arp_command = "arp -a";
if($^O =~ m/(linux|freebsd)/){
	$arp_command = "arp -na";
};

#Load settings from config
open (CONFIG, "/netup/utm5/utm5.cfg");
@config = <CONFIG>;
close (CONFIG);
foreach $line (@config) {
  if ($line =~ m/^([^#].+?)=(.*)$/) {
    $$1 = $2;
  };
};

# Connect to the database
if ($database_type eq "mysql") {
  $DBI_data="DBI:$database_type:database=$database;host=$database_host;mysql_socket=$database_sock_path;";
} elsif ($database_type eq "postgres") {
  $DBI_data="DBI:$database_type:dbname=$database";
} else {
  print "Unknown database $database_type! Stopped. \n";
  exit (1);
};
$dbh = DBI->connect("$DBI_data","$database_login","$database_password",{'RaiseError' => 1});

open(MAC,"$arp_command|");
@mac = <MAC>;
close (MAC);
foreach (@mac){
	if ($_ =~ m/[^0-9]*([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)[^0-9]+(.{2}(:|-).{2}(:|-).{2}(:|-).{2}(:|-).{2}(:|-).{2}).+/){
		$bin_ip = unpack("N",inet_aton($1));
		$bin_ip =  $bin_ip > 2147483647 ? ($bin_ip - 0xFFFFFFFF - 1):$bin_ip;

		# insert obtained ip-mac into DB. Don't insert duplicates
		my $duplicated = 0;
		$q = "SELECT ip FROM temp_ip WHERE ip=$bin_ip LIMIT 1";
		$sth = $dbh->prepare( $q );
		$sth->execute();
		while( $zzz = $sth->fetchrow_hashref )
		{
			$duplicated = 1;
		};
		if (!$duplicated){
			$dbh->do("INSERT INTO temp_ip (ip, mac) VALUES ($bin_ip, '$2')");
			printf ("Inserted ip/mac $1/$2 to database \n");
		};
	};
};
