--
-- Table structure for table `access_log`
--

CREATE TABLE access_log (
  id int(11) NOT NULL auto_increment,
  who int(11) default '0',
  login_date int(11) default '0',
  logout_date int(11) default '0',
  ip int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `access_log`
--



--
-- Table structure for table `account_invoice`
--

CREATE TABLE account_invoice (
  id int(11) NOT NULL auto_increment,
  is_printed int(11) default '0',
  invc_id int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `account_invoice`
--



--
-- Table structure for table `account_tariff_link`
--

CREATE TABLE account_tariff_link (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default '0',
  tariff_id int(11) default '0',
  next_tariff_id int(11) default '0',
  discount_period_id int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `account_tariff_link`
--



--
-- Table structure for table `accounts`
--

CREATE TABLE accounts (
  id int(11) NOT NULL auto_increment,
  balance double default '0',
  account_name varchar(255) default '',
  credit double default '0',
  flags int(11) default '0',
  discount_period_id int(11) default '0',
  is_blocked int(11) default '0',
  dealer_account_id int(11) default '0',
  comission_coef double default '0',
  default_comission_value double default '0',
  is_dealer int(11) default '0',
  vat_rate double default '0',
  sale_tax_rate double default '0',
  int_status int(11) default '0',
  dont_charge_if_block int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `accounts`
--


INSERT INTO accounts VALUES (1,0,'auto create account',0,1,0,0,0,0,0,0,0,0,1,0,0);
INSERT INTO accounts VALUES (2,0,'auto create account',0,1,0,0,0,0,0,0,0,0,1,0,0);
INSERT INTO accounts VALUES (3,0,'auto create account',0,1,0,0,0,0,0,0,0,0,1,0,0);

--
-- Table structure for table `acts`
--

CREATE TABLE acts (
  id int(11) NOT NULL auto_increment,
  act_id int(11) default NULL,
  invc_id int(11) default NULL,
  gen_date int(11) default NULL,
  act_text text,
  is_sign int(11) default '0',
  sign_date int(11) default '0',
  doc_type int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `acts`
--



--
-- Table structure for table `acts_templates`
--

CREATE TABLE acts_templates (
  id int(11) NOT NULL auto_increment,
  act_id int(11) default NULL,
  is_old int(11) default NULL,
  gen_date int(11) default NULL,
  act_name varchar(255) default NULL,
  act_text text,
  doc_type int(11) default NULL,
  def int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `acts_templates`
--


INSERT INTO acts_templates VALUES (1,1,0,1090567022,'Acts - test','<html><head> <style> td { FONT: 9px Times New Roman; } h1 { FONT: 9px Arial; } </style> </head> <table align=center width=\"85\\%\"> <tr><td> <!--   --> <h1 align=center> <b>    </b> </h1> <!--       --> <!--         --> </td></tr> </table> </html>',1,1);
INSERT INTO acts_templates VALUES (2,2,0,1090567022,'User instruction - test','<html><head><style> body  { FONT: 9px Times New Roman; } h1 { FONT: 9px Arial; } </style> </head> <body> <table width=\"60%\"> <tr> <td> <h1 align=\"center\"> <b>   @USR_FULL_NAME@ </b> </h1> <h1>  @USR_FULL_NAME@!       @SUP_NAME@.  <br>     @SUP_FACT_ADDR@.  <br> <br> <b>  :</b> <br> :  @USR_LOGIN@ <br> : @USR_PASSWORD@ <br>   :  @USR_BASIC_ACOUNT@  <br> : @USR_TAX@ <br> : @USR_KPP@ <br> </h1> <b> IP :</b>  <br> @USR_IPS@ </td></tr></body></html>',2,1);
INSERT INTO acts_templates VALUES (3,3,0,1090567022,'Contract - test','<html><head><style> td  { FONT: 9px Times New Roman; } h1 { FONT: 9px Arial; }</style></head><table align=center width=\"85%\"><tr><td><!--   --><h1 align=center> <b>     </b> </h1><!--       --> @SUP_NAME@     @USR_FULL_NAME@          . <br><br>: <b>@USR_LOGIN@</b>; <br>: <b>@USR_PASSWORD@</b>; <br><!--         --></td></tr></table></html>',3,1);
INSERT INTO acts_templates VALUES (4,4,0,1090567022,'Receipt - test','<html><head><style> td  { FONT: 9px Times New Roman; } h1 { FONT: 9px Arial; }</style></head><table align=center width=\"85%\"><tr><td><!--   --><h1 align=center> <b>     </b> </h1><!--       -->: @USR_FULL_NAME@ <br> : @USR_LOGIN@ <br> : @PAY_SUM_INC_URR@ <br> : @PAY_CURR_ID@(@PAY_CURR_BRIEF_NAME@) - @PAY_CURR_FULL_NAME@ <br>: @PAY_CURR_RATE@ <br>   : @DOC_GEN_TIME@ <br><!--         --> </td></tr></table></html>',4,1);

--
-- Table structure for table `banks`
--

CREATE TABLE banks (
  id int(11) NOT NULL auto_increment,
  bic varchar(255) default NULL,
  name text,
  city varchar(255) default NULL,
  kschet varchar(255) default NULL,
  PRIMARY KEY  (id),
  KEY first_ba (bic)
) TYPE=MyISAM;

--
-- Dumping data for table `banks`
--


INSERT INTO banks VALUES (1,'044525762','First Bank','Moscow','30101810400000000768');

--
-- Table structure for table `blocks_info`
--

CREATE TABLE blocks_info (
  id int(11) NOT NULL auto_increment,
  user_id int(11) default NULL,
  account_id int(11) default NULL,
  slink_id int(11) default NULL,
  what_blocked int(11) default '0',
  block_type int(11) default '0',
  start_date int(11) default '0',
  expire_date int(11) default '2000000000',
  is_planning int(11) default '0',
  is_deleted int(11) default '0',
  service_id int(11) default NULL,
  unabon int(11) default NULL,
  unprepay int(11) default NULL,
  comment varchar(255) default NULL,
  PRIMARY KEY  (id),
  KEY first_block (start_date,expire_date,account_id,is_deleted,what_blocked)
) TYPE=MyISAM;

--
-- Dumping data for table `blocks_info`
--

INSERT INTO blocks_info VALUES (1,1,0,0,1,2,1049177177,2000000000,0,1,0,1,1,NULL);
INSERT INTO blocks_info VALUES (2,2,0,0,1,2,1049177213,2000000000,0,1,0,1,1,NULL);
INSERT INTO blocks_info VALUES (3,3,0,0,1,2,1049177251,2000000000,0,1,0,1,1,NULL);


--
-- Table structure for table `card_info`
--

CREATE TABLE card_info (
  id int(11) NOT NULL auto_increment,
  pool_id int(11) default '0',
  secret varchar(255) default NULL,
  balance double default '0',
  currency int(11) default '0',
  expiration int(11) default '2000000000',
  is_used int(11) default '0',
  service_id int(11) default '0',
  PRIMARY KEY  (id),
  KEY first_car (pool_id)
) TYPE=MyISAM;

--
-- Dumping data for table `card_info`
--


INSERT INTO card_info VALUES (1,1,'card',10,0,2000000000,0,0);
INSERT INTO card_info VALUES (2,1,'card',20,0,2000000000,0,0);
INSERT INTO card_info VALUES (3,0,'card',30,0,2000000000,0,0);

--
-- Table structure for table `card_pool_info`
--

CREATE TABLE card_pool_info (
  pool_id int(11) NOT NULL auto_increment,
  cards int(11) default '0',
  cards_used int(11) default '0',
  last_update int(11) default '0',
  first_update int(11) default '0',
  PRIMARY KEY  (pool_id)
) TYPE=MyISAM;

--
-- Dumping data for table `card_pool_info`
--


INSERT INTO card_pool_info VALUES (1,2,0,0,0);

--
-- Table structure for table `contracts`
--

CREATE TABLE contracts (
  id int(11) NOT NULL auto_increment,
  contract_number varchar(255) default NULL,
  date int(11) default '0',
  contract_text text,
  uid int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `contracts`
--



--
-- Table structure for table `contracts_templates`
--

CREATE TABLE contracts_templates (
  id int(11) NOT NULL auto_increment,
  contract_number varchar(255) default NULL,
  date int(11) default '0',
  contract_text text,
  template_name varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `contracts_templates`
--



--
-- Table structure for table `currency_list`
--

CREATE TABLE currency_list (
  id int(11) NOT NULL auto_increment,
  currency_brief_name varchar(255) default NULL,
  currency_full_name varchar(255) default NULL,
  percent double default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `currency_list`
--


INSERT INTO currency_list VALUES (840,'USD','USA Dollar',0,0);
INSERT INTO currency_list VALUES (810,'RUR','Russian Rouble',0,0);
INSERT INTO currency_list VALUES (978,'EUR','Euro',0,0);

--
-- Table structure for table `currency_rates`
--

CREATE TABLE currency_rates (
  id int(11) NOT NULL auto_increment,
  currency_id int(11) default NULL,
  date int(11) default NULL,
  currency_rate double default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `currency_rates`
--


INSERT INTO currency_rates VALUES (1,810,1070491240,1);
INSERT INTO currency_rates VALUES (2,978,1070491247,34.6813);
INSERT INTO currency_rates VALUES (3,840,1070491244,29.9441);

--
-- Table structure for table `dealer_transactions`
--

CREATE TABLE dealer_transactions (
  id int(11) NOT NULL auto_increment,
  comission double default NULL,
  discount_transaction_id int(11) default '0',
  payment_transaction_id int(11) default '0',
  is_canceled int(11) default '0',
  cancel_id int(11) default '0',
  account_id int(11) default NULL,
  dealer_account_id int(11) default NULL,
  date int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dealer_transactions`
--



--
-- Table structure for table `dhs_access_log`
--

CREATE TABLE dhs_access_log (
  id int(11) NOT NULL auto_increment,
  recv_date int(11) default '0',
  User_Name varchar(255) default '',
  Service_Type int(11) default '0',
  Framed_Protocol int(11) default '0',
  NAS_IP_Address int(11) default '0',
  NAS_Id varchar(255) default '',
  is_success int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_access_log`
--



--
-- Table structure for table `dhs_sessions_detail`
--

CREATE TABLE dhs_sessions_detail (
  id int(11) NOT NULL auto_increment,
  dhs_sess_id int(11) default '0',
  trange_id int(11) default '0',
  recv_date int(11) default '0',
  account_id int(11) default '0',
  disc_per_id int(11) default '0',
  slink_id int(11) default '0',
  duration bigint(20) default '0',
  base_cost double default '0',
  sum_cost double default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_sessions_detail`
--



--
-- Table structure for table `dhs_sessions_log`
--

CREATE TABLE dhs_sessions_log (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default '0',
  slink_id int(11) default '0',
  recv_date int(11) default '0',
  last_update_date int(11) default '0',
  Framed_IP_Address int(11) default '0',
  NAS_Port int(11) default '0',
  Acct_Delay_Time int(11) default '0',
  Acct_Session_Id varchar(255) default '',
  NAS_Port_Type int(11) default '0',
  User_Name varchar(255) default '',
  Service_Type int(11) default '0',
  Framed_Protocol int(11) default '0',
  NAS_IP_Address int(11) default '0',
  NAS_Id varchar(255) default '',
  Acct_Status_Type int(11) default '0',
  Acct_Input_Packets bigint(20) default '0',
  Acct_Input_Octets bigint(20) default '0',
  Acct_Output_Packets bigint(20) default '0',
  Acct_Output_Octets bigint(20) default '0',
  Acct_Session_Time bigint(20) default '0',
  Called_Station_Id varchar(255) default NULL,
  Calling_Station_Id varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_sessions_log`
--



--
-- Table structure for table `dialup_cost_info`
--

CREATE TABLE dialup_cost_info (
  dialup_cost_info_id int(11) default NULL,
  timerange_id int(11) default NULL,
  cost double default NULL
) TYPE=MyISAM;

--
-- Dumping data for table `dialup_cost_info`
--


INSERT INTO dialup_cost_info VALUES (1,3,1);
INSERT INTO dialup_cost_info VALUES (1,2,2);

--
-- Table structure for table `dialup_service_links`
--

CREATE TABLE dialup_service_links (
  id int(11) NOT NULL auto_increment,
  time_in_curr_disc_period int(11) default '0',
  old_time int(11) default '0',
  login varchar(255) default 'dialup',
  password varchar(255) default 'dialup',
  allowed_cid varchar(255) default '',
  allowed_csid varchar(255) default '',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dialup_service_links`
--


INSERT INTO dialup_service_links VALUES (1,0,0,'dialup1','123','','',0);
INSERT INTO dialup_service_links VALUES (2,0,0,'dialup2','123','','',0);
INSERT INTO dialup_service_links VALUES (3,0,0,'dialup3','123','','',0);

--
-- Table structure for table `dialup_services_data`
--

CREATE TABLE dialup_services_data (
  id int(11) NOT NULL auto_increment,
  dialup_cost_info_id int(11) default NULL,
  null_service_prepaid int(11) default '1',
  pool_name varchar(255) default 'dialup',
  max_timeout int(11) default '86400',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dialup_services_data`
--


INSERT INTO dialup_services_data VALUES (1,1,1,'TEST',72000,0);

--
-- Table structure for table `dir_zones`
--

CREATE TABLE dir_zones (
  id int(11) NOT NULL auto_increment,
  zone_id int(11) default '0',
  dir_id int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dir_zones`
--



--
-- Table structure for table `discount_periods`
--

CREATE TABLE discount_periods (
  id int(11) NOT NULL auto_increment,
  start_date int(11) default NULL,
  end_date int(11) default NULL,
  periodic_type int(11) default NULL,
  next_discount_period_id int(11) default '0',
  canonical_len int(11) default NULL,
  is_expired int(11) default '0',
  PRIMARY KEY  (id),
  KEY first (is_expired)
) TYPE=MyISAM;

--
-- Dumping data for table `discount_periods`
--


INSERT INTO discount_periods VALUES (1,0,2000000000,1,0,2000000000,0);
INSERT INTO discount_periods VALUES (2,unix_timestamp('2003-04-01 00:00:00'),unix_timestamp('2003-05-01 00:00:00'),3,0,2592000,0);

--
-- Table structure for table `discount_transactions_all`
--

CREATE TABLE discount_transactions_all (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default NULL,
  incoming_rest double default NULL,
  outgoing_rest double default NULL,
  discount double default NULL,
  discount_without_tax double default NULL,
  discount_with_tax double default NULL,
  service_id int(11) default NULL,
  service_type int(11) default NULL,
  discount_period_id int(11) default NULL,
  slink_id int(11) default NULL,
  discount_date int(11) default NULL,
  comment varchar(255) default NULL,
  dealer_transaction_id int(11) default NULL,
  dealer_payment_transaction_id int(11) default NULL,
  is_canceled int(11) default '0',
  cancel_id int(11) default '0',
  PRIMARY KEY  (id),
  KEY first_disc (discount_date,account_id)
) TYPE=MyISAM;

--
-- Dumping data for table `discount_transactions_all`
--



--
-- Table structure for table `discount_transactions_iptraffic_all`
--

CREATE TABLE discount_transactions_iptraffic_all (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default NULL,
  discount double default NULL,
  discount_with_tax double default NULL,
  service_id int(11) default NULL,
  discount_period_id int(11) default NULL,
  slink_id int(11) default NULL,
  discount_date int(11) default NULL,
  discount_date_hour int(11) default NULL,
  discount_date_day int(11) default NULL,
  discount_date_month int(11) default NULL,
  t_class int(11) default '0',
  base_cost double default '0',
  ipid int(11) default '0',
  bytes bigint(20) default NULL,
  is_canceled int(11) default '0',
  cancel_id int(11) default '0',
  PRIMARY KEY  (id),
  KEY first_dtr (discount_date,account_id,slink_id)
) TYPE=MyISAM;

--
-- Dumping data for table `discount_transactions_iptraffic_all`
--



--
-- Table structure for table `downloaded`
--

CREATE TABLE downloaded (
  downloaded_id int(11) default NULL,
  tclass_id int(11) default NULL,
  qnt bigint(20) default '0',
  old_prepay bigint(20) default '0',
  custom_prepay bigint(20) default '0',
  downed_as_prepaid bigint(20) default '0',
  discounted double default '0',
  traffic_quota bigint(20) default '0',
  is_deleted int(11) default '0',
  KEY first_dow (downloaded_id,tclass_id)
) TYPE=MyISAM;

--
-- Dumping data for table `downloaded`
--



--
-- Table structure for table `dtagg_cust`
--

CREATE TABLE dtagg_cust (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default '0',
  discounted double default '0',
  discounted_without_tax double default '0',
  exp_date int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_cust`
--



--
-- Table structure for table `dtagg_hotspot`
--

CREATE TABLE dtagg_hotspot (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default '0',
  is_closed int(11) default '0',
  base_cost double default '0',
  discounted double default '0',
  discounted_without_tax double default '0',
  session_time int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_hotspot`
--



--
-- Table structure for table `dtagg_iptraffic`
--

CREATE TABLE dtagg_iptraffic (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default '0',
  is_closed int(11) default '0',
  base_cost double default '0',
  tclass int(11) default '0',
  ipid int(11) default '0',
  discounted double default '0',
  discounted_without_tax double default '0',
  bytes int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_iptraffic`
--



--
-- Table structure for table `dtagg_once`
--

CREATE TABLE dtagg_once (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default '0',
  is_closed int(11) default '0',
  discounted double default '0',
  discounted_without_tax double default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_once`
--



--
-- Table structure for table `dtagg_periodic`
--

CREATE TABLE dtagg_periodic (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default '0',
  is_closed int(11) default '0',
  discounted double default '0',
  discounted_without_tax double default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_periodic`
--



--
-- Table structure for table `dtagg_telephony`
--

CREATE TABLE dtagg_telephony (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default '0',
  is_closed int(11) default '0',
  base_cost double default '0',
  zone_id int(11) default '0',
  discounted double default '0',
  discounted_without_tax double default '0',
  duration int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_telephony`
--



--
-- Table structure for table `firewall_rules`
--

CREATE TABLE firewall_rules (
  id int(11) NOT NULL auto_increment,
  is_for_all int(11) default '0',
  uid int(11) default '0',
  group_id int(11) default '0',
  tariff_id int(11) default '0',
  rule_on varchar(255) default '',
  rule_off varchar(255) default '',
  router_id int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `firewall_rules`
--


INSERT INTO firewall_rules VALUES (1,0,1,0,0,'/sbin/ipfw add RULE_ID allow tcp from UIP/UBITS to any','/sbin/ipfw delete RULE_ID',1,0);
INSERT INTO firewall_rules VALUES (2,0,1,0,0,'/sbin/iptables -A FORWARD -s UIP/UBITS -j ACCEPT','/sbin/iptables -D FORWARD -s UIP/UBITS -j ACCEPT',2,0);
INSERT INTO firewall_rules VALUES (3,0,0,100,0,'/bin/echo -A FORWARD -s UIP/UBITS -j ACCEPT','/bin/echo -D FORWARD -s UIP/UBITS -j ACCEPT',2,0);

--
-- Table structure for table `groups`
--

CREATE TABLE groups (
  id int(11) NOT NULL auto_increment,
  group_name varchar(255) default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `groups`
--


INSERT INTO groups VALUES (1,'Administrators');
INSERT INTO groups VALUES (100,'Hotspot');
INSERT INTO groups VALUES (102,'Users');
INSERT INTO groups VALUES (200,'Guests');

--
-- Table structure for table `hotspot_cost_info`
--

CREATE TABLE hotspot_cost_info (
  hotspot_cost_info_id int(11) default NULL,
  timerange_id int(11) default NULL,
  cost double default NULL
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_cost_info`
--



--
-- Table structure for table `hotspot_service_links`
--

CREATE TABLE hotspot_service_links (
  id int(11) NOT NULL auto_increment,
  time_in_curr_disc_period int(11) default '0',
  old_time int(11) default '0',
  login varchar(255) default 'card',
  password varchar(255) default 'card',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_service_links`
--



--
-- Table structure for table `hotspot_services_data`
--

CREATE TABLE hotspot_services_data (
  id int(11) NOT NULL auto_increment,
  hotspot_cost_info_id int(11) default NULL,
  null_service_prepaid int(11) default '1',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_services_data`
--



--
-- Table structure for table `houses`
--

CREATE TABLE houses (
  id int(11) NOT NULL auto_increment,
  post_code varchar(255) default NULL,
  country varchar(255) default NULL,
  region varchar(255) default NULL,
  city varchar(255) default NULL,
  street varchar(255) default NULL,
  number varchar(255) default NULL,
  building varchar(255) default NULL,
  connect_date int(11) default NULL,
  ip_zone_id int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `houses`
--



--
-- Table structure for table `invoice_entry`
--

CREATE TABLE invoice_entry (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  invoice_id int(11) default '0',
  slink_id int(11) default '0',
  discount_period_id int(11) default '0',
  date int(11) default '0',
  qnt double default '0',
  base_cost double default '0',
  sum_cost double default '0',
  tax_amount double default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `invoice_entry`
--


--
-- Table structure for table `invoices`
--

CREATE TABLE invoices (
  id int(11) NOT NULL auto_increment,
  ext_num varchar(255) default NULL,
  invoice_date int(11) default '0',
  payment_transaction_id int(11) default '0',
  expire_date int(11) default '0',
  is_payed int(11) default '0',
  is_printed int(11) default '0',
  is_mailed int(11) default '0',
  uid int(11) default '0',
  account_id int(11) default '0',
  PRIMARY KEY  (id),
  KEY first_inv (account_id)
) TYPE=MyISAM;

--
-- Dumping data for table `invoices`
--


--
-- Table structure for table `ip_groups`
--

CREATE TABLE ip_groups (
  id int(11) NOT NULL auto_increment,
  ip_group_id int(11) default NULL,
  ip int(11) default '0',
  mask int(11) default '-1',
  uname varchar(64) default NULL,
  upass varchar(64) default NULL,
  mac varchar(32) default NULL,
  allowed_cid varchar(32) default NULL,
  create_date int(11) default '0',
  delete_date int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `ip_groups`
--



--
-- Table structure for table `ip_zones`
--

CREATE TABLE ip_zones (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `ip_zones`
--



--
-- Table structure for table `ip_zones_detail`
--

CREATE TABLE ip_zones_detail (
  id int(11) NOT NULL auto_increment,
  ip_zone_id int(11) default NULL,
  net int(11) default NULL,
  mask int(11) default NULL,
  gateway int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `ip_zones_detail`
--



--
-- Table structure for table `iptraffic_borders`
--

CREATE TABLE iptraffic_borders (
  borders_id int(11) default NULL,
  border bigint(20) default NULL,
  cost double default NULL
) TYPE=MyISAM;

--
-- Dumping data for table `iptraffic_borders`
--



--
-- Table structure for table `iptraffic_service_links`
--

CREATE TABLE iptraffic_service_links (
  id int(11) NOT NULL auto_increment,
  ip_group_id int(11) default NULL,
  downloaded_id int(11) default NULL,
  recalc_type int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `iptraffic_service_links`
--



--
-- Table structure for table `iptraffic_services_data`
--

CREATE TABLE iptraffic_services_data (
  id int(11) NOT NULL auto_increment,
  tst_id int(11) default NULL,
  null_service_prepaid int(11) default '1',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `iptraffic_services_data`
--



--
-- Table structure for table `license_info`
--

CREATE TABLE license_info (
  id int(11) NOT NULL auto_increment,
  module varchar(255) default NULL,
  version varchar(255) default 'current',
  hash varchar(255) default NULL,
  data text,
  date int(11) default '0',
  request int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `license_info`
--



--
-- Table structure for table `messages`
--

CREATE TABLE messages (
  id int(11) NOT NULL auto_increment,
  sender_id int(11) default NULL,
  receiver_id int(11) default NULL,
  subject varchar(255) default NULL,
  message text,
  send_date int(11) default NULL,
  is_for_all int(11) default '0',
  recv_date int(11) default '0',
  PRIMARY KEY  (id),
  KEY first_mes (receiver_id,send_date)
) TYPE=MyISAM;

--
-- Dumping data for table `messages`
--


--
-- Table structure for table `nas_info`
--

CREATE TABLE nas_info (
  id int(11) NOT NULL auto_increment,
  nas_id varchar(255) default '',
  auth_secret varchar(255) default '',
  acct_secret varchar(255) default '',
  nas_type int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `nas_info`
--


INSERT INTO nas_info VALUES (1,'void.lz','secret','secret',0,0);
INSERT INTO nas_info VALUES (2,'127.0.0.1','secret','secret',0,0);
INSERT INTO nas_info VALUES (3,'localhost','secret','secret',0,0);
INSERT INTO nas_info VALUES (4,'utm.netup.ru','secret','secret',0,0);

--
-- Table structure for table `once_service_data`
--

CREATE TABLE once_service_data (
  id int(11) NOT NULL auto_increment,
  cost double default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `once_service_data`
--



--
-- Table structure for table `once_service_links`
--

CREATE TABLE once_service_links (
  id int(11) NOT NULL auto_increment,
  discount_date int(11) default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `once_service_links`
--



--
-- Table structure for table `payment_methods`
--

CREATE TABLE payment_methods (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `payment_methods`
--


INSERT INTO payment_methods VALUES (1,'Cash payment');
INSERT INTO payment_methods VALUES (2,'Wire transfer');
INSERT INTO payment_methods VALUES (3,'Card payment');
INSERT INTO payment_methods VALUES (4,'Dealer comission');
INSERT INTO payment_methods VALUES (5,'Cash through dealer');
INSERT INTO payment_methods VALUES (6,'Payment through Rapida');

--
-- Table structure for table `payment_transactions`
--

CREATE TABLE payment_transactions (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default NULL,
  payment_incurrency double default NULL,
  currency_id int(11) default NULL,
  currency_rate double default NULL,
  payment_absolute double default NULL,
  actual_date int(11) default NULL,
  payment_enter_date int(11) default NULL,
  payment_ext_number varchar(255) default '',
  method int(11) default NULL,
  who_receive int(11) default NULL,
  comments_for_user varchar(255) default NULL,
  comments_for_admins varchar(255) default NULL,
  discount_transaction_id int(11) default '0',
  dealer_transaction_id int(11) default '0',
  is_canceled int(11) default '0',
  cancel_id int(11) default '0',
  PRIMARY KEY  (id),
  KEY first_ptr (actual_date,account_id)
) TYPE=MyISAM;

--
-- Dumping data for table `payment_transactions`
--


--
-- Table structure for table `payments_timed`
--

CREATE TABLE payments_timed (
  id int(11) NOT NULL auto_increment,
  payment_trans_id int(11) default '0',
  expire_date int(11) default '0',
  pay_date int(11) default '0',
  account_id int(11) default '0',
  payment_value double default '0',
  custagg_id int(11) default '0',
  is_passed int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `payments_timed`
--



--
-- Table structure for table `periodic_service_links`
--

CREATE TABLE periodic_service_links (
  id int(11) NOT NULL auto_increment,
  is_blocked int(11) default '0',
  discount_period_id int(11) default '0',
  discounted_in_curr_period double default '0',
  start_date int(11) default '0',
  is_planned int(11) default '1',
  expire_date int(11) default '2000000000',
  need_del int(11) default '0',
  unabon_period int(11) default '0',
  unprepay_period int(11) default '0',
  start_block_unabon int(11) default '0',
  start_block_unprepay int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `periodic_service_links`
--


INSERT INTO periodic_service_links VALUES (1,0,2,0,1042750800,0,2130706431,0,0,28,0,0,0);
INSERT INTO periodic_service_links VALUES (2,0,2,0,1042750800,0,2130706431,0,0,68,0,0,0);
INSERT INTO periodic_service_links VALUES (3,0,2,0,1042750800,0,2130706431,0,0,101,0,0,0);

--
-- Table structure for table `periodic_services_data`
--

CREATE TABLE periodic_services_data (
  id int(11) NOT NULL auto_increment,
  cost double default NULL,
  discount_method int(11) default NULL,
  start_date int(11) default '0',
  expire_date int(11) default '2000000000',
  radius_sessions_limit int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `periodic_services_data`
--


INSERT INTO periodic_services_data VALUES (1,10,3,1042750800,2130706431,0,0);

--
-- Table structure for table `permissions`
--

CREATE TABLE permissions (
  id int(11) NOT NULL auto_increment,
  fid int(11) default '0',
  sys_acc_id int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `permissions`
--



--
-- Table structure for table `pre_invoice`
--

CREATE TABLE pre_invoice (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default '0',
  discount_period_id int(11) default '0',
  tclass int(11) default '0',
  base_cost double default '0',
  qnt double default '0',
  sum_cost double default '0',
  sum_cost_with_tax double default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `pre_invoice`
--



--
-- Table structure for table `radius_data`
--

CREATE TABLE radius_data (
  id int(11) NOT NULL auto_increment,
  owner_id int(11) default NULL,
  owner_type int(11) default NULL,
  vendor int(11) default '0',
  attr int(11) default NULL,
  value text,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `radius_data`
--



--
-- Table structure for table `radius_pool_info`
--

CREATE TABLE radius_pool_info (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  ip int(11) default '0',
  mask int(11) default '-1',
  create_date int(11) default '0',
  delete_date int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `radius_pool_info`
--



--
-- Table structure for table `registration_info`
--

CREATE TABLE registration_info (
  name varchar(255) default NULL,
  country varchar(255) default NULL,
  region varchar(255) default NULL,
  city varchar(255) default NULL,
  address varchar(255) default NULL,
  email varchar(255) default NULL,
  tel varchar(255) default NULL,
  web varchar(255) default NULL,
  cert text,
  signed int(11) default '0'
) TYPE=MyISAM;

--
-- Dumping data for table `registration_info`
--


--
-- Table structure for table `routers_info`
--

CREATE TABLE routers_info (
  id int(11) NOT NULL auto_increment,
  router_type int(11) default '0',
  router_ip varchar(255) default '',
  login varchar(255) default '',
  password varchar(255) default '',
  router_comments varchar(255) default '',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `routers_info`
--


INSERT INTO routers_info VALUES (1,0,'127.0.0.1','','','Local FreeBSD',0);
INSERT INTO routers_info VALUES (2,0,'127.0.0.1','','','Local Linux iptables',0);
INSERT INTO routers_info VALUES (3,2,'10.1.2.99','netup','hzp','Remote Cisco 3620',0);

--
-- Table structure for table `service_links`
--

CREATE TABLE service_links (
  id int(11) NOT NULL auto_increment,
  user_id int(11) default NULL,
  account_id int(11) default NULL,
  service_id int(11) default NULL,
  tariff_link_id int(11) default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `service_links`
--


INSERT INTO service_links VALUES (1,1,1,1,0,0);
INSERT INTO service_links VALUES (2,2,2,1,0,0);
INSERT INTO service_links VALUES (3,3,3,1,0,0);

--
-- Table structure for table `services_data`
--

CREATE TABLE services_data (
  id int(11) NOT NULL auto_increment,
  service_type int(11) default NULL,
  service_name varchar(255) default NULL,
  comment varchar(255) default NULL,
  comission_value double default '0',
  is_deleted int(11) default '0',
  tariff_id int(11) default '0',
  parent_service_id int(11) default '0',
  link_by_default int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `services_data`
--


INSERT INTO services_data VALUES (1,5,'Dial-up service','',0,0,0,0,0);

--
-- Table structure for table `slink_tech_param`
--

CREATE TABLE slink_tech_param (
  id int(11) NOT NULL auto_increment,
  type_id int(11) default '0',
  param varchar(255) default '',
  reg_date int(11) default '0',
  slink_id int(11) default '0',
  passwd varchar(255) default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `slink_tech_param`
--



--
-- Table structure for table `slink_tech_param_type`
--

CREATE TABLE slink_tech_param_type (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  descr varchar(255) default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `slink_tech_param_type`
--


--
-- Table structure for table `special_accounts`
--

CREATE TABLE special_accounts (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  balance double default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `special_accounts`
--


INSERT INTO special_accounts VALUES (1,'cash account',0);
INSERT INTO special_accounts VALUES (2,'tax account',0);
INSERT INTO special_accounts VALUES (3,'profit account',0);

--
-- Table structure for table `special_transactions`
--

CREATE TABLE special_transactions (
  id int(11) NOT NULL auto_increment,
  transaction_type int(11) default '0',
  date int(11) default NULL,
  incoming_rest double default NULL,
  outgoing_rest double default NULL,
  payment_transaction_id int(11) default '0',
  discount_transaction_id int(11) default '0',
  dealer_transaction_id int(11) default '0',
  is_canceled int(11) default '0',
  cancel_id int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `special_transactions`
--



--
-- Table structure for table `supplier_info`
--

CREATE TABLE supplier_info (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  ur_adress varchar(255) default NULL,
  act_adress varchar(255) default NULL,
  inn varchar(255) default NULL,
  kpp varchar(255) default NULL,
  bank_id int(11) default NULL,
  account varchar(255) default NULL,
  fio_headman varchar(255) default NULL,
  fio_bookeeper varchar(255) default NULL,
  fio_headman_sh varchar(255) default NULL,
  fio_bookeeper_sh varchar(255) default NULL,
  name_sh varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `supplier_info`
--


INSERT INTO supplier_info VALUES (1,'\"NET Inc.\"','117419,Moscow, Lenina 2, B2/7','117419,Moscow,8/7','7722165','7722001',1,'1654136496','Ivanov Ivan Ivanovich','Sergey Sergeev','I. Ivanov','S.Sergeev','Net');

--
-- Table structure for table `system_accounts`
--

CREATE TABLE system_accounts (
  id int(11) NOT NULL auto_increment,
  login varchar(255) default NULL,
  password varchar(255) default NULL,
  ip int(11) default '0',
  mask int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `system_accounts`
--


INSERT INTO system_accounts VALUES (-1,'init','init',0,0);
INSERT INTO system_accounts VALUES (-2,'radius','radius',2130706433,-1);
INSERT INTO system_accounts VALUES (-3,'web','web',2130706433,-1);

--
-- Table structure for table `system_group_info`
--

CREATE TABLE system_group_info (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default '',
  info varchar(255) default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `system_group_info`
--


INSERT INTO system_group_info VALUES (1,'Wheel','MegaAdmins');
INSERT INTO system_group_info VALUES (2,'Cashier','Cashier');

--
-- Table structure for table `system_groups`
--

CREATE TABLE system_groups (
  group_id int(11) default '0',
  user_id int(11) default '0'
) TYPE=MyISAM;

--
-- Dumping data for table `system_groups`
--


INSERT INTO system_groups VALUES (1,-1);
INSERT INTO system_groups VALUES (1,-2);
INSERT INTO system_groups VALUES (1,-3);

--
-- Table structure for table `system_rights`
--

CREATE TABLE system_rights (
  group_id int(11) default '0',
  fid int(11) default '0'
) TYPE=MyISAM;

--
-- Dumping data for table `system_rights`
--


INSERT INTO system_rights VALUES (2,69);
INSERT INTO system_rights VALUES (2,4608);
INSERT INTO system_rights VALUES (2,8193);
INSERT INTO system_rights VALUES (2,8209);
INSERT INTO system_rights VALUES (2,9216);
INSERT INTO system_rights VALUES (2,10512);
INSERT INTO system_rights VALUES (2,12544);
INSERT INTO system_rights VALUES (2,12560);
INSERT INTO system_rights VALUES (2,20496);
INSERT INTO system_rights VALUES (2,69905);

--
-- Table structure for table `t_class`
--

CREATE TABLE t_class (
  id int(11) NOT NULL auto_increment,
  t_class_name varchar(255) default '',
  graph_color int(11) default '255',
  is_display int(11) default '0',
  is_fill int(11) default '0',
  time_range_id int(11) default '0',
  dont_save int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `t_class`
--


INSERT INTO t_class VALUES (10,'Incoming',255,1,0,0,0,0);
INSERT INTO t_class VALUES (20,'Outgoing',255,1,0,0,0,0);

--
-- Table structure for table `t_class_detail`
--

CREATE TABLE t_class_detail (
  id int(11) NOT NULL auto_increment,
  t_class_id int(11) NOT NULL default '0',
  saddr int(11) default '0',
  saddr_mask int(11) default '0',
  daddr int(11) default '0',
  daddr_mask int(11) default '0',
  sport int(11) default '0',
  dport int(11) default '0',
  input int(11) default '0',
  output int(11) default '0',
  src_as int(11) default '0',
  dst_as int(11) default '0',
  nexthop int(11) default '0',
  tcp_flags int(11) default '0',
  proto int(11) default '0',
  tos int(11) default '0',
  use_sport int(11) default '0',
  use_dport int(11) default '0',
  use_input int(11) default '0',
  use_output int(11) default '0',
  use_src_as int(11) default '0',
  use_dst_as int(11) default '0',
  use_nexthop int(11) default '0',
  use_tcp_flags int(11) default '0',
  use_proto int(11) default '0',
  use_tos int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `t_class_detail`
--


INSERT INTO t_class_detail VALUES (1,10,0,0,167772160,-16777216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,0,0,0,0,0);
INSERT INTO t_class_detail VALUES (2,20,167772160,-16777216,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,0,0,0,0,0);

--
-- Table structure for table `tariffs`
--

CREATE TABLE tariffs (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  create_date int(11) default '0',
  change_date int(11) default '0',
  who_change int(11) default '0',
  who_create int(11) default '0',
  expire_date int(11) default '0',
  is_blocked int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tariffs`
--



--
-- Table structure for table `tariffs_services_link`
--

CREATE TABLE tariffs_services_link (
  id int(11) NOT NULL auto_increment,
  tariff_id int(11) default '0',
  service_id int(11) default '0',
  q int(11) default '1',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tariffs_services_link`
--



--
-- Table structure for table `tel_directions`
--

CREATE TABLE tel_directions (
  id int(11) NOT NULL auto_increment,
  prefix varchar(255) default '',
  name varchar(255) default '',
  create_date int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_directions`
--



--
-- Table structure for table `tel_numbers`
--

CREATE TABLE tel_numbers (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default '0',
  tel_number varchar(255) default '',
  login varchar(255) default '',
  password varchar(255) default '',
  allowed_cid varchar(255) default '',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_numbers`
--



--
-- Table structure for table `tel_service_links`
--

CREATE TABLE tel_service_links (
  id int(11) NOT NULL auto_increment,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_service_links`
--



--
-- Table structure for table `tel_service_links_downloaded`
--

CREATE TABLE tel_service_links_downloaded (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default NULL,
  direction_id int(11) default NULL,
  downloaded int(11) default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_service_links_downloaded`
--



--
-- Table structure for table `tel_service_links_prepaid`
--

CREATE TABLE tel_service_links_prepaid (
  id int(11) NOT NULL auto_increment,
  slink_id int(11) default NULL,
  tarif_key int(11) default NULL,
  downed_as_prepaid int(11) default NULL,
  old_prepaid int(11) default NULL,
  custom_prepaid int(11) default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_service_links_prepaid`
--



--
-- Table structure for table `tel_services_borders`
--

CREATE TABLE tel_services_borders (
  id int(11) NOT NULL auto_increment,
  tel_service_id int(11) default NULL,
  tarif_key int(11) default NULL,
  border bigint(20) default NULL,
  cost double default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_borders`
--



--
-- Table structure for table `tel_services_data`
--

CREATE TABLE tel_services_data (
  id int(11) NOT NULL auto_increment,
  t_s_step int(11) default '1',
  t_s_free int(11) default '0',
  max_timeout int(11) default '86400',
  first_interval bigint(20) default '1',
  incremental_interval bigint(20) default '1',
  first_interval_around bigint(20) default '0',
  free_time bigint(20) default '0',
  fixed_call_cost double default '0',
  unit_size bigint(20) default '60',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_data`
--



--
-- Table structure for table `tel_services_prepaid`
--

CREATE TABLE tel_services_prepaid (
  id int(11) NOT NULL auto_increment,
  tel_service_id int(11) default NULL,
  tarif_key int(11) default NULL,
  prepaid bigint(20) default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_prepaid`
--



--
-- Table structure for table `tel_services_price`
--

CREATE TABLE tel_services_price (
  id int(11) NOT NULL auto_increment,
  service_id int(11) default NULL,
  zone_id int(11) default NULL,
  trange_id int(11) default NULL,
  cost double default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_price`
--



--
-- Table structure for table `tel_services_tr_mult`
--

CREATE TABLE tel_services_tr_mult (
  id int(11) NOT NULL auto_increment,
  tel_service_id int(11) default NULL,
  tarif_key int(11) default NULL,
  time_range_id int(11) default NULL,
  mult double default NULL,
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_tr_mult`
--



--
-- Table structure for table `tel_sessions_detail`
--

CREATE TABLE tel_sessions_detail (
  id int(11) NOT NULL auto_increment,
  dhs_sess_id int(11) default '0',
  recv_date int(11) default '0',
  trange_id int(11) default '0',
  account_id int(11) default '0',
  disc_per_id int(11) default '0',
  slink_id int(11) default '0',
  duration bigint(20) default '0',
  base_cost double default '0',
  sum_cost double default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_sessions_detail`
--



--
-- Table structure for table `tel_sessions_log`
--

CREATE TABLE tel_sessions_log (
  id int(11) NOT NULL auto_increment,
  account_id int(11) default '0',
  slink_id int(11) default '0',
  recv_date int(11) default '0',
  last_update_date int(11) default '0',
  zone_id int(11) default '0',
  did int(11) default '0',
  NAS_Port int(11) default '0',
  Acct_Delay_Time int(11) default '0',
  Acct_Session_Id varchar(255) default '',
  NAS_Port_Type int(11) default '0',
  User_Name varchar(255) default '',
  Service_Type int(11) default '0',
  Framed_Protocol int(11) default '0',
  NAS_IP_Address int(11) default '0',
  NAS_Id varchar(255) default '',
  Acct_Status_Type int(11) default '0',
  Acct_Input_Packets bigint(20) default '0',
  Acct_Input_Octets bigint(20) default '0',
  Acct_Output_Packets bigint(20) default '0',
  Acct_Output_Octets bigint(20) default '0',
  Acct_Session_Time bigint(20) default '0',
  Called_Station_Id varchar(255) default NULL,
  Calling_Station_Id varchar(255) default NULL,
  h323_remote_address varchar(255) default NULL,
  h323_conf_id varchar(255) default NULL,
  h323_setup_time varchar(255) default NULL,
  h323_call_origin varchar(255) default NULL,
  h323_call_type varchar(255) default NULL,
  h323_connect_time varchar(255) default NULL,
  h323_disconnect_time varchar(255) default NULL,
  h323_disconnect_cause varchar(255) default NULL,
  h323_gw_id varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_sessions_log`
--



--
-- Table structure for table `tel_zones`
--

CREATE TABLE tel_zones (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default '',
  create_date int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_zones`
--



--
-- Table structure for table `template_type`
--

CREATE TABLE template_type (
  id int(11) NOT NULL auto_increment,
  type_id int(11) default NULL,
  type_name varchar(255) default NULL,
  sys_doc int(11) default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `template_type`
--


INSERT INTO template_type VALUES (1,1,'Acts of end job',1);
INSERT INTO template_type VALUES (2,2,'User instruction',1);
INSERT INTO template_type VALUES (3,3,'Contract',1);
INSERT INTO template_type VALUES (4,4,'Receipt',1);

--
-- Table structure for table `time_range`
--

CREATE TABLE time_range (
  id int(11) NOT NULL auto_increment,
  time_range_name varchar(255) default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `time_range`
--


INSERT INTO time_range VALUES (1,'All day');
INSERT INTO time_range VALUES (2,'Day');
INSERT INTO time_range VALUES (3,'Night');

--
-- Table structure for table `time_range_detail`
--

CREATE TABLE time_range_detail (
  id int(11) NOT NULL auto_increment,
  time_range_id int(11) default '0',
  sec_start int(11) default '0',
  sec_stop int(11) default '0',
  min_start int(11) default '0',
  min_stop int(11) default '0',
  hour_start int(11) default '0',
  hour_stop int(11) default '0',
  wday_start int(11) default '0',
  wday_stop int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `time_range_detail`
--


INSERT INTO time_range_detail VALUES (1,1,0,59,0,59,0,23,0,6);
INSERT INTO time_range_detail VALUES (2,2,0,59,0,59,8,19,0,6);
INSERT INTO time_range_detail VALUES (3,3,0,59,0,59,20,23,0,6);
INSERT INTO time_range_detail VALUES (4,3,0,59,0,59,0,7,0,6);

--
-- Table structure for table `traf_serv_tclasses`
--

CREATE TABLE traf_serv_tclasses (
  tst_id int(11) default NULL,
  tclass_id int(11) default NULL,
  borders_id int(11) default NULL,
  prepaid_units bigint(20) default '0',
  group_id int(11) default '0',
  tariff_formula int(11) default '0'
) TYPE=MyISAM;

--
-- Dumping data for table `traf_serv_tclasses`
--



--
-- Table structure for table `user_contact_em`
--

CREATE TABLE user_contact_em (
  id int(11) NOT NULL auto_increment,
  name_position varchar(255) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `user_contact_em`
--


INSERT INTO user_contact_em VALUES (1,'CEO');
INSERT INTO user_contact_em VALUES (2,'Manager');
INSERT INTO user_contact_em VALUES (3,'Accountant');

--
-- Table structure for table `user_contacts`
--

CREATE TABLE user_contacts (
  id int(11) NOT NULL auto_increment,
  uid int(11) default NULL,
  person varchar(255) default NULL,
  descr text,
  contact text,
  email text,
  email_notice int(11) default '0',
  person_short varchar(128) default NULL,
  bday varchar(255) default NULL,
  id_exec_man int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `user_contacts`
--


INSERT INTO user_contacts VALUES (1,1,'Ivanov Uriy','CEO','Earth',NULL,0,'U.Ivanov','June 14 1969',1);
INSERT INTO user_contacts VALUES (2,1,'Juranova Julia','Accountant','Earth',NULL,0,'J.Juranova','October 12 1979',2);

--
-- Table structure for table `users`
--

CREATE TABLE users (
  id int(11) NOT NULL auto_increment,
  login varchar(255) default '',
  password varchar(255) default '',
  basic_account int(11) default '0',
  is_blocked int(11) default '0',
  discount_period_id int(11) default '0',
  create_date int(11) default NULL,
  last_change_date int(11) default NULL,
  who_create int(11) default NULL,
  who_change int(11) default NULL,
  is_juridical int(11) default '0',
  full_name text,
  juridical_address text,
  actual_address text,
  work_telephone varchar(255) default NULL,
  home_telephone varchar(255) default NULL,
  mobile_telephone varchar(255) default NULL,
  web_page varchar(255) default NULL,
  icq_number varchar(255) default NULL,
  tax_number varchar(255) default NULL,
  kpp_number varchar(255) default NULL,
  bank_id int(11) default '0',
  bank_account varchar(255) default NULL,
  email varchar(255) default NULL,
  house_id int(11) default NULL,
  flat_number varchar(255) default NULL,
  entrance varchar(255) default NULL,
  floor varchar(255) default NULL,
  passport varchar(255) default NULL,
  comments text,
  personal_manager varchar(255) default NULL,
  connect_date int(11) default NULL,
  remote_switch_id int(11) default '0',
  port_number int(11) default '0',
  personal_currency_coef double default '1',
  binded_currency_code int(11) default '810',
  is_deleted int(11) default '0',
  is_send_invoice int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `users`
--


INSERT INTO users VALUES (1,'dialup1','cbbce3',1,0,0,1049141303,1049140831,-1,-1,0,'','','','','','','','','','',0,'','',0,'','','','','','',-10800,0,0,1,810,0,0);
INSERT INTO users VALUES (2,'dialup2','3daaa4',2,0,0,1049140843,1049140869,-1,-1,0,'','','','','','','','','','',0,'','',0,'','','','','','',-10800,0,0,1,810,0,0);
INSERT INTO users VALUES (3,'dialup3','b85773',3,0,0,1049140880,1049140903,-1,-1,0,'','','','','','','','','','',0,'','',0,'','','','','','',-10800,0,0,1,810,0,0);

--
-- Table structure for table `users_accounts`
--

CREATE TABLE users_accounts (
  id int(11) NOT NULL auto_increment,
  uid int(11) default '0',
  account_id int(11) default '0',
  is_deleted int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `users_accounts`
--


INSERT INTO users_accounts VALUES (1,1,1,0);
INSERT INTO users_accounts VALUES (2,2,2,0);
INSERT INTO users_accounts VALUES (3,3,3,0);

--
-- Table structure for table `users_groups_link`
--

CREATE TABLE users_groups_link (
  id int(11) NOT NULL auto_increment,
  user_id int(11) default '0',
  group_id int(11) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `users_groups_link`
--



--
-- Table structure for table `utm5_settings`
--

CREATE TABLE utm5_settings (
  id int(11) NOT NULL auto_increment,
  variable varchar(255) default '',
  value text,
  change_date int(11) default NULL,
  PRIMARY KEY  (id),
  KEY first_set (variable)
) TYPE=MyISAM;

--
-- Dumping data for table `utm5_settings`
--


INSERT INTO utm5_settings VALUES (1,'smtp_relay','127.0.0.1',1057003200);
INSERT INTO utm5_settings VALUES (2,'smtp_port','25',1057003200);
INSERT INTO utm5_settings VALUES (3,'smtp_fqdn','localhost',1057003200);
INSERT INTO utm5_settings VALUES (4,'smtp_sender','admin@localhost',1057003200);
INSERT INTO utm5_settings VALUES (5,'smtp_subject','Message from UTM5',1057003200);
INSERT INTO utm5_settings VALUES (6,'admin_email','admin@localhost',1057003200);
INSERT INTO utm5_settings VALUES (7,'admin_email','admin@anotherhost',1057003200);
INSERT INTO utm5_settings VALUES (8,'sudo_path','/usr/bin/sudo',1057003200);
INSERT INTO utm5_settings VALUES (9,'web_session_timeout','3000',1057003200);
INSERT INTO utm5_settings VALUES (10,'hotspot_refresh_timeout','600',1057003200);
INSERT INTO utm5_settings VALUES (11,'hotspot_default_service','0',1057003200);
INSERT INTO utm5_settings VALUES (12,'notification_borders','-1',1057003200);
INSERT INTO utm5_settings VALUES (13,'notification_borders','0',1057003200);
INSERT INTO utm5_settings VALUES (14,'notification_borders','3',1057003200);
INSERT INTO utm5_settings VALUES (15,'raw_max_files','10',1057003200);
INSERT INTO utm5_settings VALUES (16,'raw_max_size','100000000',1057003200);
INSERT INTO utm5_settings VALUES (17,'raw_prefix','',1057003200);
INSERT INTO utm5_settings VALUES (18,'raw_cleanup_sleep','1800000000',1057003200);
INSERT INTO utm5_settings VALUES (19,'discount_barrier','0.1',1057003200);
INSERT INTO utm5_settings VALUES (20,'notification_borders','0.1 2 5',1057003200);
INSERT INTO utm5_settings VALUES (21,'bytes_in_kbyte','1024',1057003200);
INSERT INTO utm5_settings VALUES (22,'traffic_agregation_interval','900',1057003200);
INSERT INTO utm5_settings VALUES (23,'flow_discounts_per_period','64',1057003200);
INSERT INTO utm5_settings VALUES (24,'flow_discount_random_coef','0.0001',1057003200);
INSERT INTO utm5_settings VALUES (25,'aggregation_todisc_barrier','5',1057003200);
INSERT INTO utm5_settings VALUES (26,'notification_message',' , FULL_NAME !\n    : ACCOUNT_ID     \nBALANCE.\n : DATE\n    EMAIL\n , .',1057003200);
INSERT INTO utm5_settings VALUES (27,'notification_message_subject','',1057003200);
INSERT INTO utm5_settings VALUES (28,'notification_message_from','admin',1057003200);
INSERT INTO utm5_settings VALUES (29,'certificate','3082038030820268020100300d06092a864886f70d0101040500308185310b3009060355040613025255310f300d060355040813064d6f73636f77310f300d060355040713064d6f73636f77310e300c060355040a13054e657475703110300e060355040b130755544d20446576310d300b0603550403130455544d353123302106092a864886f70d010901161475746d646576407465616d2e6e657475702e7275301e170d3034303130313134353733335a170d3034303133313134353733335a308185310b3009060355040613025255310f300d060355040813064d6f73636f77310f300d060355040713064d6f73636f77310e300c060355040a13054e657475703110300e060355040b130755544d20446576310d300b0603550403130455544d353123302106092a864886f70d010901161475746d646576407465616d2e6e657475702e727530820122300d06092a864886f70d01010105000382010f003082010a0282010100d713fd63540621c7f84f4672b6b5bdc9ac5ef54a1c826363db7f73b6b5bdda9aa570c15558c5bc79e1af432139a806f8d9ab2ac0e97f28d413e25a05b9519fb54654e9a12649e33cd04cfdc62055e84e58aa1f68ffb7073295267035e1d89cd802a61483fbc23333e0b48f743ce23d148e2b26898691bf55468fc0d2446e5a7d6c3da6c1cf0c8ac0dd0a87040116bb4c29788e7d1310105007e8f030259101fa9a5548935e2ef15500d20a477a62626de8e6c3a105a368e8df226faf87988ed618a71473f47ba54819c7721989545130dbea78cb8d56839b88b607c40fa38cdf6a9771348b7a7a80afc180888dd2a38e53f2c2119283c7a8a2bba1bab3b2c71f0203010001300d06092a864886f70d01010405000382010100a8d3e31c290a9133b63f440cb4c005abb9fdea6d2b1f20163d5d91ab1801b80c570173a5c04ee8d172e5224dcb1cd94564b2b8373c4ca7bf5cef8a5526820c74463696a4dc42e476f1c9cfb63b25a2e1da18e32cd76dcd4645c13b599d901f357873c06adf953da77cf1cc96b36ccdaf961d21792ef63accbf98a09317a158f5ba2a645255392183ca5564908fc692f03e515a2837b4ba8713aeff03bf3953226f597a68ca4afa70acb72dc6f8c2cb957e8ae69879c2582d4b457cbf1a7e7a89242cd696f769956c8b228622aa711c3abf5a26fd234e5edcbe8c1aeb9fd0f4841ac33cb7eac889f37d76244193d59ef899861bb1f7562cdbc023212f587c9566',1057003200);

