-- Kontrolnyi primer for NetUP UTM 5 Billing System
-- Table structure for table `access_log`
--

CREATE TABLE `access_log` (
  `id` int(11) NOT NULL auto_increment,
  `who` int(11) default '0',
  `login_date` int(11) default '0',
  `logout_date` int(11) default '0',
  `ip` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `access_log`
--


--
-- Table structure for table `account_invoice`
--

CREATE TABLE `account_invoice` (
  `id` int(11) NOT NULL auto_increment,
  `payed_date` int(11) default '0',
  `is_printed` int(11) default '0',
  `invc_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `account_invoice`
--


--
-- Table structure for table `account_tariff_link`
--

CREATE TABLE `account_tariff_link` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `tariff_id` int(11) default '0',
  `next_tariff_id` int(11) default '0',
  `discount_period_id` int(11) default '0',
  `is_deleted` int(11) default '0',
  `link_date` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `account_tariff_link`
--


--
-- Table structure for table `accounts`
--

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL auto_increment,
  `balance` double default '0',
  `account_name` varchar(255) default '',
  `credit` double default '0',
  `discount_period_id` int(11) default '0',
  `is_blocked` int(11) default '0',
  `dealer_account_id` int(11) default '0',
  `comission_coef` double default '0',
  `default_comission_value` double default '0',
  `is_dealer` int(11) default '0',
  `vat_rate` double default '0',
  `sale_tax_rate` double default '0',
  `flags` int(11) default '0',
  `int_status` int(11) default '0',
  `dont_charge_if_block` int(11) default '0',
  `block_recalc_abon` int(11) default '0',
  `block_recalc_prepaid` int(11) default '0',
  `unlimited` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `accounts`
--

INSERT INTO `accounts` VALUES (1,0,'auto create account',0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0);
INSERT INTO `accounts` VALUES (2,0,'auto create account',0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0);
INSERT INTO `accounts` VALUES (3,0,'auto create account',0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0);
INSERT INTO `accounts` VALUES (4,0,'auto create account',0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0);
INSERT INTO `accounts` VALUES (5,0,'auto create account',0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0);

--
-- Table structure for table `acts`
--

CREATE TABLE `acts` (
  `id` int(11) NOT NULL auto_increment,
  `act_id` int(11) default NULL,
  `invc_id` int(11) default NULL,
  `gen_date` int(11) default NULL,
  `act_text` text,
  `is_sign` int(11) default '0',
  `sign_date` int(11) default '0',
  `doc_type` int(11) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `acts`
--


--
-- Table structure for table `acts_templates`
--

CREATE TABLE `acts_templates` (
  `id` int(11) NOT NULL auto_increment,
  `act_id` int(11) default NULL,
  `is_old` int(11) default NULL,
  `gen_date` int(11) default NULL,
  `act_name` varchar(255) default NULL,
  `act_text` text,
  `doc_type` int(11) default NULL,
  `def` int(11) default '0',
  `landscape` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `acts_templates`
--


--
-- Table structure for table `additional_ip_zones2houses`
--

CREATE TABLE `additional_ip_zones2houses` (
  `id` int(11) NOT NULL auto_increment,
  `house_key` int(11) default '0',
  `ip_zone_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `additional_ip_zones2houses`
--


--
-- Table structure for table `balance_history`
--

CREATE TABLE `balance_history` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `accounting_period_id` int(11) default '0',
  `out_balance` double default NULL,
  `date` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `balance_history`
--


--
-- Table structure for table `banks`
--

CREATE TABLE `banks` (
  `id` int(11) NOT NULL auto_increment,
  `bic` varchar(255) default NULL,
  `name` text,
  `city` varchar(255) default NULL,
  `kschet` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `first_ba` (`bic`)
) TYPE=MyISAM;

--
-- Dumping data for table `banks`
--

INSERT INTO `banks` VALUES (1,'044525762','First Bank','Moscow','30101810400000000768');

--
-- Table structure for table `blocks_info`
--

CREATE TABLE `blocks_info` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `account_id` int(11) default NULL,
  `slink_id` int(11) default NULL,
  `what_blocked` int(11) default '0',
  `block_type` int(11) default '0',
  `start_date` int(11) default '0',
  `expire_date` int(11) default '2000000000',
  `is_planning` int(11) default '0',
  `is_deleted` int(11) default '0',
  `service_id` int(11) default NULL,
  `unabon` int(11) default NULL,
  `unprepay` int(11) default NULL,
  `comment` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `first_block` (`start_date`,`expire_date`,`account_id`,`is_deleted`,`what_blocked`)
) TYPE=MyISAM;

--
-- Dumping data for table `blocks_info`
--

INSERT INTO `blocks_info` VALUES (1,1,0,0,1,2,1049177177,2000000000,0,1,0,1,1,NULL);
INSERT INTO `blocks_info` VALUES (2,2,0,0,1,2,1049177213,2000000000,0,1,0,1,1,NULL);
INSERT INTO `blocks_info` VALUES (3,3,0,0,1,2,1049177251,2000000000,0,1,0,1,1,NULL);
INSERT INTO `blocks_info` VALUES (4,4,0,0,1,2,1049177293,2000000000,0,1,0,1,1,NULL);
INSERT INTO `blocks_info` VALUES (5,5,0,0,1,2,1049177333,2000000000,0,1,0,1,1,NULL);

--
-- Table structure for table `card_info`
--

CREATE TABLE `card_info` (
  `id` int(11) NOT NULL auto_increment,
  `pool_id` int(11) default '0',
  `secret` varchar(255) default NULL,
  `balance` double default '0',
  `currency` int(11) default '0',
  `expiration` int(11) default '2000000000',
  `is_used` int(11) default '0',
  `service_id` int(11) default '0',
  `days` int(11) default '0',
  `is_blocked` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_car` (`pool_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `card_info`
--

INSERT INTO `card_info` VALUES (1,1,'card',10,0,2000000000,0,0,0,0);
INSERT INTO `card_info` VALUES (2,1,'card',20,0,2000000000,0,0,0,0);
INSERT INTO `card_info` VALUES (3,0,'card',30,0,2000000000,0,0,0,0);

--
-- Table structure for table `card_info_expired`
--

CREATE TABLE `card_info_expired` (
  `id` int(11) NOT NULL auto_increment,
  `card_id` int(11) default '0',
  `pool_id` int(11) default '0',
  `secret` varchar(255) default NULL,
  `balance` double default '0',
  `currency` int(11) default '0',
  `expiration` int(11) default '0',
  `is_used` int(11) default '0',
  `service_id` int(11) default '0',
  `days` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `card_info_expired`
--


--
-- Table structure for table `card_pool_info`
--

CREATE TABLE `card_pool_info` (
  `pool_id` int(11) NOT NULL auto_increment,
  `cards` int(11) default '0',
  `cards_used` int(11) default '0',
  `last_update` int(11) default '0',
  `first_update` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`pool_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `card_pool_info`
--

INSERT INTO `card_pool_info` VALUES (1,2,0,0,0,0);

--
-- Table structure for table `card_pool_owners`
--

CREATE TABLE `card_pool_owners` (
  `id` int(11) NOT NULL auto_increment,
  `pool_id` int(11) default '0',
  `user_id` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `card_pool_owners`
--


--
-- Table structure for table `contracts`
--

CREATE TABLE `contracts` (
  `id` int(11) NOT NULL auto_increment,
  `contract_number` varchar(255) default NULL,
  `date` int(11) default '0',
  `contract_text` text,
  `uid` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `contracts`
--


--
-- Table structure for table `contracts_templates`
--

CREATE TABLE `contracts_templates` (
  `id` int(11) NOT NULL auto_increment,
  `contract_number` varchar(255) default NULL,
  `date` int(11) default '0',
  `contract_text` text,
  `template_name` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `contracts_templates`
--


--
-- Table structure for table `credits`
--

CREATE TABLE `credits` (
  `id` int(11) NOT NULL auto_increment,
  `payment_trans_id` int(11) default '0',
  `expire_date` int(11) default '0',
  `start_date` int(11) default '0',
  `account_id` int(11) default '0',
  `value` double default '0',
  `status` int(11) default '0',
  `is_passed` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `credits`
--


--
-- Table structure for table `credits_history`
--

CREATE TABLE `credits_history` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `credit` double default '0',
  `who_set` int(11) default '0',
  `expire_date` int(11) default '2000000000',
  `status` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `credits_history`
--


--
-- Table structure for table `currency_list`
--

CREATE TABLE `currency_list` (
  `id` int(11) NOT NULL auto_increment,
  `currency_brief_name` varchar(255) default NULL,
  `currency_full_name` varchar(255) default NULL,
  `percent` double default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `currency_list`
--

INSERT INTO `currency_list` VALUES (840,'USD','USA Dollar',0,0);
INSERT INTO `currency_list` VALUES (810,'RUR','Russian Rouble',0,0);
INSERT INTO `currency_list` VALUES (978,'EUR','Euro',0,0);

--
-- Table structure for table `currency_rates`
--

CREATE TABLE `currency_rates` (
  `id` int(11) NOT NULL auto_increment,
  `currency_id` int(11) default NULL,
  `date` int(11) default NULL,
  `currency_rate` double default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `currency_rates`
--

INSERT INTO `currency_rates` VALUES (1,810,1070491240,1);
INSERT INTO `currency_rates` VALUES (2,978,1070491247,34.6813);
INSERT INTO `currency_rates` VALUES (3,840,1070491244,29.9441);

--
-- Table structure for table `dealer_comissions`
--

CREATE TABLE `dealer_comissions` (
  `id` int(11) NOT NULL auto_increment,
  `dealer_account_id` int(11) NOT NULL default '0',
  `service_id` int(11) NOT NULL default '0',
  `comission_value` double NOT NULL default '0',
  `add_data` int(11) NOT NULL default '0',
  `is_deleted` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dealer_comissions`
--


--
-- Table structure for table `dealer_groups_link`
--

CREATE TABLE `dealer_groups_link` (
  `id` int(11) NOT NULL auto_increment,
  `dealer_id` int(11) default '0',
  `group_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dealer_groups_link`
--


--
-- Table structure for table `dealer_transactions`
--

CREATE TABLE `dealer_transactions` (
  `id` int(11) NOT NULL auto_increment,
  `comission` double default NULL,
  `discount_transaction_id` int(11) default '0',
  `payment_transaction_id` int(11) default '0',
  `is_canceled` int(11) default '0',
  `cancel_id` int(11) default '0',
  `account_id` int(11) default NULL,
  `dealer_account_id` int(11) default NULL,
  `date` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dealer_transactions`
--


--
-- Table structure for table `dhs_access_log`
--

CREATE TABLE `dhs_access_log` (
  `id` int(11) NOT NULL auto_increment,
  `recv_date` int(11) default '0',
  `User_Name` varchar(255) default '',
  `Service_Type` int(11) default '0',
  `Framed_Protocol` int(11) default '0',
  `NAS_IP_Address` int(11) default '0',
  `NAS_Id` varchar(255) default '',
  `is_success` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_access_log`
--


--
-- Table structure for table `dhs_access_log_attrs`
--

CREATE TABLE `dhs_access_log_attrs` (
  `id` int(11) NOT NULL auto_increment,
  `access_id` int(11) default '0',
  `vendor` int(11) default '0',
  `attr` int(11) default '0',
  `value` text NOT NULL,
  `status_type` int(11) default '0',
  `date` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_access` (`access_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_access_log_attrs`
--


--
-- Table structure for table `dhs_sessions_detail`
--

CREATE TABLE `dhs_sessions_detail` (
  `id` int(11) NOT NULL auto_increment,
  `dhs_sess_id` int(11) default '0',
  `trange_id` int(11) default '0',
  `recv_date` int(11) default '0',
  `account_id` int(11) default '0',
  `duration` bigint(20) default '0',
  `base_cost` double default '0',
  `sum_cost` double default '0',
  `disc_per_id` int(11) default '0',
  `slink_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_sessions_detail`
--


--
-- Table structure for table `dhs_sessions_log`
--

CREATE TABLE `dhs_sessions_log` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `slink_id` int(11) default '0',
  `recv_date` int(11) default '0',
  `last_update_date` int(11) default '0',
  `Framed_IP_Address` int(11) default '0',
  `NAS_Port` int(11) default '0',
  `Acct_Delay_Time` int(11) default '0',
  `Acct_Session_Id` varchar(255) default '',
  `NAS_Port_Type` int(11) default '0',
  `User_Name` varchar(255) default '',
  `Service_Type` int(11) default '0',
  `Framed_Protocol` int(11) default '0',
  `NAS_IP_Address` int(11) default '0',
  `NAS_Id` varchar(255) default '',
  `Acct_Status_Type` int(11) default '0',
  `Acct_Input_Packets` bigint(20) default '0',
  `Acct_Input_Octets` bigint(20) default '0',
  `Acct_Output_Packets` bigint(20) default '0',
  `Acct_Output_Octets` bigint(20) default '0',
  `Acct_Session_Time` bigint(20) default '0',
  `Acct_Input_Gigawords` bigint(20) default '0',
  `Acct_Output_Gigawords` bigint(20) default '0',
  `Acct_Terminate_Cause` int(11) default '0',
  `Called_Station_Id` varchar(255) default NULL,
  `Calling_Station_Id` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_sessions_log`
--


--
-- Table structure for table `dhs_sessions_log_attrs`
--

CREATE TABLE `dhs_sessions_log_attrs` (
  `id` int(11) NOT NULL auto_increment,
  `session_id` int(11) default '0',
  `vendor` int(11) default '0',
  `attr` int(11) default '0',
  `value` text NOT NULL,
  `status_type` int(11) default '0',
  `date` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_sess_dhs` (`session_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dhs_sessions_log_attrs`
--


--
-- Table structure for table `dialup_cost_info`
--

CREATE TABLE `dialup_cost_info` (
  `id` int(11) NOT NULL auto_increment,
  `dialup_cost_info_id` int(11) default NULL,
  `timerange_id` int(11) default NULL,
  `cost` double default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dialup_cost_info`
--


--
-- Table structure for table `dialup_service_links`
--

CREATE TABLE `dialup_service_links` (
  `id` int(11) NOT NULL auto_increment,
  `time_in_curr_disc_period` int(11) default '0',
  `old_time` int(11) default '0',
  `login` varchar(255) default 'dialup',
  `password` varchar(255) default 'dialup',
  `allowed_cid` varchar(255) default '',
  `allowed_csid` varchar(255) default '',
  `is_deleted` int(11) default '0',
  `callback_enabled` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dialup_service_links`
--


--
-- Table structure for table `dialup_services_data`
--

CREATE TABLE `dialup_services_data` (
  `id` int(11) NOT NULL auto_increment,
  `dialup_cost_info_id` int(11) default NULL,
  `null_service_prepaid` int(11) default '1',
  `pool_name` varchar(255) default 'dialup',
  `max_timeout` int(11) default '86400',
  `login_prefix` varchar(255) default '',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dialup_services_data`
--


--
-- Table structure for table `dir_zones`
--

CREATE TABLE `dir_zones` (
  `id` int(11) NOT NULL auto_increment,
  `zone_id` int(11) default '0',
  `dir_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dir_zones`
--


--
-- Table structure for table `discount_periods`
--

CREATE TABLE `discount_periods` (
  `id` int(11) NOT NULL auto_increment,
  `start_date` int(11) default NULL,
  `end_date` int(11) default NULL,
  `periodic_type` int(11) default NULL,
  `next_discount_period_id` int(11) default '0',
  `canonical_len` int(11) default NULL,
  `is_expired` int(11) default '0',
  `discount_interval` int(11) default '0',
  `custom_duration` int(11) default '0',
  `static_id` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first` (`is_expired`)
) TYPE=MyISAM;

--
-- Dumping data for table `discount_periods`
--

INSERT INTO `discount_periods` VALUES (1,0,2000000000,1,0,2000000000,0,0,0,0);
INSERT INTO `discount_periods` VALUES (2,1049177020,1049177120,3,0,100,1,0,0,0);
INSERT INTO `discount_periods` VALUES (3,1049140800,1051732800,3,0,2592000,0,0,0,0);

--
-- Table structure for table `discount_transactions_all`
--

CREATE TABLE `discount_transactions_all` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default NULL,
  `incoming_rest` double default NULL,
  `outgoing_rest` double default NULL,
  `discount` double default NULL,
  `discount_without_tax` double default NULL,
  `discount_with_tax` double default NULL,
  `service_id` int(11) default NULL,
  `service_type` int(11) default NULL,
  `discount_period_id` int(11) default NULL,
  `slink_id` int(11) default NULL,
  `discount_date` int(11) default NULL,
  `comment` varchar(255) default NULL,
  `dealer_transaction_id` int(11) default NULL,
  `dealer_payment_transaction_id` int(11) default NULL,
  `is_canceled` int(11) default '0',
  `cancel_id` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_disc` (`discount_date`,`account_id`),
  KEY `first_disc1` (`account_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `discount_transactions_all`
--


--
-- Table structure for table `discount_transactions_iptraffic_all`
--

CREATE TABLE `discount_transactions_iptraffic_all` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default NULL,
  `discount` double default NULL,
  `discount_with_tax` double default NULL,
  `service_id` int(11) default NULL,
  `discount_period_id` int(11) default NULL,
  `slink_id` int(11) default NULL,
  `discount_date` int(11) default NULL,
  `discount_date_hour` int(11) default NULL,
  `discount_date_day` int(11) default NULL,
  `discount_date_month` int(11) default NULL,
  `t_class` int(11) default '0',
  `base_cost` double default '0',
  `ipid` int(11) default '0',
  `bytes` bigint(20) default NULL,
  `is_canceled` int(11) default '0',
  `cancel_id` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_dtr` (`discount_date`,`account_id`,`slink_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `discount_transactions_iptraffic_all`
--


--
-- Table structure for table `downloaded`
--

CREATE TABLE `downloaded` (
  `downloaded_id` int(11) default NULL,
  `tclass_id` int(11) default NULL,
  `qnt` bigint(20) default '0',
  `old_prepay` bigint(20) default '0',
  `is_deleted` int(11) default '0',
  `id` int(11) NOT NULL auto_increment,
  `custom_prepay` bigint(20) default '0',
  `downed_as_prepaid` bigint(20) default '0',
  `discounted` double default '0',
  `traffic_quota` bigint(20) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_dow` (`downloaded_id`,`tclass_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `downloaded`
--

INSERT INTO `downloaded` VALUES (1,0,0,0,0,1,0,0,0,0);
INSERT INTO `downloaded` VALUES (2,0,0,0,0,2,0,0,0,0);
INSERT INTO `downloaded` VALUES (3,0,0,0,0,3,0,0,0,0);
INSERT INTO `downloaded` VALUES (4,0,0,0,0,4,0,0,0,0);
INSERT INTO `downloaded` VALUES (5,0,0,0,0,5,0,0,0,0);

--
-- Table structure for table `dtagg_cust`
--

CREATE TABLE `dtagg_cust` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `discounted` double default '0',
  `discounted_without_tax` double default '0',
  `exp_date` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_cust`
--


--
-- Table structure for table `dtagg_hotspot`
--

CREATE TABLE `dtagg_hotspot` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `is_closed` int(11) default '0',
  `base_cost` double default '0',
  `discounted` double default '0',
  `discounted_without_tax` double default '0',
  `session_time` int(11) default '0',
  `recv_bytes` bigint(20) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_hotspot`
--


--
-- Table structure for table `dtagg_iptraffic`
--

CREATE TABLE `dtagg_iptraffic` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `is_closed` int(11) default '0',
  `base_cost` double default '0',
  `tclass` int(11) default '0',
  `ipid` int(11) default '0',
  `discounted` double default '0',
  `discounted_without_tax` double default '0',
  `bytes` bigint(20) default NULL,
  PRIMARY KEY  (`id`),
  KEY `first_dtagg` (`tclass`)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_iptraffic`
--


--
-- Table structure for table `dtagg_once`
--

CREATE TABLE `dtagg_once` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `is_closed` int(11) default '0',
  `discounted` double default '0',
  `discounted_without_tax` double default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_once`
--


--
-- Table structure for table `dtagg_periodic`
--

CREATE TABLE `dtagg_periodic` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `is_closed` int(11) default '0',
  `discounted` double default '0',
  `discounted_without_tax` double default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_periodic`
--


--
-- Table structure for table `dtagg_telephony`
--

CREATE TABLE `dtagg_telephony` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `is_closed` int(11) default '0',
  `base_cost` double default '0',
  `zone_id` int(11) default '0',
  `discounted` double default '0',
  `discounted_without_tax` double default '0',
  `duration` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `dtagg_telephony`
--


--
-- Table structure for table `firewall_rules`
--

CREATE TABLE `firewall_rules` (
  `id` int(11) NOT NULL auto_increment,
  `is_for_all` int(11) default '0',
  `uid` int(11) default '0',
  `group_id` int(11) default '0',
  `tariff_id` int(11) default '0',
  `rule_on` varchar(255) default '',
  `rule_off` varchar(255) default '',
  `rule_block` varchar(255) default '',
  `router_id` int(11) default '0',
  `is_deleted` int(11) default '0',
  `and_logic` int(11) default '0',
  `add_user` int(11) default '0',
  `edit_user` int(11) default '0',
  `del_user` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `firewall_rules`
--

INSERT INTO `firewall_rules` VALUES (1,0,1,0,0,'/sbin/ipfw add RULE_ID allow tcp from UIP/UBITS to any','/sbin/ipfw delete RULE_ID','',1,0,0,0,0,0);
INSERT INTO `firewall_rules` VALUES (2,0,1,0,0,'/sbin/iptables -A FORWARD -s UIP/UBITS -j ACCEPT','/sbin/iptables -D FORWARD -s UIP/UBITS -j ACCEPT','',2,0,0,0,0,0);
INSERT INTO `firewall_rules` VALUES (3,0,0,100,0,'/bin/echo -A FORWARD -s UIP/UBITS -j ACCEPT','/bin/echo -D FORWARD -s UIP/UBITS -j ACCEPT','',2,0,0,0,0,0);

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `id` int(11) NOT NULL auto_increment,
  `group_name` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` VALUES (1,'Administrators');
INSERT INTO `groups` VALUES (100,'Hotspot');
INSERT INTO `groups` VALUES (102,'Users');
INSERT INTO `groups` VALUES (200,'Guests');

--
-- Table structure for table `hotspot_allowed_net`
--

CREATE TABLE `hotspot_allowed_net` (
  `id` int(11) NOT NULL auto_increment,
  `hotspot_service_id` int(11) default NULL,
  `ip` int(11) default '0',
  `mask` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_allowed_net`
--


--
-- Table structure for table `hotspot_cost_info`
--

CREATE TABLE `hotspot_cost_info` (
  `hotspot_cost_info_id` int(11) default NULL,
  `timerange_id` int(11) default NULL,
  `cost` double default NULL
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_cost_info`
--


--
-- Table structure for table `hotspot_service_links`
--

CREATE TABLE `hotspot_service_links` (
  `id` int(11) NOT NULL auto_increment,
  `time_in_curr_disc_period` int(11) default '0',
  `old_time` int(11) default '0',
  `login` varchar(255) default 'card',
  `password` varchar(255) default 'card',
  `is_deleted` int(11) default '0',
  `recv_bytes` bigint(20) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_service_links`
--


--
-- Table structure for table `hotspot_services_data`
--

CREATE TABLE `hotspot_services_data` (
  `id` int(11) NOT NULL auto_increment,
  `hotspot_cost_info_id` int(11) default NULL,
  `null_service_prepaid` int(11) default '1',
  `recv_cost` double default '0',
  `rate_limit` varchar(255) default NULL,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `hotspot_services_data`
--


--
-- Table structure for table `houses`
--

CREATE TABLE `houses` (
  `id` int(11) NOT NULL auto_increment,
  `post_code` varchar(255) default NULL,
  `country` varchar(255) default NULL,
  `region` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `street` varchar(255) default NULL,
  `number` varchar(255) default NULL,
  `building` varchar(255) default NULL,
  `connect_date` int(11) default NULL,
  `ip_zone_id` int(11) default NULL,
  `additional_ip_zones_key` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `houses`
--


--
-- Table structure for table `invoice_entry`
--

CREATE TABLE `invoice_entry` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `invoice_id` int(11) default '0',
  `slink_id` int(11) default '0',
  `discount_period_id` int(11) default '0',
  `date` int(11) default '0',
  `qnt` double default '0',
  `base_cost` double default '0',
  `sum_cost` double default '0',
  `tax_amount` double default '0',
  `service_type` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_inve` (`invoice_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `invoice_entry`
--

INSERT INTO `invoice_entry` VALUES (1,'name1',1,0,0,0,10,5,500,60,0);
INSERT INTO `invoice_entry` VALUES (2,'name2',1,0,0,0,10,4,400,29,0);
INSERT INTO `invoice_entry` VALUES (3,'name3',1,0,0,0,10,1,10,2,0);

--
-- Table structure for table `invoices`
--

CREATE TABLE `invoices` (
  `id` int(11) NOT NULL auto_increment,
  `ext_num` varchar(255) default NULL,
  `invoice_date` int(11) default '0',
  `payment_transaction_id` int(11) default '0',
  `expire_date` int(11) default '0',
  `is_payed` int(11) default '0',
  `is_printed` int(11) default '0',
  `uid` int(11) default '0',
  `account_id` int(11) default '0',
  `is_mailed` int(11) default '0',
  `arrearage` double default '0',
  PRIMARY KEY  (`id`),
  KEY `first_inv` (`account_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `invoices`
--

INSERT INTO `invoices` VALUES (1,'qwe123o-9y',1997,0,0,0,0,0,1,0,0);

--
-- Table structure for table `ip_groups`
--

CREATE TABLE `ip_groups` (
  `ip_group_id` int(11) default NULL,
  `ip` int(11) default '0',
  `mask` int(11) default '-1',
  `uname` varchar(64) default NULL,
  `upass` varchar(64) default NULL,
  `mac` varchar(32) default NULL,
  `create_date` int(11) default '0',
  `delete_date` int(11) default '0',
  `is_deleted` int(11) default '0',
  `id` int(11) NOT NULL auto_increment,
  `allowed_cid` varchar(32) default NULL,
  `ip_type` int(11) default '0',
  `router_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `ip_groups`
--

INSERT INTO `ip_groups` VALUES (1,168430090,-1,'cli1','123','',1049177177,0,0,1,NULL,0,0);
INSERT INTO `ip_groups` VALUES (2,168430091,-1,'cli2','123','',1049177213,0,0,2,NULL,0,0);
INSERT INTO `ip_groups` VALUES (3,168430092,-1,'cli3','123','',1049177251,0,0,3,NULL,0,0);
INSERT INTO `ip_groups` VALUES (4,168430093,-1,'cli4','123','',1049177293,0,0,4,NULL,0,0);
INSERT INTO `ip_groups` VALUES (5,168430094,-1,'cli5','123','',1049177333,0,0,5,NULL,0,0);

--
-- Table structure for table `ip_zones`
--

CREATE TABLE `ip_zones` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `ip_zones`
--


--
-- Table structure for table `ip_zones_detail`
--

CREATE TABLE `ip_zones_detail` (
  `id` int(11) NOT NULL auto_increment,
  `ip_zone_id` int(11) default NULL,
  `net` int(11) default NULL,
  `mask` int(11) default NULL,
  `gateway` int(11) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `ip_zones_detail`
--


--
-- Table structure for table `iptraffic_borders`
--

CREATE TABLE `iptraffic_borders` (
  `borders_id` int(11) default NULL,
  `border` bigint(20) default NULL,
  `cost` double default NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `iptraffic_borders`
--

INSERT INTO `iptraffic_borders` VALUES (1,0,0,1);
INSERT INTO `iptraffic_borders` VALUES (1,52428800,0.2,2);
INSERT INTO `iptraffic_borders` VALUES (2,0,0,3);
INSERT INTO `iptraffic_borders` VALUES (2,524288000,0.15,4);

--
-- Table structure for table `iptraffic_service_links`
--

CREATE TABLE `iptraffic_service_links` (
  `id` int(11) NOT NULL auto_increment,
  `ip_group_id` int(11) default NULL,
  `downloaded_id` int(11) default NULL,
  `is_deleted` int(11) default '0',
  `recalc_type` int(11) default '0',
  `flags` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `iptraffic_service_links`
--

INSERT INTO `iptraffic_service_links` VALUES (1,1,1,0,0,0);
INSERT INTO `iptraffic_service_links` VALUES (2,2,2,0,0,0);
INSERT INTO `iptraffic_service_links` VALUES (3,3,3,0,0,0);
INSERT INTO `iptraffic_service_links` VALUES (4,4,4,0,0,0);
INSERT INTO `iptraffic_service_links` VALUES (5,5,5,0,0,0);

--
-- Table structure for table `iptraffic_services_data`
--

CREATE TABLE `iptraffic_services_data` (
  `id` int(11) NOT NULL auto_increment,
  `tst_id` int(11) default NULL,
  `null_service_prepaid` int(11) default '1',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `iptraffic_services_data`
--

INSERT INTO `iptraffic_services_data` VALUES (1,1,0,0);
INSERT INTO `iptraffic_services_data` VALUES (2,2,0,0);

--
-- Table structure for table `license_info`
--

CREATE TABLE `license_info` (
  `id` int(11) NOT NULL auto_increment,
  `module` varchar(255) default NULL,
  `path` varchar(255) default NULL,
  `version` varchar(255) default 'current',
  `hash` varchar(255) default NULL,
  `date` int(11) default '0',
  `data` text,
  `request` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `license_info`
--

INSERT INTO `license_info` VALUES (1,'core','/home/psha/utm5_core/lic/core.lic','current',NULL,0,NULL,0);

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` int(11) NOT NULL auto_increment,
  `sender_id` int(11) default NULL,
  `receiver_id` int(11) default NULL,
  `subject` varchar(255) default NULL,
  `message` text,
  `send_date` int(11) default NULL,
  `recv_date` int(11) default '0',
  `mime` varchar(255) default 'text/plain',
  `state` int(11) default '-1',
  `is_for_all` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_mes` (`receiver_id`,`send_date`)
) TYPE=MyISAM;

--
-- Dumping data for table `messages`
--

INSERT INTO `messages` VALUES (1,NULL,1,'Test message','This is sample test message body!',1068193805,0,'text/plain',-1,0);

--
-- Table structure for table `nas_info`
--

CREATE TABLE `nas_info` (
  `id` int(11) NOT NULL auto_increment,
  `nas_id` varchar(255) default '',
  `auth_secret` varchar(255) default '',
  `acct_secret` varchar(255) default '',
  `nas_type` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `nas_info`
--

INSERT INTO `nas_info` VALUES (1,'void.lz','secret','secret',0,0);
INSERT INTO `nas_info` VALUES (2,'127.0.0.1','secret','secret',0,0);
INSERT INTO `nas_info` VALUES (3,'localhost','secret','secret',0,0);
INSERT INTO `nas_info` VALUES (4,'utm.netup.ru','secret','secret',0,0);

--
-- Table structure for table `npo_end_users`
--

CREATE TABLE `npo_end_users` (
  `id` int(11) NOT NULL auto_increment,
  `is_blocked` int(11) default '0',
  `create_date` int(11) default NULL,
  `last_change_date` int(11) default NULL,
  `who_create` int(11) default NULL,
  `who_change` int(11) default NULL,
  `is_juridical` int(11) default '0',
  `full_name` text,
  `juridical_address` text,
  `actual_address` text,
  `email` varchar(255) default NULL,
  `work_telephone` varchar(255) default NULL,
  `home_telephone` varchar(255) default NULL,
  `mobile_telephone` varchar(255) default NULL,
  `web_page` varchar(255) default NULL,
  `icq_number` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `npo_end_users`
--


--
-- Table structure for table `npo_price_list`
--

CREATE TABLE `npo_price_list` (
  `id` int(11) NOT NULL auto_increment,
  `position_name` text,
  `position_cost` double default '0',
  `create_date` int(11) default '0',
  `change_date` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `npo_price_list`
--

INSERT INTO `npo_price_list` VALUES (1,'NetUP UTM v5.0 for UNIX (single license). Includes main module and leased lines support module.',525,0,0,0);
INSERT INTO `npo_price_list` VALUES (2,'Additional dial-up and VPN support module (UTM for UNIX).',112.5,0,0,0);
INSERT INTO `npo_price_list` VALUES (3,'Basic Partner Support Service for one month',30,0,0,0);

--
-- Table structure for table `npo_stores`
--

CREATE TABLE `npo_stores` (
  `id` int(11) NOT NULL auto_increment,
  `reseller_order_id` varchar(255) default '',
  `reseller_id` int(11) default '0',
  `date` int(11) default '0',
  `payment_type` int(11) default '0',
  `is_payed` int(11) default '0',
  `delivery` int(11) default '0',
  `cost` double default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `npo_stores`
--


--
-- Table structure for table `npo_stores_baskets`
--

CREATE TABLE `npo_stores_baskets` (
  `id` int(11) NOT NULL auto_increment,
  `store_id` int(11) default '0',
  `position_id` int(11) default '0',
  `quantity` int(11) default '0',
  `summary_cost` double default '0',
  `reseller_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `npo_stores_baskets`
--


--
-- Table structure for table `npo_utm_keys`
--

CREATE TABLE `npo_utm_keys` (
  `id` int(11) NOT NULL auto_increment,
  `key1` varchar(255) default NULL,
  `key2` varchar(255) default NULL,
  `reseller_id` int(11) default '0',
  `activate_date` int(11) default '0',
  `activate_ip` int(11) default '0',
  `end_user_id` int(11) default '0',
  `store_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `npo_utm_keys`
--


--
-- Table structure for table `once_service_data`
--

CREATE TABLE `once_service_data` (
  `id` int(11) NOT NULL auto_increment,
  `cost` double default NULL,
  `drop_from_group` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `once_service_data`
--


--
-- Table structure for table `once_service_links`
--

CREATE TABLE `once_service_links` (
  `id` int(11) NOT NULL auto_increment,
  `discount_date` int(11) default NULL,
  `is_deleted` int(11) default '0',
  `quantity` double default NULL,
  `invoice_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `once_service_links`
--


--
-- Table structure for table `payment_methods`
--

CREATE TABLE `payment_methods` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `payment_methods`
--

INSERT INTO `payment_methods` VALUES (1,'Cash payment');
INSERT INTO `payment_methods` VALUES (2,'Wire transfer');
INSERT INTO `payment_methods` VALUES (3,'Card payment');
INSERT INTO `payment_methods` VALUES (4,'Dealer comission');
INSERT INTO `payment_methods` VALUES (5,'Cash throught dealer');

--
-- Table structure for table `payment_transactions`
--

CREATE TABLE `payment_transactions` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default NULL,
  `payment_incurrency` double default NULL,
  `currency_id` int(11) default NULL,
  `currency_rate` double default NULL,
  `payment_absolute` double default NULL,
  `actual_date` int(11) default NULL,
  `payment_enter_date` int(11) default NULL,
  `payment_ext_number` varchar(255) default '',
  `method` int(11) default NULL,
  `who_receive` int(11) default NULL,
  `comments_for_user` varchar(255) default NULL,
  `comments_for_admins` varchar(255) default NULL,
  `burn_time` int(11) default '0',
  `discount_transaction_id` int(11) default '0',
  `dealer_transaction_id` int(11) default '0',
  `dealer_client_account_id` int(11) default '0',
  `is_canceled` int(11) default '0',
  `cancel_id` int(11) default '0',
  `hash` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `first_ptr` (`actual_date`,`account_id`),
  KEY `first_ptr_hash` (`hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `payment_transactions`
--

INSERT INTO `payment_transactions` VALUES (1,1,62,810,31,2,1068134072,1068134072,'',1,NULL,'Test Payment',NULL,0,0,0,0,0,0,NULL);

--
-- Table structure for table `payments_timed`
--

CREATE TABLE `payments_timed` (
  `id` int(11) NOT NULL auto_increment,
  `payment_trans_id` int(11) default '0',
  `expire_date` int(11) default '0',
  `pay_date` int(11) default '0',
  `last_pay_date` int(11) default '0',
  `account_id` int(11) default '0',
  `payment_value` double default '0',
  `custagg_id` int(11) default '0',
  `is_passed` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `payments_timed`
--


--
-- Table structure for table `periodic_service_links`
--

CREATE TABLE `periodic_service_links` (
  `id` int(11) NOT NULL auto_increment,
  `is_blocked` int(11) default '0',
  `discount_period_id` int(11) default '0',
  `discounted_in_curr_period` double default '0',
  `start_date` int(11) default '0',
  `is_planned` int(11) default '1',
  `expire_date` int(11) default '2000000000',
  `need_del` int(11) default '0',
  `unabon_period` int(11) default '0',
  `unprepay_period` int(11) default '0',
  `start_block_unabon` int(11) default '0',
  `start_block_unprepay` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `periodic_service_links`
--

INSERT INTO `periodic_service_links` VALUES (1,0,3,0,1042750800,0,1292533200,0,0,0,0,0,0);
INSERT INTO `periodic_service_links` VALUES (2,0,3,0,1042750800,0,1292533200,0,0,0,0,0,0);
INSERT INTO `periodic_service_links` VALUES (3,0,3,0,1042750800,0,1292533200,0,0,0,0,0,0);
INSERT INTO `periodic_service_links` VALUES (4,0,3,0,1042750800,0,1292533200,0,0,0,0,0,0);
INSERT INTO `periodic_service_links` VALUES (5,0,3,0,1042750800,0,1292533200,0,0,0,0,0,0);

--
-- Table structure for table `periodic_services_data`
--

CREATE TABLE `periodic_services_data` (
  `id` int(11) NOT NULL auto_increment,
  `cost` double default NULL,
  `periodic_type` int(11) default NULL,
  `discount_method` int(11) default NULL,
  `start_date` int(11) default '0',
  `is_planned` int(11) default '0',
  `expire_date` int(11) default '2000000000',
  `radius_sessions_limit` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `periodic_services_data`
--

INSERT INTO `periodic_services_data` VALUES (1,3,3,3,1042750800,0,1292533200,0,0);
INSERT INTO `periodic_services_data` VALUES (2,100,3,3,1042750800,0,1292533200,0,0);

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` int(11) NOT NULL auto_increment,
  `fid` int(11) default '0',
  `sys_acc_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `permissions`
--


--
-- Table structure for table `pre_invoice`
--

CREATE TABLE `pre_invoice` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `discount_period_id` int(11) default '0',
  `tclass` int(11) default '0',
  `base_cost` double default '0',
  `qnt` double default '0',
  `sum_cost` double default '0',
  `sum_cost_with_tax` double default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `pre_invoice`
--


--
-- Table structure for table `radius_data`
--

CREATE TABLE `radius_data` (
  `id` int(11) NOT NULL auto_increment,
  `owner_id` int(11) default NULL,
  `owner_type` int(11) default NULL,
  `vendor` int(11) default '0',
  `attr` int(11) default NULL,
  `value` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `radius_data`
--


--
-- Table structure for table `radius_pool_info`
--

CREATE TABLE `radius_pool_info` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `ip` int(11) default '0',
  `mask` int(11) default '-1',
  `create_date` int(11) default '0',
  `delete_date` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `radius_pool_info`
--


--
-- Table structure for table `registration_info`
--

CREATE TABLE `registration_info` (
  `name` varchar(255) default NULL,
  `country` varchar(255) default NULL,
  `region` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `tel` varchar(255) default NULL,
  `web` varchar(255) default NULL,
  `pubkey` varchar(255) default '/dev/null',
  `cert` text,
  `signed` int(11) default '0'
) TYPE=MyISAM;

--
-- Dumping data for table `registration_info`
--


--
-- Table structure for table `routers_info`
--

CREATE TABLE `routers_info` (
  `id` int(11) NOT NULL auto_increment,
  `router_type` int(11) default '0',
  `router_ip` varchar(255) default '',
  `login` varchar(255) default '',
  `password` varchar(255) default '',
  `router_comments` varchar(255) default '',
  `is_deleted` int(11) default '0',
  `router_bin_ip` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `routers_info`
--

INSERT INTO `routers_info` VALUES (1,0,'127.0.0.1','','','Local FreeBSD',0,0);
INSERT INTO `routers_info` VALUES (2,0,'127.0.0.1','','','Local Linux iptables',0,0);
INSERT INTO `routers_info` VALUES (3,2,'10.1.2.99','netup','hzp','Remote Cisco 3620',0,0);

--
-- Table structure for table `service_email`
--

CREATE TABLE `service_email` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `reg_date` int(11) default '0',
  `email` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `service_email`
--


--
-- Table structure for table `service_links`
--

CREATE TABLE `service_links` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `account_id` int(11) default NULL,
  `service_id` int(11) default NULL,
  `is_deleted` int(11) default '0',
  `tariff_link_id` int(11) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `service_links`
--

INSERT INTO `service_links` VALUES (1,1,1,1,0,NULL);
INSERT INTO `service_links` VALUES (2,2,2,1,0,NULL);
INSERT INTO `service_links` VALUES (3,3,3,1,0,NULL);
INSERT INTO `service_links` VALUES (4,4,4,2,0,NULL);
INSERT INTO `service_links` VALUES (5,5,5,2,0,NULL);

--
-- Table structure for table `service_www`
--

CREATE TABLE `service_www` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `reg_date` int(11) default '0',
  `www` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `service_www`
--


--
-- Table structure for table `services_data`
--

CREATE TABLE `services_data` (
  `id` int(11) NOT NULL auto_increment,
  `service_type` int(11) default NULL,
  `service_name` varchar(255) default NULL,
  `comment` varchar(255) default NULL,
  `comission_value` double default '0',
  `is_deleted` int(11) default '0',
  `tariff_id` int(11) default '0',
  `parent_service_id` int(11) default '0',
  `default_dp_type` int(11) default '0',
  `link_by_default` int(11) default '0',
  `is_dynamic` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `services_data`
--

INSERT INTO `services_data` VALUES (1,3,'base1','',0,0,0,0,0,0,0);
INSERT INTO `services_data` VALUES (2,3,'base2','',0,0,0,0,0,0,0);

--
-- Table structure for table `services_groups_link`
--

CREATE TABLE `services_groups_link` (
  `id` int(11) NOT NULL auto_increment,
  `service_id` int(11) default '0',
  `group_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `services_groups_link`
--


--
-- Table structure for table `slink_tech_param`
--

CREATE TABLE `slink_tech_param` (
  `id` int(11) NOT NULL auto_increment,
  `type_id` int(11) default '0',
  `param` varchar(255) default '',
  `reg_date` int(11) default '0',
  `slink_id` int(11) default '0',
  `passwd` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `slink_tech_param`
--


--
-- Table structure for table `slink_tech_param_type`
--

CREATE TABLE `slink_tech_param_type` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `descr` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `slink_tech_param_type`
--


--
-- Table structure for table `special_accounts`
--

CREATE TABLE `special_accounts` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `balance` double default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `special_accounts`
--

INSERT INTO `special_accounts` VALUES (1,'cash account',0);
INSERT INTO `special_accounts` VALUES (2,'tax account',0);
INSERT INTO `special_accounts` VALUES (3,'profit account',0);

--
-- Table structure for table `special_transactions`
--

CREATE TABLE `special_transactions` (
  `id` int(11) NOT NULL auto_increment,
  `transaction_type` int(11) default '0',
  `date` int(11) default NULL,
  `incoming_rest` double default NULL,
  `outgoing_rest` double default NULL,
  `payment_transaction_id` int(11) default '0',
  `discount_transaction_id` int(11) default '0',
  `dealer_transaction_id` int(11) default '0',
  `is_canceled` int(11) default '0',
  `cancel_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `special_transactions`
--


--
-- Table structure for table `supplier_info`
--

CREATE TABLE `supplier_info` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `ur_adress` varchar(255) default NULL,
  `act_adress` varchar(255) default NULL,
  `inn` varchar(255) default NULL,
  `kpp` varchar(255) default NULL,
  `bank_id` int(11) default NULL,
  `account` varchar(255) default NULL,
  `fio_headman` varchar(255) default NULL,
  `fio_bookeeper` varchar(255) default NULL,
  `fio_headman_sh` varchar(255) default NULL,
  `fio_bookeeper_sh` varchar(255) default NULL,
  `name_sh` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `supplier_info`
--

INSERT INTO `supplier_info` VALUES (1,'ZAO \"NetUp\"','117419,Moscow, Roshinskiy 2, B2/7','117419,Moscow,8/7','7725167465','772501001',1,'1654136496','Abilay Ospan','Ivan Stepanov','A.Ospan','I.Stepanov','NetUp');

--
-- Table structure for table `system_accounts`
--

CREATE TABLE `system_accounts` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(255) default NULL,
  `password` varchar(255) default NULL,
  `ip` int(11) default '0',
  `mask` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `system_accounts`
--

INSERT INTO `system_accounts` VALUES (-1,'init','init',0,0,0);
INSERT INTO `system_accounts` VALUES (-2,'radius','radius',0,0,0);
INSERT INTO `system_accounts` VALUES (-3,'web','web',0,0,0);

--
-- Table structure for table `system_group_info`
--

CREATE TABLE `system_group_info` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default '',
  `info` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `system_group_info`
--

INSERT INTO `system_group_info` VALUES (1,'Wheel','MegaAdmins');

--
-- Table structure for table `system_groups`
--

CREATE TABLE `system_groups` (
  `group_id` int(11) default '0',
  `user_id` int(11) default '0',
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `system_groups`
--

INSERT INTO `system_groups` VALUES (1,-1,1);
INSERT INTO `system_groups` VALUES (1,-2,2);
INSERT INTO `system_groups` VALUES (1,-3,3);

--
-- Table structure for table `system_rights`
--

CREATE TABLE `system_rights` (
  `group_id` int(11) default '0',
  `fid` int(11) default '0'
) TYPE=MyISAM;

--
-- Dumping data for table `system_rights`
--


--
-- Table structure for table `t_class`
--

CREATE TABLE `t_class` (
  `id` int(11) NOT NULL auto_increment,
  `t_class_name` varchar(255) default '',
  `graph_color` int(11) default '255',
  `is_display` int(11) default '0',
  `is_fill` int(11) default '0',
  `time_range_id` int(11) default '0',
  `dont_save` int(11) default '0',
  `local_traf_policy` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `t_class`
--

INSERT INTO `t_class` VALUES (10,'Incoming',255,1,0,0,0,0,0);
INSERT INTO `t_class` VALUES (20,'Outgoing',255,1,0,0,0,0,0);

--
-- Table structure for table `t_class_detail`
--

CREATE TABLE `t_class_detail` (
  `id` int(11) NOT NULL auto_increment,
  `t_class_id` int(11) NOT NULL default '0',
  `saddr` int(11) default '0',
  `saddr_mask` int(11) default '0',
  `daddr` int(11) default '0',
  `daddr_mask` int(11) default '0',
  `sport` int(11) default '0',
  `dport` int(11) default '0',
  `input` int(11) default '0',
  `output` int(11) default '0',
  `src_as` int(11) default '0',
  `dst_as` int(11) default '0',
  `nexthop` int(11) default '0',
  `tcp_flags` int(11) default '0',
  `proto` int(11) default '0',
  `tos` int(11) default '0',
  `use_sport` int(11) default '0',
  `use_dport` int(11) default '0',
  `use_input` int(11) default '0',
  `use_output` int(11) default '0',
  `use_src_as` int(11) default '0',
  `use_dst_as` int(11) default '0',
  `use_nexthop` int(11) default '0',
  `use_tcp_flags` int(11) default '0',
  `use_proto` int(11) default '0',
  `use_tos` int(11) default '0',
  `skip` int(11) default '0',
  `ip_from` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `t_class_detail`
--

INSERT INTO `t_class_detail` VALUES (1,10,0,0,167772160,-16777216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,0,0,0,0,0,0,0);
INSERT INTO `t_class_detail` VALUES (2,20,167772160,-16777216,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,0,0,0,0,0,0,0);

--
-- Table structure for table `t_class_time_range`
--

CREATE TABLE `t_class_time_range` (
  `id` int(11) NOT NULL auto_increment,
  `t_class` int(11) default '0',
  `time_range` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `t_class_time_range`
--

INSERT INTO `t_class_time_range` VALUES (1,10,1);
INSERT INTO `t_class_time_range` VALUES (2,20,2);
INSERT INTO `t_class_time_range` VALUES (3,20,3);

--
-- Table structure for table `tariffs`
--

CREATE TABLE `tariffs` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `create_date` int(11) default '0',
  `change_date` int(11) default '0',
  `who_change` int(11) default '0',
  `who_create` int(11) default '0',
  `expire_date` int(11) default '0',
  `is_blocked` int(11) default '0',
  `balance_rollover` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tariffs`
--


--
-- Table structure for table `tariffs_groups_link`
--

CREATE TABLE `tariffs_groups_link` (
  `id` int(11) NOT NULL auto_increment,
  `tariff_id` int(11) default '0',
  `group_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tariffs_groups_link`
--


--
-- Table structure for table `tariffs_history`
--

CREATE TABLE `tariffs_history` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) NOT NULL default '0',
  `tariff_id` int(11) NOT NULL default '0',
  `link_date` int(11) NOT NULL default '0',
  `unlink_date` int(11) NOT NULL default '0',
  `tariff_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tariffs_history`
--


--
-- Table structure for table `tariffs_services_link`
--

CREATE TABLE `tariffs_services_link` (
  `id` int(11) NOT NULL auto_increment,
  `tariff_id` int(11) default '0',
  `service_id` int(11) default '0',
  `q` int(11) default '1',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tariffs_services_link`
--


--
-- Table structure for table `tel_directions`
--

CREATE TABLE `tel_directions` (
  `id` int(11) NOT NULL auto_increment,
  `prefix` varchar(255) default '',
  `name` varchar(255) default '',
  `create_date` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_directions`
--


--
-- Table structure for table `tel_numbers`
--

CREATE TABLE `tel_numbers` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default '0',
  `tel_number` varchar(255) default '',
  `login` varchar(255) default '',
  `password` varchar(255) default '',
  `allowed_cid` varchar(255) default '',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_numbers`
--


--
-- Table structure for table `tel_service_links`
--

CREATE TABLE `tel_service_links` (
  `id` int(11) NOT NULL auto_increment,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_service_links`
--


--
-- Table structure for table `tel_service_links_downloaded`
--

CREATE TABLE `tel_service_links_downloaded` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default NULL,
  `direction_id` int(11) default NULL,
  `downloaded` int(11) default NULL,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_service_links_downloaded`
--


--
-- Table structure for table `tel_service_links_prepaid`
--

CREATE TABLE `tel_service_links_prepaid` (
  `id` int(11) NOT NULL auto_increment,
  `slink_id` int(11) default NULL,
  `tarif_key` int(11) default NULL,
  `downed_as_prepaid` int(11) default NULL,
  `old_prepaid` int(11) default NULL,
  `custom_prepaid` int(11) default NULL,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_service_links_prepaid`
--


--
-- Table structure for table `tel_services_borders`
--

CREATE TABLE `tel_services_borders` (
  `id` int(11) NOT NULL auto_increment,
  `tel_service_id` int(11) default NULL,
  `tarif_key` int(11) default NULL,
  `border` bigint(20) default NULL,
  `cost` double default NULL,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_borders`
--


--
-- Table structure for table `tel_services_data`
--

CREATE TABLE `tel_services_data` (
  `id` int(11) NOT NULL auto_increment,
  `t_s_step` int(11) default '1',
  `t_s_free` int(11) default '0',
  `max_timeout` int(11) default '86400',
  `first_interval` bigint(20) default '1',
  `incremental_interval` bigint(20) default '1',
  `first_interval_around` bigint(20) default '0',
  `free_time` bigint(20) default '0',
  `fixed_call_cost` double default '0',
  `unit_size` bigint(20) default '60',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_data`
--


--
-- Table structure for table `tel_services_prepaid`
--

CREATE TABLE `tel_services_prepaid` (
  `id` int(11) NOT NULL auto_increment,
  `tel_service_id` int(11) default NULL,
  `tarif_key` int(11) default NULL,
  `prepaid` bigint(20) default NULL,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_prepaid`
--


--
-- Table structure for table `tel_services_price`
--

CREATE TABLE `tel_services_price` (
  `id` int(11) NOT NULL auto_increment,
  `service_id` int(11) default NULL,
  `zone_id` int(11) default NULL,
  `trange_id` int(11) default NULL,
  `cost` double default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_price`
--


--
-- Table structure for table `tel_services_tr_mult`
--

CREATE TABLE `tel_services_tr_mult` (
  `id` int(11) NOT NULL auto_increment,
  `tel_service_id` int(11) default NULL,
  `tarif_key` int(11) default NULL,
  `time_range_id` int(11) default NULL,
  `mult` double default NULL,
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_services_tr_mult`
--


--
-- Table structure for table `tel_sessions_detail`
--

CREATE TABLE `tel_sessions_detail` (
  `id` int(11) NOT NULL auto_increment,
  `dhs_sess_id` int(11) default '0',
  `trange_id` int(11) default '0',
  `duration` bigint(20) default '0',
  `base_cost` double default '0',
  `sum_cost` double default '0',
  `recv_date` int(11) default '0',
  `account_id` int(11) default '0',
  `disc_per_id` int(11) default '0',
  `slink_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_sessions_detail`
--


--
-- Table structure for table `tel_sessions_log`
--

CREATE TABLE `tel_sessions_log` (
  `id` int(11) NOT NULL auto_increment,
  `account_id` int(11) default '0',
  `slink_id` int(11) default '0',
  `recv_date` int(11) default '0',
  `last_update_date` int(11) default '0',
  `zone_id` int(11) default '0',
  `NAS_Port` int(11) default '0',
  `Acct_Delay_Time` int(11) default '0',
  `Acct_Session_Id` varchar(255) default '',
  `NAS_Port_Type` int(11) default '0',
  `User_Name` varchar(255) default '',
  `Service_Type` int(11) default '0',
  `Framed_Protocol` int(11) default '0',
  `NAS_IP_Address` int(11) default '0',
  `NAS_Id` varchar(255) default '',
  `Acct_Status_Type` int(11) default '0',
  `Acct_Input_Packets` bigint(20) default '0',
  `Acct_Input_Octets` bigint(20) default '0',
  `Acct_Output_Packets` bigint(20) default '0',
  `Acct_Output_Octets` bigint(20) default '0',
  `Acct_Session_Time` bigint(20) default '0',
  `did` int(11) default '0',
  `Called_Station_Id` varchar(255) default NULL,
  `Calling_Station_Id` varchar(255) default NULL,
  `h323_remote_address` varchar(255) default NULL,
  `h323_conf_id` varchar(255) default NULL,
  `h323_setup_time` varchar(255) default NULL,
  `h323_call_origin` varchar(255) default NULL,
  `h323_call_type` varchar(255) default NULL,
  `h323_connect_time` varchar(255) default NULL,
  `h323_disconnect_time` varchar(255) default NULL,
  `h323_disconnect_cause` varchar(255) default NULL,
  `h323_gw_id` varchar(255) default NULL,
  `session_start_date` int(11) default '0',
  `session_end_date` int(11) default '0',
  `Acct_Input_Gigawords` bigint(20) default '0',
  `Acct_Output_Gigawords` bigint(20) default '0',
  `Acct_Terminate_Cause` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_sessions_log`
--


--
-- Table structure for table `tel_sessions_log_attrs`
--

CREATE TABLE `tel_sessions_log_attrs` (
  `id` int(11) NOT NULL auto_increment,
  `session_id` int(11) default '0',
  `vendor` int(11) default '0',
  `attr` int(11) default '0',
  `value` text NOT NULL,
  `status_type` int(11) default '0',
  `date` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `first_sess_tel` (`session_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_sessions_log_attrs`
--


--
-- Table structure for table `tel_zones`
--

CREATE TABLE `tel_zones` (
  `id` int(11) NOT NULL auto_increment,
  `dir_id` int(11) default '0',
  `name` varchar(255) default '',
  `create_date` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `tel_zones`
--


--
-- Table structure for table `temp_ip`
--

CREATE TABLE `temp_ip` (
  `id` int(11) NOT NULL auto_increment,
  `ip` int(11) default '0',
  `mac` varchar(255) default '',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `temp_ip`
--


--
-- Table structure for table `template_type`
--

CREATE TABLE `template_type` (
  `id` int(11) NOT NULL auto_increment,
  `type_id` int(11) default NULL,
  `type_name` varchar(255) default NULL,
  `sys_doc` int(11) default '1',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `template_type`
--


--
-- Table structure for table `time_range`
--

CREATE TABLE `time_range` (
  `id` int(11) NOT NULL auto_increment,
  `time_range_name` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `time_range`
--

INSERT INTO `time_range` VALUES (1,'Day');
INSERT INTO `time_range` VALUES (2,'Night');
INSERT INTO `time_range` VALUES (3,'Morning');
INSERT INTO `time_range` VALUES (4,'Evening');

--
-- Table structure for table `time_range_days`
--

CREATE TABLE `time_range_days` (
  `id` int(11) NOT NULL auto_increment,
  `time_range_id` int(11) default '0',
  `mday` int(11) default '0',
  `month` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `time_range_days`
--


--
-- Table structure for table `time_range_detail`
--

CREATE TABLE `time_range_detail` (
  `id` int(11) NOT NULL auto_increment,
  `time_range_id` int(11) default '0',
  `sec_start` int(11) default '0',
  `sec_stop` int(11) default '0',
  `min_start` int(11) default '0',
  `min_stop` int(11) default '0',
  `hour_start` int(11) default '0',
  `hour_stop` int(11) default '0',
  `wday_start` int(11) default '0',
  `wday_stop` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `time_range_detail`
--

INSERT INTO `time_range_detail` VALUES (1,1,0,59,0,59,10,19,0,7);
INSERT INTO `time_range_detail` VALUES (2,2,0,59,0,59,0,7,0,7);
INSERT INTO `time_range_detail` VALUES (3,3,0,59,0,59,8,9,0,7);
INSERT INTO `time_range_detail` VALUES (4,4,0,59,0,59,20,23,0,7);

--
-- Table structure for table `traf_serv_tclasses`
--

CREATE TABLE `traf_serv_tclasses` (
  `tst_id` int(11) default NULL,
  `tclass_id` int(11) default NULL,
  `borders_id` int(11) default NULL,
  `prepaid_units` bigint(20) default '0',
  `id` int(11) NOT NULL auto_increment,
  `prepaid_units_max` bigint(20) default '0',
  `group_id` int(11) default '0',
  `tariff_formula` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `traf_serv_tclasses`
--

INSERT INTO `traf_serv_tclasses` VALUES (1,10,1,0,1,0,0,0);
INSERT INTO `traf_serv_tclasses` VALUES (2,10,2,0,2,0,0,0);

--
-- Table structure for table `uaddparams_desc`
--

CREATE TABLE `uaddparams_desc` (
  `paramid` int(11) default NULL,
  `name` varchar(255) default NULL,
  `display_name` varchar(255) default NULL,
  `visible` int(11) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table `uaddparams_desc`
--


--
-- Table structure for table `user_additional_params`
--

CREATE TABLE `user_additional_params` (
  `id` int(11) NOT NULL auto_increment,
  `paramid` int(11) default NULL,
  `userid` int(11) default NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `user_additional_params`
--


--
-- Table structure for table `user_contact_em`
--

CREATE TABLE `user_contact_em` (
  `id` int(11) NOT NULL auto_increment,
  `name_position` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `user_contact_em`
--


--
-- Table structure for table `user_contacts`
--

CREATE TABLE `user_contacts` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) default NULL,
  `person` varchar(255) default NULL,
  `descr` text,
  `contact` text,
  `email` text,
  `email_notice` int(11) default '0',
  `person_short` varchar(128) default NULL,
  `bday` varchar(255) default NULL,
  `id_exec_man` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `user_contacts`
--

INSERT INTO `user_contacts` VALUES (1,1,'Ivanov Uriy','Director','Earth',NULL,0,'U.Ivanov','June 14 1969',0);
INSERT INTO `user_contacts` VALUES (2,1,'Juranova Julia','Bookeeper','Earth',NULL,0,'J.Juranova','October 12 1979',0);

--
-- Table structure for table `user_log`
--

CREATE TABLE `user_log` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `date` int(11) default NULL,
  `who` int(11) default NULL,
  `what` varchar(255) default NULL,
  `comment` varchar(255) default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `user_log`
--


--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default '0',
  `login` varchar(255) default '',
  `password` varchar(255) default '',
  `basic_account` int(11) default '0',
  `is_blocked` int(11) default '0',
  `discount_period_id` int(11) default '0',
  `create_date` int(11) default NULL,
  `last_change_date` int(11) default NULL,
  `who_create` int(11) default NULL,
  `who_change` int(11) default NULL,
  `is_juridical` int(11) default '0',
  `full_name` text,
  `juridical_address` text,
  `actual_address` text,
  `work_telephone` varchar(255) default NULL,
  `home_telephone` varchar(255) default NULL,
  `mobile_telephone` varchar(255) default NULL,
  `web_page` varchar(255) default NULL,
  `icq_number` varchar(255) default NULL,
  `tax_number` varchar(255) default NULL,
  `kpp_number` varchar(255) default NULL,
  `bank_id` int(11) default '0',
  `bank_account` varchar(255) default NULL,
  `int_status` int(11) default '0',
  `email` varchar(255) default NULL,
  `house_id` int(11) default NULL,
  `flat_number` varchar(255) default NULL,
  `entrance` varchar(255) default NULL,
  `floor` varchar(255) default NULL,
  `passport` varchar(255) default NULL,
  `advance_payment` int(11) default '0',
  `district` varchar(255) default NULL,
  `building` varchar(255) default NULL,
  `comments` text,
  `personal_manager` varchar(255) default NULL,
  `connect_date` int(11) default NULL,
  `remote_switch_id` int(11) default '0',
  `port_number` int(11) default '0',
  `personal_currency_coef` double default '1',
  `binded_currency_code` int(11) default '810',
  `is_deleted` int(11) default '0',
  `is_send_invoice` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES (1,1,'cli1','123',1,0,1,1049177177,1049177177,-3,-3,0,'','','','','','','','','','',0,'',0,'',NULL,'','','','',0,NULL,NULL,NULL,NULL,NULL,0,0,1,810,0,0);
INSERT INTO `users` VALUES (2,1,'cli2','123',2,0,1,1049177213,1049177213,-3,-3,0,'','','','','','','','','','',0,'',0,'',NULL,'','','','',0,NULL,NULL,NULL,NULL,NULL,0,0,1,810,0,0);
INSERT INTO `users` VALUES (3,1,'cli3','123',3,0,1,1049177251,1049177251,-3,-3,0,'','','','','','','','','','',0,'',0,'',NULL,'','','','',0,NULL,NULL,NULL,NULL,NULL,0,0,1,810,0,0);
INSERT INTO `users` VALUES (4,1,'cli4','123',4,0,1,1049177293,1049177293,-3,-3,0,'','','','','','','','','','',0,'',0,'',NULL,'','','','',0,NULL,NULL,NULL,NULL,NULL,0,0,1,810,0,0);
INSERT INTO `users` VALUES (5,1,'cli5','123',5,0,1,1049177333,1049177333,-3,-3,0,'','','','','','','','','','',0,'',0,'',NULL,'','','','',0,NULL,NULL,NULL,NULL,NULL,0,0,1,810,0,0);

--
-- Table structure for table `users_accounts`
--

CREATE TABLE `users_accounts` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) default '0',
  `account_id` int(11) default '0',
  `is_deleted` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `users_accounts`
--

INSERT INTO `users_accounts` VALUES (1,1,1,0);
INSERT INTO `users_accounts` VALUES (2,2,2,0);
INSERT INTO `users_accounts` VALUES (3,3,3,0);
INSERT INTO `users_accounts` VALUES (4,4,4,0);
INSERT INTO `users_accounts` VALUES (5,5,5,0);

--
-- Table structure for table `users_groups_link`
--

CREATE TABLE `users_groups_link` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default '0',
  `group_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

--
-- Dumping data for table `users_groups_link`
--


--
-- Table structure for table `utm5_settings`
--

CREATE TABLE `utm5_settings` (
  `id` int(11) NOT NULL auto_increment,
  `variable` varchar(255) default '',
  `value` text,
  `change_date` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `first_set` (`variable`)
) TYPE=MyISAM;

--
-- Dumping data for table `utm5_settings`
--

INSERT INTO `utm5_settings` VALUES (1,'smtp_relay','127.0.0.1',1057003200);
INSERT INTO `utm5_settings` VALUES (2,'smtp_port','25',1057003200);
INSERT INTO `utm5_settings` VALUES (3,'smtp_fqdn','netup.ru',1057003200);
INSERT INTO `utm5_settings` VALUES (4,'smtp_sender','admin@localhost',1057003200);
INSERT INTO `utm5_settings` VALUES (5,'smtp_subject','Message from UTM5',1057003200);
INSERT INTO `utm5_settings` VALUES (6,'admin_email','admin@localhost',1057003200);
INSERT INTO `utm5_settings` VALUES (7,'admin_email','admin@anotherhost',1057003200);
INSERT INTO `utm5_settings` VALUES (8,'sudo_path','/usr/bin/sudo',1057003200);
INSERT INTO `utm5_settings` VALUES (9,'web_session_timeout','3000',1057003200);
INSERT INTO `utm5_settings` VALUES (10,'hotspot_refresh_timeout','600',1057003200);
INSERT INTO `utm5_settings` VALUES (11,'hotspot_default_service','0',1057003200);
INSERT INTO `utm5_settings` VALUES (12,'notification_borders','-1 0 10.123',1057003200);
INSERT INTO `utm5_settings` VALUES (15,'raw_max_files','10',1057003200);
INSERT INTO `utm5_settings` VALUES (16,'raw_max_size','100000000',1057003200);
INSERT INTO `utm5_settings` VALUES (18,'raw_cleanup_sleep','1800000000',1057003200);
INSERT INTO `utm5_settings` VALUES (19,'discount_barrier','0.1',1057003200);
INSERT INTO `utm5_settings` VALUES (20,'notification_borders','0.1 2 5',1057003200);
INSERT INTO `utm5_settings` VALUES (21,'bytes_in_kbyte','1024',1057003200);
INSERT INTO `utm5_settings` VALUES (22,'traffic_agregation_interval','900',1057003200);
INSERT INTO `utm5_settings` VALUES (23,'flow_discounts_per_period','64',1057003200);
INSERT INTO `utm5_settings` VALUES (24,'flow_discount_random_coef','0.0001',1057003200);

