CREATE TABLE temp_ip (
    id int(11) NOT NULL auto_increment,
	ip int DEFAULT '0' NOT NULL,
	mac varchar(255) DEFAULT '' NOT NULL,
	is_deleted int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE system_rights(
    group_id int DEFAULT '0' NOT NULL,
    fid      int DEFAULT '0' NOT NULL
) TYPE=InnoDB;

CREATE TABLE system_group_info (
    id int(11) NOT NULL auto_increment,
    name varchar(255) NOT NULL,
    info varchar(255) DEFAULT '' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE system_groups (
    id int(11) NOT NULL auto_increment,
    group_id int NOT NULL,
    user_id  int NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_directions(
	id int(11) NOT NULL auto_increment,
	prefix varchar(255) DEFAULT '' NOT NULL,
	name varchar(255) DEFAULT '' NOT NULL,
	create_date int DEFAULT '0' NOT NULL,
	is_deleted int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_zones(
	id int(11) NOT NULL auto_increment,
	name varchar(255) DEFAULT '' NOT NULL,
	create_date int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dir_zones(
	id int(11) NOT NULL auto_increment,
	zone_id int DEFAULT '0' NOT NULL,
	dir_id int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_services_data(
  id int(11) NOT NULL auto_increment,
  t_s_step int DEFAULT '1' NOT NULL,
  t_s_free int DEFAULT '0' NOT NULL,
  max_timeout int default '86400' NOT NULL,
  first_interval bigint default '0' NOT NULL,
  incremental_interval bigint default '0' NOT NULL,
  first_interval_around bigint DEFAULT '0' NOT NULL,
  free_time bigint DEFAULT '0' NOT NULL,
  fixed_call_cost real DEFAULT '0' NOT NULL,
  unit_size bigint default '60' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_services_borders(
    id int(11) NOT NULL auto_increment,
    tel_service_id int NOT NULL,
    -- direction or zone
    tarif_key int NOT NULL,
    border bigint NOT NULL,
    cost real NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;
CREATE TABLE tel_services_prepaid(
    id int(11) NOT NULL auto_increment,
    tel_service_id int NOT NULL,
    -- direction or zone
    tarif_key int NOT NULL,
    prepaid bigint NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;
CREATE TABLE tel_services_tr_mult(
    id int(11) NOT NULL auto_increment,
    tel_service_id int NOT NULL,
    -- direction or zone
    tarif_key int NOT NULL,
    time_range_id int NOT NULL,
    mult real NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_service_links(
  id int(11) NOT NULL auto_increment,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_service_links_downloaded(
    id int(11) NOT NULL auto_increment,
    slink_id int NOT NULL,
    direction_id int NOT NULL,
    downloaded int NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_service_links_prepaid(
    id int(11) NOT NULL auto_increment,
    slink_id int NOT NULL,
    tarif_key int NOT NULL,
    downed_as_prepaid int NOT NULL,
    old_prepaid int NOT NULL,
    custom_prepaid int NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_numbers(
  id int(11) NOT NULL auto_increment,
  slink_id int NOT NULL,
  tel_number varchar(255) default '' NOT NULL,
  login varchar(255) NOT NULL,
  password varchar(255) default '' NOT NULL,
  allowed_cid varchar(255) default '' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_sessions_log(
    id int(11) NOT NULL auto_increment,
    account_id int DEFAULT '0' NOT NULL,
    slink_id int DEFAULT '0' NOT NULL,
    recv_date int DEFAULT '0' NOT NULL,
	last_update_date int DEFAULT '0' NOT NULL,
	zone_id int DEFAULT '0' NOT NULL,
	did int DEFAULT '0' NOT NULL,
    NAS_Port int DEFAULT '0' NOT NULL,
    Acct_Delay_Time int DEFAULT '0' NOT NULL,
    Acct_Session_Id varchar(255) default '',
    NAS_Port_Type int DEFAULT '0' NOT NULL,
    User_Name varchar(255) default '' NOT NULL,
    Service_Type int DEFAULT '0' NOT NULL,
    Framed_Protocol int DEFAULT '0' NOT NULL,
    NAS_IP_Address int DEFAULT '0' NOT NULL,
    NAS_Id varchar(255) DEFAULT '' NOT NULL,
    Acct_Status_Type int DEFAULT '0' NOT NULL,
    Acct_Input_Packets bigint DEFAULT '0' NOT NULL,
    Acct_Input_Octets bigint DEFAULT '0' NOT NULL,
    Acct_Output_Packets bigint DEFAULT '0' NOT NULL,
    Acct_Output_Octets bigint DEFAULT '0' NOT NULL,
    Acct_Session_Time bigint DEFAULT '0' NOT NULL,
	Called_Station_Id varchar(255) NOT NULL,
	Calling_Station_Id varchar(255) NOT NULL,
	h323_remote_address varchar(255) NOT NULL,
	h323_conf_id varchar(255) NOT NULL,
	h323_setup_time varchar(255) NOT NULL,
	h323_call_origin varchar(255) NOT NULL,
	h323_call_type varchar(255) NOT NULL,
	h323_connect_time varchar(255) NOT NULL,
	h323_disconnect_time varchar(255) NOT NULL,
	h323_disconnect_cause varchar(255) NOT NULL,
	h323_gw_id varchar(255) NOT NULL,
	session_start_date int DEFAULT '0' NOT NULL,
	session_end_date int DEFAULT '0' NOT NULL,
    Acct_Input_Gigawords bigint DEFAULT '0' NOT NULL,
    Acct_Output_Gigawords bigint DEFAULT '0' NOT NULL,
	Acct_Terminate_Cause int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_sessions_detail(
	id int(11) NOT NULL auto_increment,
	dhs_sess_id int DEFAULT '0' NOT NULL,
	recv_date int DEFAULT '0' NOT NULL,
	trange_id int DEFAULT '0' NOT NULL,
	account_id int DEFAULT '0' NOT NULL,
	disc_per_id int DEFAULT '0' NOT NULL,
	slink_id int DEFAULT '0' NOT NULL,
	duration bigint DEFAULT '0' NOT NULL,
	base_cost REAL DEFAULT '0' NOT NULL,
	sum_cost REAL DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tel_sessions_log_attrs(
	id int(11) NOT NULL auto_increment,
	session_id int DEFAULT '0' NOT NULL,
	vendor int DEFAULT '0' NOT NULL,
	attr int DEFAULT '0' NOT NULL,
	value text,
	status_type int DEFAULT '0' NOT NULL,
	date int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dhs_sessions_log_attrs(
	id int(11) NOT NULL auto_increment,
	session_id int DEFAULT '0' NOT NULL,
	vendor int DEFAULT '0' NOT NULL,
	attr int DEFAULT '0' NOT NULL,
	value text,
	status_type int DEFAULT '0' NOT NULL,
	date int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dhs_access_log_attrs(
	id int(11) NOT NULL auto_increment,
	access_id int DEFAULT '0' NOT NULL,
	vendor int DEFAULT '0' NOT NULL,
	attr int DEFAULT '0' NOT NULL,
	value text,
	status_type int DEFAULT '0' NOT NULL,
	date int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dhs_sessions_log(
	id int(11) NOT NULL auto_increment,
	account_id int DEFAULT '0' NOT NULL,
	slink_id int DEFAULT '0' NOT NULL,
	recv_date int DEFAULT '0' NOT NULL,
	last_update_date int DEFAULT '0' NOT NULL,
	Framed_IP_Address int DEFAULT '0' NOT NULL,
    NAS_Port int DEFAULT '0' NOT NULL,
	Acct_Delay_Time int DEFAULT '0' NOT NULL,
	Acct_Session_Id varchar(255) DEFAULT '' NOT NULL,
    NAS_Port_Type int DEFAULT '0' NOT NULL,
	User_Name varchar(255) DEFAULT '' NOT NULL,
    Service_Type int DEFAULT '0' NOT NULL,
    Framed_Protocol int DEFAULT '0' NOT NULL,
	NAS_IP_Address int DEFAULT '0' NOT NULL,
    NAS_Id varchar(255) default '' NOT NULL,
	Acct_Status_Type int DEFAULT '0' NOT NULL,
	Acct_Input_Packets bigint DEFAULT '0' NOT NULL,
	Acct_Input_Octets bigint DEFAULT '0' NOT NULL,
	Acct_Input_Gigawords bigint DEFAULT '0' NOT NULL,
	Acct_Output_Packets bigint DEFAULT '0' NOT NULL,
	Acct_Output_Octets bigint DEFAULT '0' NOT NULL,
	Acct_Output_Gigawords bigint DEFAULT '0' NOT NULL,
	Acct_Session_Time bigint DEFAULT '0' NOT NULL,
	Acct_Terminate_Cause int DEFAULT '0' NOT NULL,
	Called_Station_Id varchar(255) NOT NULL,
	Calling_Station_Id varchar(255) NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dhs_sessions_detail(
	id int(11) NOT NULL auto_increment,
	dhs_sess_id int DEFAULT '0' NOT NULL,
	trange_id int DEFAULT '0' NOT NULL,
	recv_date int DEFAULT '0' NOT NULL,
	account_id int DEFAULT '0' NOT NULL,
	disc_per_id int DEFAULT '0' NOT NULL,
	slink_id int DEFAULT '0' NOT NULL,
	duration bigint DEFAULT '0' NOT NULL,
	base_cost REAL DEFAULT '0' NOT NULL,
	sum_cost REAL DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dhs_access_log(
	id int(11) NOT NULL auto_increment,
	recv_date int DEFAULT '0' NOT NULL,
    User_Name varchar(255) DEFAULT '' NOT NULL,
    Service_Type int DEFAULT '0' NOT NULL,
    Framed_Protocol int DEFAULT '0' NOT NULL,
    NAS_IP_Address int DEFAULT '0' NOT NULL,
    NAS_Id varchar(255) DEFAULT '' NOT NULL,
	is_success int DEFAULT '0' NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE slink_tech_param(
    id int(11) NOT NULL auto_increment,
    type_id int DEFAULT '0' NOT NULL,
    param varchar(255) DEFAULT '' NOT NULL,
    reg_date int DEFAULT '0' NOT NULL,
    slink_id int DEFAULT '0' NOT NULL,
    passwd varchar(255) DEFAULT '' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE slink_tech_param_type(
    id int(11) NOT NULL auto_increment,
    name varchar(255) NOT NULL,
    descr varchar(255) DEFAULT '' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE license_data(
    id int(11) NOT NULL auto_increment,
    hash1 varchar(255) NOT NULL,
    hash2 varchar(255) NOT NULL,
    date int DEFAULT '0' NOT NULL,
    lic_type int DEFAULT '1' NOT NULL,
    data text,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE invoices(
    id  int(11) NOT NULL auto_increment,
    ext_num varchar(255) DEFAULT '' NOT NULL,
    invoice_date int DEFAULT '0' NOT NULL,
    payment_transaction_id int DEFAULT '0' NOT NULL,
    expire_date int DEFAULT '0' NOT NULL,
    is_payed int DEFAULT '0' NOT NULL,
    is_printed int DEFAULT '0' NOT NULL,
    is_mailed int DEFAULT '0' NOT NULL,
    uid int DEFAULT '0' NOT NULL,
    account_id int DEFAULT '0' NOT NULL,
    arrearage REAL DEFAULT '0' NOT NULL,
    period_start int DEFAULT '0' NOT NULL,
    period_end int DEFAULT '0' NOT NULL,
    balance_on_set REAL DEFAULT '0' NOT NULL,
    version int DEFAULT '0' NOT NULL,
    ic_status int DEFAULT '0' NOT NULL,
    ic_id varchar(255) DEFAULT '' NOT NULL,
    last_sync_date int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE invoice_entry(
    id int(11) NOT NULL auto_increment,
    name varchar(255) NOT NULL,
    invoice_id int DEFAULT '0' NOT NULL,
    slink_id int DEFAULT '0' NOT NULL,
    service_type int DEFAULT '0' NOT NULL,
    discount_period_id int DEFAULT '0' NOT NULL,
    date int DEFAULT '0' NOT NULL,
    qnt REAL DEFAULT '0' NOT NULL,
    base_cost REAL DEFAULT '0' NOT NULL,
    sum_cost REAL DEFAULT '0' NOT NULL,
    tax_amount REAL DEFAULT '0' NOT NULL,
    version int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE invoice_entry_details(
    id int(11) NOT NULL auto_increment,
    entry_id int NOT NULL,
    type int NOT NULL,
    value int NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE account_invoice(
    id int(11) NOT NULL auto_increment,
    is_printed int DEFAULT '0' NOT NULL,
    invc_id int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE messages (
  id int(11) NOT NULL auto_increment,
  sender_id int NOT NULL,
  group_id int NOT NULL,
  receiver_id int NOT NULL,
  subject varchar(255) NOT NULL,
  message text,
  mime varchar(255) default 'text/plain' NOT NULL,
  state int default '-1' NOT NULL,
  send_date int NOT NULL,
  is_for_all int DEFAULT '0' NOT NULL,
  recv_date int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE houses (
  id int(11) NOT NULL auto_increment,
  post_code varchar(255) NOT NULL,
  country varchar(255) NOT NULL,
  region varchar(255) NOT NULL,
  city varchar(255) NOT NULL,
  street varchar(255) NOT NULL,
  number varchar(255) NOT NULL,
  building varchar(255) NOT NULL,
  connect_date integer DEFAULT '0' NOT NULL NOT NULL,
  ip_zone_id integer DEFAULT '0' NOT NULL NOT NULL,
  additional_ip_zones_key integer DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE additional_ip_zones2houses (
  id int(11) NOT NULL auto_increment,
  house_key integer DEFAULT '0' NOT NULL,
  ip_zone_id integer DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE ip_zones(
  id int(11) NOT NULL auto_increment,
  name varchar(255) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE ip_zones_detail(
  id int(11) NOT NULL auto_increment,
  ip_zone_id int NOT NULL,
  net int NOT NULL,
  mask int NOT NULL,
  gateway int NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE balance_history (
	id int(11) NOT NULL auto_increment,
	account_id int DEFAULT 0 NOT NULL,
	accounting_period_id int DEFAULT 0 NOT NULL,
	out_balance REAL NOT NULL,
	date int DEFAULT 0 NOT NULL,
	PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE tariffs (
  id int(11) NOT NULL auto_increment,
  name varchar(255) NOT NULL,
  create_date int DEFAULT '0' NOT NULL,
  change_date int DEFAULT '0' NOT NULL,
  who_change int DEFAULT '0' NOT NULL,
  who_create int DEFAULT '0' NOT NULL,
  expire_date int DEFAULT '0' NOT NULL,
  balance_rollover int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE tariffs_services_link(
  id int(11) NOT NULL auto_increment,
  tariff_id int DEFAULT '0' NOT NULL,
  service_id int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;


CREATE TABLE users_groups_link(
  id int(11) NOT NULL auto_increment,
  user_id int DEFAULT '0' NOT NULL,
  group_id int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE users (
  id int(11) NOT NULL auto_increment,
  login varchar(255) NOT NULL,
  password varchar(255) DEFAULT '' NOT NULL,
  basic_account int NOT NULL,
  advance_payment int DEFAULT 0 NOT NULL,
  create_date int DEFAULT 0 NOT NULL,
  last_change_date int DEFAULT 0 NOT NULL,
  who_create int DEFAULT 0 NOT NULL,
  who_change int DEFAULT 0 NOT NULL,
  is_juridical int DEFAULT 0 NOT NULL,
  full_name text,
  juridical_address text,
  actual_address text,
  work_telephone varchar(255) DEFAULT '' NOT NULL,
  home_telephone varchar(255) DEFAULT '' NOT NULL,
  mobile_telephone varchar(255) DEFAULT '' NOT NULL,
  web_page varchar(255) DEFAULT '' NOT NULL,
  icq_number varchar(255) DEFAULT '' NOT NULL,
  tax_number varchar(255) DEFAULT '' NOT NULL,
  kpp_number varchar(255) DEFAULT '' NOT NULL,
  bank_id int DEFAULT '0' NOT NULL,
  bank_account varchar(255) DEFAULT '' NOT NULL,
  email varchar(255) DEFAULT '' NOT NULL,
  house_id int DEFAULT 0 NOT NULL,
  flat_number varchar(255) DEFAULT '' NOT NULL,
  entrance varchar(255) DEFAULT '' NOT NULL,
  floor varchar(255) DEFAULT '' NOT NULL,
  district varchar(255) DEFAULT '' NOT NULL,
  building varchar(255) DEFAULT '' NOT NULL,
  passport varchar(255) DEFAULT '' NOT NULL,
  comments text,
  personal_manager varchar(255) DEFAULT '' NOT NULL,
  connect_date int DEFAULT 0 NOT NULL,
  remote_switch_id int DEFAULT 0 NOT NULL,
  port_number int DEFAULT 0 NOT NULL,
  binded_currency_code int default 810 NOT NULL,
  is_deleted int DEFAULT 0 NOT NULL,
  is_send_invoice int DEFAULT 0 NOT NULL,
  ic_status int DEFAULT '0' NOT NULL,
  ic_id varchar(255) DEFAULT '' NOT NULL,
  last_sync_date int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE uaddparams_desc (
  paramid integer NOT NULL,
  name varchar(255) NOT NULL,
  display_name varchar(255) DEFAULT '' NOT NULL,
  visible integer DEFAULT 0 NOT NULL
) TYPE=InnoDB;

CREATE TABLE user_additional_params (
  id int(11) NOT NULL auto_increment,
  paramid integer NOT NULL,
  userid integer NOT NULL,
  value varchar(255) NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE user_contacts (
  id int(11) NOT NULL auto_increment,
  uid int NOT NULL,
  person varchar(255) DEFAULT '' NOT NULL,
  descr text,
  contact text,
  email text,
  email_notice int DEFAULT '0' NOT NULL,
  person_short varchar(128) DEFAULT '' NOT NULL,
  bday varchar(255) DEFAULT '' NOT NULL,
  id_exec_man int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE user_contact_em (
  id int(11) NOT NULL auto_increment,
  name_position varchar(255) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE user_log (
  id      int(11) NOT NULL auto_increment,
  user_id int NOT NULL,
  date    int NOT NULL,
  who     int NOT NULL,
  what    varchar(255) NOT NULL,
  comment varchar(255) default '' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;


CREATE TABLE template_type (
  id int(11) NOT NULL auto_increment,
  type_id int NOT NULL,
  type_name varchar(255) NOT NULL,
  sys_doc int default '1' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE acts_templates (
  id int(11) NOT NULL auto_increment,
  act_id int NOT NULL,
  is_old int NOT NULL,
  gen_date int NOT NULL,
  act_name varchar(255) NOT NULL,
  act_text text,
  doc_type int NOT NULL,
  def int DEFAULT '0' NOT NULL,
  landscape int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE acts (
  id int(11) NOT NULL auto_increment,
  act_id int NOT NULL,
  invc_id int NOT NULL,
  gen_date int NOT NULL,
  act_text text,
  is_sign int DEFAULT '0' NOT NULL,
  sign_date int DEFAULT '0' NOT NULL,
  doc_type int NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE contracts (
  id int(11) NOT NULL auto_increment,
  contract_number varchar(255) NOT NULL,
  date int DEFAULT '0' NOT NULL,
  contract_text text,
  uid int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE contracts_templates (
  id int(11) NOT NULL auto_increment,
  contract_number varchar(255) NOT NULL,
  date int DEFAULT '0' NOT NULL,
  contract_text text,
  template_name varchar(255) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE system_accounts (
  id int,
  login varchar(255) NOT NULL,
  password varchar(255) NOT NULL,
  ip int DEFAULT '0' NOT NULL,
  mask int DEFAULT '0' NOT NULL,
  is_dealer int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE card_pool_owners (
  id int(11) NOT NULL auto_increment,
  pool_id int DEFAULT '0' NOT NULL,
  user_id int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE card_pool_info (
  pool_id int,
  cards int DEFAULT '0' NOT NULL,
  cards_used int DEFAULT '0' NOT NULL,
  last_update int DEFAULT '0' NOT NULL,
  first_update int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (pool_id)
) TYPE=InnoDB;

CREATE TABLE card_info (
  id int(11) NOT NULL auto_increment,
  pool_id int DEFAULT '0' NOT NULL,
  secret varchar(255) NOT NULL,
  balance REAL DEFAULT '0' NOT NULL,
  currency int DEFAULT '0' NOT NULL,
  expiration int default '2000000000',
  is_used  int DEFAULT '0' NOT NULL,
  service_id int DEFAULT '0' NOT NULL,
  days int DEFAULT '0' NOT NULL,
  is_blocked int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE card_info_expired (
  id int(11) NOT NULL auto_increment,
  card_id int DEFAULT '0' NOT NULL,
  pool_id int DEFAULT '0' NOT NULL,
  secret varchar(255) NOT NULL,
  balance REAL DEFAULT '0' NOT NULL,
  currency int DEFAULT '0' NOT NULL,
  expiration int DEFAULT '0' NOT NULL,
  is_used  int DEFAULT '0' NOT NULL,
  service_id int DEFAULT '0' NOT NULL,
  days int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE groups(
  id int(11) NOT NULL auto_increment,
  group_name varchar(255) default '' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE accounts(
  id int(11) NOT NULL auto_increment,
  balance REAL DEFAULT '0' NOT NULL,
  account_name varchar(255) default '' NOT NULL,
  credit REAL DEFAULT '0' NOT NULL,
  flags int DEFAULT '0' NOT NULL,
  is_blocked int DEFAULT '0' NOT NULL,
  vat_rate REAL DEFAULT '0' NOT NULL,
  sale_tax_rate REAL DEFAULT '0' NOT NULL,
  int_status int DEFAULT '0' NOT NULL,
  block_recalc_abon int DEFAULT '0' NOT NULL,
  block_recalc_prepaid int DEFAULT '0' NOT NULL,
  unlimited int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  external_id varchar(255) DEFAULT '' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE tariffs_history(
  id int(11) NOT NULL auto_increment,
  account_id int default '0' NOT NULL,
  tariff_id int default '0' NOT NULL,
  link_date int default '0' NOT NULL,
  unlink_date int default '0' NOT NULL,
  tariff_name varchar(255) default '' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE account_tariff_link(
  id int(11) NOT NULL auto_increment,
  account_id int DEFAULT '0' NOT NULL,
  tariff_id int DEFAULT '0' NOT NULL,
  next_tariff_id int DEFAULT '0' NOT NULL,
  discount_period_id int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  link_date int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE users_accounts(
  id int(11) NOT NULL auto_increment,
  uid int DEFAULT '0' NOT NULL,
  account_id int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE discount_transactions_all(
   id int(11) NOT NULL auto_increment,
   account_id int DEFAULT '0' NOT NULL,
   incoming_rest REAL DEFAULT '0' NOT NULL,
   outgoing_rest REAL DEFAULT '0' NOT NULL,
   discount REAL DEFAULT '0' NOT NULL,
   discount_with_tax REAL DEFAULT '0' NOT NULL,
   service_id int DEFAULT '0' NOT NULL,
   service_type int DEFAULT '0' NOT NULL,
   discount_period_id int DEFAULT '0' NOT NULL,
   slink_id int DEFAULT '0' NOT NULL,
   discount_date int DEFAULT '0' NOT NULL,
   charge_type int DEFAULT '0' NOT NULL,
   PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE discount_transactions_iptraffic_all(
  id int DEFAULT '0' NOT NULL,
  account_id int DEFAULT '0' NOT NULL,
  discount REAL DEFAULT '0' NOT NULL,
  discount_with_tax REAL DEFAULT '0' NOT NULL,
  service_id int DEFAULT '0' NOT NULL,
  discount_period_id int DEFAULT '0' NOT NULL,
  slink_id int DEFAULT '0' NOT NULL,
  discount_date int DEFAULT '0' NOT NULL,
  discount_date_hour int DEFAULT '0' NOT NULL,
  discount_date_day int DEFAULT '0' NOT NULL,
  discount_date_month int DEFAULT '0' NOT NULL,
  t_class int DEFAULT '0' NOT NULL,
  base_cost REAL DEFAULT '0' NOT NULL,
  ipid int DEFAULT '0' NOT NULL,
  bytes bigint DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dtagg_once (
  id int(11) NOT NULL auto_increment,
  account_id int DEFAULT '0' NOT NULL,
  is_closed int DEFAULT '0' NOT NULL,
  discounted REAL DEFAULT '0' NOT NULL,
  discounted_without_tax REAL DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dtagg_periodic (
  id int(11) NOT NULL auto_increment,
  slink_id int DEFAULT '0' NOT NULL,
  is_closed int DEFAULT '0' NOT NULL,
  discounted REAL DEFAULT '0' NOT NULL,
  discounted_without_tax REAL DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dtagg_hotspot (
  id int(11) NOT NULL auto_increment,
  slink_id int DEFAULT '0' NOT NULL,
  is_closed int DEFAULT '0' NOT NULL,
  base_cost REAL DEFAULT '0' NOT NULL,
  discounted REAL DEFAULT '0' NOT NULL,
  discounted_without_tax REAL DEFAULT '0' NOT NULL,
  session_time int DEFAULT '0' NOT NULL,
  recv_bytes bigint DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dtagg_telephony (
  id int(11) NOT NULL auto_increment,
  slink_id int DEFAULT '0' NOT NULL,
  is_closed int DEFAULT '0' NOT NULL,
  base_cost REAL DEFAULT '0' NOT NULL,
  zone_id int DEFAULT '0' NOT NULL,
  discounted REAL DEFAULT '0' NOT NULL,
  discounted_without_tax REAL DEFAULT '0' NOT NULL,
  duration int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dtagg_iptraffic (
    id int(11) NOT NULL auto_increment,
    slink_id int DEFAULT '0' NOT NULL,
    is_closed int DEFAULT '0' NOT NULL,
    base_cost REAL DEFAULT '0' NOT NULL,
    tclass int DEFAULT '0' NOT NULL,
    ipid int DEFAULT '0' NOT NULL,
    discounted REAL DEFAULT '0' NOT NULL,
    discounted_without_tax REAL DEFAULT '0' NOT NULL,
    bytes bigint NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dtagg_cust (
    id int(11) NOT NULL auto_increment,
    account_id int DEFAULT '0' NOT NULL,
    discounted REAL DEFAULT '0' NOT NULL,
    discounted_without_tax REAL DEFAULT '0' NOT NULL,
    exp_date int DEFAULT '0' NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE services_data(
  id int(11) NOT NULL auto_increment,
  service_type int NOT NULL,
  service_name varchar(255) NOT NULL,
  comment varchar(255) NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  tariff_id int DEFAULT '0' NOT NULL,
  parent_service_id int DEFAULT '0' NOT NULL,
  link_by_default int DEFAULT '0' NOT NULL,
  is_dynamic int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE service_links(
  id int(11) NOT NULL auto_increment,
  user_id int NOT NULL,
  account_id int NOT NULL,
  service_id int NOT NULL,
  tariff_link_id int NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE periodic_services_data(
  id int(11) NOT NULL auto_increment,
  cost real NOT NULL,
  discount_method int NOT NULL,
  start_date int DEFAULT '0' NOT NULL,
  expire_date int default '2000000000' NOT NULL,
  radius_sessions_limit int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE periodic_service_links(
  id int(11) NOT NULL auto_increment,
  is_blocked int DEFAULT '0' NOT NULL,
  discount_period_id int DEFAULT '0' NOT NULL,
  discounted_in_curr_period REAL DEFAULT '0' NOT NULL,
  start_date int DEFAULT '0' NOT NULL,
  is_planned int default '0' NOT NULL,
  expire_date int default '2000000000',
  need_del int DEFAULT '0' NOT NULL,
  unabon_period int DEFAULT '0' NOT NULL,
  unprepay_period int DEFAULT '0' NOT NULL,
  start_block_unabon int DEFAULT '0' NOT NULL,
  start_block_unprepay int DEFAULT '0' NOT NULL,
  is_invoice_set int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE hotspot_service_links(
  id int(11) NOT NULL auto_increment,
  time_in_curr_disc_period int DEFAULT '0' NOT NULL,
  old_time int DEFAULT '0' NOT NULL,
  recv_bytes bigint DEFAULT '0' NOT NULL,
  login varchar(255) NOT NULL,
  password varchar(255) NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE hotspot_services_data(
  id int(11) NOT NULL auto_increment,
  hotspot_cost_info_id int NOT NULL,
  recv_cost REAL DEFAULT '0' NOT NULL,
  rate_limit varchar(255) DEFAULT '' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE hotspot_allowed_net(
  id int(11) NOT NULL auto_increment,
  hotspot_service_id int NOT NULL,
  ip int DEFAULT '0' NOT NULL,
  mask int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE hotspot_cost_info(
    hotspot_cost_info_id int NOT NULL,
    timerange_id int NOT NULL,
    cost REAL NOT NULL
) TYPE=InnoDB;

CREATE TABLE dialup_service_links(
  id int(11) NOT NULL auto_increment,
  time_in_curr_disc_period int DEFAULT '0' NOT NULL,
  old_time int DEFAULT '0' NOT NULL,
  login varchar(255) NOT NULL,
  password varchar(255) DEFAULT '' NOT NULL,
  allowed_cid varchar(255) NOT NULL default '',
  allowed_csid varchar(255) NOT NULL default '',
  is_deleted int DEFAULT '0' NOT NULL,
  callback_enabled int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dialup_services_data(
  id int(11) NOT NULL auto_increment,
  dialup_cost_info_id int NOT NULL,
  pool_name varchar(255) DEFAULT '' NOT NULL,
  max_timeout int default '86400' NOT NULL,
  login_prefix varchar(255) DEFAULT '' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dialup_cost_info(
  id int(11) NOT NULL auto_increment,
  dialup_cost_info_id int NOT NULL,
  timerange_id int NOT NULL,
  cost REAL NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE ip_groups(
  id int(11) NOT NULL auto_increment,
  ip_group_id int NOT NULL,
  ip int DEFAULT '0' NOT NULL,
  mask int DEFAULT '-1' NOT NULL,
  uname varchar(255) NOT NULL,
  upass varchar(255) NOT NULL,
  mac varchar(255) DEFAULT '' NOT NULL,
  allowed_cid varchar(255) DEFAULT '' NOT NULL,
  ip_type int DEFAULT '0' NOT NULL,
  router_id int DEFAULT '0' NOT NULL,
  create_date int DEFAULT '0' NOT NULL,
  delete_date int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE downloaded(
  id int(11) NOT NULL auto_increment,
  downloaded_id int NOT NULL,
  tclass_id int NOT NULL,
  qnt bigint DEFAULT '0' NOT NULL,
  old_prepay bigint DEFAULT '0' NOT NULL,
  custom_prepay bigint DEFAULT '0' NOT NULL,
  downed_as_prepaid bigint DEFAULT '0' NOT NULL,
  discounted real DEFAULT '0' NOT NULL,
  traffic_quota bigint DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE iptraffic_service_links (
  id int(11) NOT NULL auto_increment,
  ip_group_id int NOT NULL,
  downloaded_id int NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE iptraffic_services_data(
  id int(11) NOT NULL auto_increment,
  tst_id int NOT NULL,
  null_service_prepaid int default '1' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE traf_serv_tclasses(
  id int(11) NOT NULL auto_increment,
  tst_id int NOT NULL,
  tclass_id int NOT NULL,
  borders_id int NOT NULL,
  prepaid_units bigint DEFAULT '0' NOT NULL,
  prepaid_units_max bigint DEFAULT '0' NOT NULL,
  group_id int DEFAULT '0' NOT NULL,
  tariff_formula int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE iptraffic_borders(
  id int(11) NOT NULL auto_increment,
  borders_id int NOT NULL,
  border bigint NOT NULL,
  cost real NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE discount_periods(
  id int(11) NOT NULL auto_increment,
  start_date int NOT NULL,
  end_date int NOT NULL,
  periodic_type int NOT NULL,
  next_discount_period_id int DEFAULT '0' NOT NULL,
  discount_interval int DEFAULT '0' NOT NULL,
  canonical_len int NOT NULL,
  is_expired int DEFAULT '0' NOT NULL,
  custom_duration int DEFAULT '0' NOT NULL,
  static_id int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;


CREATE TABLE blocks_info(
  id int(11) NOT NULL auto_increment,
  account_id int NOT NULL,
  block_type int DEFAULT '0' NOT NULL,
  start_date int DEFAULT '0' NOT NULL,
  expire_date int default '2000000000',
  is_planning int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  unabon int DEFAULT 0 NOT NULL,
  unprepay int DEFAULT 0 NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE once_service_data(
  id int(11) NOT NULL auto_increment,
  cost real NOT NULL,
  drop_from_group int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE once_service_links(
  id int(11) NOT NULL auto_increment,
  discount_date int NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;


CREATE TABLE utm5_settings(
  id int(11) NOT NULL auto_increment,
  variable varchar(255) DEFAULT '' NOT NULL,
  value text,
  change_date int DEFAULT 0 NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE t_class (
  id int(11) NOT NULL auto_increment,
  t_class_name varchar(255) NOT NULL,
  graph_color int default '255' NOT NULL,
  is_display int DEFAULT '0' NOT NULL,
  is_fill int DEFAULT '0' NOT NULL,
  time_range_id int DEFAULT '0' NOT NULL,
  dont_save int DEFAULT '0' NOT NULL,
  local_traf_policy int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE t_class_detail (
  id int(11) NOT NULL auto_increment,
  t_class_id int NOT NULL,
  saddr int DEFAULT '0' NOT NULL,
  saddr_mask int DEFAULT '0' NOT NULL,
  daddr int DEFAULT '0' NOT NULL,
  daddr_mask int DEFAULT '0' NOT NULL,
  sport int DEFAULT '0' NOT NULL,
  dport int DEFAULT '0' NOT NULL,
  input int DEFAULT '0' NOT NULL,
  output int DEFAULT '0' NOT NULL,
  src_as int DEFAULT '0' NOT NULL,
  dst_as int DEFAULT '0' NOT NULL,
  nexthop int DEFAULT '0' NOT NULL,
  tcp_flags int DEFAULT '0' NOT NULL,
  proto int DEFAULT '0' NOT NULL,
  tos int DEFAULT '0' NOT NULL,
  use_sport int DEFAULT '0' NOT NULL,
  use_dport int DEFAULT '0' NOT NULL,
  use_input int DEFAULT '0' NOT NULL,
  use_output int DEFAULT '0' NOT NULL,
  use_src_as int DEFAULT '0' NOT NULL,
  use_dst_as int DEFAULT '0' NOT NULL,
  use_nexthop int DEFAULT '0' NOT NULL,
  use_tcp_flags int DEFAULT '0' NOT NULL,
  use_proto int DEFAULT '0' NOT NULL,
  use_tos int DEFAULT '0' NOT NULL,
  skip int DEFAULT '0' NOT NULL,
  ip_from int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE time_range (
  id int(11) NOT NULL auto_increment,
  time_range_name varchar(255) default '' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE time_range_detail (
  id int(11) NOT NULL auto_increment,
  time_range_id int DEFAULT '0' NOT NULL,
  sec_start int DEFAULT '0' NOT NULL,
  sec_stop int DEFAULT '0' NOT NULL,
  min_start int DEFAULT '0' NOT NULL,
  min_stop int DEFAULT '0' NOT NULL,
  hour_start int DEFAULT '0' NOT NULL,
  hour_stop int DEFAULT '0' NOT NULL,
  wday_start int DEFAULT '0' NOT NULL,
  wday_stop int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE time_range_days (
  id int(11) NOT NULL auto_increment,
  time_range_id int DEFAULT '0' NOT NULL,
  mday int DEFAULT '0' NOT NULL,
  month int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE payment_transactions(
  id int(11) NOT NULL auto_increment,
  account_id int DEFAULT '0' NOT NULL,
  payment_incurrency REAL DEFAULT '0' NOT NULL,
  currency_id int DEFAULT '0' NOT NULL,
  currency_rate REAL DEFAULT '0' NOT NULL,
  payment_absolute REAL DEFAULT '0' NOT NULL,
  actual_date int DEFAULT '0' NOT NULL,
  payment_enter_date int DEFAULT '0' NOT NULL,
  payment_ext_number varchar(255) default '',
  method int DEFAULT '0' NOT NULL,
  who_receive int DEFAULT '0' NOT NULL,
  comments_for_user varchar(255) DEFAULT '',
  comments_for_admins varchar(255) DEFAULT '',
  burn_time int DEFAULT '0' NOT NULL,
  is_canceled int DEFAULT '0' NOT NULL,
  cancel_id int DEFAULT '0' NOT NULL,
  hash varchar(255) DEFAULT '' NOT NULL,
  charge_id int DEFAULT '0' NOT NULL,
  ic_status int DEFAULT '0' NOT NULL,
  ic_id varchar(255) DEFAULT '' NOT NULL,
  last_sync_date int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)  
) TYPE=InnoDB;

CREATE TABLE payment_methods(
	id int(11) NOT NULL auto_increment,
	name varchar(255) NOT NULL,
	PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE payments_timed(
    id int(11) NOT NULL auto_increment,
    payment_trans_id int DEFAULT '0' NOT NULL,
    expire_date int DEFAULT '0' NOT NULL,
    pay_date int DEFAULT '0' NOT NULL,
    last_pay_date int DEFAULT '0' NOT NULL,
    account_id int DEFAULT '0' NOT NULL,
    payment_value real DEFAULT '0' NOT NULL,
    custagg_id int DEFAULT '0' NOT NULL,
    is_passed int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE credits(
    id int(11) NOT NULL auto_increment,
    payment_trans_id int DEFAULT '0' NOT NULL,
    expire_date int DEFAULT '0' NOT NULL,
    start_date int DEFAULT '0' NOT NULL,
    account_id int DEFAULT '0' NOT NULL,
    value real DEFAULT '0' NOT NULL,
    status int DEFAULT '0' NOT NULL,
    is_passed int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE routers_info(
  id int(11) NOT NULL auto_increment,
  router_type int DEFAULT '0' NOT NULL,
  router_ip varchar(255) default '' NOT NULL,
  login varchar(255) default '' NOT NULL,
  password varchar(255) default '' NOT NULL,
  router_comments varchar(255) default '' NOT NULL,
  router_bin_ip int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)  
) TYPE=InnoDB;

CREATE TABLE firewall_rules(
  id int(11) NOT NULL auto_increment,
  is_for_all int DEFAULT '0' NOT NULL,
  uid int DEFAULT '0' NOT NULL,
  group_id int DEFAULT '0' NOT NULL,
  tariff_id int DEFAULT '0' NOT NULL,
  rule_on varchar(255) default '' NOT NULL,
  rule_off varchar(255) default '' NOT NULL,
  rule_block varchar(255) default '' NOT NULL,
  router_id int DEFAULT '0' NOT NULL,
  and_logic int DEFAULT '0' NOT NULL,
  add_user int DEFAULT '0' NOT NULL,
  edit_user int DEFAULT '0' NOT NULL,
  del_user int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE radius_data(
    id int(11) NOT NULL auto_increment,
    owner_id int NOT NULL,
    owner_type int NOT NULL,
    vendor int DEFAULT '0' NOT NULL,
    attr int NOT NULL,
    value text,
    attr_type int NOT NULL DEFAULT '0',
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE radius_pool_info (
  id int(11) NOT NULL auto_increment,
  name varchar(255) NOT NULL,
  ip int DEFAULT '0' NOT NULL,
  mask int DEFAULT '-1' NOT NULL,
  create_date int DEFAULT '0' NOT NULL,
  delete_date int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE nas_info(
  id int(11) NOT NULL auto_increment,
  nas_id varchar(255) default '',
  auth_secret varchar(255) default '',
  acct_secret varchar(255) default '',
  nas_type int DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;


CREATE TABLE banks(
  id int(11) NOT NULL auto_increment,
  bic varchar(255) NOT NULL,
  name text,
  city varchar(255) NOT NULL,
  kschet varchar(255) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE currency_list(
  id int(11) NOT NULL auto_increment,
  currency_brief_name varchar(255) NOT NULL,
  currency_full_name varchar(255) NOT NULL,
  percent REAL DEFAULT '0' NOT NULL,
  is_deleted int DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)  
) TYPE=InnoDB;

CREATE TABLE currency_rates(
  id int(11) NOT NULL auto_increment,
  currency_id int NOT NULL,
  date int NOT NULL,
  currency_rate REAL NOT NULL,
  PRIMARY KEY  (id)  
) TYPE=InnoDB;

CREATE TABLE archives (
  id int(11) NOT NULL auto_increment,
  archive_id int NOT NULL,
  table_type int NOT NULL,
  table_name varchar(255) NOT NULL,
  start_date int NOT NULL,
  end_date int NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

CREATE TABLE supplier_info(
  id int(11) NOT NULL auto_increment,
  name varchar(255) DEFAULT '' NOT NULL,
  ur_adress varchar(255) DEFAULT '' NOT NULL,
  act_adress varchar(255) DEFAULT '' NOT NULL,
  inn varchar(255) DEFAULT '' NOT NULL,
  kpp varchar(255) DEFAULT '' NOT NULL,
  bank_id int DEFAULT 0 NOT NULL,
  account varchar(255) DEFAULT '' NOT NULL,
  fio_headman varchar(255) DEFAULT '' NOT NULL,
  fio_bookeeper varchar(255) DEFAULT '' NOT NULL,
  fio_headman_sh varchar(255) DEFAULT '' NOT NULL,
  fio_bookeeper_sh varchar(255) DEFAULT '' NOT NULL,
  name_sh varchar(255) DEFAULT '' NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

-- Dealer details table
-- dealer_details.id must be equivalent to system_accounts.id for each dealer user
CREATE TABLE dealer_details(
    id int NOT NULL,
    full_name VARCHAR(255) DEFAULT '' NOT NULL,
    act_address VARCHAR(255) DEFAULT '' NOT NULL,
    passport VARCHAR(255) DEFAULT '' NOT NULL,
    work_tel VARCHAR(255) DEFAULT '' NOT NULL,
    home_tel VARCHAR(255) DEFAULT '' NOT NULL,
    mob_tel VARCHAR(255) DEFAULT '' NOT NULL,
    web_page VARCHAR(255) DEFAULT '' NOT NULL,
    icq_number VARCHAR(255) DEFAULT '' NOT NULL,
    email VARCHAR(255) DEFAULT '' NOT NULL,
    comments VARCHAR(255) DEFAULT '' NOT NULL,
    who_create int DEFAULT 0 NOT NULL,
    who_change int DEFAULT 0 NOT NULL,
    create_date int DEFAULT 0 NOT NULL,
    change_date int DEFAULT 0 NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

-- Dealer access list table
-- Each record in this table specifies entity available for dealer specified in dealer_id field
-- entity_type is:
-- 1 User (entity_id linked to users.id)
-- 2 Service (entity_id linked to services_data.id)
-- 3 Tariff (entity_id linked to tariffs.id)
-- 4 Discount period (entity_id linked to discount_periods.static_id)
CREATE TABLE dealer_access_list(
    id int(11) NOT NULL auto_increment,
    dealer_id INT NOT NULL,
    entity_type INT NOT NULL,
    entity_id INT NOT NULL,
    is_deleted INT DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE dealer_log(
    id int(11) NOT NULL auto_increment,
    dealer_id INT NOT NULL,
    action INT NOT NULL,
    action_date INT NOT NULL,
    comments VARCHAR(255) DEFAULT '' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE firewall_rules_new(
    id int(11) NOT NULL auto_increment,
    flags INT NOT NULL,
    events INT NOT NULL,
    router_id INT NOT NULL,
    tariff_id INT NOT NULL,
    group_id INT NOT NULL,
    user_id INT NOT NULL,
    rule VARCHAR(255) NOT NULL,
    comment  VARCHAR(255) NOT NULL,
    is_deleted INT NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE ic_integration(
    id int(11) NOT NULL auto_increment,
    user_id INT NOT NULL,
    max_invoice_id INT DEFAULT '0' NOT NULL,
    max_payment_id INT DEFAULT '0' NOT NULL,
    PRIMARY KEY (id)
) TYPE=InnoDB;

CREATE TABLE ic_settings(
    id int(11) NOT NULL auto_increment,
    send_users int DEFAULT '1' NOT NULL,
    send_inv int DEFAULT '1' NOT NULL,
    send_payments int DEFAULT '1' NOT NULL,
    recv_payments int DEFAULT '1' NOT NULL,
    sync_card int DEFAULT '0' NOT NULL,
    sync_empty_name int DEFAULT '1' NOT NULL,
    sync_empty_inn int DEFAULT '1' NOT NULL,
    sync_empty_kpp int DEFAULT '1' NOT NULL,
    sync_users_since int DEFAULT '0' NOT NULL,
    sync_users_till int DEFAULT '2000000000' NOT NULL,
    sync_inv_since int DEFAULT '0' NOT NULL,
    sync_inv_till int DEFAULT '2000000000' NOT NULL,
    sync_payments_since int DEFAULT '0' NOT NULL,
    sync_payments_till int DEFAULT '2000000000' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE utm5_tray_settings(
    id int(11) NOT NULL auto_increment,
    name VARCHAR(255) NOT NULL,
    value VARCHAR(255) DEFAULT '' NOT NULL,
    is_deleted int DEFAULT '0',
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE dynashape_services(
    id int(11) NOT NULL auto_increment,
    service_id int NOT NULL,
    direction int NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE dynashape_borders(
    id int(11) NOT NULL auto_increment,
    dyna_id int NOT NULL,
    border bigint NOT NULL,
    timerange int NOT NULL,
    lim int NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE dynashape_tclasses(
    id int(11) NOT NULL auto_increment,
    dyna_id int NOT NULL,
    tclass_id int NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE dynashape_settings(
    id int(11) NOT NULL auto_increment,
    flags int DEFAULT '0' NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE dynashape_data (
    id int(11) NOT NULL auto_increment,
    slink_id int NOT NULL,
    direction int NOT NULL,
    curr_limit int NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE dynashape_radius_attrs (
    id int(11) NOT NULL auto_increment,
    service_id int NOT NULL,
    vendor_id int NOT NULL,
    attr_id int NOT NULL,
    attr_type int NOT NULL,
    value VARCHAR(255) NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE hotspot_network_list(
    id int(11) NOT NULL auto_increment,
    service_id int NOT NULL,
    ip int NOT NULL,
    mask int NOT NULL,
    is_deleted int DEFAULT '0' NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

CREATE TABLE messages_status(
    id int(11) NOT NULL auto_increment,
    message_id int NOT NULL,
    user_id int NOT NULL,
    status int NOT NULL,
    PRIMARY KEY(id)
) TYPE=InnoDB;

INSERT INTO ic_settings (id) VALUES (1);

INSERT INTO discount_periods(id, start_date, end_date,canonical_len,periodic_type) VALUES(1,0,2000000000,2000000000,1);

INSERT INTO tel_directions (id,is_deleted) VALUES(1001000,1);

INSERT INTO template_type(type_id,type_name) VALUES('2','User\'s info sheet');
INSERT INTO template_type(type_id,type_name) VALUES('3','Contract');
INSERT INTO template_type(type_id,type_name) VALUES('4','Receipt');
INSERT INTO template_type(type_id,type_name) VALUES('5','Invoice');
INSERT INTO template_type(type_id,type_name) VALUES('6','Tax invoice');
INSERT INTO template_type(type_id,type_name) VALUES('7','Report of completion for individual');
INSERT INTO template_type(type_id,type_name) VALUES('8','Report of completion for legal person');

INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,act_text) VALUES('2','0','0','User\'s info sheet','2','1','');
INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,act_text) VALUES('3','0','0','Contract','3','1','');
INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,act_text) VALUES('4','0','0','Receipt','4','1','');
INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,act_text) VALUES('5','0','0','Invoice','5','1','');
INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,landscape,act_text) VALUES('6','0','0','Tax invoice','6','1','1','');
INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,landscape,act_text) VALUES('7','0','0','Report of completion for individual','7','1','1','');
INSERT INTO acts_templates(act_id,is_old,gen_date,act_name,doc_type,def,landscape,act_text) VALUES('8','0','0','Report of completion for legal person','8','1','1','');

INSERT INTO utm5_settings(variable, value, change_date) VALUES ('system_currency','810',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('smtp_relay','127.0.0.1',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('smtp_port','25',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('smtp_fqdn','localhost',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('smtp_sender','admin@localhost',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('smtp_subject','Message from UTM5',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('smtp_recipient','root@localhost',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('balance_notification_email','',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('web_session_timeout','3000',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('hotspot_refresh_timeout','600',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('raw_max_files', '10', 1057003200 );
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('raw_max_size', '100000000', 1057003200 );
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('raw_prefix', '', 1057003200 );

INSERT INTO utm5_settings(variable, value, change_date) VALUES ('discount_barrier', '0.1', 1057003200 );
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('notification_borders', '1', 1057003200 );
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('bytes_in_kbyte','1024',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('traffic_agregation_interval','900',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('flow_discounts_per_period','64',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('aggregation_todisc_barrier','5',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('card_user_prefix','card_',1057003200);

INSERT INTO utm5_settings(variable, value, change_date) VALUES ('invoice_subject','UTM Invoice',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('invoice_text','Invoice',1057003200);

INSERT INTO utm5_settings(variable, value, change_date) VALUES( 'notification_message','Уважаемый абонент, FULL_NAME !\nНа вашем лицевом счету номер: ACCOUNT_ID возник дефицит средств в размере\nBALANCE.\nДата сообщения: DATE\nДанное сообщение послано на EMAIL\nС уважением, Провайдер.', 1057003200 );
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('notification_message_subject', 'Уведомление',1057003200);
INSERT INTO utm5_settings(variable, value, change_date) VALUES ('notification_message_from', 'admin',1057003200);

INSERT INTO system_accounts(id,login,password) VALUES('-1','init', 'init');
INSERT INTO system_accounts(id,login,password,ip,mask) VALUES('-2','radius', 'radius','2130706433','-1');
INSERT INTO system_accounts(id,login,password,ip,mask) VALUES('-3','web', 'web','2130706433','-1');
INSERT INTO system_accounts(id,login,password,ip,mask) VALUES('-4','rfw', 'rfw','2130706433','-1');

INSERT INTO system_group_info(id,name,info) VALUES('1', 'Wheel', '');
INSERT INTO system_group_info(id,name,info) VALUES('2', 'Cashier', '');

INSERT INTO system_rights VALUES (2,69);
INSERT INTO system_rights VALUES (2,4608);
INSERT INTO system_rights VALUES (2,8193);
INSERT INTO system_rights VALUES (2,8209);
INSERT INTO system_rights VALUES (2,9216);
INSERT INTO system_rights VALUES (2,10512);
INSERT INTO system_rights VALUES (2,12544);
INSERT INTO system_rights VALUES (2,12560);
INSERT INTO system_rights VALUES (2,17418);
INSERT INTO system_rights VALUES (2,20496);
INSERT INTO system_rights VALUES (2,69905);

INSERT INTO system_groups(id,group_id,user_id) VALUES(1,'1', '-1');
INSERT INTO system_groups(id,group_id,user_id) VALUES(2,'1', '-3');

INSERT INTO card_pool_info(pool_id,cards) VALUES('1', '0');

INSERT INTO groups(id,group_name) VALUES('1','Administrators');
INSERT INTO groups(id,group_name) VALUES('100','Hotspot');
INSERT INTO groups(id,group_name) VALUES('102','Users');
INSERT INTO groups(id,group_name) VALUES('200','Guests');

INSERT INTO t_class(id,t_class_name,graph_color,is_display) VALUES(10,'Incoming','255',1);
INSERT INTO t_class(id,t_class_name,graph_color,is_display) VALUES(20,'Outgoing','255',1);
INSERT INTO t_class_detail(t_class_id,saddr,saddr_mask,daddr,daddr_mask) VALUES('10','0','0','167772160','-16777216');
INSERT INTO t_class_detail(t_class_id,saddr,saddr_mask,daddr,daddr_mask) VALUES('20','167772160','-16777216','0','0');


INSERT INTO currency_list(id, currency_brief_name, currency_full_name) VALUES('840','USD','U.S. Dollar');
INSERT INTO currency_list(id, currency_brief_name, currency_full_name) VALUES('810','RUR','Russia Rouble');
INSERT INTO currency_list(id, currency_brief_name, currency_full_name) VALUES('978','EUR','Euro');

INSERT INTO currency_rates(currency_id,date,currency_rate) VALUES('810','0','1');
INSERT INTO currency_rates(currency_id,date,currency_rate) VALUES('978','0','37.0433');
INSERT INTO currency_rates(currency_id,date,currency_rate) VALUES('840','0','23.533');

INSERT INTO nas_info(nas_id,auth_secret,acct_secret) VALUES ('127.0.0.1','secret','secret');

INSERT INTO routers_info(router_type, router_ip, router_comments) VALUES('0','127.0.0.1','Local FreeBSD');

INSERT INTO firewall_rules(uid,rule_on,rule_off,router_id) VALUES('1','add RULE_ID allow ip from UIP/UBITS to any','delete RULE_ID','1');


INSERT INTO payment_methods(id,name) VALUES('1','Cash payment');
INSERT INTO payment_methods(id,name) VALUES('2','Wire transfer');
INSERT INTO payment_methods(id,name) VALUES('3','Card payment' );
INSERT INTO payment_methods(id,name) VALUES('7','Credit');


insert into supplier_info(id) values(1);


insert into user_contact_em(id,name_position) values(1,'CEO');
insert into user_contact_em(id,name_position) values(2,'Manager');
insert into user_contact_em(id,name_position) values(3,'Accountant');


insert into slink_tech_param_type(id,name) values(1,'web');
insert into slink_tech_param_type(id,name) values(2,'email');

INSERT INTO time_range (id,time_range_name) VALUES (1,'All day');
INSERT INTO time_range_detail (time_range_id,sec_start,sec_stop,min_start,min_stop,hour_start,hour_stop,wday_start,wday_stop) VALUES (1,0,59,0,59,0,23,0,6);

