<%@ page contentType="text/html;charset=iso-8859-1" %>
<% response.setContentType("text/html;charset=UTF-8"); %>
<%@ page import='java.lang.*' %>
<%@ page import='java.sql.*' %>
<%@ page import='java.util.*' %>
<%@ page import='oracle.jdbc.*' %>

<html>
<title>Search!</title>
<body>
<form action="<%= request.getRequestURI()%>" method="GET">
  Search keyword : <input type="TEXT" name="SEARCH"><br>
  Search Language: 

  <select name="LANGUAGE">
    <option value="EN">English
    <option value="JP">Japanese
    <option value="ZH">Chinese
    <option value="KO">Korean
  </select>
  <br><input type="submit">
</form>

<%

// JSP for 9iText Multi-lexer Demo 
// Run search against File Datastore
//
// author : Kei Saito, IPG, Oracle Corporation 
// version: $Id: search_url.jsp,v 1.1 2001/08/02 17:53:54 ksaitoh Exp $
//
// This JSP gives you to search documents that are in various formats
// and various languages by using Oracle 9iText feature.
//


  String raw_keyword = request.getParameter("SEARCH");
  String language  = request.getParameter("LANGUAGE"); // EN or JP or ZHT or KO

  String keyword;

  if (raw_keyword != null){

    if (!raw_keyword.equalsIgnoreCase("")) { 

    // Salvage the parameter.
    // The page was sent in UTF-8, so the parameter might be using UTF-8.
    keyword = new String (raw_keyword.getBytes("ISO-8859-1"), "UTF-8");

    // Put the HTML comment to hide debug code -----------
    out.println ("<!--");

    out.println("<br>keyword : <font color=RED>" + keyword +"</font><br><Br>");

    // Load the Oracle JDBC driver
    // You have to make sure that 9i jdbc library is set in 
    // your CLASSPATH.  
    DriverManager.registerDriver(new oracle.jdbc.OracleDriver());

    // Change this line to the database which you have set up. 
//    String url = "jdbc:oracle:thin:@130.35.69.96:1521:u9011";
    String url = "jdbc:oracle:thin:@spradhan-sun:1521:o10i";
    
    // Connect to the database
    // Change username and password which you have set up.
    Connection conn =
      DriverManager.getConnection (url, "po", "po");

    // Create a Statement
    Statement stmt = conn.createStatement ();

    String sql, lang;
    ResultSet rset;


    // Set NLS_LANGUAGE and NLS_TERRITORY 
    // 9itext will use this value for choosing lexer.

    if (language.equalsIgnoreCase("ZH")) {
      sql = "Alter session set NLS_LANGUAGE = 'TRADITIONAL CHINESE'";
       stmt.execute(sql);
      sql = "Alter session set NLS_TERRITORY = 'TAIWAN'";
      stmt.execute(sql);
      lang = "Chinese";

    }
    else if (language.equalsIgnoreCase("JP")) {
      sql = "Alter session set NLS_LANGUAGE = 'JAPANESE'";
      stmt.execute(sql);
      sql = "Alter session set NLS_TERRITORY = 'JAPAN'";
      stmt.execute(sql);
      lang = "Japanese";
    }
    else if (language.equalsIgnoreCase("KO")) {
      sql = "Alter session set NLS_LANGUAGE = 'KOREAN'";
      stmt.execute(sql);
      sql = "Alter session set NLS_TERRITORY = 'KOREA'";
      stmt.execute(sql);
      lang = "Korean";
    }
    else 
    {
      sql = "Alter session set NLS_LANGUAGE = 'AMERICAN'";
      stmt.execute (sql);
      sql = "Alter session set NLS_TERRITORY = 'AMERICA'";
      stmt.execute (sql);
      lang = "English";
    }


    // Debug output to just verify the NLS_LANGUAGE and NLS_TERRITORY
    sql = "select * from v$nls_parameters";
    rset = stmt.executeQuery (sql);

    while (rset.next ()){
      out.println (rset.getString (1) + ":" + rset.getString (2) +"<br>");
    } 


    // Create SQL  
    sql = "select ID, URL, LANG, score(1) from FILEDOC ";
    sql += "where contains (URL, '" + keyword + "', 1)>0 order by score(1) desc";  

    out.println(sql + "<br><br>");
    // ------------ Put the HTML comment close to hide debug code 
    out.println ("-->");

    rset = stmt.executeQuery (sql);

    out.println ("<br><br>Keyword: <b><font color=RED>" + keyword +"</font></b><br>");
    out.println ("Language: <b><font color=RED>" + lang +"</font></b><br>");

    // Iterate through the result and print the search results
    while (rset.next ()){

      out.println ("<br><br>Score: <b>" + rset.getString (4) +"</b><br>");
      out.println ("Doc ID:       " + rset.getString (1) +"<br>");
      out.println ("Doc Name:  <b>" + rset.getString (2) +"  </b><br>");
      out.println ("Lang:         " + rset.getString (3) +"<br>");


      // Call procedure to get the part of the documentation
      // that includes the first occurrence of the keyword.
      CallableStatement cs = 
        conn.prepareCall ("begin  ? := GET_TEXT_AROUND_KEYWORD(?,?,?); end;");

      cs.registerOutParameter(1,Types.CHAR);
      cs.setString(2, "FILEDOC_IDX");              // Name of Index for 9iText
      cs.setString(3, rset.getString(1));         // Doc_ID
      cs.setString(4, keyword);                   // Keyword

      // Execute procedure
      cs.executeUpdate();

      out.println("<br><hr><font size=-1 color=Green> ...");
      out.println(cs.getString(1));
      out.println("...</font><hr>");

    }
    // Close the RseultSet
    rset.close();

    // Close the Statement
    stmt.close();

    // Close the connection
    conn.close();
    }
  }

%>

</body>
</html>
